// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewKerberosInterfaceCollectionGetParams creates a new KerberosInterfaceCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewKerberosInterfaceCollectionGetParams() *KerberosInterfaceCollectionGetParams {
	return &KerberosInterfaceCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewKerberosInterfaceCollectionGetParamsWithTimeout creates a new KerberosInterfaceCollectionGetParams object
// with the ability to set a timeout on a request.
func NewKerberosInterfaceCollectionGetParamsWithTimeout(timeout time.Duration) *KerberosInterfaceCollectionGetParams {
	return &KerberosInterfaceCollectionGetParams{
		timeout: timeout,
	}
}

// NewKerberosInterfaceCollectionGetParamsWithContext creates a new KerberosInterfaceCollectionGetParams object
// with the ability to set a context for a request.
func NewKerberosInterfaceCollectionGetParamsWithContext(ctx context.Context) *KerberosInterfaceCollectionGetParams {
	return &KerberosInterfaceCollectionGetParams{
		Context: ctx,
	}
}

// NewKerberosInterfaceCollectionGetParamsWithHTTPClient creates a new KerberosInterfaceCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewKerberosInterfaceCollectionGetParamsWithHTTPClient(client *http.Client) *KerberosInterfaceCollectionGetParams {
	return &KerberosInterfaceCollectionGetParams{
		HTTPClient: client,
	}
}

/*
KerberosInterfaceCollectionGetParams contains all the parameters to send to the API endpoint

	for the kerberos interface collection get operation.

	Typically these are written to a http.Request.
*/
type KerberosInterfaceCollectionGetParams struct {

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* EncryptionTypes.

	   Filter by encryption_types
	*/
	EncryptionTypes *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* InterfaceIPAddress.

	   Filter by interface.ip.address
	*/
	InterfaceIPAddress *string

	/* InterfaceName.

	   Filter by interface.name
	*/
	InterfaceName *string

	/* InterfaceUUID.

	   Filter by interface.uuid
	*/
	InterfaceUUID *string

	/* MachineAccount.

	   Filter by machine_account
	*/
	MachineAccount *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Spn.

	   Filter by spn
	*/
	Spn *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the kerberos interface collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *KerberosInterfaceCollectionGetParams) WithDefaults() *KerberosInterfaceCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the kerberos interface collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *KerberosInterfaceCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := KerberosInterfaceCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) WithTimeout(timeout time.Duration) *KerberosInterfaceCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) WithContext(ctx context.Context) *KerberosInterfaceCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) WithHTTPClient(client *http.Client) *KerberosInterfaceCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithEnabled adds the enabled to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) WithEnabled(enabled *bool) *KerberosInterfaceCollectionGetParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithEncryptionTypes adds the encryptionTypes to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) WithEncryptionTypes(encryptionTypes *string) *KerberosInterfaceCollectionGetParams {
	o.SetEncryptionTypes(encryptionTypes)
	return o
}

// SetEncryptionTypes adds the encryptionTypes to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) SetEncryptionTypes(encryptionTypes *string) {
	o.EncryptionTypes = encryptionTypes
}

// WithFields adds the fields to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) WithFields(fields []string) *KerberosInterfaceCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithInterfaceIPAddress adds the interfaceIPAddress to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) WithInterfaceIPAddress(interfaceIPAddress *string) *KerberosInterfaceCollectionGetParams {
	o.SetInterfaceIPAddress(interfaceIPAddress)
	return o
}

// SetInterfaceIPAddress adds the interfaceIpAddress to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) SetInterfaceIPAddress(interfaceIPAddress *string) {
	o.InterfaceIPAddress = interfaceIPAddress
}

// WithInterfaceName adds the interfaceName to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) WithInterfaceName(interfaceName *string) *KerberosInterfaceCollectionGetParams {
	o.SetInterfaceName(interfaceName)
	return o
}

// SetInterfaceName adds the interfaceName to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) SetInterfaceName(interfaceName *string) {
	o.InterfaceName = interfaceName
}

// WithInterfaceUUID adds the interfaceUUID to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) WithInterfaceUUID(interfaceUUID *string) *KerberosInterfaceCollectionGetParams {
	o.SetInterfaceUUID(interfaceUUID)
	return o
}

// SetInterfaceUUID adds the interfaceUuid to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) SetInterfaceUUID(interfaceUUID *string) {
	o.InterfaceUUID = interfaceUUID
}

// WithMachineAccount adds the machineAccount to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) WithMachineAccount(machineAccount *string) *KerberosInterfaceCollectionGetParams {
	o.SetMachineAccount(machineAccount)
	return o
}

// SetMachineAccount adds the machineAccount to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) SetMachineAccount(machineAccount *string) {
	o.MachineAccount = machineAccount
}

// WithMaxRecords adds the maxRecords to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) WithMaxRecords(maxRecords *int64) *KerberosInterfaceCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) WithOrderBy(orderBy []string) *KerberosInterfaceCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) WithReturnRecords(returnRecords *bool) *KerberosInterfaceCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *KerberosInterfaceCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSpn adds the spn to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) WithSpn(spn *string) *KerberosInterfaceCollectionGetParams {
	o.SetSpn(spn)
	return o
}

// SetSpn adds the spn to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) SetSpn(spn *string) {
	o.Spn = spn
}

// WithSvmName adds the svmName to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) WithSvmName(svmName *string) *KerberosInterfaceCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) WithSvmUUID(svmUUID *string) *KerberosInterfaceCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the kerberos interface collection get params
func (o *KerberosInterfaceCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *KerberosInterfaceCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.EncryptionTypes != nil {

		// query param encryption_types
		var qrEncryptionTypes string

		if o.EncryptionTypes != nil {
			qrEncryptionTypes = *o.EncryptionTypes
		}
		qEncryptionTypes := qrEncryptionTypes
		if qEncryptionTypes != "" {

			if err := r.SetQueryParam("encryption_types", qEncryptionTypes); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.InterfaceIPAddress != nil {

		// query param interface.ip.address
		var qrInterfaceIPAddress string

		if o.InterfaceIPAddress != nil {
			qrInterfaceIPAddress = *o.InterfaceIPAddress
		}
		qInterfaceIPAddress := qrInterfaceIPAddress
		if qInterfaceIPAddress != "" {

			if err := r.SetQueryParam("interface.ip.address", qInterfaceIPAddress); err != nil {
				return err
			}
		}
	}

	if o.InterfaceName != nil {

		// query param interface.name
		var qrInterfaceName string

		if o.InterfaceName != nil {
			qrInterfaceName = *o.InterfaceName
		}
		qInterfaceName := qrInterfaceName
		if qInterfaceName != "" {

			if err := r.SetQueryParam("interface.name", qInterfaceName); err != nil {
				return err
			}
		}
	}

	if o.InterfaceUUID != nil {

		// query param interface.uuid
		var qrInterfaceUUID string

		if o.InterfaceUUID != nil {
			qrInterfaceUUID = *o.InterfaceUUID
		}
		qInterfaceUUID := qrInterfaceUUID
		if qInterfaceUUID != "" {

			if err := r.SetQueryParam("interface.uuid", qInterfaceUUID); err != nil {
				return err
			}
		}
	}

	if o.MachineAccount != nil {

		// query param machine_account
		var qrMachineAccount string

		if o.MachineAccount != nil {
			qrMachineAccount = *o.MachineAccount
		}
		qMachineAccount := qrMachineAccount
		if qMachineAccount != "" {

			if err := r.SetQueryParam("machine_account", qMachineAccount); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Spn != nil {

		// query param spn
		var qrSpn string

		if o.Spn != nil {
			qrSpn = *o.Spn
		}
		qSpn := qrSpn
		if qSpn != "" {

			if err := r.SetQueryParam("spn", qSpn); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamKerberosInterfaceCollectionGet binds the parameter fields
func (o *KerberosInterfaceCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamKerberosInterfaceCollectionGet binds the parameter order_by
func (o *KerberosInterfaceCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
