// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewKerberosInterfaceModifyCollectionParams creates a new KerberosInterfaceModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewKerberosInterfaceModifyCollectionParams() *KerberosInterfaceModifyCollectionParams {
	return &KerberosInterfaceModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewKerberosInterfaceModifyCollectionParamsWithTimeout creates a new KerberosInterfaceModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewKerberosInterfaceModifyCollectionParamsWithTimeout(timeout time.Duration) *KerberosInterfaceModifyCollectionParams {
	return &KerberosInterfaceModifyCollectionParams{
		timeout: timeout,
	}
}

// NewKerberosInterfaceModifyCollectionParamsWithContext creates a new KerberosInterfaceModifyCollectionParams object
// with the ability to set a context for a request.
func NewKerberosInterfaceModifyCollectionParamsWithContext(ctx context.Context) *KerberosInterfaceModifyCollectionParams {
	return &KerberosInterfaceModifyCollectionParams{
		Context: ctx,
	}
}

// NewKerberosInterfaceModifyCollectionParamsWithHTTPClient creates a new KerberosInterfaceModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewKerberosInterfaceModifyCollectionParamsWithHTTPClient(client *http.Client) *KerberosInterfaceModifyCollectionParams {
	return &KerberosInterfaceModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
KerberosInterfaceModifyCollectionParams contains all the parameters to send to the API endpoint

	for the kerberos interface modify collection operation.

	Typically these are written to a http.Request.
*/
type KerberosInterfaceModifyCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* EncryptionTypes.

	   Filter by encryption_types
	*/
	EncryptionTypes *string

	/* Info.

	   Info specification
	*/
	Info KerberosInterfaceModifyCollectionBody

	/* InterfaceIPAddress.

	   Filter by interface.ip.address
	*/
	InterfaceIPAddress *string

	/* InterfaceName.

	   Filter by interface.name
	*/
	InterfaceName *string

	/* InterfaceUUID.

	   Filter by interface.uuid
	*/
	InterfaceUUID *string

	/* MachineAccount.

	   Filter by machine_account
	*/
	MachineAccount *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Spn.

	   Filter by spn
	*/
	Spn *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the kerberos interface modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *KerberosInterfaceModifyCollectionParams) WithDefaults() *KerberosInterfaceModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the kerberos interface modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *KerberosInterfaceModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := KerberosInterfaceModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) WithTimeout(timeout time.Duration) *KerberosInterfaceModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) WithContext(ctx context.Context) *KerberosInterfaceModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) WithHTTPClient(client *http.Client) *KerberosInterfaceModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *KerberosInterfaceModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithEnabled adds the enabled to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) WithEnabled(enabled *bool) *KerberosInterfaceModifyCollectionParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithEncryptionTypes adds the encryptionTypes to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) WithEncryptionTypes(encryptionTypes *string) *KerberosInterfaceModifyCollectionParams {
	o.SetEncryptionTypes(encryptionTypes)
	return o
}

// SetEncryptionTypes adds the encryptionTypes to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) SetEncryptionTypes(encryptionTypes *string) {
	o.EncryptionTypes = encryptionTypes
}

// WithInfo adds the info to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) WithInfo(info KerberosInterfaceModifyCollectionBody) *KerberosInterfaceModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) SetInfo(info KerberosInterfaceModifyCollectionBody) {
	o.Info = info
}

// WithInterfaceIPAddress adds the interfaceIPAddress to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) WithInterfaceIPAddress(interfaceIPAddress *string) *KerberosInterfaceModifyCollectionParams {
	o.SetInterfaceIPAddress(interfaceIPAddress)
	return o
}

// SetInterfaceIPAddress adds the interfaceIpAddress to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) SetInterfaceIPAddress(interfaceIPAddress *string) {
	o.InterfaceIPAddress = interfaceIPAddress
}

// WithInterfaceName adds the interfaceName to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) WithInterfaceName(interfaceName *string) *KerberosInterfaceModifyCollectionParams {
	o.SetInterfaceName(interfaceName)
	return o
}

// SetInterfaceName adds the interfaceName to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) SetInterfaceName(interfaceName *string) {
	o.InterfaceName = interfaceName
}

// WithInterfaceUUID adds the interfaceUUID to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) WithInterfaceUUID(interfaceUUID *string) *KerberosInterfaceModifyCollectionParams {
	o.SetInterfaceUUID(interfaceUUID)
	return o
}

// SetInterfaceUUID adds the interfaceUuid to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) SetInterfaceUUID(interfaceUUID *string) {
	o.InterfaceUUID = interfaceUUID
}

// WithMachineAccount adds the machineAccount to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) WithMachineAccount(machineAccount *string) *KerberosInterfaceModifyCollectionParams {
	o.SetMachineAccount(machineAccount)
	return o
}

// SetMachineAccount adds the machineAccount to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) SetMachineAccount(machineAccount *string) {
	o.MachineAccount = machineAccount
}

// WithReturnRecords adds the returnRecords to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) WithReturnRecords(returnRecords *bool) *KerberosInterfaceModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *KerberosInterfaceModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) WithSerialRecords(serialRecords *bool) *KerberosInterfaceModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSpn adds the spn to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) WithSpn(spn *string) *KerberosInterfaceModifyCollectionParams {
	o.SetSpn(spn)
	return o
}

// SetSpn adds the spn to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) SetSpn(spn *string) {
	o.Spn = spn
}

// WithSvmName adds the svmName to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) WithSvmName(svmName *string) *KerberosInterfaceModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) WithSvmUUID(svmUUID *string) *KerberosInterfaceModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the kerberos interface modify collection params
func (o *KerberosInterfaceModifyCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *KerberosInterfaceModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.EncryptionTypes != nil {

		// query param encryption_types
		var qrEncryptionTypes string

		if o.EncryptionTypes != nil {
			qrEncryptionTypes = *o.EncryptionTypes
		}
		qEncryptionTypes := qrEncryptionTypes
		if qEncryptionTypes != "" {

			if err := r.SetQueryParam("encryption_types", qEncryptionTypes); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.InterfaceIPAddress != nil {

		// query param interface.ip.address
		var qrInterfaceIPAddress string

		if o.InterfaceIPAddress != nil {
			qrInterfaceIPAddress = *o.InterfaceIPAddress
		}
		qInterfaceIPAddress := qrInterfaceIPAddress
		if qInterfaceIPAddress != "" {

			if err := r.SetQueryParam("interface.ip.address", qInterfaceIPAddress); err != nil {
				return err
			}
		}
	}

	if o.InterfaceName != nil {

		// query param interface.name
		var qrInterfaceName string

		if o.InterfaceName != nil {
			qrInterfaceName = *o.InterfaceName
		}
		qInterfaceName := qrInterfaceName
		if qInterfaceName != "" {

			if err := r.SetQueryParam("interface.name", qInterfaceName); err != nil {
				return err
			}
		}
	}

	if o.InterfaceUUID != nil {

		// query param interface.uuid
		var qrInterfaceUUID string

		if o.InterfaceUUID != nil {
			qrInterfaceUUID = *o.InterfaceUUID
		}
		qInterfaceUUID := qrInterfaceUUID
		if qInterfaceUUID != "" {

			if err := r.SetQueryParam("interface.uuid", qInterfaceUUID); err != nil {
				return err
			}
		}
	}

	if o.MachineAccount != nil {

		// query param machine_account
		var qrMachineAccount string

		if o.MachineAccount != nil {
			qrMachineAccount = *o.MachineAccount
		}
		qMachineAccount := qrMachineAccount
		if qMachineAccount != "" {

			if err := r.SetQueryParam("machine_account", qMachineAccount); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.Spn != nil {

		// query param spn
		var qrSpn string

		if o.Spn != nil {
			qrSpn = *o.Spn
		}
		qSpn := qrSpn
		if qSpn != "" {

			if err := r.SetQueryParam("spn", qSpn); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
