// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewKerberosRealmCollectionGetParams creates a new KerberosRealmCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewKerberosRealmCollectionGetParams() *KerberosRealmCollectionGetParams {
	return &KerberosRealmCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewKerberosRealmCollectionGetParamsWithTimeout creates a new KerberosRealmCollectionGetParams object
// with the ability to set a timeout on a request.
func NewKerberosRealmCollectionGetParamsWithTimeout(timeout time.Duration) *KerberosRealmCollectionGetParams {
	return &KerberosRealmCollectionGetParams{
		timeout: timeout,
	}
}

// NewKerberosRealmCollectionGetParamsWithContext creates a new KerberosRealmCollectionGetParams object
// with the ability to set a context for a request.
func NewKerberosRealmCollectionGetParamsWithContext(ctx context.Context) *KerberosRealmCollectionGetParams {
	return &KerberosRealmCollectionGetParams{
		Context: ctx,
	}
}

// NewKerberosRealmCollectionGetParamsWithHTTPClient creates a new KerberosRealmCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewKerberosRealmCollectionGetParamsWithHTTPClient(client *http.Client) *KerberosRealmCollectionGetParams {
	return &KerberosRealmCollectionGetParams{
		HTTPClient: client,
	}
}

/*
KerberosRealmCollectionGetParams contains all the parameters to send to the API endpoint

	for the kerberos realm collection get operation.

	Typically these are written to a http.Request.
*/
type KerberosRealmCollectionGetParams struct {

	/* AdServerAddress.

	   Filter by ad_server.address
	*/
	AdServerAddress *string

	/* AdServerName.

	   Filter by ad_server.name
	*/
	AdServerName *string

	/* AdminServerAddress.

	   Filter by admin_server.address
	*/
	AdminServerAddress *string

	/* AdminServerPort.

	   Filter by admin_server.port
	*/
	AdminServerPort *int64

	/* ClockSkew.

	   Filter by clock_skew
	*/
	ClockSkew *int64

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* EncryptionTypes.

	   Filter by encryption_types
	*/
	EncryptionTypes *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* KdcIP.

	   Filter by kdc.ip
	*/
	KdcIP *string

	/* KdcPort.

	   Filter by kdc.port
	*/
	KdcPort *int64

	/* KdcVendor.

	   Filter by kdc.vendor
	*/
	KdcVendor *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* PasswordServerAddress.

	   Filter by password_server.address
	*/
	PasswordServerAddress *string

	/* PasswordServerPort.

	   Filter by password_server.port
	*/
	PasswordServerPort *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the kerberos realm collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *KerberosRealmCollectionGetParams) WithDefaults() *KerberosRealmCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the kerberos realm collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *KerberosRealmCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := KerberosRealmCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) WithTimeout(timeout time.Duration) *KerberosRealmCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) WithContext(ctx context.Context) *KerberosRealmCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) WithHTTPClient(client *http.Client) *KerberosRealmCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAdServerAddress adds the adServerAddress to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) WithAdServerAddress(adServerAddress *string) *KerberosRealmCollectionGetParams {
	o.SetAdServerAddress(adServerAddress)
	return o
}

// SetAdServerAddress adds the adServerAddress to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) SetAdServerAddress(adServerAddress *string) {
	o.AdServerAddress = adServerAddress
}

// WithAdServerName adds the adServerName to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) WithAdServerName(adServerName *string) *KerberosRealmCollectionGetParams {
	o.SetAdServerName(adServerName)
	return o
}

// SetAdServerName adds the adServerName to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) SetAdServerName(adServerName *string) {
	o.AdServerName = adServerName
}

// WithAdminServerAddress adds the adminServerAddress to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) WithAdminServerAddress(adminServerAddress *string) *KerberosRealmCollectionGetParams {
	o.SetAdminServerAddress(adminServerAddress)
	return o
}

// SetAdminServerAddress adds the adminServerAddress to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) SetAdminServerAddress(adminServerAddress *string) {
	o.AdminServerAddress = adminServerAddress
}

// WithAdminServerPort adds the adminServerPort to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) WithAdminServerPort(adminServerPort *int64) *KerberosRealmCollectionGetParams {
	o.SetAdminServerPort(adminServerPort)
	return o
}

// SetAdminServerPort adds the adminServerPort to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) SetAdminServerPort(adminServerPort *int64) {
	o.AdminServerPort = adminServerPort
}

// WithClockSkew adds the clockSkew to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) WithClockSkew(clockSkew *int64) *KerberosRealmCollectionGetParams {
	o.SetClockSkew(clockSkew)
	return o
}

// SetClockSkew adds the clockSkew to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) SetClockSkew(clockSkew *int64) {
	o.ClockSkew = clockSkew
}

// WithComment adds the comment to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) WithComment(comment *string) *KerberosRealmCollectionGetParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithEncryptionTypes adds the encryptionTypes to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) WithEncryptionTypes(encryptionTypes *string) *KerberosRealmCollectionGetParams {
	o.SetEncryptionTypes(encryptionTypes)
	return o
}

// SetEncryptionTypes adds the encryptionTypes to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) SetEncryptionTypes(encryptionTypes *string) {
	o.EncryptionTypes = encryptionTypes
}

// WithFields adds the fields to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) WithFields(fields []string) *KerberosRealmCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithKdcIP adds the kdcIP to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) WithKdcIP(kdcIP *string) *KerberosRealmCollectionGetParams {
	o.SetKdcIP(kdcIP)
	return o
}

// SetKdcIP adds the kdcIp to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) SetKdcIP(kdcIP *string) {
	o.KdcIP = kdcIP
}

// WithKdcPort adds the kdcPort to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) WithKdcPort(kdcPort *int64) *KerberosRealmCollectionGetParams {
	o.SetKdcPort(kdcPort)
	return o
}

// SetKdcPort adds the kdcPort to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) SetKdcPort(kdcPort *int64) {
	o.KdcPort = kdcPort
}

// WithKdcVendor adds the kdcVendor to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) WithKdcVendor(kdcVendor *string) *KerberosRealmCollectionGetParams {
	o.SetKdcVendor(kdcVendor)
	return o
}

// SetKdcVendor adds the kdcVendor to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) SetKdcVendor(kdcVendor *string) {
	o.KdcVendor = kdcVendor
}

// WithMaxRecords adds the maxRecords to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) WithMaxRecords(maxRecords *int64) *KerberosRealmCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) WithName(name *string) *KerberosRealmCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) WithOrderBy(orderBy []string) *KerberosRealmCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPasswordServerAddress adds the passwordServerAddress to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) WithPasswordServerAddress(passwordServerAddress *string) *KerberosRealmCollectionGetParams {
	o.SetPasswordServerAddress(passwordServerAddress)
	return o
}

// SetPasswordServerAddress adds the passwordServerAddress to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) SetPasswordServerAddress(passwordServerAddress *string) {
	o.PasswordServerAddress = passwordServerAddress
}

// WithPasswordServerPort adds the passwordServerPort to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) WithPasswordServerPort(passwordServerPort *int64) *KerberosRealmCollectionGetParams {
	o.SetPasswordServerPort(passwordServerPort)
	return o
}

// SetPasswordServerPort adds the passwordServerPort to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) SetPasswordServerPort(passwordServerPort *int64) {
	o.PasswordServerPort = passwordServerPort
}

// WithReturnRecords adds the returnRecords to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) WithReturnRecords(returnRecords *bool) *KerberosRealmCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *KerberosRealmCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmName adds the svmName to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) WithSvmName(svmName *string) *KerberosRealmCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) WithSvmUUID(svmUUID *string) *KerberosRealmCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the kerberos realm collection get params
func (o *KerberosRealmCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *KerberosRealmCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AdServerAddress != nil {

		// query param ad_server.address
		var qrAdServerAddress string

		if o.AdServerAddress != nil {
			qrAdServerAddress = *o.AdServerAddress
		}
		qAdServerAddress := qrAdServerAddress
		if qAdServerAddress != "" {

			if err := r.SetQueryParam("ad_server.address", qAdServerAddress); err != nil {
				return err
			}
		}
	}

	if o.AdServerName != nil {

		// query param ad_server.name
		var qrAdServerName string

		if o.AdServerName != nil {
			qrAdServerName = *o.AdServerName
		}
		qAdServerName := qrAdServerName
		if qAdServerName != "" {

			if err := r.SetQueryParam("ad_server.name", qAdServerName); err != nil {
				return err
			}
		}
	}

	if o.AdminServerAddress != nil {

		// query param admin_server.address
		var qrAdminServerAddress string

		if o.AdminServerAddress != nil {
			qrAdminServerAddress = *o.AdminServerAddress
		}
		qAdminServerAddress := qrAdminServerAddress
		if qAdminServerAddress != "" {

			if err := r.SetQueryParam("admin_server.address", qAdminServerAddress); err != nil {
				return err
			}
		}
	}

	if o.AdminServerPort != nil {

		// query param admin_server.port
		var qrAdminServerPort int64

		if o.AdminServerPort != nil {
			qrAdminServerPort = *o.AdminServerPort
		}
		qAdminServerPort := swag.FormatInt64(qrAdminServerPort)
		if qAdminServerPort != "" {

			if err := r.SetQueryParam("admin_server.port", qAdminServerPort); err != nil {
				return err
			}
		}
	}

	if o.ClockSkew != nil {

		// query param clock_skew
		var qrClockSkew int64

		if o.ClockSkew != nil {
			qrClockSkew = *o.ClockSkew
		}
		qClockSkew := swag.FormatInt64(qrClockSkew)
		if qClockSkew != "" {

			if err := r.SetQueryParam("clock_skew", qClockSkew); err != nil {
				return err
			}
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.EncryptionTypes != nil {

		// query param encryption_types
		var qrEncryptionTypes string

		if o.EncryptionTypes != nil {
			qrEncryptionTypes = *o.EncryptionTypes
		}
		qEncryptionTypes := qrEncryptionTypes
		if qEncryptionTypes != "" {

			if err := r.SetQueryParam("encryption_types", qEncryptionTypes); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.KdcIP != nil {

		// query param kdc.ip
		var qrKdcIP string

		if o.KdcIP != nil {
			qrKdcIP = *o.KdcIP
		}
		qKdcIP := qrKdcIP
		if qKdcIP != "" {

			if err := r.SetQueryParam("kdc.ip", qKdcIP); err != nil {
				return err
			}
		}
	}

	if o.KdcPort != nil {

		// query param kdc.port
		var qrKdcPort int64

		if o.KdcPort != nil {
			qrKdcPort = *o.KdcPort
		}
		qKdcPort := swag.FormatInt64(qrKdcPort)
		if qKdcPort != "" {

			if err := r.SetQueryParam("kdc.port", qKdcPort); err != nil {
				return err
			}
		}
	}

	if o.KdcVendor != nil {

		// query param kdc.vendor
		var qrKdcVendor string

		if o.KdcVendor != nil {
			qrKdcVendor = *o.KdcVendor
		}
		qKdcVendor := qrKdcVendor
		if qKdcVendor != "" {

			if err := r.SetQueryParam("kdc.vendor", qKdcVendor); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PasswordServerAddress != nil {

		// query param password_server.address
		var qrPasswordServerAddress string

		if o.PasswordServerAddress != nil {
			qrPasswordServerAddress = *o.PasswordServerAddress
		}
		qPasswordServerAddress := qrPasswordServerAddress
		if qPasswordServerAddress != "" {

			if err := r.SetQueryParam("password_server.address", qPasswordServerAddress); err != nil {
				return err
			}
		}
	}

	if o.PasswordServerPort != nil {

		// query param password_server.port
		var qrPasswordServerPort int64

		if o.PasswordServerPort != nil {
			qrPasswordServerPort = *o.PasswordServerPort
		}
		qPasswordServerPort := swag.FormatInt64(qrPasswordServerPort)
		if qPasswordServerPort != "" {

			if err := r.SetQueryParam("password_server.port", qPasswordServerPort); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamKerberosRealmCollectionGet binds the parameter fields
func (o *KerberosRealmCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamKerberosRealmCollectionGet binds the parameter order_by
func (o *KerberosRealmCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
