// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// KerberosRealmCreateReader is a Reader for the KerberosRealmCreate structure.
type KerberosRealmCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *KerberosRealmCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewKerberosRealmCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewKerberosRealmCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewKerberosRealmCreateCreated creates a KerberosRealmCreateCreated with default headers values
func NewKerberosRealmCreateCreated() *KerberosRealmCreateCreated {
	return &KerberosRealmCreateCreated{}
}

/*
KerberosRealmCreateCreated describes a response with status code 201, with default header values.

Created
*/
type KerberosRealmCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string
}

// IsSuccess returns true when this kerberos realm create created response has a 2xx status code
func (o *KerberosRealmCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this kerberos realm create created response has a 3xx status code
func (o *KerberosRealmCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this kerberos realm create created response has a 4xx status code
func (o *KerberosRealmCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this kerberos realm create created response has a 5xx status code
func (o *KerberosRealmCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this kerberos realm create created response a status code equal to that given
func (o *KerberosRealmCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the kerberos realm create created response
func (o *KerberosRealmCreateCreated) Code() int {
	return 201
}

func (o *KerberosRealmCreateCreated) Error() string {
	return fmt.Sprintf("[POST /protocols/nfs/kerberos/realms][%d] kerberosRealmCreateCreated", 201)
}

func (o *KerberosRealmCreateCreated) String() string {
	return fmt.Sprintf("[POST /protocols/nfs/kerberos/realms][%d] kerberosRealmCreateCreated", 201)
}

func (o *KerberosRealmCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	return nil
}

// NewKerberosRealmCreateDefault creates a KerberosRealmCreateDefault with default headers values
func NewKerberosRealmCreateDefault(code int) *KerberosRealmCreateDefault {
	return &KerberosRealmCreateDefault{
		_statusCode: code,
	}
}

/*
	KerberosRealmCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error codes | Description |
| ----------- | ----------- |
| 2949121     | Active Directory server name required.|
| 2949122     | Active Directory server address required|
| 2949123     | Failed to create Kerberos realm.|
| 2949124     | Failed to create hosts file entry.|
| 3276949     | Kerberos realm creation failed. Reason: The parameters "ad_server.name" and "ad_server.address" are only valid when "kdc.vendor" is Microsoft|
| 3276976     | "realm" is a required input|
| 3276998     | Only the data Vservers can own NFS Kerberos realms.|
*/
type KerberosRealmCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this kerberos realm create default response has a 2xx status code
func (o *KerberosRealmCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this kerberos realm create default response has a 3xx status code
func (o *KerberosRealmCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this kerberos realm create default response has a 4xx status code
func (o *KerberosRealmCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this kerberos realm create default response has a 5xx status code
func (o *KerberosRealmCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this kerberos realm create default response a status code equal to that given
func (o *KerberosRealmCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the kerberos realm create default response
func (o *KerberosRealmCreateDefault) Code() int {
	return o._statusCode
}

func (o *KerberosRealmCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/nfs/kerberos/realms][%d] kerberos_realm_create default %s", o._statusCode, payload)
}

func (o *KerberosRealmCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/nfs/kerberos/realms][%d] kerberos_realm_create default %s", o._statusCode, payload)
}

func (o *KerberosRealmCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *KerberosRealmCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
