// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// KerberosRealmDeleteCollectionReader is a Reader for the KerberosRealmDeleteCollection structure.
type KerberosRealmDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *KerberosRealmDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewKerberosRealmDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewKerberosRealmDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewKerberosRealmDeleteCollectionOK creates a KerberosRealmDeleteCollectionOK with default headers values
func NewKerberosRealmDeleteCollectionOK() *KerberosRealmDeleteCollectionOK {
	return &KerberosRealmDeleteCollectionOK{}
}

/*
KerberosRealmDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type KerberosRealmDeleteCollectionOK struct {
}

// IsSuccess returns true when this kerberos realm delete collection o k response has a 2xx status code
func (o *KerberosRealmDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this kerberos realm delete collection o k response has a 3xx status code
func (o *KerberosRealmDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this kerberos realm delete collection o k response has a 4xx status code
func (o *KerberosRealmDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this kerberos realm delete collection o k response has a 5xx status code
func (o *KerberosRealmDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this kerberos realm delete collection o k response a status code equal to that given
func (o *KerberosRealmDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the kerberos realm delete collection o k response
func (o *KerberosRealmDeleteCollectionOK) Code() int {
	return 200
}

func (o *KerberosRealmDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/nfs/kerberos/realms][%d] kerberosRealmDeleteCollectionOK", 200)
}

func (o *KerberosRealmDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/nfs/kerberos/realms][%d] kerberosRealmDeleteCollectionOK", 200)
}

func (o *KerberosRealmDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewKerberosRealmDeleteCollectionDefault creates a KerberosRealmDeleteCollectionDefault with default headers values
func NewKerberosRealmDeleteCollectionDefault(code int) *KerberosRealmDeleteCollectionDefault {
	return &KerberosRealmDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	KerberosRealmDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error codes | Description |
| ----------- | ----------- |
| 1966125     | Failed to remove hosts entry.|
| 1966126     | Failed to lookup hosts entry.|
| 2949141     | Failed to lookup Kerberos realm.|
| 2949142     | Failed to remove Kerberos realm.|
| 3276942     | Service principal name is invalid. It must of the format:"nfs/<LIF-FQDN>@REALM\\\"|
| 3276976     | "realm" is a required input|
| 3276998     | Only the data Vservers can own NFS Kerberos realms.|
*/
type KerberosRealmDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this kerberos realm delete collection default response has a 2xx status code
func (o *KerberosRealmDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this kerberos realm delete collection default response has a 3xx status code
func (o *KerberosRealmDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this kerberos realm delete collection default response has a 4xx status code
func (o *KerberosRealmDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this kerberos realm delete collection default response has a 5xx status code
func (o *KerberosRealmDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this kerberos realm delete collection default response a status code equal to that given
func (o *KerberosRealmDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the kerberos realm delete collection default response
func (o *KerberosRealmDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *KerberosRealmDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nfs/kerberos/realms][%d] kerberos_realm_delete_collection default %s", o._statusCode, payload)
}

func (o *KerberosRealmDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nfs/kerberos/realms][%d] kerberos_realm_delete_collection default %s", o._statusCode, payload)
}

func (o *KerberosRealmDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *KerberosRealmDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
KerberosRealmDeleteCollectionBody kerberos realm delete collection body
swagger:model KerberosRealmDeleteCollectionBody
*/
type KerberosRealmDeleteCollectionBody struct {

	// kerberos realm response inline records
	KerberosRealmResponseInlineRecords []*models.KerberosRealm `json:"records,omitempty"`
}

// Validate validates this kerberos realm delete collection body
func (o *KerberosRealmDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateKerberosRealmResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *KerberosRealmDeleteCollectionBody) validateKerberosRealmResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.KerberosRealmResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.KerberosRealmResponseInlineRecords); i++ {
		if swag.IsZero(o.KerberosRealmResponseInlineRecords[i]) { // not required
			continue
		}

		if o.KerberosRealmResponseInlineRecords[i] != nil {
			if err := o.KerberosRealmResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this kerberos realm delete collection body based on the context it is used
func (o *KerberosRealmDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateKerberosRealmResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *KerberosRealmDeleteCollectionBody) contextValidateKerberosRealmResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.KerberosRealmResponseInlineRecords); i++ {

		if o.KerberosRealmResponseInlineRecords[i] != nil {
			if err := o.KerberosRealmResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *KerberosRealmDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *KerberosRealmDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res KerberosRealmDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
