// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// KerberosRealmDeleteReader is a Reader for the KerberosRealmDelete structure.
type KerberosRealmDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *KerberosRealmDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewKerberosRealmDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewKerberosRealmDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewKerberosRealmDeleteOK creates a KerberosRealmDeleteOK with default headers values
func NewKerberosRealmDeleteOK() *KerberosRealmDeleteOK {
	return &KerberosRealmDeleteOK{}
}

/*
KerberosRealmDeleteOK describes a response with status code 200, with default header values.

OK
*/
type KerberosRealmDeleteOK struct {
}

// IsSuccess returns true when this kerberos realm delete o k response has a 2xx status code
func (o *KerberosRealmDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this kerberos realm delete o k response has a 3xx status code
func (o *KerberosRealmDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this kerberos realm delete o k response has a 4xx status code
func (o *KerberosRealmDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this kerberos realm delete o k response has a 5xx status code
func (o *KerberosRealmDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this kerberos realm delete o k response a status code equal to that given
func (o *KerberosRealmDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the kerberos realm delete o k response
func (o *KerberosRealmDeleteOK) Code() int {
	return 200
}

func (o *KerberosRealmDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/nfs/kerberos/realms/{svm.uuid}/{name}][%d] kerberosRealmDeleteOK", 200)
}

func (o *KerberosRealmDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/nfs/kerberos/realms/{svm.uuid}/{name}][%d] kerberosRealmDeleteOK", 200)
}

func (o *KerberosRealmDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewKerberosRealmDeleteDefault creates a KerberosRealmDeleteDefault with default headers values
func NewKerberosRealmDeleteDefault(code int) *KerberosRealmDeleteDefault {
	return &KerberosRealmDeleteDefault{
		_statusCode: code,
	}
}

/*
	KerberosRealmDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error codes | Description |
| ----------- | ----------- |
| 1966125     | Failed to remove hosts entry.|
| 1966126     | Failed to lookup hosts entry.|
| 2949141     | Failed to lookup Kerberos realm.|
| 2949142     | Failed to remove Kerberos realm.|
| 3276942     | Service principal name is invalid. It must of the format:"nfs/<LIF-FQDN>@REALM\\\"|
| 3276976     | "realm" is a required input|
| 3276998     | Only the data Vservers can own NFS Kerberos realms.|
*/
type KerberosRealmDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this kerberos realm delete default response has a 2xx status code
func (o *KerberosRealmDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this kerberos realm delete default response has a 3xx status code
func (o *KerberosRealmDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this kerberos realm delete default response has a 4xx status code
func (o *KerberosRealmDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this kerberos realm delete default response has a 5xx status code
func (o *KerberosRealmDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this kerberos realm delete default response a status code equal to that given
func (o *KerberosRealmDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the kerberos realm delete default response
func (o *KerberosRealmDeleteDefault) Code() int {
	return o._statusCode
}

func (o *KerberosRealmDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nfs/kerberos/realms/{svm.uuid}/{name}][%d] kerberos_realm_delete default %s", o._statusCode, payload)
}

func (o *KerberosRealmDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nfs/kerberos/realms/{svm.uuid}/{name}][%d] kerberos_realm_delete default %s", o._statusCode, payload)
}

func (o *KerberosRealmDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *KerberosRealmDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
