// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// KerberosRealmModifyCollectionReader is a Reader for the KerberosRealmModifyCollection structure.
type KerberosRealmModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *KerberosRealmModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewKerberosRealmModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewKerberosRealmModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewKerberosRealmModifyCollectionOK creates a KerberosRealmModifyCollectionOK with default headers values
func NewKerberosRealmModifyCollectionOK() *KerberosRealmModifyCollectionOK {
	return &KerberosRealmModifyCollectionOK{}
}

/*
KerberosRealmModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type KerberosRealmModifyCollectionOK struct {
}

// IsSuccess returns true when this kerberos realm modify collection o k response has a 2xx status code
func (o *KerberosRealmModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this kerberos realm modify collection o k response has a 3xx status code
func (o *KerberosRealmModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this kerberos realm modify collection o k response has a 4xx status code
func (o *KerberosRealmModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this kerberos realm modify collection o k response has a 5xx status code
func (o *KerberosRealmModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this kerberos realm modify collection o k response a status code equal to that given
func (o *KerberosRealmModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the kerberos realm modify collection o k response
func (o *KerberosRealmModifyCollectionOK) Code() int {
	return 200
}

func (o *KerberosRealmModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/nfs/kerberos/realms][%d] kerberosRealmModifyCollectionOK", 200)
}

func (o *KerberosRealmModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/nfs/kerberos/realms][%d] kerberosRealmModifyCollectionOK", 200)
}

func (o *KerberosRealmModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewKerberosRealmModifyCollectionDefault creates a KerberosRealmModifyCollectionDefault with default headers values
func NewKerberosRealmModifyCollectionDefault(code int) *KerberosRealmModifyCollectionDefault {
	return &KerberosRealmModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	KerberosRealmModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error codes | Description |
| ----------- | ----------- |
| 1966125     | Failed to remove hosts entry.|
| 1966126     | Failed to lookup hosts entry.|
| 1966131     | Failed to create hosts entry.|
| 1966132     | Failed to modify hosts entry.|
| 2949121     | Active Directory server name required.|
| 2949122     | Active Directory server address required|
| 2949123     | Failed to create Kerberos realm.|
| 2949124     | Failed to create hosts file entry.|
| 2949141     | Failed to lookup Kerberos realm.|
| 2949148     | Failed to modify Kerberos realm.|
| 3276976     | "realm" is a required input|
| 3276998     | Only the data Vservers can own NFS Kerberos realms.|
*/
type KerberosRealmModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this kerberos realm modify collection default response has a 2xx status code
func (o *KerberosRealmModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this kerberos realm modify collection default response has a 3xx status code
func (o *KerberosRealmModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this kerberos realm modify collection default response has a 4xx status code
func (o *KerberosRealmModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this kerberos realm modify collection default response has a 5xx status code
func (o *KerberosRealmModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this kerberos realm modify collection default response a status code equal to that given
func (o *KerberosRealmModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the kerberos realm modify collection default response
func (o *KerberosRealmModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *KerberosRealmModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/nfs/kerberos/realms][%d] kerberos_realm_modify_collection default %s", o._statusCode, payload)
}

func (o *KerberosRealmModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/nfs/kerberos/realms][%d] kerberos_realm_modify_collection default %s", o._statusCode, payload)
}

func (o *KerberosRealmModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *KerberosRealmModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
KerberosRealmModifyCollectionBody kerberos realm modify collection body
swagger:model KerberosRealmModifyCollectionBody
*/
type KerberosRealmModifyCollectionBody struct {

	// links
	Links *models.KerberosRealmInlineLinks `json:"_links,omitempty"`

	// ad server
	AdServer *models.KerberosRealmInlineAdServer `json:"ad_server,omitempty"`

	// admin server
	AdminServer *models.KerberosRealmInlineAdminServer `json:"admin_server,omitempty"`

	// Specifies the allowed time of clock-skew between the server and clients, in minutes.
	ClockSkew *int64 `json:"clock_skew,omitempty"`

	// Comment
	Comment *string `json:"comment,omitempty"`

	// encryption types
	// Read Only: true
	EncryptionTypes []*string `json:"encryption_types,omitempty"`

	// kdc
	Kdc *models.KerberosRealmInlineKdc `json:"kdc,omitempty"`

	// kerberos realm response inline records
	KerberosRealmResponseInlineRecords []*models.KerberosRealm `json:"records,omitempty"`

	// Kerberos realm
	Name *string `json:"name,omitempty"`

	// password server
	PasswordServer *models.KerberosRealmInlinePasswordServer `json:"password_server,omitempty"`

	// svm
	Svm *models.KerberosRealmInlineSvm `json:"svm,omitempty"`
}

// Validate validates this kerberos realm modify collection body
func (o *KerberosRealmModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAdServer(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAdminServer(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEncryptionTypes(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateKdc(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateKerberosRealmResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePasswordServer(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *KerberosRealmModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *KerberosRealmModifyCollectionBody) validateAdServer(formats strfmt.Registry) error {
	if swag.IsZero(o.AdServer) { // not required
		return nil
	}

	if o.AdServer != nil {
		if err := o.AdServer.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ad_server")
			}
			return err
		}
	}

	return nil
}

func (o *KerberosRealmModifyCollectionBody) validateAdminServer(formats strfmt.Registry) error {
	if swag.IsZero(o.AdminServer) { // not required
		return nil
	}

	if o.AdminServer != nil {
		if err := o.AdminServer.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "admin_server")
			}
			return err
		}
	}

	return nil
}

var kerberosRealmModifyCollectionBodyEncryptionTypesItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["des","des3","aes_128","aes_256"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		kerberosRealmModifyCollectionBodyEncryptionTypesItemsEnum = append(kerberosRealmModifyCollectionBodyEncryptionTypesItemsEnum, v)
	}
}

func (o *KerberosRealmModifyCollectionBody) validateEncryptionTypesItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, kerberosRealmModifyCollectionBodyEncryptionTypesItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *KerberosRealmModifyCollectionBody) validateEncryptionTypes(formats strfmt.Registry) error {
	if swag.IsZero(o.EncryptionTypes) { // not required
		return nil
	}

	for i := 0; i < len(o.EncryptionTypes); i++ {
		if swag.IsZero(o.EncryptionTypes[i]) { // not required
			continue
		}

		// value enum
		if err := o.validateEncryptionTypesItemsEnum("info"+"."+"encryption_types"+"."+strconv.Itoa(i), "body", *o.EncryptionTypes[i]); err != nil {
			return err
		}

	}

	return nil
}

func (o *KerberosRealmModifyCollectionBody) validateKdc(formats strfmt.Registry) error {
	if swag.IsZero(o.Kdc) { // not required
		return nil
	}

	if o.Kdc != nil {
		if err := o.Kdc.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "kdc")
			}
			return err
		}
	}

	return nil
}

func (o *KerberosRealmModifyCollectionBody) validateKerberosRealmResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.KerberosRealmResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.KerberosRealmResponseInlineRecords); i++ {
		if swag.IsZero(o.KerberosRealmResponseInlineRecords[i]) { // not required
			continue
		}

		if o.KerberosRealmResponseInlineRecords[i] != nil {
			if err := o.KerberosRealmResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *KerberosRealmModifyCollectionBody) validatePasswordServer(formats strfmt.Registry) error {
	if swag.IsZero(o.PasswordServer) { // not required
		return nil
	}

	if o.PasswordServer != nil {
		if err := o.PasswordServer.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "password_server")
			}
			return err
		}
	}

	return nil
}

func (o *KerberosRealmModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this kerberos realm modify collection body based on the context it is used
func (o *KerberosRealmModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAdServer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAdminServer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEncryptionTypes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateKdc(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateKerberosRealmResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePasswordServer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *KerberosRealmModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *KerberosRealmModifyCollectionBody) contextValidateAdServer(ctx context.Context, formats strfmt.Registry) error {

	if o.AdServer != nil {
		if err := o.AdServer.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ad_server")
			}
			return err
		}
	}

	return nil
}

func (o *KerberosRealmModifyCollectionBody) contextValidateAdminServer(ctx context.Context, formats strfmt.Registry) error {

	if o.AdminServer != nil {
		if err := o.AdminServer.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "admin_server")
			}
			return err
		}
	}

	return nil
}

func (o *KerberosRealmModifyCollectionBody) contextValidateEncryptionTypes(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"encryption_types", "body", []*string(o.EncryptionTypes)); err != nil {
		return err
	}

	for i := 0; i < len(o.EncryptionTypes); i++ {

		if err := validate.ReadOnly(ctx, "info"+"."+"encryption_types"+"."+strconv.Itoa(i), "body", o.EncryptionTypes[i]); err != nil {
			return err
		}

	}

	return nil
}

func (o *KerberosRealmModifyCollectionBody) contextValidateKdc(ctx context.Context, formats strfmt.Registry) error {

	if o.Kdc != nil {
		if err := o.Kdc.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "kdc")
			}
			return err
		}
	}

	return nil
}

func (o *KerberosRealmModifyCollectionBody) contextValidateKerberosRealmResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.KerberosRealmResponseInlineRecords); i++ {

		if o.KerberosRealmResponseInlineRecords[i] != nil {
			if err := o.KerberosRealmResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *KerberosRealmModifyCollectionBody) contextValidatePasswordServer(ctx context.Context, formats strfmt.Registry) error {

	if o.PasswordServer != nil {
		if err := o.PasswordServer.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "password_server")
			}
			return err
		}
	}

	return nil
}

func (o *KerberosRealmModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *KerberosRealmModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *KerberosRealmModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res KerberosRealmModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
KerberosRealmInlineLinks kerberos realm inline links
swagger:model kerberos_realm_inline__links
*/
type KerberosRealmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this kerberos realm inline links
func (o *KerberosRealmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *KerberosRealmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this kerberos realm inline links based on the context it is used
func (o *KerberosRealmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *KerberosRealmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *KerberosRealmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *KerberosRealmInlineLinks) UnmarshalBinary(b []byte) error {
	var res KerberosRealmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
KerberosRealmInlineAdServer kerberos realm inline ad server
swagger:model kerberos_realm_inline_ad_server
*/
type KerberosRealmInlineAdServer struct {

	// Active Directory server IP address
	// Example: 1.2.3.4
	Address *string `json:"address,omitempty"`

	// Active Directory server name
	Name *string `json:"name,omitempty"`
}

// Validate validates this kerberos realm inline ad server
func (o *KerberosRealmInlineAdServer) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this kerberos realm inline ad server based on context it is used
func (o *KerberosRealmInlineAdServer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *KerberosRealmInlineAdServer) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *KerberosRealmInlineAdServer) UnmarshalBinary(b []byte) error {
	var res KerberosRealmInlineAdServer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
KerberosRealmInlineAdminServer kerberos realm inline admin server
swagger:model kerberos_realm_inline_admin_server
*/
type KerberosRealmInlineAdminServer struct {

	// Admin server IP address.
	// Example: 1.2.3.4
	Address *string `json:"address,omitempty"`

	// Specifies the port number of admin server.
	Port *int64 `json:"port,omitempty"`
}

// Validate validates this kerberos realm inline admin server
func (o *KerberosRealmInlineAdminServer) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this kerberos realm inline admin server based on context it is used
func (o *KerberosRealmInlineAdminServer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *KerberosRealmInlineAdminServer) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *KerberosRealmInlineAdminServer) UnmarshalBinary(b []byte) error {
	var res KerberosRealmInlineAdminServer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
KerberosRealmInlineKdc kerberos realm inline kdc
swagger:model kerberos_realm_inline_kdc
*/
type KerberosRealmInlineKdc struct {

	// KDC IP address
	// Example: 1.2.3.4
	IP *string `json:"ip,omitempty"`

	// KDC port
	// Example: 88
	// Maximum: 65535
	// Minimum: 1
	Port *int64 `json:"port,omitempty"`

	// Key Distribution Center (KDC) vendor. Following values are supported:
	// * microsoft - Microsoft Active Directory KDC
	// * other - MIT Kerberos KDC or other KDC
	//
	// Enum: ["microsoft","other"]
	Vendor *string `json:"vendor,omitempty"`
}

// Validate validates this kerberos realm inline kdc
func (o *KerberosRealmInlineKdc) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePort(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVendor(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *KerberosRealmInlineKdc) validatePort(formats strfmt.Registry) error {
	if swag.IsZero(o.Port) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"kdc"+"."+"port", "body", *o.Port, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"kdc"+"."+"port", "body", *o.Port, 65535, false); err != nil {
		return err
	}

	return nil
}

var kerberosRealmInlineKdcTypeVendorPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["microsoft","other"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		kerberosRealmInlineKdcTypeVendorPropEnum = append(kerberosRealmInlineKdcTypeVendorPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// kerberos_realm_inline_kdc
	// KerberosRealmInlineKdc
	// vendor
	// Vendor
	// microsoft
	// END DEBUGGING
	// KerberosRealmInlineKdcVendorMicrosoft captures enum value "microsoft"
	KerberosRealmInlineKdcVendorMicrosoft string = "microsoft"

	// BEGIN DEBUGGING
	// kerberos_realm_inline_kdc
	// KerberosRealmInlineKdc
	// vendor
	// Vendor
	// other
	// END DEBUGGING
	// KerberosRealmInlineKdcVendorOther captures enum value "other"
	KerberosRealmInlineKdcVendorOther string = "other"
)

// prop value enum
func (o *KerberosRealmInlineKdc) validateVendorEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, kerberosRealmInlineKdcTypeVendorPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *KerberosRealmInlineKdc) validateVendor(formats strfmt.Registry) error {
	if swag.IsZero(o.Vendor) { // not required
		return nil
	}

	// value enum
	if err := o.validateVendorEnum("info"+"."+"kdc"+"."+"vendor", "body", *o.Vendor); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this kerberos realm inline kdc based on context it is used
func (o *KerberosRealmInlineKdc) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *KerberosRealmInlineKdc) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *KerberosRealmInlineKdc) UnmarshalBinary(b []byte) error {
	var res KerberosRealmInlineKdc
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
KerberosRealmInlinePasswordServer kerberos realm inline password server
swagger:model kerberos_realm_inline_password_server
*/
type KerberosRealmInlinePasswordServer struct {

	// Password server IP address.
	// Example: 1.2.3.4
	Address *string `json:"address,omitempty"`

	// Specifies the port number of password server.
	Port *int64 `json:"port,omitempty"`
}

// Validate validates this kerberos realm inline password server
func (o *KerberosRealmInlinePasswordServer) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this kerberos realm inline password server based on context it is used
func (o *KerberosRealmInlinePasswordServer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *KerberosRealmInlinePasswordServer) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *KerberosRealmInlinePasswordServer) UnmarshalBinary(b []byte) error {
	var res KerberosRealmInlinePasswordServer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
KerberosRealmInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model kerberos_realm_inline_svm
*/
type KerberosRealmInlineSvm struct {

	// links
	Links *models.KerberosRealmInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this kerberos realm inline svm
func (o *KerberosRealmInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *KerberosRealmInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this kerberos realm inline svm based on the context it is used
func (o *KerberosRealmInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *KerberosRealmInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *KerberosRealmInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *KerberosRealmInlineSvm) UnmarshalBinary(b []byte) error {
	var res KerberosRealmInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
KerberosRealmInlineSvmInlineLinks kerberos realm inline svm inline links
swagger:model kerberos_realm_inline_svm_inline__links
*/
type KerberosRealmInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this kerberos realm inline svm inline links
func (o *KerberosRealmInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *KerberosRealmInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this kerberos realm inline svm inline links based on the context it is used
func (o *KerberosRealmInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *KerberosRealmInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *KerberosRealmInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *KerberosRealmInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res KerberosRealmInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
