// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// KerberosRealmModifyReader is a Reader for the KerberosRealmModify structure.
type KerberosRealmModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *KerberosRealmModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewKerberosRealmModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewKerberosRealmModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewKerberosRealmModifyOK creates a KerberosRealmModifyOK with default headers values
func NewKerberosRealmModifyOK() *KerberosRealmModifyOK {
	return &KerberosRealmModifyOK{}
}

/*
KerberosRealmModifyOK describes a response with status code 200, with default header values.

OK
*/
type KerberosRealmModifyOK struct {
}

// IsSuccess returns true when this kerberos realm modify o k response has a 2xx status code
func (o *KerberosRealmModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this kerberos realm modify o k response has a 3xx status code
func (o *KerberosRealmModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this kerberos realm modify o k response has a 4xx status code
func (o *KerberosRealmModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this kerberos realm modify o k response has a 5xx status code
func (o *KerberosRealmModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this kerberos realm modify o k response a status code equal to that given
func (o *KerberosRealmModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the kerberos realm modify o k response
func (o *KerberosRealmModifyOK) Code() int {
	return 200
}

func (o *KerberosRealmModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/nfs/kerberos/realms/{svm.uuid}/{name}][%d] kerberosRealmModifyOK", 200)
}

func (o *KerberosRealmModifyOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/nfs/kerberos/realms/{svm.uuid}/{name}][%d] kerberosRealmModifyOK", 200)
}

func (o *KerberosRealmModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewKerberosRealmModifyDefault creates a KerberosRealmModifyDefault with default headers values
func NewKerberosRealmModifyDefault(code int) *KerberosRealmModifyDefault {
	return &KerberosRealmModifyDefault{
		_statusCode: code,
	}
}

/*
	KerberosRealmModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error codes | Description |
| ----------- | ----------- |
| 1966125     | Failed to remove hosts entry.|
| 1966126     | Failed to lookup hosts entry.|
| 1966131     | Failed to create hosts entry.|
| 1966132     | Failed to modify hosts entry.|
| 2949121     | Active Directory server name required.|
| 2949122     | Active Directory server address required|
| 2949123     | Failed to create Kerberos realm.|
| 2949124     | Failed to create hosts file entry.|
| 2949141     | Failed to lookup Kerberos realm.|
| 2949148     | Failed to modify Kerberos realm.|
| 3276976     | "realm" is a required input|
| 3276998     | Only the data Vservers can own NFS Kerberos realms.|
*/
type KerberosRealmModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this kerberos realm modify default response has a 2xx status code
func (o *KerberosRealmModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this kerberos realm modify default response has a 3xx status code
func (o *KerberosRealmModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this kerberos realm modify default response has a 4xx status code
func (o *KerberosRealmModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this kerberos realm modify default response has a 5xx status code
func (o *KerberosRealmModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this kerberos realm modify default response a status code equal to that given
func (o *KerberosRealmModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the kerberos realm modify default response
func (o *KerberosRealmModifyDefault) Code() int {
	return o._statusCode
}

func (o *KerberosRealmModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/nfs/kerberos/realms/{svm.uuid}/{name}][%d] kerberos_realm_modify default %s", o._statusCode, payload)
}

func (o *KerberosRealmModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/nfs/kerberos/realms/{svm.uuid}/{name}][%d] kerberos_realm_modify default %s", o._statusCode, payload)
}

func (o *KerberosRealmModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *KerberosRealmModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
