// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewLocalCifsGroupCollectionGetParams creates a new LocalCifsGroupCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLocalCifsGroupCollectionGetParams() *LocalCifsGroupCollectionGetParams {
	return &LocalCifsGroupCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLocalCifsGroupCollectionGetParamsWithTimeout creates a new LocalCifsGroupCollectionGetParams object
// with the ability to set a timeout on a request.
func NewLocalCifsGroupCollectionGetParamsWithTimeout(timeout time.Duration) *LocalCifsGroupCollectionGetParams {
	return &LocalCifsGroupCollectionGetParams{
		timeout: timeout,
	}
}

// NewLocalCifsGroupCollectionGetParamsWithContext creates a new LocalCifsGroupCollectionGetParams object
// with the ability to set a context for a request.
func NewLocalCifsGroupCollectionGetParamsWithContext(ctx context.Context) *LocalCifsGroupCollectionGetParams {
	return &LocalCifsGroupCollectionGetParams{
		Context: ctx,
	}
}

// NewLocalCifsGroupCollectionGetParamsWithHTTPClient creates a new LocalCifsGroupCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewLocalCifsGroupCollectionGetParamsWithHTTPClient(client *http.Client) *LocalCifsGroupCollectionGetParams {
	return &LocalCifsGroupCollectionGetParams{
		HTTPClient: client,
	}
}

/*
LocalCifsGroupCollectionGetParams contains all the parameters to send to the API endpoint

	for the local cifs group collection get operation.

	Typically these are written to a http.Request.
*/
type LocalCifsGroupCollectionGetParams struct {

	/* Description.

	   Filter by description
	*/
	Description *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* MembersName.

	   Filter by members.name
	*/
	MembersName *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Sid.

	   Filter by sid
	*/
	Sid *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the local cifs group collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LocalCifsGroupCollectionGetParams) WithDefaults() *LocalCifsGroupCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the local cifs group collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LocalCifsGroupCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := LocalCifsGroupCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) WithTimeout(timeout time.Duration) *LocalCifsGroupCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) WithContext(ctx context.Context) *LocalCifsGroupCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) WithHTTPClient(client *http.Client) *LocalCifsGroupCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDescription adds the description to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) WithDescription(description *string) *LocalCifsGroupCollectionGetParams {
	o.SetDescription(description)
	return o
}

// SetDescription adds the description to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) SetDescription(description *string) {
	o.Description = description
}

// WithFields adds the fields to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) WithFields(fields []string) *LocalCifsGroupCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) WithMaxRecords(maxRecords *int64) *LocalCifsGroupCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMembersName adds the membersName to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) WithMembersName(membersName *string) *LocalCifsGroupCollectionGetParams {
	o.SetMembersName(membersName)
	return o
}

// SetMembersName adds the membersName to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) SetMembersName(membersName *string) {
	o.MembersName = membersName
}

// WithName adds the name to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) WithName(name *string) *LocalCifsGroupCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) WithOrderBy(orderBy []string) *LocalCifsGroupCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) WithReturnRecords(returnRecords *bool) *LocalCifsGroupCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *LocalCifsGroupCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSid adds the sid to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) WithSid(sid *string) *LocalCifsGroupCollectionGetParams {
	o.SetSid(sid)
	return o
}

// SetSid adds the sid to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) SetSid(sid *string) {
	o.Sid = sid
}

// WithSvmName adds the svmName to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) WithSvmName(svmName *string) *LocalCifsGroupCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) WithSvmUUID(svmUUID *string) *LocalCifsGroupCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the local cifs group collection get params
func (o *LocalCifsGroupCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *LocalCifsGroupCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Description != nil {

		// query param description
		var qrDescription string

		if o.Description != nil {
			qrDescription = *o.Description
		}
		qDescription := qrDescription
		if qDescription != "" {

			if err := r.SetQueryParam("description", qDescription); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.MembersName != nil {

		// query param members.name
		var qrMembersName string

		if o.MembersName != nil {
			qrMembersName = *o.MembersName
		}
		qMembersName := qrMembersName
		if qMembersName != "" {

			if err := r.SetQueryParam("members.name", qMembersName); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Sid != nil {

		// query param sid
		var qrSid string

		if o.Sid != nil {
			qrSid = *o.Sid
		}
		qSid := qrSid
		if qSid != "" {

			if err := r.SetQueryParam("sid", qSid); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamLocalCifsGroupCollectionGet binds the parameter fields
func (o *LocalCifsGroupCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamLocalCifsGroupCollectionGet binds the parameter order_by
func (o *LocalCifsGroupCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
