// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LocalCifsGroupDeleteCollectionReader is a Reader for the LocalCifsGroupDeleteCollection structure.
type LocalCifsGroupDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LocalCifsGroupDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLocalCifsGroupDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLocalCifsGroupDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLocalCifsGroupDeleteCollectionOK creates a LocalCifsGroupDeleteCollectionOK with default headers values
func NewLocalCifsGroupDeleteCollectionOK() *LocalCifsGroupDeleteCollectionOK {
	return &LocalCifsGroupDeleteCollectionOK{}
}

/*
LocalCifsGroupDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type LocalCifsGroupDeleteCollectionOK struct {
}

// IsSuccess returns true when this local cifs group delete collection o k response has a 2xx status code
func (o *LocalCifsGroupDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this local cifs group delete collection o k response has a 3xx status code
func (o *LocalCifsGroupDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this local cifs group delete collection o k response has a 4xx status code
func (o *LocalCifsGroupDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this local cifs group delete collection o k response has a 5xx status code
func (o *LocalCifsGroupDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this local cifs group delete collection o k response a status code equal to that given
func (o *LocalCifsGroupDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the local cifs group delete collection o k response
func (o *LocalCifsGroupDeleteCollectionOK) Code() int {
	return 200
}

func (o *LocalCifsGroupDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/cifs/local-groups][%d] localCifsGroupDeleteCollectionOK", 200)
}

func (o *LocalCifsGroupDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/cifs/local-groups][%d] localCifsGroupDeleteCollectionOK", 200)
}

func (o *LocalCifsGroupDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewLocalCifsGroupDeleteCollectionDefault creates a LocalCifsGroupDeleteCollectionDefault with default headers values
func NewLocalCifsGroupDeleteCollectionDefault(code int) *LocalCifsGroupDeleteCollectionDefault {
	return &LocalCifsGroupDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
LocalCifsGroupDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type LocalCifsGroupDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this local cifs group delete collection default response has a 2xx status code
func (o *LocalCifsGroupDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this local cifs group delete collection default response has a 3xx status code
func (o *LocalCifsGroupDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this local cifs group delete collection default response has a 4xx status code
func (o *LocalCifsGroupDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this local cifs group delete collection default response has a 5xx status code
func (o *LocalCifsGroupDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this local cifs group delete collection default response a status code equal to that given
func (o *LocalCifsGroupDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the local cifs group delete collection default response
func (o *LocalCifsGroupDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *LocalCifsGroupDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/cifs/local-groups][%d] local_cifs_group_delete_collection default %s", o._statusCode, payload)
}

func (o *LocalCifsGroupDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/cifs/local-groups][%d] local_cifs_group_delete_collection default %s", o._statusCode, payload)
}

func (o *LocalCifsGroupDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LocalCifsGroupDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
LocalCifsGroupDeleteCollectionBody local cifs group delete collection body
swagger:model LocalCifsGroupDeleteCollectionBody
*/
type LocalCifsGroupDeleteCollectionBody struct {

	// local cifs group response inline records
	LocalCifsGroupResponseInlineRecords []*models.LocalCifsGroup `json:"records,omitempty"`
}

// Validate validates this local cifs group delete collection body
func (o *LocalCifsGroupDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLocalCifsGroupResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LocalCifsGroupDeleteCollectionBody) validateLocalCifsGroupResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.LocalCifsGroupResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.LocalCifsGroupResponseInlineRecords); i++ {
		if swag.IsZero(o.LocalCifsGroupResponseInlineRecords[i]) { // not required
			continue
		}

		if o.LocalCifsGroupResponseInlineRecords[i] != nil {
			if err := o.LocalCifsGroupResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this local cifs group delete collection body based on the context it is used
func (o *LocalCifsGroupDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLocalCifsGroupResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LocalCifsGroupDeleteCollectionBody) contextValidateLocalCifsGroupResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.LocalCifsGroupResponseInlineRecords); i++ {

		if o.LocalCifsGroupResponseInlineRecords[i] != nil {
			if err := o.LocalCifsGroupResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *LocalCifsGroupDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LocalCifsGroupDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res LocalCifsGroupDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
