// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LocalCifsGroupMembersCreateReader is a Reader for the LocalCifsGroupMembersCreate structure.
type LocalCifsGroupMembersCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LocalCifsGroupMembersCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewLocalCifsGroupMembersCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLocalCifsGroupMembersCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLocalCifsGroupMembersCreateCreated creates a LocalCifsGroupMembersCreateCreated with default headers values
func NewLocalCifsGroupMembersCreateCreated() *LocalCifsGroupMembersCreateCreated {
	return &LocalCifsGroupMembersCreateCreated{}
}

/*
LocalCifsGroupMembersCreateCreated describes a response with status code 201, with default header values.

Created
*/
type LocalCifsGroupMembersCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string
}

// IsSuccess returns true when this local cifs group members create created response has a 2xx status code
func (o *LocalCifsGroupMembersCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this local cifs group members create created response has a 3xx status code
func (o *LocalCifsGroupMembersCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this local cifs group members create created response has a 4xx status code
func (o *LocalCifsGroupMembersCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this local cifs group members create created response has a 5xx status code
func (o *LocalCifsGroupMembersCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this local cifs group members create created response a status code equal to that given
func (o *LocalCifsGroupMembersCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the local cifs group members create created response
func (o *LocalCifsGroupMembersCreateCreated) Code() int {
	return 201
}

func (o *LocalCifsGroupMembersCreateCreated) Error() string {
	return fmt.Sprintf("[POST /protocols/cifs/local-groups/{svm.uuid}/{local_cifs_group.sid}/members][%d] localCifsGroupMembersCreateCreated", 201)
}

func (o *LocalCifsGroupMembersCreateCreated) String() string {
	return fmt.Sprintf("[POST /protocols/cifs/local-groups/{svm.uuid}/{local_cifs_group.sid}/members][%d] localCifsGroupMembersCreateCreated", 201)
}

func (o *LocalCifsGroupMembersCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	return nil
}

// NewLocalCifsGroupMembersCreateDefault creates a LocalCifsGroupMembersCreateDefault with default headers values
func NewLocalCifsGroupMembersCreateDefault(code int) *LocalCifsGroupMembersCreateDefault {
	return &LocalCifsGroupMembersCreateDefault{
		_statusCode: code,
	}
}

/*
	LocalCifsGroupMembersCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 655673     | Failed to resolve the member to be added to the specified group. |
| 655718     | Failed to add a member to the specified group. The error code returned details the failure along with the reason for the failure. Take corrective actions as per the specified reason. |
| 655742     | Records must not be specified when member name is specified. |
| 655743     | SVM UUID and CIFS local group SID are invalid fields for the "records" parameter. |
| 655744     | Either name or records must be specified. |
*/
type LocalCifsGroupMembersCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this local cifs group members create default response has a 2xx status code
func (o *LocalCifsGroupMembersCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this local cifs group members create default response has a 3xx status code
func (o *LocalCifsGroupMembersCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this local cifs group members create default response has a 4xx status code
func (o *LocalCifsGroupMembersCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this local cifs group members create default response has a 5xx status code
func (o *LocalCifsGroupMembersCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this local cifs group members create default response a status code equal to that given
func (o *LocalCifsGroupMembersCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the local cifs group members create default response
func (o *LocalCifsGroupMembersCreateDefault) Code() int {
	return o._statusCode
}

func (o *LocalCifsGroupMembersCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/cifs/local-groups/{svm.uuid}/{local_cifs_group.sid}/members][%d] local_cifs_group_members_create default %s", o._statusCode, payload)
}

func (o *LocalCifsGroupMembersCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/cifs/local-groups/{svm.uuid}/{local_cifs_group.sid}/members][%d] local_cifs_group_members_create default %s", o._statusCode, payload)
}

func (o *LocalCifsGroupMembersCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LocalCifsGroupMembersCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
