// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LocalCifsUserDeleteCollectionReader is a Reader for the LocalCifsUserDeleteCollection structure.
type LocalCifsUserDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LocalCifsUserDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLocalCifsUserDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLocalCifsUserDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLocalCifsUserDeleteCollectionOK creates a LocalCifsUserDeleteCollectionOK with default headers values
func NewLocalCifsUserDeleteCollectionOK() *LocalCifsUserDeleteCollectionOK {
	return &LocalCifsUserDeleteCollectionOK{}
}

/*
LocalCifsUserDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type LocalCifsUserDeleteCollectionOK struct {
}

// IsSuccess returns true when this local cifs user delete collection o k response has a 2xx status code
func (o *LocalCifsUserDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this local cifs user delete collection o k response has a 3xx status code
func (o *LocalCifsUserDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this local cifs user delete collection o k response has a 4xx status code
func (o *LocalCifsUserDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this local cifs user delete collection o k response has a 5xx status code
func (o *LocalCifsUserDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this local cifs user delete collection o k response a status code equal to that given
func (o *LocalCifsUserDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the local cifs user delete collection o k response
func (o *LocalCifsUserDeleteCollectionOK) Code() int {
	return 200
}

func (o *LocalCifsUserDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/cifs/local-users][%d] localCifsUserDeleteCollectionOK", 200)
}

func (o *LocalCifsUserDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/cifs/local-users][%d] localCifsUserDeleteCollectionOK", 200)
}

func (o *LocalCifsUserDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewLocalCifsUserDeleteCollectionDefault creates a LocalCifsUserDeleteCollectionDefault with default headers values
func NewLocalCifsUserDeleteCollectionDefault(code int) *LocalCifsUserDeleteCollectionDefault {
	return &LocalCifsUserDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	LocalCifsUserDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 655735     | The local Administrator account cannot be deleted. |
*/
type LocalCifsUserDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this local cifs user delete collection default response has a 2xx status code
func (o *LocalCifsUserDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this local cifs user delete collection default response has a 3xx status code
func (o *LocalCifsUserDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this local cifs user delete collection default response has a 4xx status code
func (o *LocalCifsUserDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this local cifs user delete collection default response has a 5xx status code
func (o *LocalCifsUserDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this local cifs user delete collection default response a status code equal to that given
func (o *LocalCifsUserDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the local cifs user delete collection default response
func (o *LocalCifsUserDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *LocalCifsUserDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/cifs/local-users][%d] local_cifs_user_delete_collection default %s", o._statusCode, payload)
}

func (o *LocalCifsUserDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/cifs/local-users][%d] local_cifs_user_delete_collection default %s", o._statusCode, payload)
}

func (o *LocalCifsUserDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LocalCifsUserDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
LocalCifsUserDeleteCollectionBody local cifs user delete collection body
swagger:model LocalCifsUserDeleteCollectionBody
*/
type LocalCifsUserDeleteCollectionBody struct {

	// local cifs user response inline records
	LocalCifsUserResponseInlineRecords []*models.LocalCifsUser `json:"records,omitempty"`
}

// Validate validates this local cifs user delete collection body
func (o *LocalCifsUserDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLocalCifsUserResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LocalCifsUserDeleteCollectionBody) validateLocalCifsUserResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.LocalCifsUserResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.LocalCifsUserResponseInlineRecords); i++ {
		if swag.IsZero(o.LocalCifsUserResponseInlineRecords[i]) { // not required
			continue
		}

		if o.LocalCifsUserResponseInlineRecords[i] != nil {
			if err := o.LocalCifsUserResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this local cifs user delete collection body based on the context it is used
func (o *LocalCifsUserDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLocalCifsUserResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LocalCifsUserDeleteCollectionBody) contextValidateLocalCifsUserResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.LocalCifsUserResponseInlineRecords); i++ {

		if o.LocalCifsUserResponseInlineRecords[i] != nil {
			if err := o.LocalCifsUserResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *LocalCifsUserDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LocalCifsUserDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res LocalCifsUserDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
