// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LocalCifsUserDeleteReader is a Reader for the LocalCifsUserDelete structure.
type LocalCifsUserDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LocalCifsUserDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLocalCifsUserDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLocalCifsUserDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLocalCifsUserDeleteOK creates a LocalCifsUserDeleteOK with default headers values
func NewLocalCifsUserDeleteOK() *LocalCifsUserDeleteOK {
	return &LocalCifsUserDeleteOK{}
}

/*
LocalCifsUserDeleteOK describes a response with status code 200, with default header values.

OK
*/
type LocalCifsUserDeleteOK struct {
}

// IsSuccess returns true when this local cifs user delete o k response has a 2xx status code
func (o *LocalCifsUserDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this local cifs user delete o k response has a 3xx status code
func (o *LocalCifsUserDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this local cifs user delete o k response has a 4xx status code
func (o *LocalCifsUserDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this local cifs user delete o k response has a 5xx status code
func (o *LocalCifsUserDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this local cifs user delete o k response a status code equal to that given
func (o *LocalCifsUserDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the local cifs user delete o k response
func (o *LocalCifsUserDeleteOK) Code() int {
	return 200
}

func (o *LocalCifsUserDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/cifs/local-users/{svm.uuid}/{sid}][%d] localCifsUserDeleteOK", 200)
}

func (o *LocalCifsUserDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/cifs/local-users/{svm.uuid}/{sid}][%d] localCifsUserDeleteOK", 200)
}

func (o *LocalCifsUserDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewLocalCifsUserDeleteDefault creates a LocalCifsUserDeleteDefault with default headers values
func NewLocalCifsUserDeleteDefault(code int) *LocalCifsUserDeleteDefault {
	return &LocalCifsUserDeleteDefault{
		_statusCode: code,
	}
}

/*
	LocalCifsUserDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 655735     | The local Administrator account cannot be deleted. |
*/
type LocalCifsUserDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this local cifs user delete default response has a 2xx status code
func (o *LocalCifsUserDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this local cifs user delete default response has a 3xx status code
func (o *LocalCifsUserDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this local cifs user delete default response has a 4xx status code
func (o *LocalCifsUserDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this local cifs user delete default response has a 5xx status code
func (o *LocalCifsUserDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this local cifs user delete default response a status code equal to that given
func (o *LocalCifsUserDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the local cifs user delete default response
func (o *LocalCifsUserDeleteDefault) Code() int {
	return o._statusCode
}

func (o *LocalCifsUserDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/cifs/local-users/{svm.uuid}/{sid}][%d] local_cifs_user_delete default %s", o._statusCode, payload)
}

func (o *LocalCifsUserDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/cifs/local-users/{svm.uuid}/{sid}][%d] local_cifs_user_delete default %s", o._statusCode, payload)
}

func (o *LocalCifsUserDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LocalCifsUserDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
