// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LocalCifsUserModifyCollectionReader is a Reader for the LocalCifsUserModifyCollection structure.
type LocalCifsUserModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LocalCifsUserModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLocalCifsUserModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLocalCifsUserModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLocalCifsUserModifyCollectionOK creates a LocalCifsUserModifyCollectionOK with default headers values
func NewLocalCifsUserModifyCollectionOK() *LocalCifsUserModifyCollectionOK {
	return &LocalCifsUserModifyCollectionOK{}
}

/*
LocalCifsUserModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type LocalCifsUserModifyCollectionOK struct {
}

// IsSuccess returns true when this local cifs user modify collection o k response has a 2xx status code
func (o *LocalCifsUserModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this local cifs user modify collection o k response has a 3xx status code
func (o *LocalCifsUserModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this local cifs user modify collection o k response has a 4xx status code
func (o *LocalCifsUserModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this local cifs user modify collection o k response has a 5xx status code
func (o *LocalCifsUserModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this local cifs user modify collection o k response a status code equal to that given
func (o *LocalCifsUserModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the local cifs user modify collection o k response
func (o *LocalCifsUserModifyCollectionOK) Code() int {
	return 200
}

func (o *LocalCifsUserModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/cifs/local-users][%d] localCifsUserModifyCollectionOK", 200)
}

func (o *LocalCifsUserModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/cifs/local-users][%d] localCifsUserModifyCollectionOK", 200)
}

func (o *LocalCifsUserModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewLocalCifsUserModifyCollectionDefault creates a LocalCifsUserModifyCollectionDefault with default headers values
func NewLocalCifsUserModifyCollectionDefault(code int) *LocalCifsUserModifyCollectionDefault {
	return &LocalCifsUserModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	LocalCifsUserModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 655661     | The user name should not exceed 20 characters. Also full_name and description should not exceed 256 characters. |
| 655668     | The specified user name contains illegal characters. |
| 655675     | The local domain name specified in the user name does not exist. |
| 655682     | The user name cannot be blank. |
| 655732     | Failed to rename a user. The error code returned details the failure along with the reason for the failure. Take corrective actions as per the specified reason. |
| 655733     | The specified password does not meet the password complexity requirements. |
| 655737     | To rename an existing user, the local domain specified in name must match the local domain of the user to be renamed. |
*/
type LocalCifsUserModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this local cifs user modify collection default response has a 2xx status code
func (o *LocalCifsUserModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this local cifs user modify collection default response has a 3xx status code
func (o *LocalCifsUserModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this local cifs user modify collection default response has a 4xx status code
func (o *LocalCifsUserModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this local cifs user modify collection default response has a 5xx status code
func (o *LocalCifsUserModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this local cifs user modify collection default response a status code equal to that given
func (o *LocalCifsUserModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the local cifs user modify collection default response
func (o *LocalCifsUserModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *LocalCifsUserModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/local-users][%d] local_cifs_user_modify_collection default %s", o._statusCode, payload)
}

func (o *LocalCifsUserModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/local-users][%d] local_cifs_user_modify_collection default %s", o._statusCode, payload)
}

func (o *LocalCifsUserModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LocalCifsUserModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
LocalCifsUserModifyCollectionBody local cifs user modify collection body
swagger:model LocalCifsUserModifyCollectionBody
*/
type LocalCifsUserModifyCollectionBody struct {

	// links
	Links *models.LocalCifsUserInlineLinks `json:"_links,omitempty"`

	// Indicates whether the user account is enabled or disabled.
	//
	AccountDisabled *bool `json:"account_disabled,omitempty"`

	// Description for the local user.
	//
	// Example: This is local user.
	// Max Length: 256
	Description *string `json:"description,omitempty"`

	// User's full name.
	//
	// Example: user name
	// Max Length: 256
	FullName *string `json:"full_name,omitempty"`

	// Specifies local groups of which this local user is a member.
	//
	// Read Only: true
	LocalCifsUserInlineMembership []*models.LocalCifsUserInlineMembershipInlineArrayItem `json:"membership,omitempty"`

	// local cifs user response inline records
	LocalCifsUserResponseInlineRecords []*models.LocalCifsUser `json:"records,omitempty"`

	// Local user name. The maximum supported length of an user name is 20 characters.
	//
	// Example: SMB_SERVER01\\user
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// Password for the local user.
	//
	// Min Length: 6
	Password *string `json:"password,omitempty"`

	// The security ID of the local user which uniquely identifies the user. The user SID is automatically generated in POST and it is retrieved using the GET method.
	//
	// Example: S-1-5-21-256008430-3394229847-3930036330-1001
	// Read Only: true
	Sid *string `json:"sid,omitempty"`

	// svm
	Svm *models.LocalCifsUserInlineSvm `json:"svm,omitempty"`
}

// Validate validates this local cifs user modify collection body
func (o *LocalCifsUserModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDescription(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFullName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocalCifsUserInlineMembership(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocalCifsUserResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePassword(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LocalCifsUserModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *LocalCifsUserModifyCollectionBody) validateDescription(formats strfmt.Registry) error {
	if swag.IsZero(o.Description) { // not required
		return nil
	}

	if err := validate.MaxLength("info"+"."+"description", "body", *o.Description, 256); err != nil {
		return err
	}

	return nil
}

func (o *LocalCifsUserModifyCollectionBody) validateFullName(formats strfmt.Registry) error {
	if swag.IsZero(o.FullName) { // not required
		return nil
	}

	if err := validate.MaxLength("info"+"."+"full_name", "body", *o.FullName, 256); err != nil {
		return err
	}

	return nil
}

func (o *LocalCifsUserModifyCollectionBody) validateLocalCifsUserInlineMembership(formats strfmt.Registry) error {
	if swag.IsZero(o.LocalCifsUserInlineMembership) { // not required
		return nil
	}

	for i := 0; i < len(o.LocalCifsUserInlineMembership); i++ {
		if swag.IsZero(o.LocalCifsUserInlineMembership[i]) { // not required
			continue
		}

		if o.LocalCifsUserInlineMembership[i] != nil {
			if err := o.LocalCifsUserInlineMembership[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "membership" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *LocalCifsUserModifyCollectionBody) validateLocalCifsUserResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.LocalCifsUserResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.LocalCifsUserResponseInlineRecords); i++ {
		if swag.IsZero(o.LocalCifsUserResponseInlineRecords[i]) { // not required
			continue
		}

		if o.LocalCifsUserResponseInlineRecords[i] != nil {
			if err := o.LocalCifsUserResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *LocalCifsUserModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	return nil
}

func (o *LocalCifsUserModifyCollectionBody) validatePassword(formats strfmt.Registry) error {
	if swag.IsZero(o.Password) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"password", "body", *o.Password, 6); err != nil {
		return err
	}

	return nil
}

func (o *LocalCifsUserModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this local cifs user modify collection body based on the context it is used
func (o *LocalCifsUserModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocalCifsUserInlineMembership(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocalCifsUserResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LocalCifsUserModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *LocalCifsUserModifyCollectionBody) contextValidateLocalCifsUserInlineMembership(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"membership", "body", []*models.LocalCifsUserInlineMembershipInlineArrayItem(o.LocalCifsUserInlineMembership)); err != nil {
		return err
	}

	for i := 0; i < len(o.LocalCifsUserInlineMembership); i++ {

		if o.LocalCifsUserInlineMembership[i] != nil {
			if err := o.LocalCifsUserInlineMembership[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "membership" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *LocalCifsUserModifyCollectionBody) contextValidateLocalCifsUserResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.LocalCifsUserResponseInlineRecords); i++ {

		if o.LocalCifsUserResponseInlineRecords[i] != nil {
			if err := o.LocalCifsUserResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *LocalCifsUserModifyCollectionBody) contextValidateSid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"sid", "body", o.Sid); err != nil {
		return err
	}

	return nil
}

func (o *LocalCifsUserModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LocalCifsUserModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LocalCifsUserModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res LocalCifsUserModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
LocalCifsUserInlineLinks local cifs user inline links
swagger:model local_cifs_user_inline__links
*/
type LocalCifsUserInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this local cifs user inline links
func (o *LocalCifsUserInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LocalCifsUserInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this local cifs user inline links based on the context it is used
func (o *LocalCifsUserInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LocalCifsUserInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LocalCifsUserInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LocalCifsUserInlineLinks) UnmarshalBinary(b []byte) error {
	var res LocalCifsUserInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
LocalCifsUserInlineMembershipInlineArrayItem local cifs user inline membership inline array item
swagger:model local_cifs_user_inline_membership_inline_array_item
*/
type LocalCifsUserInlineMembershipInlineArrayItem struct {

	// links
	Links *models.LocalCifsUserInlineMembershipInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// Local group name. The maximum supported length of a group name is 256 characters.
	//
	// Example: SMB_SERVER01\\group
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The security ID of the local group which uniquely identifies the group. The group SID is automatically generated in POST and it is retrieved using the GET method.
	//
	// Example: S-1-5-21-256008430-3394229847-3930036330-1001
	// Read Only: true
	Sid *string `json:"sid,omitempty"`
}

// Validate validates this local cifs user inline membership inline array item
func (o *LocalCifsUserInlineMembershipInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LocalCifsUserInlineMembershipInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *LocalCifsUserInlineMembershipInlineArrayItem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *o.Name, 1); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this local cifs user inline membership inline array item based on the context it is used
func (o *LocalCifsUserInlineMembershipInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LocalCifsUserInlineMembershipInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *LocalCifsUserInlineMembershipInlineArrayItem) contextValidateSid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "sid", "body", o.Sid); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LocalCifsUserInlineMembershipInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LocalCifsUserInlineMembershipInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res LocalCifsUserInlineMembershipInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
LocalCifsUserInlineMembershipInlineArrayItemInlineLinks local cifs user inline membership inline array item inline links
swagger:model local_cifs_user_inline_membership_inline_array_item_inline__links
*/
type LocalCifsUserInlineMembershipInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this local cifs user inline membership inline array item inline links
func (o *LocalCifsUserInlineMembershipInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LocalCifsUserInlineMembershipInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this local cifs user inline membership inline array item inline links based on the context it is used
func (o *LocalCifsUserInlineMembershipInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LocalCifsUserInlineMembershipInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LocalCifsUserInlineMembershipInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LocalCifsUserInlineMembershipInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res LocalCifsUserInlineMembershipInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
LocalCifsUserInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model local_cifs_user_inline_svm
*/
type LocalCifsUserInlineSvm struct {

	// links
	Links *models.LocalCifsUserInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this local cifs user inline svm
func (o *LocalCifsUserInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LocalCifsUserInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this local cifs user inline svm based on the context it is used
func (o *LocalCifsUserInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LocalCifsUserInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LocalCifsUserInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LocalCifsUserInlineSvm) UnmarshalBinary(b []byte) error {
	var res LocalCifsUserInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
LocalCifsUserInlineSvmInlineLinks local cifs user inline svm inline links
swagger:model local_cifs_user_inline_svm_inline__links
*/
type LocalCifsUserInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this local cifs user inline svm inline links
func (o *LocalCifsUserInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LocalCifsUserInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this local cifs user inline svm inline links based on the context it is used
func (o *LocalCifsUserInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LocalCifsUserInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LocalCifsUserInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LocalCifsUserInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res LocalCifsUserInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
