// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LocalCifsUsersAndGroupsImportCreateReader is a Reader for the LocalCifsUsersAndGroupsImportCreate structure.
type LocalCifsUsersAndGroupsImportCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LocalCifsUsersAndGroupsImportCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewLocalCifsUsersAndGroupsImportCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewLocalCifsUsersAndGroupsImportCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLocalCifsUsersAndGroupsImportCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLocalCifsUsersAndGroupsImportCreateCreated creates a LocalCifsUsersAndGroupsImportCreateCreated with default headers values
func NewLocalCifsUsersAndGroupsImportCreateCreated() *LocalCifsUsersAndGroupsImportCreateCreated {
	return &LocalCifsUsersAndGroupsImportCreateCreated{}
}

/*
LocalCifsUsersAndGroupsImportCreateCreated describes a response with status code 201, with default header values.

Created
*/
type LocalCifsUsersAndGroupsImportCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.LocalCifsUsersAndGroupsImportJobLinkResponse
}

// IsSuccess returns true when this local cifs users and groups import create created response has a 2xx status code
func (o *LocalCifsUsersAndGroupsImportCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this local cifs users and groups import create created response has a 3xx status code
func (o *LocalCifsUsersAndGroupsImportCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this local cifs users and groups import create created response has a 4xx status code
func (o *LocalCifsUsersAndGroupsImportCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this local cifs users and groups import create created response has a 5xx status code
func (o *LocalCifsUsersAndGroupsImportCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this local cifs users and groups import create created response a status code equal to that given
func (o *LocalCifsUsersAndGroupsImportCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the local cifs users and groups import create created response
func (o *LocalCifsUsersAndGroupsImportCreateCreated) Code() int {
	return 201
}

func (o *LocalCifsUsersAndGroupsImportCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/cifs/users-and-groups/bulk-import/{svm.uuid}][%d] localCifsUsersAndGroupsImportCreateCreated %s", 201, payload)
}

func (o *LocalCifsUsersAndGroupsImportCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/cifs/users-and-groups/bulk-import/{svm.uuid}][%d] localCifsUsersAndGroupsImportCreateCreated %s", 201, payload)
}

func (o *LocalCifsUsersAndGroupsImportCreateCreated) GetPayload() *models.LocalCifsUsersAndGroupsImportJobLinkResponse {
	return o.Payload
}

func (o *LocalCifsUsersAndGroupsImportCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.LocalCifsUsersAndGroupsImportJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLocalCifsUsersAndGroupsImportCreateAccepted creates a LocalCifsUsersAndGroupsImportCreateAccepted with default headers values
func NewLocalCifsUsersAndGroupsImportCreateAccepted() *LocalCifsUsersAndGroupsImportCreateAccepted {
	return &LocalCifsUsersAndGroupsImportCreateAccepted{}
}

/*
LocalCifsUsersAndGroupsImportCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type LocalCifsUsersAndGroupsImportCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.LocalCifsUsersAndGroupsImportJobLinkResponse
}

// IsSuccess returns true when this local cifs users and groups import create accepted response has a 2xx status code
func (o *LocalCifsUsersAndGroupsImportCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this local cifs users and groups import create accepted response has a 3xx status code
func (o *LocalCifsUsersAndGroupsImportCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this local cifs users and groups import create accepted response has a 4xx status code
func (o *LocalCifsUsersAndGroupsImportCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this local cifs users and groups import create accepted response has a 5xx status code
func (o *LocalCifsUsersAndGroupsImportCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this local cifs users and groups import create accepted response a status code equal to that given
func (o *LocalCifsUsersAndGroupsImportCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the local cifs users and groups import create accepted response
func (o *LocalCifsUsersAndGroupsImportCreateAccepted) Code() int {
	return 202
}

func (o *LocalCifsUsersAndGroupsImportCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/cifs/users-and-groups/bulk-import/{svm.uuid}][%d] localCifsUsersAndGroupsImportCreateAccepted %s", 202, payload)
}

func (o *LocalCifsUsersAndGroupsImportCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/cifs/users-and-groups/bulk-import/{svm.uuid}][%d] localCifsUsersAndGroupsImportCreateAccepted %s", 202, payload)
}

func (o *LocalCifsUsersAndGroupsImportCreateAccepted) GetPayload() *models.LocalCifsUsersAndGroupsImportJobLinkResponse {
	return o.Payload
}

func (o *LocalCifsUsersAndGroupsImportCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.LocalCifsUsersAndGroupsImportJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLocalCifsUsersAndGroupsImportCreateDefault creates a LocalCifsUsersAndGroupsImportCreateDefault with default headers values
func NewLocalCifsUsersAndGroupsImportCreateDefault(code int) *LocalCifsUsersAndGroupsImportCreateDefault {
	return &LocalCifsUsersAndGroupsImportCreateDefault{
		_statusCode: code,
	}
}

/*
	LocalCifsUsersAndGroupsImportCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 655688     | Invalid file decryption password. Valid password characters are: a-z, A-Z, and 0-9. |
| 655660     | This operation is only permitted on data SVMs. |
| 655661     | URI username, URI password and the file decryption password cannot exceed 128 characters. |
| 655689     | File decryption password cannot be empty. |
| 655399     | CIFS server does not exist. |
| 655683     | Domain Security Identifier is already present in Active Directory. |
| 655685     | Cluster is busy processing a local users and groups transition task. |
| 655687     | Unknown file schema version. |
| 655690     | Processing the import file failed. Check the file decryption password, compression format and content. |
| 655691     | Error occurred before processing the file. Verify the input parameters. |
| 655692     | Domain name that qualifies the local users and groups must match the CIFS server name. |
| 655693     | All local users and local groups must be prefixed with the NetBIOS domain name. |
| 655693     | Well-known user of group will not be present in this SVM. |
| 655695     | Group membership of the specified user will not be created. |
| 655697     | Failed processing a line of the bulk import file. |
| 655698     | Failed to parse a line of the bulk import file. Check the syntax and contents. |
| 655699     | Invalid number of elements in a line of the bulk import file. |
| 655700     | Failed processing a field index of a line in the input bulk import file. |
| 655701     | Unknown element type. |
| 655702     | Invalid URI. |
| 655703     | Failed to download the import file. Network error occurred. |
| 655709     | Failed to queue CIFS local users and groups import job since a similar job already exists. Retry the operation after some time. |
*/
type LocalCifsUsersAndGroupsImportCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this local cifs users and groups import create default response has a 2xx status code
func (o *LocalCifsUsersAndGroupsImportCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this local cifs users and groups import create default response has a 3xx status code
func (o *LocalCifsUsersAndGroupsImportCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this local cifs users and groups import create default response has a 4xx status code
func (o *LocalCifsUsersAndGroupsImportCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this local cifs users and groups import create default response has a 5xx status code
func (o *LocalCifsUsersAndGroupsImportCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this local cifs users and groups import create default response a status code equal to that given
func (o *LocalCifsUsersAndGroupsImportCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the local cifs users and groups import create default response
func (o *LocalCifsUsersAndGroupsImportCreateDefault) Code() int {
	return o._statusCode
}

func (o *LocalCifsUsersAndGroupsImportCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/cifs/users-and-groups/bulk-import/{svm.uuid}][%d] local_cifs_users_and_groups_import_create default %s", o._statusCode, payload)
}

func (o *LocalCifsUsersAndGroupsImportCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/cifs/users-and-groups/bulk-import/{svm.uuid}][%d] local_cifs_users_and_groups_import_create default %s", o._statusCode, payload)
}

func (o *LocalCifsUsersAndGroupsImportCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LocalCifsUsersAndGroupsImportCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
