// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new n a s API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for n a s API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	ActiveDirectoryCollectionGet(params *ActiveDirectoryCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryCollectionGetOK, error)

	ActiveDirectoryCreate(params *ActiveDirectoryCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryCreateCreated, error)

	ActiveDirectoryDelete(params *ActiveDirectoryDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryDeleteOK, error)

	ActiveDirectoryDeleteCollection(params *ActiveDirectoryDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryDeleteCollectionOK, error)

	ActiveDirectoryGet(params *ActiveDirectoryGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryGetOK, error)

	ActiveDirectoryModify(params *ActiveDirectoryModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryModifyOK, error)

	ActiveDirectoryModifyCollection(params *ActiveDirectoryModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryModifyCollectionOK, error)

	ActiveDirectoryPreferredDcCollectionGet(params *ActiveDirectoryPreferredDcCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryPreferredDcCollectionGetOK, error)

	ActiveDirectoryPreferredDcCreate(params *ActiveDirectoryPreferredDcCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryPreferredDcCreateCreated, error)

	ActiveDirectoryPreferredDcDelete(params *ActiveDirectoryPreferredDcDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryPreferredDcDeleteOK, error)

	ActiveDirectoryPreferredDcDeleteCollection(params *ActiveDirectoryPreferredDcDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryPreferredDcDeleteCollectionOK, error)

	ActiveDirectoryPreferredDcGet(params *ActiveDirectoryPreferredDcGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryPreferredDcGetOK, error)

	AuditCollectionGet(params *AuditCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuditCollectionGetOK, error)

	AuditCreate(params *AuditCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuditCreateCreated, *AuditCreateAccepted, error)

	AuditDelete(params *AuditDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuditDeleteOK, *AuditDeleteAccepted, error)

	AuditDeleteCollection(params *AuditDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuditDeleteCollectionOK, *AuditDeleteCollectionAccepted, error)

	AuditGet(params *AuditGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuditGetOK, error)

	AuditModify(params *AuditModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuditModifyOK, *AuditModifyAccepted, error)

	AuditModifyCollection(params *AuditModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuditModifyCollectionOK, *AuditModifyCollectionAccepted, error)

	CifsCollectionPerformanceMetricsGet(params *CifsCollectionPerformanceMetricsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsCollectionPerformanceMetricsGetOK, error)

	CifsConnectionCollectionGet(params *CifsConnectionCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsConnectionCollectionGetOK, error)

	CifsDomainCollectionGet(params *CifsDomainCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsDomainCollectionGetOK, error)

	CifsDomainGet(params *CifsDomainGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsDomainGetOK, error)

	CifsDomainModify(params *CifsDomainModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsDomainModifyOK, error)

	CifsDomainModifyCollection(params *CifsDomainModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsDomainModifyCollectionOK, error)

	CifsDomainPreferredDcCollectionGet(params *CifsDomainPreferredDcCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsDomainPreferredDcCollectionGetOK, error)

	CifsDomainPreferredDcCreate(params *CifsDomainPreferredDcCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsDomainPreferredDcCreateCreated, error)

	CifsDomainPreferredDcDelete(params *CifsDomainPreferredDcDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsDomainPreferredDcDeleteOK, error)

	CifsDomainPreferredDcDeleteCollection(params *CifsDomainPreferredDcDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsDomainPreferredDcDeleteCollectionOK, error)

	CifsDomainPreferredDcGet(params *CifsDomainPreferredDcGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsDomainPreferredDcGetOK, error)

	CifsHomedirSearchPathGet(params *CifsHomedirSearchPathGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsHomedirSearchPathGetOK, error)

	CifsOpenFileCollectionGet(params *CifsOpenFileCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsOpenFileCollectionGetOK, error)

	CifsOpenFileDelete(params *CifsOpenFileDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsOpenFileDeleteOK, error)

	CifsOpenFileDeleteCollection(params *CifsOpenFileDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsOpenFileDeleteCollectionOK, error)

	CifsOpenFileGet(params *CifsOpenFileGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsOpenFileGetOK, error)

	CifsSearchPathCollectionGet(params *CifsSearchPathCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSearchPathCollectionGetOK, error)

	CifsSearchPathCreate(params *CifsSearchPathCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSearchPathCreateCreated, error)

	CifsSearchPathDelete(params *CifsSearchPathDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSearchPathDeleteOK, error)

	CifsSearchPathDeleteCollection(params *CifsSearchPathDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSearchPathDeleteCollectionOK, error)

	CifsSearchPathModify(params *CifsSearchPathModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSearchPathModifyOK, error)

	CifsSearchPathModifyCollection(params *CifsSearchPathModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSearchPathModifyCollectionOK, error)

	CifsServiceCollectionGet(params *CifsServiceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsServiceCollectionGetOK, error)

	CifsServiceCreate(params *CifsServiceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsServiceCreateCreated, *CifsServiceCreateAccepted, error)

	CifsServiceDelete(params *CifsServiceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsServiceDeleteOK, *CifsServiceDeleteAccepted, error)

	CifsServiceDeleteCollection(params *CifsServiceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsServiceDeleteCollectionOK, *CifsServiceDeleteCollectionAccepted, error)

	CifsServiceGet(params *CifsServiceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsServiceGetOK, error)

	CifsServiceModify(params *CifsServiceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsServiceModifyOK, *CifsServiceModifyAccepted, error)

	CifsServiceModifyCollection(params *CifsServiceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsServiceModifyCollectionOK, *CifsServiceModifyCollectionAccepted, error)

	CifsSessionCollectionGet(params *CifsSessionCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSessionCollectionGetOK, error)

	CifsSessionDelete(params *CifsSessionDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSessionDeleteOK, error)

	CifsSessionDeleteCollection(params *CifsSessionDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSessionDeleteCollectionOK, error)

	CifsSessionGet(params *CifsSessionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSessionGetOK, error)

	CifsShareACLCollectionGet(params *CifsShareACLCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareACLCollectionGetOK, error)

	CifsShareACLCreate(params *CifsShareACLCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareACLCreateCreated, error)

	CifsShareACLDelete(params *CifsShareACLDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareACLDeleteOK, error)

	CifsShareACLDeleteCollection(params *CifsShareACLDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareACLDeleteCollectionOK, error)

	CifsShareACLGet(params *CifsShareACLGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareACLGetOK, error)

	CifsShareACLModify(params *CifsShareACLModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareACLModifyOK, error)

	CifsShareACLModifyCollection(params *CifsShareACLModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareACLModifyCollectionOK, error)

	CifsShareCollectionGet(params *CifsShareCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareCollectionGetOK, error)

	CifsShareCreate(params *CifsShareCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareCreateCreated, error)

	CifsShareDelete(params *CifsShareDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareDeleteOK, error)

	CifsShareDeleteCollection(params *CifsShareDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareDeleteCollectionOK, error)

	CifsShareGet(params *CifsShareGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareGetOK, error)

	CifsShareModify(params *CifsShareModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareModifyOK, error)

	CifsShareModifyCollection(params *CifsShareModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareModifyCollectionOK, error)

	CifsSymlinkMappingCollectionGet(params *CifsSymlinkMappingCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSymlinkMappingCollectionGetOK, error)

	CifsSymlinkMappingCreate(params *CifsSymlinkMappingCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSymlinkMappingCreateCreated, error)

	CifsSymlinkMappingDelete(params *CifsSymlinkMappingDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSymlinkMappingDeleteOK, error)

	CifsSymlinkMappingDeleteCollection(params *CifsSymlinkMappingDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSymlinkMappingDeleteCollectionOK, error)

	CifsSymlinkMappingGet(params *CifsSymlinkMappingGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSymlinkMappingGetOK, error)

	CifsSymlinkMappingModify(params *CifsSymlinkMappingModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSymlinkMappingModifyOK, error)

	CifsSymlinkMappingModifyCollection(params *CifsSymlinkMappingModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSymlinkMappingModifyCollectionOK, error)

	ClientLockCollectionGet(params *ClientLockCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClientLockCollectionGetOK, error)

	ClientLockDelete(params *ClientLockDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClientLockDeleteOK, error)

	ClientLockDeleteCollection(params *ClientLockDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClientLockDeleteCollectionOK, error)

	ClientLockGet(params *ClientLockGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClientLockGetOK, error)

	EffectivePermissionGet(params *EffectivePermissionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EffectivePermissionGetOK, error)

	ExportPolicyCollectionGet(params *ExportPolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportPolicyCollectionGetOK, error)

	ExportPolicyCreate(params *ExportPolicyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportPolicyCreateCreated, error)

	ExportPolicyDelete(params *ExportPolicyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportPolicyDeleteOK, error)

	ExportPolicyDeleteCollection(params *ExportPolicyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportPolicyDeleteCollectionOK, error)

	ExportPolicyGet(params *ExportPolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportPolicyGetOK, error)

	ExportPolicyModify(params *ExportPolicyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportPolicyModifyOK, error)

	ExportPolicyModifyCollection(params *ExportPolicyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportPolicyModifyCollectionOK, error)

	ExportRuleClientsCreate(params *ExportRuleClientsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportRuleClientsCreateCreated, error)

	ExportRuleClientsDelete(params *ExportRuleClientsDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportRuleClientsDeleteOK, error)

	ExportRuleClientsDeleteCollection(params *ExportRuleClientsDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportRuleClientsDeleteCollectionOK, error)

	ExportRuleClientsGet(params *ExportRuleClientsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportRuleClientsGetOK, error)

	ExportRuleCollectionGet(params *ExportRuleCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportRuleCollectionGetOK, error)

	ExportRuleCreate(params *ExportRuleCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportRuleCreateCreated, error)

	ExportRuleDelete(params *ExportRuleDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportRuleDeleteOK, error)

	ExportRuleDeleteCollection(params *ExportRuleDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportRuleDeleteCollectionOK, error)

	ExportRuleGet(params *ExportRuleGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportRuleGetOK, error)

	ExportRuleModify(params *ExportRuleModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportRuleModifyOK, error)

	ExportRuleModifyCollection(params *ExportRuleModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportRuleModifyCollectionOK, error)

	FileDirectorySecurityACLCreate(params *FileDirectorySecurityACLCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileDirectorySecurityACLCreateCreated, *FileDirectorySecurityACLCreateAccepted, error)

	FileDirectorySecurityACLDelete(params *FileDirectorySecurityACLDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileDirectorySecurityACLDeleteOK, *FileDirectorySecurityACLDeleteAccepted, error)

	FileDirectorySecurityACLModify(params *FileDirectorySecurityACLModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileDirectorySecurityACLModifyOK, *FileDirectorySecurityACLModifyAccepted, error)

	FileDirectorySecurityCreate(params *FileDirectorySecurityCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileDirectorySecurityCreateCreated, *FileDirectorySecurityCreateAccepted, error)

	FileDirectorySecurityDelete(params *FileDirectorySecurityDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileDirectorySecurityDeleteOK, error)

	FileDirectorySecurityGet(params *FileDirectorySecurityGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileDirectorySecurityGetOK, error)

	FileDirectorySecurityModify(params *FileDirectorySecurityModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileDirectorySecurityModifyOK, *FileDirectorySecurityModifyAccepted, error)

	FpolicyCollectionGet(params *FpolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyCollectionGetOK, error)

	FpolicyConnectionCollectionGet(params *FpolicyConnectionCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyConnectionCollectionGetOK, error)

	FpolicyConnectionGet(params *FpolicyConnectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyConnectionGetOK, error)

	FpolicyConnectionModify(params *FpolicyConnectionModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyConnectionModifyOK, error)

	FpolicyConnectionModifyCollection(params *FpolicyConnectionModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyConnectionModifyCollectionOK, error)

	FpolicyCreate(params *FpolicyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyCreateCreated, error)

	FpolicyDelete(params *FpolicyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyDeleteOK, error)

	FpolicyDeleteCollection(params *FpolicyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyDeleteCollectionOK, error)

	FpolicyEngineCollectionGet(params *FpolicyEngineCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEngineCollectionGetOK, error)

	FpolicyEngineCreate(params *FpolicyEngineCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEngineCreateCreated, error)

	FpolicyEngineDelete(params *FpolicyEngineDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEngineDeleteOK, error)

	FpolicyEngineDeleteCollection(params *FpolicyEngineDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEngineDeleteCollectionOK, error)

	FpolicyEngineGet(params *FpolicyEngineGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEngineGetOK, error)

	FpolicyEngineModify(params *FpolicyEngineModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEngineModifyOK, error)

	FpolicyEngineModifyCollection(params *FpolicyEngineModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEngineModifyCollectionOK, error)

	FpolicyEventCollectionGet(params *FpolicyEventCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEventCollectionGetOK, error)

	FpolicyEventCreate(params *FpolicyEventCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEventCreateCreated, error)

	FpolicyEventDelete(params *FpolicyEventDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEventDeleteOK, error)

	FpolicyEventDeleteCollection(params *FpolicyEventDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEventDeleteCollectionOK, error)

	FpolicyEventModify(params *FpolicyEventModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEventModifyOK, error)

	FpolicyEventModifyCollection(params *FpolicyEventModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEventModifyCollectionOK, error)

	FpolicyEventsGet(params *FpolicyEventsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEventsGetOK, error)

	FpolicyGet(params *FpolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyGetOK, error)

	FpolicyPersistentStoreCollectionGet(params *FpolicyPersistentStoreCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPersistentStoreCollectionGetOK, error)

	FpolicyPersistentStoreCreate(params *FpolicyPersistentStoreCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPersistentStoreCreateCreated, error)

	FpolicyPersistentStoreDelete(params *FpolicyPersistentStoreDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPersistentStoreDeleteOK, error)

	FpolicyPersistentStoreDeleteCollection(params *FpolicyPersistentStoreDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPersistentStoreDeleteCollectionOK, error)

	FpolicyPersistentStoreGet(params *FpolicyPersistentStoreGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPersistentStoreGetOK, error)

	FpolicyPersistentStoreModify(params *FpolicyPersistentStoreModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPersistentStoreModifyOK, error)

	FpolicyPersistentStoreModifyCollection(params *FpolicyPersistentStoreModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPersistentStoreModifyCollectionOK, error)

	FpolicyPolicyCollectionGet(params *FpolicyPolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPolicyCollectionGetOK, error)

	FpolicyPolicyCreate(params *FpolicyPolicyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPolicyCreateCreated, error)

	FpolicyPolicyDelete(params *FpolicyPolicyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPolicyDeleteOK, error)

	FpolicyPolicyDeleteCollection(params *FpolicyPolicyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPolicyDeleteCollectionOK, error)

	FpolicyPolicyGet(params *FpolicyPolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPolicyGetOK, error)

	FpolicyPolicyModify(params *FpolicyPolicyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPolicyModifyOK, error)

	FpolicyPolicyModifyCollection(params *FpolicyPolicyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPolicyModifyCollectionOK, error)

	GroupPoliciesToBeAppliedModify(params *GroupPoliciesToBeAppliedModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupPoliciesToBeAppliedModifyOK, error)

	GroupPoliciesToBeAppliedModifyCollection(params *GroupPoliciesToBeAppliedModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupPoliciesToBeAppliedModifyCollectionOK, error)

	GroupPolicyObjectCentralAccessPolicyCollectionGet(params *GroupPolicyObjectCentralAccessPolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupPolicyObjectCentralAccessPolicyCollectionGetOK, error)

	GroupPolicyObjectCentralAccessPolicyGet(params *GroupPolicyObjectCentralAccessPolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupPolicyObjectCentralAccessPolicyGetOK, error)

	GroupPolicyObjectCentralAccessRuleCollectionGet(params *GroupPolicyObjectCentralAccessRuleCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupPolicyObjectCentralAccessRuleCollectionGetOK, error)

	GroupPolicyObjectCentralAccessRuleGet(params *GroupPolicyObjectCentralAccessRuleGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupPolicyObjectCentralAccessRuleGetOK, error)

	GroupPolicyObjectCollectionGet(params *GroupPolicyObjectCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupPolicyObjectCollectionGetOK, error)

	GroupPolicyObjectGet(params *GroupPolicyObjectGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupPolicyObjectGetOK, error)

	GroupPolicyObjectRestrictedGroupCollectionGet(params *GroupPolicyObjectRestrictedGroupCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupPolicyObjectRestrictedGroupCollectionGetOK, error)

	GroupPolicyObjectRestrictedGroupGet(params *GroupPolicyObjectRestrictedGroupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupPolicyObjectRestrictedGroupGetOK, error)

	KerberosInterfaceCollectionGet(params *KerberosInterfaceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KerberosInterfaceCollectionGetOK, error)

	KerberosInterfaceGet(params *KerberosInterfaceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KerberosInterfaceGetOK, error)

	KerberosInterfaceModify(params *KerberosInterfaceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KerberosInterfaceModifyOK, error)

	KerberosInterfaceModifyCollection(params *KerberosInterfaceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KerberosInterfaceModifyCollectionOK, error)

	KerberosRealmCollectionGet(params *KerberosRealmCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KerberosRealmCollectionGetOK, error)

	KerberosRealmCreate(params *KerberosRealmCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KerberosRealmCreateCreated, error)

	KerberosRealmDelete(params *KerberosRealmDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KerberosRealmDeleteOK, error)

	KerberosRealmDeleteCollection(params *KerberosRealmDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KerberosRealmDeleteCollectionOK, error)

	KerberosRealmGet(params *KerberosRealmGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KerberosRealmGetOK, error)

	KerberosRealmModify(params *KerberosRealmModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KerberosRealmModifyOK, error)

	KerberosRealmModifyCollection(params *KerberosRealmModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KerberosRealmModifyCollectionOK, error)

	LocalCifsGroupCollectionGet(params *LocalCifsGroupCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupCollectionGetOK, error)

	LocalCifsGroupCreate(params *LocalCifsGroupCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupCreateCreated, error)

	LocalCifsGroupDelete(params *LocalCifsGroupDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupDeleteOK, error)

	LocalCifsGroupDeleteCollection(params *LocalCifsGroupDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupDeleteCollectionOK, error)

	LocalCifsGroupGet(params *LocalCifsGroupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupGetOK, error)

	LocalCifsGroupMembersBulkDelete(params *LocalCifsGroupMembersBulkDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupMembersBulkDeleteOK, error)

	LocalCifsGroupMembersCollectionGet(params *LocalCifsGroupMembersCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupMembersCollectionGetOK, error)

	LocalCifsGroupMembersCreate(params *LocalCifsGroupMembersCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupMembersCreateCreated, error)

	LocalCifsGroupMembersDelete(params *LocalCifsGroupMembersDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupMembersDeleteOK, error)

	LocalCifsGroupMembersGet(params *LocalCifsGroupMembersGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupMembersGetOK, error)

	LocalCifsGroupModify(params *LocalCifsGroupModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupModifyOK, error)

	LocalCifsGroupModifyCollection(params *LocalCifsGroupModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupModifyCollectionOK, error)

	LocalCifsUserCollectionGet(params *LocalCifsUserCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsUserCollectionGetOK, error)

	LocalCifsUserCreate(params *LocalCifsUserCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsUserCreateCreated, error)

	LocalCifsUserDelete(params *LocalCifsUserDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsUserDeleteOK, error)

	LocalCifsUserDeleteCollection(params *LocalCifsUserDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsUserDeleteCollectionOK, error)

	LocalCifsUserGet(params *LocalCifsUserGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsUserGetOK, error)

	LocalCifsUserModify(params *LocalCifsUserModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsUserModifyOK, error)

	LocalCifsUserModifyCollection(params *LocalCifsUserModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsUserModifyCollectionOK, error)

	LocalCifsUsersAndGroupsImportCreate(params *LocalCifsUsersAndGroupsImportCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsUsersAndGroupsImportCreateCreated, *LocalCifsUsersAndGroupsImportCreateAccepted, error)

	LocalCifsUsersAndGroupsImportGet(params *LocalCifsUsersAndGroupsImportGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsUsersAndGroupsImportGetOK, error)

	LocalCifsUsersAndGroupsImportModify(params *LocalCifsUsersAndGroupsImportModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsUsersAndGroupsImportModifyOK, *LocalCifsUsersAndGroupsImportModifyAccepted, error)

	NetbiosCollectionGet(params *NetbiosCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetbiosCollectionGetOK, error)

	NfsClientsCacheGet(params *NfsClientsCacheGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsClientsCacheGetOK, error)

	NfsClientsCacheModify(params *NfsClientsCacheModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsClientsCacheModifyOK, error)

	NfsClientsGet(params *NfsClientsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsClientsGetOK, error)

	NfsClientsMapGet(params *NfsClientsMapGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsClientsMapGetOK, error)

	NfsCollectionGet(params *NfsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsCollectionGetOK, error)

	NfsCollectionPerformanceMetricsGet(params *NfsCollectionPerformanceMetricsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsCollectionPerformanceMetricsGetOK, error)

	NfsCreate(params *NfsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsCreateCreated, error)

	NfsDelete(params *NfsDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsDeleteOK, error)

	NfsDeleteCollection(params *NfsDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsDeleteCollectionOK, error)

	NfsGet(params *NfsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsGetOK, error)

	NfsModify(params *NfsModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsModifyOK, error)

	NfsModifyCollection(params *NfsModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsModifyCollectionOK, error)

	NfsTLSInterfaceCollectionGet(params *NfsTLSInterfaceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsTLSInterfaceCollectionGetOK, error)

	NfsTLSInterfaceGet(params *NfsTLSInterfaceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsTLSInterfaceGetOK, error)

	NfsTLSInterfaceModify(params *NfsTLSInterfaceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsTLSInterfaceModifyOK, error)

	NfsTLSInterfaceModifyCollection(params *NfsTLSInterfaceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsTLSInterfaceModifyCollectionOK, error)

	PoliciesAndRulesToBeAppliedCollectionGet(params *PoliciesAndRulesToBeAppliedCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PoliciesAndRulesToBeAppliedCollectionGetOK, error)

	PoliciesAndRulesToBeAppliedGet(params *PoliciesAndRulesToBeAppliedGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PoliciesAndRulesToBeAppliedGetOK, error)

	S3AuditCreate(params *S3AuditCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3AuditCreateCreated, *S3AuditCreateAccepted, error)

	S3AuditDelete(params *S3AuditDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3AuditDeleteOK, *S3AuditDeleteAccepted, error)

	S3AuditGet(params *S3AuditGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3AuditGetOK, error)

	S3AuditModify(params *S3AuditModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3AuditModifyOK, *S3AuditModifyAccepted, error)

	ShadowcopyCollectionGet(params *ShadowcopyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShadowcopyCollectionGetOK, error)

	ShadowcopyGet(params *ShadowcopyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShadowcopyGetOK, error)

	ShadowcopyModify(params *ShadowcopyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShadowcopyModifyOK, error)

	ShadowcopyModifyCollection(params *ShadowcopyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShadowcopyModifyCollectionOK, error)

	ShadowcopySetCollectionGet(params *ShadowcopySetCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShadowcopySetCollectionGetOK, error)

	ShadowcopySetGet(params *ShadowcopySetGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShadowcopySetGetOK, error)

	ShadowcopySetModify(params *ShadowcopySetModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShadowcopySetModifyOK, error)

	ShadowcopySetModifyCollection(params *ShadowcopySetModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShadowcopySetModifyCollectionOK, error)

	UserGroupPrivilegesCollectionGet(params *UserGroupPrivilegesCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UserGroupPrivilegesCollectionGetOK, error)

	UserGroupPrivilegesCreate(params *UserGroupPrivilegesCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UserGroupPrivilegesCreateCreated, error)

	UserGroupPrivilegesGet(params *UserGroupPrivilegesGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UserGroupPrivilegesGetOK, error)

	UserGroupPrivilegesModify(params *UserGroupPrivilegesModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UserGroupPrivilegesModifyOK, error)

	UserGroupPrivilegesModifyCollection(params *UserGroupPrivilegesModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UserGroupPrivilegesModifyCollectionOK, error)

	VscanCollectionGet(params *VscanCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanCollectionGetOK, error)

	VscanConfigDelete(params *VscanConfigDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanConfigDeleteOK, error)

	VscanConfigDeleteCollection(params *VscanConfigDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanConfigDeleteCollectionOK, error)

	VscanCreate(params *VscanCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanCreateCreated, error)

	VscanEventCollectionGet(params *VscanEventCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanEventCollectionGetOK, error)

	VscanGet(params *VscanGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanGetOK, error)

	VscanModify(params *VscanModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanModifyOK, error)

	VscanModifyCollection(params *VscanModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanModifyCollectionOK, error)

	VscanOnAccessCreate(params *VscanOnAccessCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnAccessCreateCreated, error)

	VscanOnAccessDelete(params *VscanOnAccessDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnAccessDeleteOK, error)

	VscanOnAccessDeleteCollection(params *VscanOnAccessDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnAccessDeleteCollectionOK, error)

	VscanOnAccessGet(params *VscanOnAccessGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnAccessGetOK, error)

	VscanOnAccessModify(params *VscanOnAccessModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnAccessModifyOK, error)

	VscanOnAccessModifyCollection(params *VscanOnAccessModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnAccessModifyCollectionOK, error)

	VscanOnAccessPolicyCollectionGet(params *VscanOnAccessPolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnAccessPolicyCollectionGetOK, error)

	VscanOnDemandCreate(params *VscanOnDemandCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnDemandCreateCreated, error)

	VscanOnDemandDelete(params *VscanOnDemandDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnDemandDeleteOK, error)

	VscanOnDemandDeleteCollection(params *VscanOnDemandDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnDemandDeleteCollectionOK, error)

	VscanOnDemandGet(params *VscanOnDemandGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnDemandGetOK, error)

	VscanOnDemandModify(params *VscanOnDemandModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnDemandModifyOK, error)

	VscanOnDemandModifyCollection(params *VscanOnDemandModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnDemandModifyCollectionOK, error)

	VscanOnDemandPolicyCollectionGet(params *VscanOnDemandPolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnDemandPolicyCollectionGetOK, error)

	VscanScannerCollectionGet(params *VscanScannerCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanScannerCollectionGetOK, error)

	VscanScannerCreate(params *VscanScannerCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanScannerCreateCreated, error)

	VscanScannerDelete(params *VscanScannerDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanScannerDeleteOK, error)

	VscanScannerDeleteCollection(params *VscanScannerDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanScannerDeleteCollectionOK, error)

	VscanScannerModify(params *VscanScannerModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanScannerModifyOK, error)

	VscanScannerModifyCollection(params *VscanScannerModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanScannerModifyCollectionOK, error)

	VscanScannerPoolGet(params *VscanScannerPoolGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanScannerPoolGetOK, error)

	VscanServerStatusGet(params *VscanServerStatusGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanServerStatusGetOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
	ActiveDirectoryCollectionGet Retrieves Active Directory accounts for all SVMs.

### Related ONTAP commands
* `vserver active-directory show`
* `vserver active-directory preferred-dc show`
* `vserver active-directory discovered-servers show`
* `vserver cifs security show`
*/
func (a *Client) ActiveDirectoryCollectionGet(params *ActiveDirectoryCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewActiveDirectoryCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "active_directory_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/active-directory",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ActiveDirectoryCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ActiveDirectoryCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ActiveDirectoryCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ActiveDirectoryCreate Creates an Active Directory account for a given SVM.

### Related ONTAP commands
* `vserver active-directory create`
### Important notes
* Active Directory account creation is asynchronous. Response contains Task UUID and Link that can be queried to get the status.
*/
func (a *Client) ActiveDirectoryCreate(params *ActiveDirectoryCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewActiveDirectoryCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "active_directory_create",
		Method:             "POST",
		PathPattern:        "/protocols/active-directory",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ActiveDirectoryCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ActiveDirectoryCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ActiveDirectoryCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ActiveDirectoryDelete Deletes the Active Directory account for a given SVM.

### Related ONTAP commands
* `vserver active-directory delete`
### Important notes
* Active Directory account deletion is asynchronous. Response contains Task UUID and Link that can be queried to get the status.
*/
func (a *Client) ActiveDirectoryDelete(params *ActiveDirectoryDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewActiveDirectoryDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "active_directory_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/active-directory/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ActiveDirectoryDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ActiveDirectoryDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ActiveDirectoryDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ActiveDirectoryDeleteCollection active directory delete collection API
*/
func (a *Client) ActiveDirectoryDeleteCollection(params *ActiveDirectoryDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewActiveDirectoryDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "active_directory_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/active-directory",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ActiveDirectoryDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ActiveDirectoryDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ActiveDirectoryDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ActiveDirectoryGet Retrieves the Active Directory account for a given SVM.

### Related ONTAP commands
* `vserver active-directory show`
* `vserver active-directory preferred-dc show`
* `vserver active-directory discovered-servers show`
* `vserver active-directory discovered-servers reset-servers`
* `vserver cifs security show`
*/
func (a *Client) ActiveDirectoryGet(params *ActiveDirectoryGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewActiveDirectoryGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "active_directory_get",
		Method:             "GET",
		PathPattern:        "/protocols/active-directory/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ActiveDirectoryGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ActiveDirectoryGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ActiveDirectoryGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ActiveDirectoryModify Modifies the Active Directory account for a given SVM.

### Related ONTAP commands
* `vserver active-directory modify`
* `vserver cifs security modify`
### Important notes
* Patching Active Directory account is asynchronous. Response contains Task UUID and Link that can be queried to get the status.
*/
func (a *Client) ActiveDirectoryModify(params *ActiveDirectoryModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewActiveDirectoryModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "active_directory_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/active-directory/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ActiveDirectoryModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ActiveDirectoryModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ActiveDirectoryModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ActiveDirectoryModifyCollection active directory modify collection API
*/
func (a *Client) ActiveDirectoryModifyCollection(params *ActiveDirectoryModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewActiveDirectoryModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "active_directory_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/active-directory",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ActiveDirectoryModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ActiveDirectoryModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ActiveDirectoryModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ActiveDirectoryPreferredDcCollectionGet Retrieves the Active Directory preferred DC configuration of an SVM.

### Related ONTAP commands
* `vserver active-directory preferred-dc show`
*/
func (a *Client) ActiveDirectoryPreferredDcCollectionGet(params *ActiveDirectoryPreferredDcCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryPreferredDcCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewActiveDirectoryPreferredDcCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "active_directory_preferred_dc_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/active-directory/{svm.uuid}/preferred-domain-controllers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ActiveDirectoryPreferredDcCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ActiveDirectoryPreferredDcCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ActiveDirectoryPreferredDcCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ActiveDirectoryPreferredDcCreate Creates an Active Directory preferred DC configuration for an SVM.

### Required properties
* `svm.uuid` - Existing SVM in which to create the preferred DC.
* `fqdn` - Fully Qualified Domain Name.
* `server_ip` - IPv4/IPv6 address of the preferred DC.
#### The following parameters are optional:
- skip_config_validation
### Related ONTAP commands
* `vserver active-directory preferred-dc add`
*/
func (a *Client) ActiveDirectoryPreferredDcCreate(params *ActiveDirectoryPreferredDcCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryPreferredDcCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewActiveDirectoryPreferredDcCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "active_directory_preferred_dc_create",
		Method:             "POST",
		PathPattern:        "/protocols/active-directory/{svm.uuid}/preferred-domain-controllers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ActiveDirectoryPreferredDcCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ActiveDirectoryPreferredDcCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ActiveDirectoryPreferredDcCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ActiveDirectoryPreferredDcDelete Deletes the Active Directory preferred DC configuration of the specified SVM and domain.

### Related ONTAP commands
* `vserver active-directory preferred-dc delete`
*/
func (a *Client) ActiveDirectoryPreferredDcDelete(params *ActiveDirectoryPreferredDcDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryPreferredDcDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewActiveDirectoryPreferredDcDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "active_directory_preferred_dc_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/active-directory/{svm.uuid}/preferred-domain-controllers/{fqdn}/{server_ip}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ActiveDirectoryPreferredDcDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ActiveDirectoryPreferredDcDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ActiveDirectoryPreferredDcDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ActiveDirectoryPreferredDcDeleteCollection active directory preferred dc delete collection API
*/
func (a *Client) ActiveDirectoryPreferredDcDeleteCollection(params *ActiveDirectoryPreferredDcDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryPreferredDcDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewActiveDirectoryPreferredDcDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "active_directory_preferred_dc_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/active-directory/{svm.uuid}/preferred-domain-controllers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ActiveDirectoryPreferredDcDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ActiveDirectoryPreferredDcDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ActiveDirectoryPreferredDcDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ActiveDirectoryPreferredDcGet Retrieves the Active Directory preferred DC configuration of an SVM.

### Related ONTAP commands
* `vserver active-directory preferred-dc show`
*/
func (a *Client) ActiveDirectoryPreferredDcGet(params *ActiveDirectoryPreferredDcGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ActiveDirectoryPreferredDcGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewActiveDirectoryPreferredDcGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "active_directory_preferred_dc_get",
		Method:             "GET",
		PathPattern:        "/protocols/active-directory/{svm.uuid}/preferred-domain-controllers/{fqdn}/{server_ip}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ActiveDirectoryPreferredDcGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ActiveDirectoryPreferredDcGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ActiveDirectoryPreferredDcGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AuditCollectionGet Retrieves audit configurations.

### Related ONTAP commands
* `vserver audit show`
### Learn more
* [`DOC /protocols/audit`](#docs-NAS-protocols_audit)
*/
func (a *Client) AuditCollectionGet(params *AuditCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuditCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAuditCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "audit_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/audit",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AuditCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AuditCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AuditCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AuditCreate Creates an audit configuration.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM to which audit configuration is to be created.
* `log_path` - Path in the owning SVM namespace that is used to store audit logs.
### Default property values
If not specified in POST, the following default property values are assigned:
* `enabled` - _true_
* `events.authorization_policy` - _false_
* `events.cap_staging` - _false_
* `events.file_share` - _false_
* `events.security_group` - _false_
* `events.user_account` - _false_
* `events.cifs_logon_logoff` - _true_
* `events.audit_policy_change` - _true_
* `events.async_delete` - _false_
* `events.file_operations` - _true_
* `log.format` - _evtx_
* `log.retention.count` - _0_
* `log.retention.duration` - _PT0S_
* `log.rotation.size` - _100MB_
* `log.rotation.now` - _false_
* `guarantee` - _true_
* `charge_qos` - _false_
### Related ONTAP commands
* `vserver audit create`
* `vserver audit enable`
### Learn more
* [`DOC /protocols/audit`](#docs-NAS-protocols_audit)
*/
func (a *Client) AuditCreate(params *AuditCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuditCreateCreated, *AuditCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAuditCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "audit_create",
		Method:             "POST",
		PathPattern:        "/protocols/audit",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AuditCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AuditCreateCreated:
		return value, nil, nil
	case *AuditCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AuditCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AuditDelete Deletes an audit configuration.

### Related ONTAP commands
* `vserver audit disable`
* `vserver audit delete`
### Learn more
* [`DOC /protocols/audit`](#docs-NAS-protocols_audit)
*/
func (a *Client) AuditDelete(params *AuditDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuditDeleteOK, *AuditDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAuditDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "audit_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/audit/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AuditDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AuditDeleteOK:
		return value, nil, nil
	case *AuditDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AuditDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AuditDeleteCollection audit delete collection API
*/
func (a *Client) AuditDeleteCollection(params *AuditDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuditDeleteCollectionOK, *AuditDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAuditDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "audit_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/audit",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AuditDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AuditDeleteCollectionOK:
		return value, nil, nil
	case *AuditDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AuditDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AuditGet Retrieves an audit configuration for an SVM.

### Related ONTAP commands
* `vserver audit show`
### Learn more
* [`DOC /protocols/audit`](#docs-NAS-protocols_audit)
*/
func (a *Client) AuditGet(params *AuditGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuditGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAuditGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "audit_get",
		Method:             "GET",
		PathPattern:        "/protocols/audit/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AuditGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AuditGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AuditGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AuditModify Updates an audit configuration for an SVM.

### Related ONTAP commands
* `vserver audit modify`
### Learn more
* [`DOC /protocols/audit`](#docs-NAS-protocols_audit)
*/
func (a *Client) AuditModify(params *AuditModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuditModifyOK, *AuditModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAuditModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "audit_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/audit/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AuditModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AuditModifyOK:
		return value, nil, nil
	case *AuditModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AuditModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AuditModifyCollection audit modify collection API
*/
func (a *Client) AuditModifyCollection(params *AuditModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuditModifyCollectionOK, *AuditModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAuditModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "audit_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/audit",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AuditModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AuditModifyCollectionOK:
		return value, nil, nil
	case *AuditModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AuditModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CifsCollectionPerformanceMetricsGet Retrieves historical performance metrics for the CIFS protocol of an SVM.
*/
func (a *Client) CifsCollectionPerformanceMetricsGet(params *CifsCollectionPerformanceMetricsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsCollectionPerformanceMetricsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsCollectionPerformanceMetricsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_collection_performance_metrics_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/services/{svm.uuid}/metrics",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsCollectionPerformanceMetricsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsCollectionPerformanceMetricsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsCollectionPerformanceMetricsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsConnectionCollectionGet Retrieves the CIFS connection information for all SVMs.

### Related ONTAP commands
  - `vserver cifs connection show`

### Learn more
* [`DOC /protocols/cifs/connections`](#docs-NAS-protocols_cifs_connections)
*/
func (a *Client) CifsConnectionCollectionGet(params *CifsConnectionCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsConnectionCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsConnectionCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_connection_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/connections",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsConnectionCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsConnectionCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsConnectionCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsDomainCollectionGet Retrieves the CIFS domain-related information of all SVMs.

### Related ONTAP commands
* `vserver cifs domain preferred-dc show`
* `vserver cifs domain trusts show`
* `vserver cifs domain discovered-servers show`
* `vserver cifs domain name-mapping-search show`
* `vserver cifs domain schedule show`
### Learn more
* [`DOC /protocols/cifs/domains`](#docs-NAS-protocols_cifs_domains)
*/
func (a *Client) CifsDomainCollectionGet(params *CifsDomainCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsDomainCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsDomainCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_domain_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/domains",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsDomainCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsDomainCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsDomainCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsDomainGet Retrieves the CIFS domain-related information of the specified SVM.

### Important notes
GET operation with query parameter `rediscover_trusts` and `reset_discovered_servers` returns available CIFS domain configurations and also triggers trusts rediscovery and discovered servers reset asynchronously for that SVM.
### Related ONTAP commands
* `vserver cifs domain preferred-dc show`
* `vserver cifs domain trusts show`
* `vserver cifs domain discovered-servers show`
* `vserver cifs domain name-mapping-search show`
* `vserver cifs domain password schedule show`
* `vserver cifs domain discovered-servers discovery-mode show`
### Learn more
* [`DOC /protocols/cifs/domains/{svm.uuid}`](#docs-NAS-protocols_cifs_domains_{svm.uuid})
*/
func (a *Client) CifsDomainGet(params *CifsDomainGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsDomainGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsDomainGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_domain_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/domains/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsDomainGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsDomainGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsDomainGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsDomainModify Modifies the CIFS domain-related information of the specified SVM.

### Related ONTAP commands
* `vserver cifs domain password schedule modify`
* `vserver cifs domain discovered-servers discovery-mode modify`
* `vserver cifs domain password reset`
* `vserver cifs domain password change`
### Important notes
* If the query is set to cifs_password_operation=reset and ad_domain_user and ad_domain_password is included in the body,a CIFS password reset is executed.
* If the query is set to cifs_password_operation=reset and tenant_id, client_id and client_certificate is included in the body,a CIFS password reset is executed in Azure EntraId for hybrid user.
* If the body is empty when the query is set to cifs_password_operation=reset, a CIFS password change is executed.
### Learn more
* [`DOC /protocols/cifs/domains/{svm.uuid}`](#docs-NAS-protocols_cifs_domains_{svm.uuid})
*/
func (a *Client) CifsDomainModify(params *CifsDomainModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsDomainModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsDomainModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_domain_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/domains/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsDomainModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsDomainModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsDomainModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CifsDomainModifyCollection cifs domain modify collection API
*/
func (a *Client) CifsDomainModifyCollection(params *CifsDomainModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsDomainModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsDomainModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_domain_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/domains",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsDomainModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsDomainModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsDomainModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsDomainPreferredDcCollectionGet Retrieves the CIFS domain preferred DC configuration of an SVM.

### Related ONTAP commands
* `vserver cifs domain preferred-dc show`
* `vserver cifs domain preferred-dc check`
### Learn more
* [`DOC /protocols/cifs/domains/{svm.uuid}/preferred-domain-controllers`](#docs-NAS-protocols_cifs_domains_{svm.uuid}_preferred-domain-controllers)
*/
func (a *Client) CifsDomainPreferredDcCollectionGet(params *CifsDomainPreferredDcCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsDomainPreferredDcCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsDomainPreferredDcCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_domain_preferred_dc_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/domains/{svm.uuid}/preferred-domain-controllers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsDomainPreferredDcCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsDomainPreferredDcCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsDomainPreferredDcCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsDomainPreferredDcCreate Creates a CIFS preferred DC configuration for an SVM.

### Important notes
* In the case of bulk POST requests, the create operation should be performed serially since there can be interdependence between records. In order to avoid issues, it is advisable to always use the query parameter "serial_records=true".
### Required properties
* `svm.uuid` - Existing SVM in which to create the preferred-dc.
* `domain` - Fully Qualified Domain Name.
* `server_ip` - IPv4/IPv6 address of the Preferred Domain Controller.
#### The following parameters are optional:
- skip_config_validation
### Related ONTAP commands
* `vserver cifs domain preferred-dc add`
### Learn more
* [`DOC /protocols/cifs/domains/{svm.uuid}/preferred-domain-controllers`](#docs-NAS-protocols_cifs_domains_{svm.uuid}_preferred-domain-controllers)
*/
func (a *Client) CifsDomainPreferredDcCreate(params *CifsDomainPreferredDcCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsDomainPreferredDcCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsDomainPreferredDcCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_domain_preferred_dc_create",
		Method:             "POST",
		PathPattern:        "/protocols/cifs/domains/{svm.uuid}/preferred-domain-controllers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsDomainPreferredDcCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsDomainPreferredDcCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsDomainPreferredDcCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsDomainPreferredDcDelete Deletes the CIFS domain preferred DC configuration of the specified SVM and domain.

### Related ONTAP commands
* `vserver cifs domain preferred-dc delete`
### Learn more
* [`DOC /protocols/cifs/domains/{svm.uuid}/preferred-domain-controllers`](#docs-NAS-protocols_cifs_domains_{svm.uuid}_preferred-domain-controllers)
*/
func (a *Client) CifsDomainPreferredDcDelete(params *CifsDomainPreferredDcDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsDomainPreferredDcDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsDomainPreferredDcDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_domain_preferred_dc_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/cifs/domains/{svm.uuid}/preferred-domain-controllers/{fqdn}/{server_ip}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsDomainPreferredDcDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsDomainPreferredDcDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsDomainPreferredDcDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CifsDomainPreferredDcDeleteCollection cifs domain preferred dc delete collection API
*/
func (a *Client) CifsDomainPreferredDcDeleteCollection(params *CifsDomainPreferredDcDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsDomainPreferredDcDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsDomainPreferredDcDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_domain_preferred_dc_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/cifs/domains/{svm.uuid}/preferred-domain-controllers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsDomainPreferredDcDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsDomainPreferredDcDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsDomainPreferredDcDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsDomainPreferredDcGet Retrieves the CIFS domain preferred DC configuration of an SVM.

### Related ONTAP commands
* `vserver cifs domain preferred-dc show`
* `vserver cifs domain preferred-dc check`
### Learn more
* [`DOC /protocols/cifs/domains/{svm.uuid}/preferred-domain-controllers`](#docs-NAS-protocols_cifs_domains_{svm.uuid}_preferred-domain-controllers)
*/
func (a *Client) CifsDomainPreferredDcGet(params *CifsDomainPreferredDcGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsDomainPreferredDcGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsDomainPreferredDcGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_domain_preferred_dc_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/domains/{svm.uuid}/preferred-domain-controllers/{fqdn}/{server_ip}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsDomainPreferredDcGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsDomainPreferredDcGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsDomainPreferredDcGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsHomedirSearchPathGet Retrieves a CIFS home directory search path of an SVM.

### Related ONTAP commands
* `cifs server home-directory search-path show`
### Learn more
* [`DOC /protocols/cifs/home-directory/search-paths`](#docs-NAS-protocols_cifs_home-directory_search-paths)
*/
func (a *Client) CifsHomedirSearchPathGet(params *CifsHomedirSearchPathGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsHomedirSearchPathGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsHomedirSearchPathGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_homedir_search_path_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/home-directory/search-paths/{svm.uuid}/{index}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsHomedirSearchPathGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsHomedirSearchPathGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsHomedirSearchPathGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsOpenFileCollectionGet Retrieves the CIFS sessions Open Files information for all SVMs.

### Related ONTAP commands
  - `vserver cifs session file show`

### Learn more
* [`DOC /protocols/cifs/session/files`](#docs-NAS-protocols_cifs_session_files)
*/
func (a *Client) CifsOpenFileCollectionGet(params *CifsOpenFileCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsOpenFileCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsOpenFileCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_open_file_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/session/files",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsOpenFileCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsOpenFileCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsOpenFileCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsOpenFileDelete Closes open files identified by svm.uuid, file.identifier, connection.identifier and session_id.

### Related ONTAP commands
  - `vserver cifs session file close`

### Learn more
* [`DOC /protocols/cifs/session/files`](#docs-NAS-protocols_cifs_session_files)
*/
func (a *Client) CifsOpenFileDelete(params *CifsOpenFileDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsOpenFileDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsOpenFileDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_open_file_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/cifs/session/files/{node.uuid}/{svm.uuid}/{identifier}/{connection.identifier}/{session.identifier}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsOpenFileDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsOpenFileDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsOpenFileDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CifsOpenFileDeleteCollection cifs open file delete collection API
*/
func (a *Client) CifsOpenFileDeleteCollection(params *CifsOpenFileDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsOpenFileDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsOpenFileDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_open_file_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/cifs/session/files",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsOpenFileDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsOpenFileDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsOpenFileDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsOpenFileGet Retrieves specific CIFS session Open Files information.

### Learn more
* [`DOC /protocols/cifs/session/files`](#docs-NAS-protocols_cifs_session_files)
*/
func (a *Client) CifsOpenFileGet(params *CifsOpenFileGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsOpenFileGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsOpenFileGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_open_file_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/session/files/{node.uuid}/{svm.uuid}/{identifier}/{connection.identifier}/{session.identifier}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsOpenFileGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsOpenFileGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsOpenFileGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsSearchPathCollectionGet Retrieves CIFS home directory search paths.

### Related ONTAP commands
* `cifs server home-directory search-path show`
### Learn more
* [`DOC /protocols/cifs/home-directory/search-paths`](#docs-NAS-protocols_cifs_home-directory_search-paths)
*/
func (a *Client) CifsSearchPathCollectionGet(params *CifsSearchPathCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSearchPathCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsSearchPathCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_search_path_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/home-directory/search-paths",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsSearchPathCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsSearchPathCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsSearchPathCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsSearchPathCreate Creates a home directory search path.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the home directory search path.
* `path` - Path in the owning SVM namespace that is used to search for home directories.
### Related ONTAP commands
* `cifs server home-directory search-path add`
### Learn more
* [`DOC /protocols/cifs/home-directory/search-paths`](#docs-NAS-protocols_cifs_home-directory_search-paths)
*/
func (a *Client) CifsSearchPathCreate(params *CifsSearchPathCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSearchPathCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsSearchPathCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_search_path_create",
		Method:             "POST",
		PathPattern:        "/protocols/cifs/home-directory/search-paths",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsSearchPathCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsSearchPathCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsSearchPathCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsSearchPathDelete Deletes a CIFS home directory search path.

### Related ONTAP commands
* `cifs server home-directory search-path remove`
### Learn more
* [`DOC /protocols/cifs/home-directory/search-paths`](#docs-NAS-protocols_cifs_home-directory_search-paths)
*/
func (a *Client) CifsSearchPathDelete(params *CifsSearchPathDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSearchPathDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsSearchPathDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_search_path_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/cifs/home-directory/search-paths/{svm.uuid}/{index}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsSearchPathDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsSearchPathDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsSearchPathDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CifsSearchPathDeleteCollection cifs search path delete collection API
*/
func (a *Client) CifsSearchPathDeleteCollection(params *CifsSearchPathDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSearchPathDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsSearchPathDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_search_path_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/cifs/home-directory/search-paths",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsSearchPathDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsSearchPathDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsSearchPathDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsSearchPathModify Reorders a CIFS home directory search path.

### Related ONTAP commands
* `cifs server home-directory search-path reorder`
### Learn more
* [`DOC /protocols/cifs/home-directory/search-paths`](#docs-NAS-protocols_cifs_home-directory_search-paths)
*/
func (a *Client) CifsSearchPathModify(params *CifsSearchPathModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSearchPathModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsSearchPathModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_search_path_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/home-directory/search-paths/{svm.uuid}/{index}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsSearchPathModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsSearchPathModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsSearchPathModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CifsSearchPathModifyCollection cifs search path modify collection API
*/
func (a *Client) CifsSearchPathModifyCollection(params *CifsSearchPathModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSearchPathModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsSearchPathModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_search_path_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/home-directory/search-paths",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsSearchPathModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsSearchPathModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsSearchPathModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsServiceCollectionGet Retrieves CIFS servers.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `statistics.*`
* `metric.*`
### Related ONTAP commands
* `vserver cifs server show`
* `vserver cifs server options show`
* `vserver cifs server security show`
### Learn more
* [`DOC /protocols/cifs/services`](#docs-NAS-protocols_cifs_services)
*/
func (a *Client) CifsServiceCollectionGet(params *CifsServiceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsServiceCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsServiceCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_service_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsServiceCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsServiceCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsServiceCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsServiceCreate Creates a CIFS server. Each SVM can have one CIFS server.</br>

### Important notes
- The CIFS server name might or might not be the same as the SVM name.
- The CIFS server name can contain up to 15 characters.
- The CIFS server name does not support the following characters: @ # * ( ) = + [ ] | ; : " , < >  / ?
### Required properties when creating CIFS server with Windows Active Directory domain
* `svm.uuid` or `svm.name` - Existing SVM in which to create the CIFS server.
* `name` -  Name of the CIFS server.
* `ad_domain.fqdn` - Fully qualified domain name of the Windows Active Directory to which this CIFS server belongs.
* `ad_domain.user` - User account with the access to add the CIFS server to the Active Directory.
* `ad_domain.password` - Account password used to add this CIFS server to the Active Directory.
### Required properties when creating CIFS server in Workgroup mode
* `svm.uuid` or `svm.name` - Existing SVM in which to create the CIFS server.
* `name` -  Name of the CIFS server.
* `workgroup` - Name of the workgroup to which this CIFS server belongs.
### Required properties when using AKV for authentication (ANF platform)
* `svm.uuid` or `svm.name` - Existing SVM in which to create the CIFS server.
* `name` -  Name of the CIFS server.
* `ad_domain.user` - User account with the access to add the CIFS server to the Active Directory.
* `ad_domain.fqdn` - Fully qualified domain name of the Windows Active Directory to which this CIFS server belongs.
* `client_id` - Application client ID of the deployed Azure application with appropriate access to an AKV or EntraId.
* `tenant_id` - Directory (tenant) ID of the deployed Azure application with appropriate access to an AKV or EntraId.
* `key_vault_uri` - URI of the deployed AKV that is used by ONTAP for storing keys.
* `authentication_method` - Authentication method used by the application to prove its identity to AKV or EntraId. It can be either "client_secret" or "certificate".
* `auth_user_type` - Type of user who can access the SMB Volume. It can be either "domain_user" or "hybrid_user". The default is domain_user. In the case of a hybrid-user, ONTAP cannot access on-premise ADDS.
* `client_secret` - Secret used by the application to prove its identity to AKV.
* `client_certificate` - Base64 encoded PKCS12 certificate used by the application to prove its identity to AKV.
### Recommended optional properties
* `comment` - Add a text comment of up to 256 characters about the CIFS server.
* `netbios.aliases` - Add a comma-delimited list of one or more NetBIOS aliases for the CIFS server.
* `netbios.wins_servers` - Add a list of Windows Internet Name Server (WINS) addresses that manage and map the NetBIOS name of the CIFS server to their network IP addresses. The IP addresses must be IPv4 addresses.
### Default property values
If not specified in POST, the following default property values are assigned:
* `ad_domain.organizational_unit` - _CN=Computers_
* `enabled` - _true_
* `security.restrict_anonymous` - _no_enumeration_
* `security.smb_signing` - _false_
* `security.smb_encryption` - _false_
* `security.encrypt_dc_connection` - _false_
* `default_unix_user` - _pcuser_
* `netbios.enabled` - _false_ However, if either "netbios.wins-server" or "netbios.aliases" is set during POST and if `netbios.enabled` is not specified then `netbios.enabled` is set to true.
* `security.aes_netlogon_enabled` - _false_
* `security.try_ldap_channel_binding` - _true_
* `security.ldap_referral_enabled` - _false_
### Related ONTAP commands
* `vserver cifs server create`
* `vserver cifs server options modify`
* `vserver cifs security modify`
* `vserver cifs server add-netbios-aliases`
### Learn more
* [`DOC /protocols/cifs/services`](#docs-NAS-protocols_cifs_services)
*/
func (a *Client) CifsServiceCreate(params *CifsServiceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsServiceCreateCreated, *CifsServiceCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsServiceCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_service_create",
		Method:             "POST",
		PathPattern:        "/protocols/cifs/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsServiceCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *CifsServiceCreateCreated:
		return value, nil, nil
	case *CifsServiceCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsServiceCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsServiceDelete Deletes a CIFS server and related CIFS configurations.<br/>

</br>Important notes:
* The default value for the "force" field is false.
* If the "force" field is set along with user login credentials, the local CIFS configuration will be deleted irrespective of any communication errors.
* If the "force" field alone is set without passing the user login credentials, the local CIFS configuration will be deleted by not making any request to Active Directory.
### Related ONTAP commands
* `vserver cifs server delete`
* `vserver cifs remove-netbios-aliases`
### Learn more
* [`DOC /protocols/cifs/services`](#docs-NAS-protocols_cifs_services)
*/
func (a *Client) CifsServiceDelete(params *CifsServiceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsServiceDeleteOK, *CifsServiceDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsServiceDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_service_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/cifs/services/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsServiceDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *CifsServiceDeleteOK:
		return value, nil, nil
	case *CifsServiceDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsServiceDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CifsServiceDeleteCollection cifs service delete collection API
*/
func (a *Client) CifsServiceDeleteCollection(params *CifsServiceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsServiceDeleteCollectionOK, *CifsServiceDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsServiceDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_service_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/cifs/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsServiceDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *CifsServiceDeleteCollectionOK:
		return value, nil, nil
	case *CifsServiceDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsServiceDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsServiceGet Retrieves a CIFS server.

### Related ONTAP commands
* `vserver cifs server show`
* `vserver cifs server options show`
* `vserver cifs server security show`
### Learn more
* [`DOC /protocols/cifs/services`](#docs-NAS-protocols_cifs_services)
*/
func (a *Client) CifsServiceGet(params *CifsServiceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsServiceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsServiceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_service_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/services/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsServiceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsServiceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsServiceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsServiceModify Updates both the mandatory and optional parameters of the CIFS configuration. Ensure the CIFS server is administratively disabled when renaming the CIFS server or modifying the <i>ad_domain</i> properties.

### Related ONTAP commands
* `vserver cifs server modify`
* `vserver cifs server options modify`
* `vserver cifs security modify`
* `vserver cifs server add-netbios-aliases`
* `vserver cifs server remove-netbios-aliases`
* `vserver cifs group-policy modify`
### Learn more
* [`DOC /protocols/cifs/services`](#docs-NAS-protocols_cifs_services)
*/
func (a *Client) CifsServiceModify(params *CifsServiceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsServiceModifyOK, *CifsServiceModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsServiceModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_service_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/services/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsServiceModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *CifsServiceModifyOK:
		return value, nil, nil
	case *CifsServiceModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsServiceModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CifsServiceModifyCollection cifs service modify collection API
*/
func (a *Client) CifsServiceModifyCollection(params *CifsServiceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsServiceModifyCollectionOK, *CifsServiceModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsServiceModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_service_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsServiceModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *CifsServiceModifyCollectionOK:
		return value, nil, nil
	case *CifsServiceModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsServiceModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsSessionCollectionGet Retrieves the CIFS sessions information for all SVMs.

### Related ONTAP commands
  - `vserver cifs session show -active-volumes`

### Learn more
* [`DOC /protocols/cifs/sessions`](#docs-NAS-protocols_cifs_sessions)
*/
func (a *Client) CifsSessionCollectionGet(params *CifsSessionCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSessionCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsSessionCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_session_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/sessions",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsSessionCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsSessionCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsSessionCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsSessionDelete Deletes SMB session information on a node for an SVM.

* To delete the specific SMB session information, pass the relevant SMB session's identifier and connection Id.
* To delete all the SMB session information on specific node and SVM, pass the both SMB session's identifier and connection Id as zero(0)
* To delete all the SMB session information on specific connection, pass the specific SMB session's Identifier value as zero(0).
* To delete all the SMB session information on specific Identifier alone is not allowed.
### Related ONTAP commands
  - `vserver cifs session close`

### Learn more
* [`DOC /protocols/cifs/sessions`](#docs-NAS-protocols_cifs_sessions)
*/
func (a *Client) CifsSessionDelete(params *CifsSessionDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSessionDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsSessionDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_session_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/cifs/sessions/{node.uuid}/{svm.uuid}/{identifier}/{connection_id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsSessionDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsSessionDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsSessionDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CifsSessionDeleteCollection cifs session delete collection API
*/
func (a *Client) CifsSessionDeleteCollection(params *CifsSessionDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSessionDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsSessionDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_session_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/cifs/sessions",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsSessionDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsSessionDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsSessionDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsSessionGet Retrieves specific SMB session information for a specific SMB connection in a node on an SVM.

### Learn more
* [`DOC /protocols/cifs/sessions`](#docs-NAS-protocols_cifs_sessions)
*/
func (a *Client) CifsSessionGet(params *CifsSessionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSessionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsSessionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_session_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/sessions/{node.uuid}/{svm.uuid}/{identifier}/{connection_id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsSessionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsSessionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsSessionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsShareACLCollectionGet Retrieves the share-level ACL on a CIFS share.

### Related ONTAP commands
* `vserver cifs share access-control show`
### Learn more
* [`DOC /protocols/cifs/shares/{svm.uuid}/{share}/acls`](#docs-NAS-protocols_cifs_shares_{svm.uuid}_{share}_acls)
*/
func (a *Client) CifsShareACLCollectionGet(params *CifsShareACLCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareACLCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsShareACLCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_share_acl_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/shares/{svm.uuid}/{share}/acls",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsShareACLCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsShareACLCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsShareACLCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsShareACLCreate Creates a share-level ACL on a CIFS share.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the share acl.
* `share` - Existing CIFS share in which to create the share acl.
* `user_or_group` - Existing user or group name for which the acl is added on the CIFS share.
* `permission` - Access rights that a user or group has on the defined CIFS share.
### Default property values
* `type` - _windows_
### Related ONTAP commands
* `vserver cifs share access-control create`
### Learn more
* [`DOC /protocols/cifs/shares/{svm.uuid}/{share}/acls`](#docs-NAS-protocols_cifs_shares_{svm.uuid}_{share}_acls)
*/
func (a *Client) CifsShareACLCreate(params *CifsShareACLCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareACLCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsShareACLCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_share_acl_create",
		Method:             "POST",
		PathPattern:        "/protocols/cifs/shares/{svm.uuid}/{share}/acls",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsShareACLCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsShareACLCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsShareACLCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsShareACLDelete Deletes a share-level ACL on a CIFS share.

### Related ONTAP commands
* `vserver cifs share access-control delete`
### Learn more
* [`DOC /protocols/cifs/shares/{svm.uuid}/{share}/acls`](#docs-NAS-protocols_cifs_shares_{svm.uuid}_{share}_acls)
*/
func (a *Client) CifsShareACLDelete(params *CifsShareACLDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareACLDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsShareACLDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_share_acl_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/cifs/shares/{svm.uuid}/{share}/acls/{user_or_group}/{type}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsShareACLDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsShareACLDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsShareACLDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CifsShareACLDeleteCollection cifs share acl delete collection API
*/
func (a *Client) CifsShareACLDeleteCollection(params *CifsShareACLDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareACLDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsShareACLDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_share_acl_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/cifs/shares/{svm.uuid}/{share}/acls",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsShareACLDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsShareACLDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsShareACLDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsShareACLGet Retrieves the share-level ACL on CIFS share for a specified user or group.

### Related ONTAP commands
* `vserver cifs share access-control show`
### Learn more
* [`DOC /protocols/cifs/shares/{svm.uuid}/{share}/acls`](#docs-NAS-protocols_cifs_shares_{svm.uuid}_{share}_acls)
*/
func (a *Client) CifsShareACLGet(params *CifsShareACLGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareACLGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsShareACLGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_share_acl_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/shares/{svm.uuid}/{share}/acls/{user_or_group}/{type}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsShareACLGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsShareACLGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsShareACLGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsShareACLModify Updates a share-level ACL on a CIFS share.

### Related ONTAP commands
* `vserver cifs share access-control modify`
### Learn more
* [`DOC /protocols/cifs/shares/{svm.uuid}/{share}/acls`](#docs-NAS-protocols_cifs_shares_{svm.uuid}_{share}_acls)
*/
func (a *Client) CifsShareACLModify(params *CifsShareACLModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareACLModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsShareACLModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_share_acl_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/shares/{svm.uuid}/{share}/acls/{user_or_group}/{type}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsShareACLModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsShareACLModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsShareACLModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CifsShareACLModifyCollection cifs share acl modify collection API
*/
func (a *Client) CifsShareACLModifyCollection(params *CifsShareACLModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareACLModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsShareACLModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_share_acl_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/shares/{svm.uuid}/{share}/acls",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsShareACLModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsShareACLModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsShareACLModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsShareCollectionGet Retrieves CIFS shares.

### Related ONTAP commands
* `vserver cifs share show`
* `vserver cifs share properties show`
### Learn more
* [`DOC /protocols/cifs/shares`](#docs-NAS-protocols_cifs_shares)
*/
func (a *Client) CifsShareCollectionGet(params *CifsShareCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsShareCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_share_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/shares",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsShareCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsShareCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsShareCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsShareCreate Creates a CIFS share.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the CIFS share.
* `name` - Name of the CIFS share.
* `path` - Path in the owning SVM namespace that is shared through this share.
### Recommended optional properties
* `comment` - Optionally choose to add a text comment of up to 256 characters about the CIFS share.
* `acls` - Optionally choose to add share permissions that users and groups have on the CIFS share.
### Default property values
If not specified in POST, the following default property values are assigned:
* `home_directory` - _false_
* `oplocks` - _true_
* `access_based_enumeration` - _false_
* `change_notify` - _true_
* `encryption` - _false_
* `unix_symlink` - _local_
### Related ONTAP commands
* `vserver cifs share create`
* `vserver cifs share properties add`
* `vserver cifs share access-control create`
### Learn more
* [`DOC /protocols/cifs/shares`](#docs-NAS-protocols_cifs_shares)
*/
func (a *Client) CifsShareCreate(params *CifsShareCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsShareCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_share_create",
		Method:             "POST",
		PathPattern:        "/protocols/cifs/shares",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsShareCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsShareCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsShareCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsShareDelete Deletes a CIFS share.

### Related ONTAP commands
* `vserver cifs share delete`
### Learn more
* [`DOC /protocols/cifs/shares`](#docs-NAS-protocols_cifs_shares)
*/
func (a *Client) CifsShareDelete(params *CifsShareDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsShareDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_share_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/cifs/shares/{svm.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsShareDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsShareDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsShareDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CifsShareDeleteCollection cifs share delete collection API
*/
func (a *Client) CifsShareDeleteCollection(params *CifsShareDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsShareDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_share_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/cifs/shares",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsShareDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsShareDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsShareDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsShareGet Retrieves a CIFS share.

### Related ONTAP commands
* `vserver cifs share show`
* `vserver cifs share properties show`
### Learn more
* [`DOC /protocols/cifs/shares`](#docs-NAS-protocols_cifs_shares)
*/
func (a *Client) CifsShareGet(params *CifsShareGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsShareGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_share_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/shares/{svm.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsShareGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsShareGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsShareGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsShareModify Updates a CIFS share.

### Related ONTAP commands
* `vserver cifs share modify`
* `vserver cifs share properties add`
* `vserver cifs share properties remove`
### Learn more
* [`DOC /protocols/cifs/shares`](#docs-NAS-protocols_cifs_shares)
*/
func (a *Client) CifsShareModify(params *CifsShareModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsShareModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_share_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/shares/{svm.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsShareModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsShareModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsShareModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CifsShareModifyCollection cifs share modify collection API
*/
func (a *Client) CifsShareModifyCollection(params *CifsShareModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsShareModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsShareModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_share_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/shares",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsShareModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsShareModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsShareModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsSymlinkMappingCollectionGet Retrieves UNIX symbolic link mappings for CIFS clients.

### Related ONTAP commands
* `vserver cifs symlink show`
### Learn more
* [`DOC /protocols/cifs/unix-symlink-mapping`](#docs-NAS-protocols_cifs_unix-symlink-mapping)
*/
func (a *Client) CifsSymlinkMappingCollectionGet(params *CifsSymlinkMappingCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSymlinkMappingCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsSymlinkMappingCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_symlink_mapping_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/unix-symlink-mapping",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsSymlinkMappingCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsSymlinkMappingCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsSymlinkMappingCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsSymlinkMappingCreate Creates a UNIX symbolic link mapping for a CIFS client.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the CIFS unix-symlink-mapping.
* `unix_path` - UNIX path to which the CIFS symlink mapping to be created.
* `target.share` - CIFS share name on the destination CIFS server to which the UNIX symbolic link is pointing.
* `target.path` - CIFS path on the destination to which the symbolic link maps.
### Default property values
* `target.server` - _Local_NetBIOS_Server_Name_
* `locality` - _local_
* `home_directory` - _false_
### Related ONTAP commands
* `vserver cifs symlink create`
### Learn more
* [`DOC /protocols/cifs/unix-symlink-mapping`](#docs-NAS-protocols_cifs_unix-symlink-mapping)
*/
func (a *Client) CifsSymlinkMappingCreate(params *CifsSymlinkMappingCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSymlinkMappingCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsSymlinkMappingCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_symlink_mapping_create",
		Method:             "POST",
		PathPattern:        "/protocols/cifs/unix-symlink-mapping",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsSymlinkMappingCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsSymlinkMappingCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsSymlinkMappingCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsSymlinkMappingDelete Deletes the UNIX symbolic link mapping for CIFS clients.

### Related ONTAP commands
* `vserver cifs symlink delete`
### Learn more
* [`DOC /protocols/cifs/unix-symlink-mapping`](#docs-NAS-protocols_cifs_unix-symlink-mapping)
*/
func (a *Client) CifsSymlinkMappingDelete(params *CifsSymlinkMappingDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSymlinkMappingDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsSymlinkMappingDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_symlink_mapping_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/cifs/unix-symlink-mapping/{svm.uuid}/{unix_path}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsSymlinkMappingDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsSymlinkMappingDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsSymlinkMappingDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CifsSymlinkMappingDeleteCollection cifs symlink mapping delete collection API
*/
func (a *Client) CifsSymlinkMappingDeleteCollection(params *CifsSymlinkMappingDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSymlinkMappingDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsSymlinkMappingDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_symlink_mapping_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/cifs/unix-symlink-mapping",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsSymlinkMappingDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsSymlinkMappingDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsSymlinkMappingDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsSymlinkMappingGet Retrieves a UNIX symbolic link mapping for CIFS clients.

### Related ONTAP commands
* `vserver cifs symlink show`
### Learn more
* [`DOC /protocols/cifs/unix-symlink-mapping`](#docs-NAS-protocols_cifs_unix-symlink-mapping)
*/
func (a *Client) CifsSymlinkMappingGet(params *CifsSymlinkMappingGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSymlinkMappingGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsSymlinkMappingGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_symlink_mapping_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/unix-symlink-mapping/{svm.uuid}/{unix_path}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsSymlinkMappingGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsSymlinkMappingGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsSymlinkMappingGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CifsSymlinkMappingModify Updates the UNIX symbolic link mapping for CIFS clients.

### Related ONTAP commands
* `vserver cifs symlink modify`
### Learn more
* [`DOC /protocols/cifs/unix-symlink-mapping`](#docs-NAS-protocols_cifs_unix-symlink-mapping)
*/
func (a *Client) CifsSymlinkMappingModify(params *CifsSymlinkMappingModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSymlinkMappingModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsSymlinkMappingModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_symlink_mapping_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/unix-symlink-mapping/{svm.uuid}/{unix_path}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsSymlinkMappingModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsSymlinkMappingModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsSymlinkMappingModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CifsSymlinkMappingModifyCollection cifs symlink mapping modify collection API
*/
func (a *Client) CifsSymlinkMappingModifyCollection(params *CifsSymlinkMappingModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CifsSymlinkMappingModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCifsSymlinkMappingModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cifs_symlink_mapping_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/unix-symlink-mapping",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CifsSymlinkMappingModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CifsSymlinkMappingModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CifsSymlinkMappingModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClientLockCollectionGet Retrieves locks details.

### Related ONTAP commands
* `vserver locks  show`
*/
func (a *Client) ClientLockCollectionGet(params *ClientLockCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClientLockCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClientLockCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "client_lock_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/locks",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClientLockCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClientLockCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClientLockCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClientLockDelete Deletes locks of given parameter.

### Related ONTAP commands
* `vserver locks break`
*/
func (a *Client) ClientLockDelete(params *ClientLockDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClientLockDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClientLockDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "client_lock_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/locks/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClientLockDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClientLockDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClientLockDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ClientLockDeleteCollection client lock delete collection API
*/
func (a *Client) ClientLockDeleteCollection(params *ClientLockDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClientLockDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClientLockDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "client_lock_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/locks",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClientLockDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClientLockDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClientLockDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClientLockGet Retrieves the lock for a specific UUID.

### Related ONTAP commands
* `vserver locks show`
*/
func (a *Client) ClientLockGet(params *ClientLockGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClientLockGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClientLockGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "client_lock_get",
		Method:             "GET",
		PathPattern:        "/protocols/locks/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClientLockGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClientLockGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClientLockGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	EffectivePermissionGet Retrieves effective security permissions on a file.

### Related ONTAP commands
* `vserver security file-directory show-effective-permissions`
*/
func (a *Client) EffectivePermissionGet(params *EffectivePermissionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*EffectivePermissionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEffectivePermissionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "effective_permission_get",
		Method:             "GET",
		PathPattern:        "/protocols/file-security/effective-permissions/{svm.uuid}/{path}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &EffectivePermissionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*EffectivePermissionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*EffectivePermissionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ExportPolicyCollectionGet Retrieves export policies.

### Related ONTAP commands
* `vserver export-policy show`
* `vserver export-policy rule show`
### Learn more
* [`DOC /protocols/nfs/export-policies`](#docs-NAS-protocols_nfs_export-policies)
####
Note: `are_rules_truncated` is set to 'true' if the total number of export-policy rules is greater than 500. If set to 'true', rules after 500 will be truncated. Use GET /api/protocols/nfs/export-policies/{id}/rules to retrieve all rules for truncated policies.
*/
func (a *Client) ExportPolicyCollectionGet(params *ExportPolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportPolicyCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewExportPolicyCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "export_policy_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/nfs/export-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ExportPolicyCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ExportPolicyCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ExportPolicyCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ExportPolicyCreate Creates an export policy. An SVM can have any number of export policies to define rules for which clients can access data exported by the SVM. A policy with no rules prohibits access.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create an export policy.
* `name`  - Name of the export policy.
### Recommended optional properties
* `rules`  - Rule(s) of an export policy. Used to create the export rule and populate the export policy with export rules in a single request.
* `rules[].index` - If you specify an index number that already matches a rule, the index number of the existing rule is incremented, as are the index numbers of all subsequent rules, either to the end of the list or to an open space in the list. If you do not specify an index number, the new rule is placed at the end of the policy's list.
### Related ONTAP commands
* `vserver export-policy create`
* `vserver export-policy rule create`
### Learn more
* [`DOC /protocols/nfs/export-policies`](#docs-NAS-protocols_nfs_export-policies)
*/
func (a *Client) ExportPolicyCreate(params *ExportPolicyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportPolicyCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewExportPolicyCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "export_policy_create",
		Method:             "POST",
		PathPattern:        "/protocols/nfs/export-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ExportPolicyCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ExportPolicyCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ExportPolicyCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ExportPolicyDelete Deletes an export policy.

### Related ONTAP commands
* `vserver export-policy delete`
### Learn more
* [`DOC /protocols/nfs/export-policies`](#docs-NAS-protocols_nfs_export-policies)
*/
func (a *Client) ExportPolicyDelete(params *ExportPolicyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportPolicyDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewExportPolicyDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "export_policy_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/nfs/export-policies/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ExportPolicyDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ExportPolicyDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ExportPolicyDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ExportPolicyDeleteCollection export policy delete collection API
*/
func (a *Client) ExportPolicyDeleteCollection(params *ExportPolicyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportPolicyDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewExportPolicyDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "export_policy_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/nfs/export-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ExportPolicyDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ExportPolicyDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ExportPolicyDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ExportPolicyGet Retrieves an export policy.

### Related ONTAP commands
* `vserver export-policy show`
* `vserver export-policy rule show`
### Learn more
* [`DOC /protocols/nfs/export-policies`](#docs-NAS-protocols_nfs_export-policies)
*/
func (a *Client) ExportPolicyGet(params *ExportPolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportPolicyGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewExportPolicyGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "export_policy_get",
		Method:             "GET",
		PathPattern:        "/protocols/nfs/export-policies/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ExportPolicyGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ExportPolicyGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ExportPolicyGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ExportPolicyModify Updates the properties of an export policy to change an export policy name or replace all export policy rules.

### Related ONTAP commands
* `vserver export-policy rename`
* `vserver export-policy rule delete`
* `vserver export-policy rule create`
### Learn more
* [`DOC /protocols/nfs/export-policies`](#docs-NAS-protocols_nfs_export-policies)
*/
func (a *Client) ExportPolicyModify(params *ExportPolicyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportPolicyModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewExportPolicyModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "export_policy_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/nfs/export-policies/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ExportPolicyModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ExportPolicyModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ExportPolicyModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ExportPolicyModifyCollection export policy modify collection API
*/
func (a *Client) ExportPolicyModifyCollection(params *ExportPolicyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportPolicyModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewExportPolicyModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "export_policy_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/nfs/export-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ExportPolicyModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ExportPolicyModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ExportPolicyModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ExportRuleClientsCreate Creates an export policy rule client

### Required properties
* `policy.id` - Existing export policy that contains export policy rules for the client being added.
* `index`  - Existing export policy rule for which to create an export client.
* `match`  - Base name for the export policy client.
### Related ONTAP commands
* `vserver export-policy rule add-clientmatches`
### Learn more
* [`DOC /protocols/nfs/export-policies`](#docs-NAS-protocols_nfs_export-policies)
*/
func (a *Client) ExportRuleClientsCreate(params *ExportRuleClientsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportRuleClientsCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewExportRuleClientsCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "export_rule_clients_create",
		Method:             "POST",
		PathPattern:        "/protocols/nfs/export-policies/{policy.id}/rules/{index}/clients",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ExportRuleClientsCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ExportRuleClientsCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ExportRuleClientsCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ExportRuleClientsDelete Deletes an export policy client

### Related ONTAP commands
* `vserver export-policy rule remove-clientmatches`
### Learn more
* [`DOC /protocols/nfs/export-policies`](#docs-NAS-protocols_nfs_export-policies)
*/
func (a *Client) ExportRuleClientsDelete(params *ExportRuleClientsDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportRuleClientsDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewExportRuleClientsDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "export_rule_clients_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/nfs/export-policies/{policy.id}/rules/{index}/clients/{match}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ExportRuleClientsDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ExportRuleClientsDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ExportRuleClientsDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ExportRuleClientsDeleteCollection export rule clients delete collection API
*/
func (a *Client) ExportRuleClientsDeleteCollection(params *ExportRuleClientsDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportRuleClientsDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewExportRuleClientsDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "export_rule_clients_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/nfs/export-policies/{policy.id}/rules/{index}/clients",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ExportRuleClientsDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ExportRuleClientsDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ExportRuleClientsDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ExportRuleClientsGet Retrieves export policy rule clients.

### Learn more
* [`DOC /protocols/nfs/export-policies`](#docs-NAS-protocols_nfs_export-policies)
*/
func (a *Client) ExportRuleClientsGet(params *ExportRuleClientsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportRuleClientsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewExportRuleClientsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "export_rule_clients_get",
		Method:             "GET",
		PathPattern:        "/protocols/nfs/export-policies/{policy.id}/rules/{index}/clients",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ExportRuleClientsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ExportRuleClientsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ExportRuleClientsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ExportRuleCollectionGet Retrieves export policy rules.

### Related ONTAP commands
* `vserver export-policy rule show`
### Learn more
* [`DOC /protocols/nfs/export-policies`](#docs-NAS-protocols_nfs_export-policies)
*/
func (a *Client) ExportRuleCollectionGet(params *ExportRuleCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportRuleCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewExportRuleCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "export_rule_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/nfs/export-policies/{policy.id}/rules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ExportRuleCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ExportRuleCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ExportRuleCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ExportRuleCreate Creates an export policy rule.

### Required properties
* `policy.id`  - Existing export policy for which to create an export rule.
* `clients.match`  - List of clients (hostnames, ipaddresses, netgroups, domains) to which the export rule applies.
* `ro_rule`  - Used to specify the security type for read-only access to volumes that use the export rule.
* `rw_rule`  - Used to specify the security type for read-write access to volumes that use the export rule.
### Optional property
* `index`    - Used to specify the index number of the export rule that you want to create. If you specify an index number that already matches a rule, the index number of the existing rule is incremented, as are the index numbers of all subsequent rules, either to the end of the list or to an open space in the list. If you do not specify an index number, the new rule is placed at the end of the policy's list.
### Default property values
If not specified in POST, the following default property values are assigned:
* `protocols` - _any_
* `anonymous_user` - _none_
* `superuser` - _any_
* `allow_device_creation` - _true_
* `ntfs_unix_security` - _fail_
* `chown_mode` - _restricted_
* `allow_suid` - _true_
### Related ONTAP commands
* `vserver export-policy rule create`
### Learn more
* [`DOC /protocols/nfs/export-policies`](#docs-NAS-protocols_nfs_export-policies)
*/
func (a *Client) ExportRuleCreate(params *ExportRuleCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportRuleCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewExportRuleCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "export_rule_create",
		Method:             "POST",
		PathPattern:        "/protocols/nfs/export-policies/{policy.id}/rules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ExportRuleCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ExportRuleCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ExportRuleCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ExportRuleDelete Deletes an export policy rule.

### Related ONTAP commands
* `vserver export-policy rule delete`
### Learn more
* [`DOC /protocols/nfs/export-policies`](#docs-NAS-protocols_nfs_export-policies)
*/
func (a *Client) ExportRuleDelete(params *ExportRuleDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportRuleDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewExportRuleDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "export_rule_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/nfs/export-policies/{policy.id}/rules/{index}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ExportRuleDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ExportRuleDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ExportRuleDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ExportRuleDeleteCollection export rule delete collection API
*/
func (a *Client) ExportRuleDeleteCollection(params *ExportRuleDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportRuleDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewExportRuleDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "export_rule_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/nfs/export-policies/{policy.id}/rules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ExportRuleDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ExportRuleDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ExportRuleDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ExportRuleGet Retrieves an export policy rule

### Related ONTAP commands
* `vserver export-policy rule show`
### Learn more
* [`DOC /protocols/nfs/export-policies`](#docs-NAS-protocols_nfs_export-policies)
*/
func (a *Client) ExportRuleGet(params *ExportRuleGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportRuleGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewExportRuleGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "export_rule_get",
		Method:             "GET",
		PathPattern:        "/protocols/nfs/export-policies/{policy.id}/rules/{index}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ExportRuleGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ExportRuleGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ExportRuleGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ExportRuleModify Updates the properties of an export policy rule to change an export policy rule's index or fields.

### Related ONTAP commands
* `vserver export-policy rule modify`
* `vserver export-policy rule setindex`
### Learn more
* [`DOC /protocols/nfs/export-policies`](#docs-NAS-protocols_nfs_export-policies)
*/
func (a *Client) ExportRuleModify(params *ExportRuleModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportRuleModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewExportRuleModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "export_rule_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/nfs/export-policies/{policy.id}/rules/{index}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ExportRuleModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ExportRuleModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ExportRuleModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ExportRuleModifyCollection export rule modify collection API
*/
func (a *Client) ExportRuleModifyCollection(params *ExportRuleModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ExportRuleModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewExportRuleModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "export_rule_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/nfs/export-policies/{policy.id}/rules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ExportRuleModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ExportRuleModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ExportRuleModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FileDirectorySecurityACLCreate Adds the new SACL/DACL ACE.

You must keep the following points in mind while using these endpoints:
* SLAG applies to all files and/or directories in a volume hence, inheritance is not required to be propagated.
* Set access_control field to slag while adding SLAG ACE.
* Set access_control field to file_directory while adding file-directory ACE. By Default access_control field is set to file_directory.
* For SLAG, valid apply_to combinations are "this-folder, sub-folders", "files", "this-folder, sub-folders, files".
### Required properties
* `user` - Name of the user to which the ACE applies.
* `access` - Specifies whether the ACE is for DACL or SACL.
### Related ONTAP commands
* `vserver security file-directory ntfs dacl add`
* `vserver security file-directory ntfs sacl add`
*/
func (a *Client) FileDirectorySecurityACLCreate(params *FileDirectorySecurityACLCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileDirectorySecurityACLCreateCreated, *FileDirectorySecurityACLCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFileDirectorySecurityACLCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "file_directory_security_acl_create",
		Method:             "POST",
		PathPattern:        "/protocols/file-security/permissions/{svm.uuid}/{path}/acl",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FileDirectorySecurityACLCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *FileDirectorySecurityACLCreateCreated:
		return value, nil, nil
	case *FileDirectorySecurityACLCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FileDirectorySecurityACLCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FileDirectorySecurityACLDelete Deletes the SACL/DACL ACL

You must keep the following points in mind while using these endpoints:
* SLAG applies to all files and/or directories in a volume hence, inheritance is not required to be propagated.
* Set access_control field to slag while deleting SLAG ACE.
* Set access_control field to file_directory while deleting file-directory ACE. By Default access_control field is set to file_directory.
* For SLAG, valid apply_to combinations are "this-folder, sub-folders", "files", "this-folder, sub-folders, files".
### Required properties
* `access` - Specifies whether the ACE is for DACL or SACL.
* `user` - Name of the user to which the ACE applies.
### Related ONTAP commands
* `vserver security file-directory ntfs dacl remove`
* `vserver security file-directory ntfs sacl remove`
*/
func (a *Client) FileDirectorySecurityACLDelete(params *FileDirectorySecurityACLDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileDirectorySecurityACLDeleteOK, *FileDirectorySecurityACLDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFileDirectorySecurityACLDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "file_directory_security_acl_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/file-security/permissions/{svm.uuid}/{path}/acl/{user}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FileDirectorySecurityACLDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *FileDirectorySecurityACLDeleteOK:
		return value, nil, nil
	case *FileDirectorySecurityACLDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FileDirectorySecurityACLDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FileDirectorySecurityACLModify Updates the SACLs/DACLs

You must keep the following points in mind while using these endpoints:
* SLAG applies to all files and/or directories in a volume hence, inheritance is not required to be propagated.
* Set access_control field to slag while updating SLAG ACE.
* Set access_control field to file_directory while updating file-directory ACE. By Default access_control field is set to file_directory.
* For SLAG, valid apply_to combinations are "this-folder, sub-folders", "files", "this-folder, sub-folders, files".
### Required properties
* `access` - Specifies whether the ACE is for DACL or SACL.
* `user` - Name of the user to which the ACE applies.
### Related ONTAP commands
* `vserver security file-directory ntfs dacl modify`
* `vserver security file-directory ntfs sacl modify`
*/
func (a *Client) FileDirectorySecurityACLModify(params *FileDirectorySecurityACLModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileDirectorySecurityACLModifyOK, *FileDirectorySecurityACLModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFileDirectorySecurityACLModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "file_directory_security_acl_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/file-security/permissions/{svm.uuid}/{path}/acl/{user}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FileDirectorySecurityACLModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *FileDirectorySecurityACLModifyOK:
		return value, nil, nil
	case *FileDirectorySecurityACLModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FileDirectorySecurityACLModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FileDirectorySecurityCreate Applies an SD  to the given path.

You must keep the following points in mind while using these endpoints:
* Either SLAG ACL/s or file-directory ACL/s can be configured in one API call. Both cannot be configured in the same API call.
* SLAG applies to all files and/or directories in a volume hence, inheritance is not required to be propagated.
* Set access_control field to slag while configuring SLAG ACLs.
* Set access_control field to file_directory while configuring file-directory ACLs. By Default access_control field is set to file_directory.
* For SLAG, valid apply_to combinations are "this-folder, sub-folders", "files", "this-folder, sub-folders, files".
### Related ONTAP commands
* `vserver security file-directory ntfs create`
* `vserver security file-directory ntfs dacl add`
* `vserver security file-directory ntfs sacl add`
* `vserver security file-directory policy create`
* `vserver security file-directory policy task add`
* `vserver security file-directory apply`
*/
func (a *Client) FileDirectorySecurityCreate(params *FileDirectorySecurityCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileDirectorySecurityCreateCreated, *FileDirectorySecurityCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFileDirectorySecurityCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "file_directory_security_create",
		Method:             "POST",
		PathPattern:        "/protocols/file-security/permissions/{svm.uuid}/{path}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FileDirectorySecurityCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *FileDirectorySecurityCreateCreated:
		return value, nil, nil
	case *FileDirectorySecurityCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FileDirectorySecurityCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FileDirectorySecurityDelete Remove all SLAG ACLs for specified path. Bulk deletion is supported only for SLAG

You must keep the following points in mind while using these endpoints:
* Do not pass additional arguments that are not required.
### Related ONTAP Commands
* `vserver security file-directory remove-slag`
*/
func (a *Client) FileDirectorySecurityDelete(params *FileDirectorySecurityDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileDirectorySecurityDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFileDirectorySecurityDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "file_directory_security_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/file-security/permissions/{svm.uuid}/{path}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FileDirectorySecurityDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FileDirectorySecurityDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FileDirectorySecurityDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FileDirectorySecurityGet Retrieves file permissions.

### Related ONTAP commands
* `vserver security file-directory show`
*/
func (a *Client) FileDirectorySecurityGet(params *FileDirectorySecurityGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileDirectorySecurityGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFileDirectorySecurityGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "file_directory_security_get",
		Method:             "GET",
		PathPattern:        "/protocols/file-security/permissions/{svm.uuid}/{path}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FileDirectorySecurityGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FileDirectorySecurityGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FileDirectorySecurityGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FileDirectorySecurityModify Updates SD specific Information. For example, owner, group and control-flags. SD specific information of SLAG ACLs is not modifiable.

### Related ONTAP commands
* `vserver security file-directory ntfs modify`
*/
func (a *Client) FileDirectorySecurityModify(params *FileDirectorySecurityModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FileDirectorySecurityModifyOK, *FileDirectorySecurityModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFileDirectorySecurityModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "file_directory_security_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/file-security/permissions/{svm.uuid}/{path}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FileDirectorySecurityModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *FileDirectorySecurityModifyOK:
		return value, nil, nil
	case *FileDirectorySecurityModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FileDirectorySecurityModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyCollectionGet Retrieves an FPolicy configuration.

### Related ONTAP commands
* `fpolicy show`
* `fpolicy policy show`
* `fpolicy policy scope show`
* `fpolicy policy event show`
* `fpolicy policy external-engine show`
* `fpolicy persistent-store show`
### Learn more
* [`DOC /protocols/fpolicy`](#docs-NAS-protocols_fpolicy)
*/
func (a *Client) FpolicyCollectionGet(params *FpolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/fpolicy",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyConnectionCollectionGet Retrieves the statuses of FPolicy servers.

### Related ONTAP commands
* `vserver fpolicy show-engine`
* `vserver fpolicy show-passthrough-read-connection`
### Learn more
* [`DOC /protocols/fpolicy/{svm.uuid}/connections`](#docs-NAS-protocols_fpolicy_{svm.uuid}_connections)
*/
func (a *Client) FpolicyConnectionCollectionGet(params *FpolicyConnectionCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyConnectionCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyConnectionCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_connection_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/connections",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyConnectionCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyConnectionCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyConnectionCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyConnectionGet Retrieves the status of an FPolicy server.

### Related ONTAP commands
* `vserver fpolicy show-engine`
### Learn more
* [`DOC /protocols/fpolicy/{svm.uuid}/connections`](#docs-NAS-protocols_fpolicy_{svm.uuid}_connections)
*/
func (a *Client) FpolicyConnectionGet(params *FpolicyConnectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyConnectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyConnectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_connection_get",
		Method:             "GET",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/connections/{node.uuid}/{policy.name}/{server}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyConnectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyConnectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyConnectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyConnectionModify Updates the status of an FPolicy server.

### Related ONTAP commands
* `vserver fpolicy engine-connect`
* `vserver fpolicy engine-disconnect`
### Learn more
* [`DOC /protocols/fpolicy/{svm.uuid}/connections`](#docs-NAS-protocols_fpolicy_{svm.uuid}_connections)
*/
func (a *Client) FpolicyConnectionModify(params *FpolicyConnectionModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyConnectionModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyConnectionModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_connection_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/connections/{node.uuid}/{policy.name}/{server}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyConnectionModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyConnectionModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyConnectionModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FpolicyConnectionModifyCollection fpolicy connection modify collection API
*/
func (a *Client) FpolicyConnectionModifyCollection(params *FpolicyConnectionModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyConnectionModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyConnectionModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_connection_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/connections",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyConnectionModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyConnectionModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyConnectionModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyCreate Creates an FPolicy configuration.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the FPolicy configuration.
### Recommended optional properties
* `engines` -  External server to which the notifications will be sent.
* `events` - File operations to monitor.
* `policies` - Policy configuration which acts as a container for FPolicy event and FPolicy engine.
* `scope` - Scope of the policy. Can be limited to exports, volumes, shares or file extensions.
### Default property values
If not specified in POST, the following default property values are assigned:
* `engines.type` - _synchronous_
* `policies.engine` - _native_
* `policies.mandatory` -  _true_
* `events.volume_monitoring` - _false_
* `events.file_operations.*` - _false_
* `events.filters.*` - _false_
* `events.monitor_fileop_failure.*` - _false_
### Related ONTAP commands
* `fpolicy policy event create`
* `fpolicy policy external-engine create`
* `fpolicy policy create`
* `fpolicy policy scope create`
* `fpolicy enable`
* `fpolicy persistent-store create`
### Learn more
* [`DOC /protocols/fpolicy`](#docs-NAS-protocols_fpolicy)
*/
func (a *Client) FpolicyCreate(params *FpolicyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_create",
		Method:             "POST",
		PathPattern:        "/protocols/fpolicy",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyDelete Deletes the FPolicy configuration for the specified SVM. Before deleting the FPolicy configuration, ensure that all policies belonging to the SVM are disabled.

</br>Important notes:
The volume associated with the FPolicy Persistent Store is not automatically deleted from the FPolicy general endpoint. The associated volume can be removed manually.
### Related ONTAP commands
* `fpolicy delete`
* `fpolicy policy scope delete`
* `fpolicy policy delete`
* `fpolicy policy event delete`
* `fpolicy policy external-engine delete`
* `fpolicy persistent-store delete`
### Learn more
* [`DOC /protocols/fpolicy`](#docs-NAS-protocols_fpolicy)
*/
func (a *Client) FpolicyDelete(params *FpolicyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FpolicyDeleteCollection fpolicy delete collection API
*/
func (a *Client) FpolicyDeleteCollection(params *FpolicyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/fpolicy",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyEngineCollectionGet Retrieves FPolicy engine configurations of all the engines for a specified SVM. ONTAP allows creation of cluster-level FPolicy engines that act as a template for all the SVMs belonging to the cluster. These cluster-level FPolicy engines are also retrieved for the specified SVM.

### Related ONTAP commands
* `fpolicy policy external-engine show`
### Learn more
* [`DOC /protocols/fpolicy/{svm.uuid}/engines`](#docs-NAS-protocols_fpolicy_{svm.uuid}_engines)
*/
func (a *Client) FpolicyEngineCollectionGet(params *FpolicyEngineCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEngineCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyEngineCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_engine_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/engines",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyEngineCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyEngineCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyEngineCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyEngineCreate Creates an FPolicy engine configuration for a specified SVM. FPolicy engine creation is allowed only on data SVMs.

### Required properties
* `svm.uuid` - Existing SVM in which to create the FPolicy engine.
* `name` - Name of external engine.
* `port` - Port number of the FPolicy server application.
* `primary_servers` - List of primary FPolicy servers to which the node will send notifications.
### Recommended optional properties
* `secondary_servers` - It is recommended to configure secondary FPolicy server to which the node will send notifications when the primary server is down.
### Default property values
* `type` - _synchronous_
* `format` - _xml_
### Related ONTAP commands
* `fpolicy policy external-engine create`
### Learn more
* [`DOC /protocols/fpolicy/{svm.uuid}/engines`](#docs-NAS-protocols_fpolicy_{svm.uuid}_engines)
*/
func (a *Client) FpolicyEngineCreate(params *FpolicyEngineCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEngineCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyEngineCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_engine_create",
		Method:             "POST",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/engines",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyEngineCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyEngineCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyEngineCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyEngineDelete Deletes the FPolicy external engine configuration. Deletion of an FPolicy engine that is attached to one or more FPolicy policies is not allowed.

### Related ONTAP commands
* `fpolicy policy external-engine delete`
### Learn more
* [`DOC /protocols/fpolicy/{svm.uuid}/engines`](#docs-NAS-protocols_fpolicy_{svm.uuid}_engines)
*/
func (a *Client) FpolicyEngineDelete(params *FpolicyEngineDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEngineDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyEngineDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_engine_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/engines/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyEngineDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyEngineDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyEngineDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FpolicyEngineDeleteCollection fpolicy engine delete collection API
*/
func (a *Client) FpolicyEngineDeleteCollection(params *FpolicyEngineDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEngineDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyEngineDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_engine_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/engines",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyEngineDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyEngineDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyEngineDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyEngineGet Retrieves a particular FPolicy engine configuration of a specified SVM. A cluster-level FPolicy engine configuration cannot be retrieved for a data SVM.

### Related ONTAP commands
* `fpolicy policy external-engine show`
### Learn more
* [`DOC /protocols/fpolicy/{svm.uuid}/engines`](#docs-NAS-protocols_fpolicy_{svm.uuid}_engines)
*/
func (a *Client) FpolicyEngineGet(params *FpolicyEngineGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEngineGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyEngineGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_engine_get",
		Method:             "GET",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/engines/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyEngineGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyEngineGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyEngineGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyEngineModify Updates a specific FPolicy engine configuration of an SVM. Modification of an FPolicy engine that is attached to one or more enabled FPolicy policies is not allowed.

### Related ONTAP commands
* `fpolicy policy external-engine modify`
### Learn more
* [`DOC /protocols/fpolicy/{svm.uuid}/engines`](#docs-NAS-protocols_fpolicy_{svm.uuid}_engines)
*/
func (a *Client) FpolicyEngineModify(params *FpolicyEngineModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEngineModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyEngineModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_engine_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/engines/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyEngineModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyEngineModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyEngineModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FpolicyEngineModifyCollection fpolicy engine modify collection API
*/
func (a *Client) FpolicyEngineModifyCollection(params *FpolicyEngineModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEngineModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyEngineModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_engine_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/engines",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyEngineModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyEngineModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyEngineModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyEventCollectionGet Retrieves FPolicy event configurations for all events for a specified SVM. ONTAP allows the creation of cluster-level FPolicy events that act as a template for all the data SVMs belonging to the cluster. These cluster-level FPolicy events are also retrieved for the specified SVM.

### Related ONTAP commands
* `fpolicy policy event show`
### Learn more
* [`DOC /protocols/fpolicy/{svm.uuid}/events`](#docs-NAS-protocols_fpolicy_{svm.uuid}_events)
*/
func (a *Client) FpolicyEventCollectionGet(params *FpolicyEventCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEventCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyEventCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_event_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/events",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyEventCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyEventCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyEventCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyEventCreate Creates an FPolicy event configuration for a specified SVM. FPolicy event creation is allowed only on data SVMs. When a protocol is specified, you must specify a file operation or a file operation and filters. When FPolicy event is configured to monitor failed file operations, you must specify protocol and file operations. Filters are not supported when failed file operations are monitored.

### Required properties
* `svm.uuid` - Existing SVM in which to create the FPolicy event.
* `name` - Name of the FPolicy event.
### Recommended optional properties
* `file-operations` - List of file operations to monitor.
* `protocol` - Protocol for which the file operations should be monitored.
* `filters` - List of filters for the specified file operations.
* `monitor-fileop-failure` - Enabled monitoring of failed file operations.
### Default property values
If not specified in POST, the following default property values are assigned:
* `file_operations.*` - _false_
* `filters.*` - _false_
* `volume-monitoring` - _false_
* `monitor-fileop-failure` - _false_
### Related ONTAP commands
* `fpolicy policy event create`
### Learn more
* [`DOC /protocols/fpolicy/{svm.uuid}/events`](#docs-NAS-protocols_fpolicy_{svm.uuid}_events)
*/
func (a *Client) FpolicyEventCreate(params *FpolicyEventCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEventCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyEventCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_event_create",
		Method:             "POST",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/events",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyEventCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyEventCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyEventCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyEventDelete Deletes a specific FPolicy event configuration for an SVM. A cluster-level FPolicy event configuration cannot be modified for a data SVM through REST. An FPolicy event that is attached to an FPolicy policy cannot be deleted.

### Related ONTAP commands
* `fpolicy policy event delete`
### Learn more
* [`DOC /protocols/fpolicy/{svm.uuid}/events`](#docs-NAS-protocols_fpolicy_{svm.uuid}_events)
*/
func (a *Client) FpolicyEventDelete(params *FpolicyEventDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEventDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyEventDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_event_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/events/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyEventDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyEventDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyEventDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FpolicyEventDeleteCollection fpolicy event delete collection API
*/
func (a *Client) FpolicyEventDeleteCollection(params *FpolicyEventDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEventDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyEventDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_event_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/events",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyEventDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyEventDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyEventDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyEventModify Updates a specific FPolicy event configuration for an SVM. A cluster-level FPolicy event configuration cannot be modified for a data SVM through REST. When the file operations and filters fields are modified, the previous values are retained and new values are added to the list of previous values. To remove a particular file operation or filter, set its value to false in the request.

### Related ONTAP commands
* `fpolicy policy event modify`
### Learn more
* [`DOC /protocols/fpolicy/{svm.uuid}/events`](#docs-NAS-protocols_fpolicy_{svm.uuid}_events)
*/
func (a *Client) FpolicyEventModify(params *FpolicyEventModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEventModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyEventModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_event_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/events/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyEventModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyEventModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyEventModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FpolicyEventModifyCollection fpolicy event modify collection API
*/
func (a *Client) FpolicyEventModifyCollection(params *FpolicyEventModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEventModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyEventModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_event_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/events",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyEventModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyEventModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyEventModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyEventsGet Retrieves a specific FPolicy event configuration for an SVM. A cluster-level FPolicy event configuration cannot be retrieved for a data SVM through a REST API.

### Related ONTAP commands
* `fpolicy policy event show`
### Learn more
* [`DOC /protocols/fpolicy/{svm.uuid}/events`](#docs-NAS-protocols_fpolicy_{svm.uuid}_events)
*/
func (a *Client) FpolicyEventsGet(params *FpolicyEventsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyEventsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyEventsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_events_get",
		Method:             "GET",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/events/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyEventsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyEventsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyEventsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyGet Retrieves an FPolicy configuration of an SVM.

### Related ONTAP commands
* `fpolicy show`
* `fpolicy policy show`
* `fpolicy policy scope show`
* `fpolicy policy event show`
* `fpolicy policy external-engine show`
* `fpolicy persistent-store show`
### Learn more
* [`DOC /protocols/fpolicy`](#docs-NAS-protocols_fpolicy)
*/
func (a *Client) FpolicyGet(params *FpolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_get",
		Method:             "GET",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyPersistentStoreCollectionGet Retrieves FPolicy Persistent Store configurations for a specified SVM.

### Related ONTAP commands
* `fpolicy persistent-store show`
### Learn more
* [`DOC /protocols/fpolicy/{svm.uuid}/persistent-stores`](#docs-NAS-protocols_fpolicy_{svm.uuid}_persistent-stores)
*/
func (a *Client) FpolicyPersistentStoreCollectionGet(params *FpolicyPersistentStoreCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPersistentStoreCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyPersistentStoreCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_persistent_store_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/persistent-stores",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyPersistentStoreCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyPersistentStoreCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyPersistentStoreCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyPersistentStoreCreate Creates an FPolicy Persistent Store configuration for a specified SVM.

</br>Important notes:
* FPolicy Persistent Store creation is allowed only on data SVMs.
* In persistent mode, when the Persistent Store is full, event notifications are dropped.
* There is flexibility to provide an existing volume or create a new volume for the persistent storage. The creation of new volume is handled internally.
* For existing volumes, the snapshot policy is set to 'none' and the size is adjusted to the specified value.
### Required properties
* `svm.uuid` - Existing SVM in which to create the FPolicy Persistent Store.
* `name` - Name of the FPolicy Persistent Store.
* `volume` - Volume specified for Persistent Store (only FlexVol volumes of type RW are supported).
### Optional properties
* `size` - Size of the Persistent Store volume.
* `autosize-mode` - Autosize mode for the Persistent Store volume.
### Related ONTAP commands
* `fpolicy persistent-store create`
### Learn more
* [`DOC /protocols/fpolicy/{svm.uuid}/persistent-stores`](#docs-NAS-protocols_fpolicy_{svm.uuid}_persistent-stores)
*/
func (a *Client) FpolicyPersistentStoreCreate(params *FpolicyPersistentStoreCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPersistentStoreCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyPersistentStoreCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_persistent_store_create",
		Method:             "POST",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/persistent-stores",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyPersistentStoreCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyPersistentStoreCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyPersistentStoreCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyPersistentStoreDelete Deletes a specific FPolicy Persistent Store configuration for an SVM.

</br>Important notes:
An option has been provided to delete the associated volume.
### Related ONTAP commands
* `fpolicy persistent-store delete`
### Learn more
* [`DOC /protocols/fpolicy/{svm.uuid}/persistent-stores`](#docs-NAS-protocols_fpolicy_{svm.uuid}_persistent-stores)
*/
func (a *Client) FpolicyPersistentStoreDelete(params *FpolicyPersistentStoreDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPersistentStoreDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyPersistentStoreDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_persistent_store_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/persistent-stores/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyPersistentStoreDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyPersistentStoreDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyPersistentStoreDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FpolicyPersistentStoreDeleteCollection fpolicy persistent store delete collection API
*/
func (a *Client) FpolicyPersistentStoreDeleteCollection(params *FpolicyPersistentStoreDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPersistentStoreDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyPersistentStoreDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_persistent_store_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/persistent-stores",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyPersistentStoreDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyPersistentStoreDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyPersistentStoreDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyPersistentStoreGet Retrieves a specific FPolicy Persistent Store configuration for an SVM.

### Related ONTAP commands
* `fpolicy persistent-store show`
### Learn more
* [`DOC /protocols/fpolicy/{svm.uuid}/persistent-stores`](#docs-NAS-protocols_fpolicy_{svm.uuid}_persistent-stores)
*/
func (a *Client) FpolicyPersistentStoreGet(params *FpolicyPersistentStoreGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPersistentStoreGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyPersistentStoreGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_persistent_store_get",
		Method:             "GET",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/persistent-stores/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyPersistentStoreGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyPersistentStoreGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyPersistentStoreGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyPersistentStoreModify Updates a specific FPolicy Persistent Store configuration for an SVM.

</br>Important notes:
* If the volume exists, it is set to the size specified and the snapshot policy is set to "none". Otherwise, a new volume is created.
* The autosize parameter is not available in PATCH operations for this endpoint, use the the "autosize" parameter in PATCH for the "/storage/volumes/{uuid}" endpoint instead.
* When the Persistent Store is updated with a new volume, the previous volume is not automatically deleted. An option is provided to delete the previous volume.
### Related ONTAP commands
* `fpolicy persistent-store modify`
### Learn more
* [`DOC /protocols/fpolicy/{svm.uuid}/persistent-stores`](#docs-NAS-protocols_fpolicy_{svm.uuid}_persistent-stores)
*/
func (a *Client) FpolicyPersistentStoreModify(params *FpolicyPersistentStoreModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPersistentStoreModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyPersistentStoreModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_persistent_store_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/persistent-stores/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyPersistentStoreModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyPersistentStoreModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyPersistentStoreModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FpolicyPersistentStoreModifyCollection fpolicy persistent store modify collection API
*/
func (a *Client) FpolicyPersistentStoreModifyCollection(params *FpolicyPersistentStoreModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPersistentStoreModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyPersistentStoreModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_persistent_store_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/persistent-stores",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyPersistentStoreModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyPersistentStoreModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyPersistentStoreModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyPolicyCollectionGet Retrieves the FPolicy policy configuration of an SVM. ONTAP allows the creation of a cluster level FPolicy policy that acts as a template for all the data SVMs belonging to the cluster. This cluster level FPolicy policy is also retrieved for the specified SVM.

### Related ONTAP commands
* `fpolicy policy show`
* `fpolicy policy scope show`
### Learn more
* [`DOC /protocols/fpolicy/{svm.uuid}/policies`](#docs-NAS-protocols_fpolicy_{svm.uuid}_policies)
*/
func (a *Client) FpolicyPolicyCollectionGet(params *FpolicyPolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPolicyCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyPolicyCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_policy_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyPolicyCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyPolicyCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyPolicyCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyPolicyCreate Creates an FPolicy policy configuration for the specified SVM. To create an FPolicy policy, you must specify the policy scope and the FPolicy events to be monitored.

</br>Important notes:
* A single policy can monitor multiple events.
* An FPolicy engine is an optional field whose default value is set to native. A native engine can be used to simply block the file access based on the file extensions specified in the policy scope.
* To enable a policy, the policy priority  must be specified. If the priority is not specified, the policy is created but it is not enabled.
* The "mandatory" field, if set to true, blocks the file access when the primary or secondary FPolicy servers are down.
### Required properties
* `svm.uuid` - Existing SVM in which to create the FPolicy policy.
* `events` - Name of the events to monitor.
* `name` - Name of the FPolicy policy.
* `scope` - Scope of the policy. Can be limited to exports, volumes, shares or file extensions.
* `priority`- Priority of the policy (ranging from 1 to 10).
### Default property values
* `mandatory` - _true_
* `engine` - _native_
### Related ONTAP commands
* `fpolicy policy scope create`
* `fpolicy policy create`
* `fpolicy enable`
### Learn more
* [`DOC /protocols/fpolicy/{svm.uuid}/policies`](#docs-NAS-protocols_fpolicy_{svm.uuid}_policies)
*/
func (a *Client) FpolicyPolicyCreate(params *FpolicyPolicyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPolicyCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyPolicyCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_policy_create",
		Method:             "POST",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyPolicyCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyPolicyCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyPolicyCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyPolicyDelete Deletes a particular FPolicy policy configuration for a specified SVM. To delete a policy, you must first disable the policy.

### Related ONTAP commands
* `fpolicy policy scope delete`
* `fpolicy policy delete`
### Learn more
* [`DOC /protocols/fpolicy/{svm.uuid}/policies`](#docs-NAS-protocols_fpolicy_{svm.uuid}_policies)
*/
func (a *Client) FpolicyPolicyDelete(params *FpolicyPolicyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPolicyDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyPolicyDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_policy_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/policies/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyPolicyDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyPolicyDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyPolicyDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FpolicyPolicyDeleteCollection fpolicy policy delete collection API
*/
func (a *Client) FpolicyPolicyDeleteCollection(params *FpolicyPolicyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPolicyDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyPolicyDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_policy_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyPolicyDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyPolicyDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyPolicyDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyPolicyGet Retrieves a particular FPolicy policy configuration for a specified SVM. Cluster-level FPolicy policy configuration details cannot be retrieved for a data SVM.

### Related ONTAP commands
* `fpolicy policy show`
* `fpolicy policy scope show`
* `fpolicy show`
### Learn more
* [`DOC /protocols/fpolicy/{svm.uuid}/policies`](#docs-NAS-protocols_fpolicy_{svm.uuid}_policies)
*/
func (a *Client) FpolicyPolicyGet(params *FpolicyPolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPolicyGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyPolicyGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_policy_get",
		Method:             "GET",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/policies/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyPolicyGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyPolicyGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyPolicyGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FpolicyPolicyModify Updates a particular FPolicy policy configuration for a specified SVM. PATCH can be used to enable or disable the policy. When enabling a policy, you must specify the policy priority. The policy priority of the policy is not required when disabling the policy. If the policy is enabled, the FPolicy policy cannot be modified.

### Related ONTAP commands
* `fpolicy policy modify`
* `fpolicy policy scope modify`
* `fpolicy enable`
* `fpolicy disable`
### Learn more
* [`DOC /protocols/fpolicy/{svm.uuid}/policies`](#docs-NAS-protocols_fpolicy_{svm.uuid}_policies)
*/
func (a *Client) FpolicyPolicyModify(params *FpolicyPolicyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPolicyModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyPolicyModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_policy_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/policies/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyPolicyModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyPolicyModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyPolicyModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FpolicyPolicyModifyCollection fpolicy policy modify collection API
*/
func (a *Client) FpolicyPolicyModifyCollection(params *FpolicyPolicyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FpolicyPolicyModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFpolicyPolicyModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fpolicy_policy_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/fpolicy/{svm.uuid}/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FpolicyPolicyModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FpolicyPolicyModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FpolicyPolicyModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GroupPoliciesToBeAppliedModify Creates a background task to update the GPO settings for the specified SVM.

Note: The group policy can be enabled or disabled using "group_policy_object_enabled" field in PATCH "/protocols/cifs/services/{svm.uuid}" API.
### Related ONTAP commands
* `vserver cifs group-policy update`
*/
func (a *Client) GroupPoliciesToBeAppliedModify(params *GroupPoliciesToBeAppliedModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupPoliciesToBeAppliedModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupPoliciesToBeAppliedModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "group_policies_to_be_applied_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/group-policies/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GroupPoliciesToBeAppliedModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupPoliciesToBeAppliedModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupPoliciesToBeAppliedModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GroupPoliciesToBeAppliedModifyCollection group policies to be applied modify collection API
*/
func (a *Client) GroupPoliciesToBeAppliedModifyCollection(params *GroupPoliciesToBeAppliedModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupPoliciesToBeAppliedModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupPoliciesToBeAppliedModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "group_policies_to_be_applied_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/group-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GroupPoliciesToBeAppliedModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupPoliciesToBeAppliedModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupPoliciesToBeAppliedModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GroupPolicyObjectCentralAccessPolicyCollectionGet Retrieves applied central access policies for specified SVM.

### Related ONTAP commands
* `vserver cifs group-policy central-access-policy show-applied`
*/
func (a *Client) GroupPolicyObjectCentralAccessPolicyCollectionGet(params *GroupPolicyObjectCentralAccessPolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupPolicyObjectCentralAccessPolicyCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupPolicyObjectCentralAccessPolicyCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "group_policy_object_central_access_policy_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/group-policies/{svm.uuid}/central-access-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GroupPolicyObjectCentralAccessPolicyCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupPolicyObjectCentralAccessPolicyCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupPolicyObjectCentralAccessPolicyCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GroupPolicyObjectCentralAccessPolicyGet Retrieves applied central access policy for specified SVM.

### Related ONTAP commands
* `vserver cifs group-policy central-access-policy show-applied`
*/
func (a *Client) GroupPolicyObjectCentralAccessPolicyGet(params *GroupPolicyObjectCentralAccessPolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupPolicyObjectCentralAccessPolicyGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupPolicyObjectCentralAccessPolicyGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "group_policy_object_central_access_policy_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/group-policies/{svm.uuid}/central-access-policies/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GroupPolicyObjectCentralAccessPolicyGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupPolicyObjectCentralAccessPolicyGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupPolicyObjectCentralAccessPolicyGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GroupPolicyObjectCentralAccessRuleCollectionGet Retrieves applied central access rules for specified SVM.

### Related ONTAP commands
* `vserver cifs group-policy central-access-rule show-applied`
*/
func (a *Client) GroupPolicyObjectCentralAccessRuleCollectionGet(params *GroupPolicyObjectCentralAccessRuleCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupPolicyObjectCentralAccessRuleCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupPolicyObjectCentralAccessRuleCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "group_policy_object_central_access_rule_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/group-policies/{svm.uuid}/central-access-rules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GroupPolicyObjectCentralAccessRuleCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupPolicyObjectCentralAccessRuleCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupPolicyObjectCentralAccessRuleCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GroupPolicyObjectCentralAccessRuleGet Retrieves applied central access rule for specified SVM.

### Related ONTAP commands
* `vserver cifs group-policy central-access-rule show-applied`
*/
func (a *Client) GroupPolicyObjectCentralAccessRuleGet(params *GroupPolicyObjectCentralAccessRuleGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupPolicyObjectCentralAccessRuleGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupPolicyObjectCentralAccessRuleGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "group_policy_object_central_access_rule_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/group-policies/{svm.uuid}/central-access-rules/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GroupPolicyObjectCentralAccessRuleGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupPolicyObjectCentralAccessRuleGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupPolicyObjectCentralAccessRuleGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GroupPolicyObjectCollectionGet Retrieves applied group policy objects for specified SVM.

### Related ONTAP commands
* `vserver cifs group-policy show-applied`
*/
func (a *Client) GroupPolicyObjectCollectionGet(params *GroupPolicyObjectCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupPolicyObjectCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupPolicyObjectCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "group_policy_object_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/group-policies/{svm.uuid}/objects",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GroupPolicyObjectCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupPolicyObjectCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupPolicyObjectCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GroupPolicyObjectGet Retrieves applied group policy object for specified SVM.

### Related ONTAP commands
* `vserver cifs group-policy show-applied`
*/
func (a *Client) GroupPolicyObjectGet(params *GroupPolicyObjectGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupPolicyObjectGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupPolicyObjectGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "group_policy_object_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/group-policies/{svm.uuid}/objects/{index}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GroupPolicyObjectGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupPolicyObjectGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupPolicyObjectGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GroupPolicyObjectRestrictedGroupCollectionGet Retrieves applied policies of restricted groups for specified SVM.

### Related ONTAP commands
* `vserver cifs group-policy restricted-group show-applied`
*/
func (a *Client) GroupPolicyObjectRestrictedGroupCollectionGet(params *GroupPolicyObjectRestrictedGroupCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupPolicyObjectRestrictedGroupCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupPolicyObjectRestrictedGroupCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "group_policy_object_restricted_group_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/group-policies/{svm.uuid}/restricted-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GroupPolicyObjectRestrictedGroupCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupPolicyObjectRestrictedGroupCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupPolicyObjectRestrictedGroupCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GroupPolicyObjectRestrictedGroupGet Retrieves applied policy of restricted group for specified SVM.

### Related ONTAP commands
* `vserver cifs group-policy restricted-group show-applied`
*/
func (a *Client) GroupPolicyObjectRestrictedGroupGet(params *GroupPolicyObjectRestrictedGroupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupPolicyObjectRestrictedGroupGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupPolicyObjectRestrictedGroupGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "group_policy_object_restricted_group_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/group-policies/{svm.uuid}/restricted-groups/{policy_index}/{group_name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GroupPolicyObjectRestrictedGroupGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupPolicyObjectRestrictedGroupGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupPolicyObjectRestrictedGroupGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	KerberosInterfaceCollectionGet Retrieves Kerberos interfaces.

### Related ONTAP commands
* `vserver nfs kerberos interface show`
### Learn more
* [`DOC /protocols/nfs/kerberos/interfaces`](#docs-NAS-protocols_nfs_kerberos_interfaces)
*/
func (a *Client) KerberosInterfaceCollectionGet(params *KerberosInterfaceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KerberosInterfaceCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewKerberosInterfaceCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "kerberos_interface_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/nfs/kerberos/interfaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &KerberosInterfaceCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*KerberosInterfaceCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*KerberosInterfaceCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	KerberosInterfaceGet Retrieves a Kerberos interface.

### Related ONTAP commands
* `vserver nfs kerberos interface show`
### Learn more
* [`DOC /protocols/nfs/kerberos/interfaces`](#docs-NAS-protocols_nfs_kerberos_interfaces)
*/
func (a *Client) KerberosInterfaceGet(params *KerberosInterfaceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KerberosInterfaceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewKerberosInterfaceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "kerberos_interface_get",
		Method:             "GET",
		PathPattern:        "/protocols/nfs/kerberos/interfaces/{interface.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &KerberosInterfaceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*KerberosInterfaceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*KerberosInterfaceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	KerberosInterfaceModify Updates the properties of a Kerberos interface.

### Optional property
* `force` - Specifies whether the server should ignore any error encountered while deleting the corresponding machine account on the KDC and also disables Kerberos on the LIF. This is applicable only when disabling Kerberos.
### Related ONTAP commands
* `vserver nfs kerberos interface modify`
* `vserver nfs kerberos interface enable`
* `vserver nfs kerberos interface disable`
### Learn more
* [`DOC /protocols/nfs/kerberos/interfaces`](#docs-NAS-protocols_nfs_kerberos_interfaces)
*/
func (a *Client) KerberosInterfaceModify(params *KerberosInterfaceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KerberosInterfaceModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewKerberosInterfaceModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "kerberos_interface_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/nfs/kerberos/interfaces/{interface.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &KerberosInterfaceModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*KerberosInterfaceModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*KerberosInterfaceModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
KerberosInterfaceModifyCollection kerberos interface modify collection API
*/
func (a *Client) KerberosInterfaceModifyCollection(params *KerberosInterfaceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KerberosInterfaceModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewKerberosInterfaceModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "kerberos_interface_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/nfs/kerberos/interfaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &KerberosInterfaceModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*KerberosInterfaceModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*KerberosInterfaceModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	KerberosRealmCollectionGet Retrieves Kerberos realms.

### Related ONTAP commands
* `vserver nfs kerberos realm show`
### Learn more
* [`DOC /protocols/nfs/kerberos/realms`](#docs-NAS-protocols_nfs_kerberos_realms)
*/
func (a *Client) KerberosRealmCollectionGet(params *KerberosRealmCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KerberosRealmCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewKerberosRealmCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "kerberos_realm_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/nfs/kerberos/realms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &KerberosRealmCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*KerberosRealmCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*KerberosRealmCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	KerberosRealmCreate Creates a Kerberos realm.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM on which to create the Kerberos realm.
* `name` - Base name for the Kerberos realm.
* `kdc.vendor` - Vendor of the Key Distribution Center (KDC) server for this Kerberos realm. If the configuration uses a Microsoft Active Directory domain for authentication, this field must be `microsoft`.
* `kdc.ip` - IP address of the KDC server for this Kerberos realm.
### Recommended optional properties
* `ad_server.name` - Host name of the Active Directory Domain Controller (DC). This is a mandatory parameter if the kdc-vendor is `microsoft`.
* `ad_server.address` - IP address of the Active Directory Domain Controller (DC). This is a mandatory parameter if the kdc-vendor is `microsoft`.
### Default property values
If not specified in POST, the following default property value is assigned:
* `kdc.port` - _88_
* `admin_server.port` - _749_
* `password_server.port` - _464_
* `clock_skew` - _5_
### Related ONTAP commands
* `vserver nfs kerberos realm create`
### Learn more
* [`DOC /protocols/nfs/kerberos/realms`](#docs-NAS-protocols_nfs_kerberos_realms)
*/
func (a *Client) KerberosRealmCreate(params *KerberosRealmCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KerberosRealmCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewKerberosRealmCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "kerberos_realm_create",
		Method:             "POST",
		PathPattern:        "/protocols/nfs/kerberos/realms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &KerberosRealmCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*KerberosRealmCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*KerberosRealmCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	KerberosRealmDelete Deletes a Kerberos realm.

* `vserver nfs kerberos realm delete`
### Learn more
* [`DOC /protocols/nfs/kerberos/realms`](#docs-NAS-protocols_nfs_kerberos_realms)
*/
func (a *Client) KerberosRealmDelete(params *KerberosRealmDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KerberosRealmDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewKerberosRealmDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "kerberos_realm_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/nfs/kerberos/realms/{svm.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &KerberosRealmDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*KerberosRealmDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*KerberosRealmDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
KerberosRealmDeleteCollection kerberos realm delete collection API
*/
func (a *Client) KerberosRealmDeleteCollection(params *KerberosRealmDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KerberosRealmDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewKerberosRealmDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "kerberos_realm_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/nfs/kerberos/realms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &KerberosRealmDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*KerberosRealmDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*KerberosRealmDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	KerberosRealmGet Retrieves a Kerberos realm.

* `vserver nfs kerberos realm show`
### Learn more
* [`DOC /protocols/nfs/kerberos/realms`](#docs-NAS-protocols_nfs_kerberos_realms)
*/
func (a *Client) KerberosRealmGet(params *KerberosRealmGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KerberosRealmGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewKerberosRealmGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "kerberos_realm_get",
		Method:             "GET",
		PathPattern:        "/protocols/nfs/kerberos/realms/{svm.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &KerberosRealmGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*KerberosRealmGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*KerberosRealmGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	KerberosRealmModify Updates the properties of a Kerberos realm.

* `vserver nfs kerberos realm modify`
### Learn more
* [`DOC /protocols/nfs/kerberos/realms`](#docs-NAS-protocols_nfs_kerberos_realms)
*/
func (a *Client) KerberosRealmModify(params *KerberosRealmModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KerberosRealmModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewKerberosRealmModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "kerberos_realm_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/nfs/kerberos/realms/{svm.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &KerberosRealmModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*KerberosRealmModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*KerberosRealmModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
KerberosRealmModifyCollection kerberos realm modify collection API
*/
func (a *Client) KerberosRealmModifyCollection(params *KerberosRealmModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KerberosRealmModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewKerberosRealmModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "kerberos_realm_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/nfs/kerberos/realms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &KerberosRealmModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*KerberosRealmModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*KerberosRealmModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LocalCifsGroupCollectionGet Retrieves the local groups for all of the SVMs.

### Advanced properties
* `members`
### Related ONTAP commands
* `vserver cifs users-and-groups local-group show`
* `vserver cifs users-and-groups local-group show-members`
### Learn more
* [`DOC /protocols/cifs/local-groups`](#docs-NAS-protocols_cifs_local-groups)
*/
func (a *Client) LocalCifsGroupCollectionGet(params *LocalCifsGroupCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalCifsGroupCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_cifs_group_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/local-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalCifsGroupCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalCifsGroupCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalCifsGroupCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LocalCifsGroupCreate Creates the local group configuration for the specified SVM.

### Important notes
* The group name can contain up to 256 characters.
* The group name cannot be terminated by a period.
* The group name does not support any of the following characters: \" / ? [ ] , : | < > + = ; ? * @ or ASCII characters in the range 1-31.
### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the local group.
* `name` - Name of the local group.
### Related ONTAP commands
* `vserver cifs users-and-groups local-group create`
### Learn more
* [`DOC /protocols/cifs/local-groups`](#docs-NAS-protocols_cifs_local-groups)
*/
func (a *Client) LocalCifsGroupCreate(params *LocalCifsGroupCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalCifsGroupCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_cifs_group_create",
		Method:             "POST",
		PathPattern:        "/protocols/cifs/local-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalCifsGroupCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalCifsGroupCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalCifsGroupCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LocalCifsGroupDelete Deletes a local group configuration for the specified SVM.

### Related ONTAP commands
* `vserver cifs users-and-groups local-group delete`
### Learn more
* [`DOC /protocols/cifs/local-groups`](#docs-NAS-protocols_cifs_local-groups)
*/
func (a *Client) LocalCifsGroupDelete(params *LocalCifsGroupDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalCifsGroupDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_cifs_group_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/cifs/local-groups/{svm.uuid}/{sid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalCifsGroupDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalCifsGroupDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalCifsGroupDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LocalCifsGroupDeleteCollection local cifs group delete collection API
*/
func (a *Client) LocalCifsGroupDeleteCollection(params *LocalCifsGroupDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalCifsGroupDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_cifs_group_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/cifs/local-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalCifsGroupDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalCifsGroupDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalCifsGroupDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LocalCifsGroupGet Retrieves local group information for the specified group and SVM.

### Advanced properties
* `members`
### Related ONTAP commands
* `vserver cifs users-and-groups local-group show`
* `vserver cifs users-and-groups local-group show-members`
### Learn more
* [`DOC /protocols/cifs/local-groups`](#docs-NAS-protocols_cifs_local-groups)
*/
func (a *Client) LocalCifsGroupGet(params *LocalCifsGroupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalCifsGroupGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_cifs_group_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/local-groups/{svm.uuid}/{sid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalCifsGroupGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalCifsGroupGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalCifsGroupGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LocalCifsGroupMembersBulkDelete Deletes the local users, Active Directory users and/or Active Directory groups from the specified local group and SVM.

### Related ONTAP commands
* `vserver cifs users-and-groups local-group remove-members`
### Learn more
* [`DOC /protocols/cifs/local-groups/{svm.uuid}/{local_cifs_group.sid}/members`](#docs-NAS-protocols_cifs_local-groups_{svm.uuid}_{local_cifs_group.sid}_members)
*/
func (a *Client) LocalCifsGroupMembersBulkDelete(params *LocalCifsGroupMembersBulkDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupMembersBulkDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalCifsGroupMembersBulkDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_cifs_group_members_bulk_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/cifs/local-groups/{svm.uuid}/{local_cifs_group.sid}/members",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalCifsGroupMembersBulkDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalCifsGroupMembersBulkDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalCifsGroupMembersBulkDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LocalCifsGroupMembersCollectionGet Retrieves local users, Active Directory users and Active Directory groups which are members of the specified local group and SVM.

### Related ONTAP commands
* `vserver cifs users-and-groups local-group show-members`
### Learn more
* [`DOC /protocols/cifs/local-groups/{svm.uuid}/{local_cifs_group.sid}/members`](#docs-NAS-protocols_cifs_local-groups_{svm.uuid}_{local_cifs_group.sid}_members)
*/
func (a *Client) LocalCifsGroupMembersCollectionGet(params *LocalCifsGroupMembersCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupMembersCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalCifsGroupMembersCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_cifs_group_members_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/local-groups/{svm.uuid}/{local_cifs_group.sid}/members",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalCifsGroupMembersCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalCifsGroupMembersCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalCifsGroupMembersCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LocalCifsGroupMembersCreate Adds local users, Active Directory users and Active Directory groups to the specified local group and SVM.

### Important note
* Specified members are appended to the existing list of members.
### Required properties
* `svm.uuid` or `svm.name` - Existing SVM for which members are added to local group.
* `local_cifs_group.sid` -  Security ID of the local group to which members are added.
* `name` or `records` - Local users, Active Directory users, or Active Directory groups to be added to a particular local group.
### Related ONTAP commands
* `vserver cifs users-and-groups local-group add-members`
### Learn more
* [`DOC /protocols/cifs/local-groups/{svm.uuid}/{local_cifs_group.sid}/members`](#docs-NAS-protocols_cifs_local-groups_{svm.uuid}_{local_cifs_group.sid}_members)
*/
func (a *Client) LocalCifsGroupMembersCreate(params *LocalCifsGroupMembersCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupMembersCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalCifsGroupMembersCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_cifs_group_members_create",
		Method:             "POST",
		PathPattern:        "/protocols/cifs/local-groups/{svm.uuid}/{local_cifs_group.sid}/members",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalCifsGroupMembersCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalCifsGroupMembersCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalCifsGroupMembersCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LocalCifsGroupMembersDelete Deletes the local user, Active Directory user and/or Active Directory group from the specified local group and SVM.

### Related ONTAP commands
* `vserver cifs users-and-groups local-group remove-members`
### Learn more
* [`DOC /protocols/cifs/local-groups/{svm.uuid}/{local_cifs_group.sid}/members`](#docs-NAS-protocols_cifs_local-groups_{svm.uuid}_{local_cifs_group.sid}_members)
*/
func (a *Client) LocalCifsGroupMembersDelete(params *LocalCifsGroupMembersDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupMembersDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalCifsGroupMembersDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_cifs_group_members_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/cifs/local-groups/{svm.uuid}/{local_cifs_group.sid}/members/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalCifsGroupMembersDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalCifsGroupMembersDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalCifsGroupMembersDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LocalCifsGroupMembersGet Retrieves local user, Active Directory user and Active Directory group which is member of the specified local group and SVM.

### Related ONTAP commands
* `vserver cifs users-and-groups local-group show-members`
### Learn more
* [`DOC /protocols/cifs/local-groups/{svm.uuid}/{local_cifs_group.sid}/members`](#docs-NAS-protocols_cifs_local-groups_{svm.uuid}_{local_cifs_group.sid}_members)
*/
func (a *Client) LocalCifsGroupMembersGet(params *LocalCifsGroupMembersGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupMembersGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalCifsGroupMembersGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_cifs_group_members_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/local-groups/{svm.uuid}/{local_cifs_group.sid}/members/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalCifsGroupMembersGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalCifsGroupMembersGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalCifsGroupMembersGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LocalCifsGroupModify Updates the local group information of the specified group in the specified SVM. This API can also be used to rename a local group.

### Related ONTAP commands
* `vserver cifs users-and-groups local-group modify`
* `vserver cifs users-and-groups local-group rename`
### Learn more
* [`DOC /protocols/cifs/local-groups`](#docs-NAS-protocols_cifs_local-groups)
*/
func (a *Client) LocalCifsGroupModify(params *LocalCifsGroupModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalCifsGroupModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_cifs_group_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/local-groups/{svm.uuid}/{sid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalCifsGroupModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalCifsGroupModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalCifsGroupModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LocalCifsGroupModifyCollection local cifs group modify collection API
*/
func (a *Client) LocalCifsGroupModifyCollection(params *LocalCifsGroupModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsGroupModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalCifsGroupModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_cifs_group_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/local-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalCifsGroupModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalCifsGroupModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalCifsGroupModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LocalCifsUserCollectionGet Retrieves local users for all of the SVMs. Local groups to which this user belongs to are also displayed.

### Advanced properties
* `membership`
### Related ONTAP commands
* `vserver cifs users-and-groups local-user show`
* `vserver cifs users-and-groups local-user show-membership`
### Learn more
* [`DOC /protocols/cifs/local-users`](#docs-NAS-protocols_cifs_local-users)
*/
func (a *Client) LocalCifsUserCollectionGet(params *LocalCifsUserCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsUserCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalCifsUserCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_cifs_user_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/local-users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalCifsUserCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalCifsUserCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalCifsUserCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LocalCifsUserCreate Creates the local user configuration for an SVM.<br/>

### Important notes
* The user name can contain up to 20 characters.
* The user name cannot be terminated by a period.
* The user name does not support any of the following characters: \" / ? [ ] , : | < > + = ; ? * @ or ASCII characters in the range 1-31.
* The password must be at least six characters in length and must not contain the user account name.
* The password must contain characters from three of the following four categories:
  - English uppercase characters (A through Z)
  - English lowercase characters (a through z)
  - Base 10 digits (0 through 9)
  - Special characters: ~ ! @ \# 0 ^ & * _ - + = ` ? | ( ) [ ] : ; \" \' < > , . ? /

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the local user.
* `name` - Name of the local user.
* `password` - Password for the local user.
### Default property values
If not specified in POST, the following default property value is assigned:
* `account_disabled` - false
### Related ONTAP commands
* `vserver cifs users-and-groups local-user create`
### Learn more
* [`DOC /protocols/cifs/local-users`](#docs-NAS-protocols_cifs_local-users)
*/
func (a *Client) LocalCifsUserCreate(params *LocalCifsUserCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsUserCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalCifsUserCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_cifs_user_create",
		Method:             "POST",
		PathPattern:        "/protocols/cifs/local-users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalCifsUserCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalCifsUserCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalCifsUserCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LocalCifsUserDelete Deletes a local user configuration for the specified SVM.

### Related ONTAP commands
* `vserver cifs users-and-groups local-user delete`
### Learn more
* [`DOC /protocols/cifs/local-users`](#docs-NAS-protocols_cifs_local-users)
*/
func (a *Client) LocalCifsUserDelete(params *LocalCifsUserDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsUserDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalCifsUserDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_cifs_user_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/cifs/local-users/{svm.uuid}/{sid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalCifsUserDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalCifsUserDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalCifsUserDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LocalCifsUserDeleteCollection local cifs user delete collection API
*/
func (a *Client) LocalCifsUserDeleteCollection(params *LocalCifsUserDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsUserDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalCifsUserDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_cifs_user_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/cifs/local-users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalCifsUserDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalCifsUserDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalCifsUserDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LocalCifsUserGet Retrieves local user information for the specified user and SVM.

### Advanced properties
* `membership`
### Related ONTAP commands
* `vserver cifs users-and-groups local-user show`
* `vserver cifs users-and-groups local-user show-membership`
### Learn more
* [`DOC /protocols/cifs/local-users`](#docs-NAS-protocols_cifs_local-users)
*/
func (a *Client) LocalCifsUserGet(params *LocalCifsUserGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsUserGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalCifsUserGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_cifs_user_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/local-users/{svm.uuid}/{sid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalCifsUserGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalCifsUserGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalCifsUserGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LocalCifsUserModify Updates local user information for the specified user and SVM. The PATCH endpoint is also used to rename a user and to set the password for the user.

### Related ONTAP commands
* `vserver cifs users-and-groups local-user modify`
* `vserver cifs users-and-groups local-user rename`
* `vserver cifs users-and-groups local-user set-password`
### Learn more
* [`DOC /protocols/cifs/local-users`](#docs-NAS-protocols_cifs_local-users)
*/
func (a *Client) LocalCifsUserModify(params *LocalCifsUserModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsUserModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalCifsUserModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_cifs_user_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/local-users/{svm.uuid}/{sid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalCifsUserModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalCifsUserModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalCifsUserModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LocalCifsUserModifyCollection local cifs user modify collection API
*/
func (a *Client) LocalCifsUserModifyCollection(params *LocalCifsUserModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsUserModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalCifsUserModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_cifs_user_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/local-users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalCifsUserModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalCifsUserModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalCifsUserModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LocalCifsUsersAndGroupsImportCreate Loads CIFS local users,groups and group memberships file from the specified URL.<br/>

### Important notes
Existing CIFS local users, groups, and group memberships will be replaced with the contents of the file.
### Required properties
- import_uri.path
- decryption_password
### Optional properties
- import_uri.username
- import_uri.password
### Related ONTAP commands
* `vserver cifs users-and-groups import load-from-uri`
*/
func (a *Client) LocalCifsUsersAndGroupsImportCreate(params *LocalCifsUsersAndGroupsImportCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsUsersAndGroupsImportCreateCreated, *LocalCifsUsersAndGroupsImportCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalCifsUsersAndGroupsImportCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_cifs_users_and_groups_import_create",
		Method:             "POST",
		PathPattern:        "/protocols/cifs/users-and-groups/bulk-import/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalCifsUsersAndGroupsImportCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *LocalCifsUsersAndGroupsImportCreateCreated:
		return value, nil, nil
	case *LocalCifsUsersAndGroupsImportCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalCifsUsersAndGroupsImportCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LocalCifsUsersAndGroupsImportGet Retrieves information about the import operation status of the CIFS local users,

groups, and group memberships.
### Related ONTAP commands
* `vserver cifs users-and-groups import get-status`
*/
func (a *Client) LocalCifsUsersAndGroupsImportGet(params *LocalCifsUsersAndGroupsImportGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsUsersAndGroupsImportGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalCifsUsersAndGroupsImportGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_cifs_users_and_groups_import_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/users-and-groups/bulk-import/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalCifsUsersAndGroupsImportGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LocalCifsUsersAndGroupsImportGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalCifsUsersAndGroupsImportGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LocalCifsUsersAndGroupsImportModify Upload the status of the bulk-import of the specified SVM to the specified URI.

### Important notes
* Only the status of the last bulk-import will be uploaded and not the status of the previous bulk-imports.
### Required properties
- status_uri.path - URI to which the status needs to be uploaded.
### Optional properties
- status_uri.username - Username of the specified URI.
- status_uri.password - Password of the specified URI.
### Related ONTAP commands
* `vserver cifs users-and-groups import get-status`
*/
func (a *Client) LocalCifsUsersAndGroupsImportModify(params *LocalCifsUsersAndGroupsImportModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LocalCifsUsersAndGroupsImportModifyOK, *LocalCifsUsersAndGroupsImportModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLocalCifsUsersAndGroupsImportModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "local_cifs_users_and_groups_import_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/users-and-groups/bulk-import/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LocalCifsUsersAndGroupsImportModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *LocalCifsUsersAndGroupsImportModifyOK:
		return value, nil, nil
	case *LocalCifsUsersAndGroupsImportModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LocalCifsUsersAndGroupsImportModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetbiosCollectionGet Retrieves NetBIOS information.

### Related ONTAP commands
* `vserver cifs nbtstat`
### Learn more
* [`DOC /protocols/cifs/netbios`](#docs-NAS-protocols_cifs_netbios)
*/
func (a *Client) NetbiosCollectionGet(params *NetbiosCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetbiosCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetbiosCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "netbios_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/netbios",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetbiosCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetbiosCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetbiosCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NfsClientsCacheGet Retrieves the NFS connected-client cache settings of the cluster.
*/
func (a *Client) NfsClientsCacheGet(params *NfsClientsCacheGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsClientsCacheGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNfsClientsCacheGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nfs_clients_cache_get",
		Method:             "GET",
		PathPattern:        "/protocols/nfs/connected-client-settings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NfsClientsCacheGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NfsClientsCacheGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NfsClientsCacheGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NfsClientsCacheModify Updates the properties of the NFS connected-client cache settings.
*/
func (a *Client) NfsClientsCacheModify(params *NfsClientsCacheModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsClientsCacheModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNfsClientsCacheModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nfs_clients_cache_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/nfs/connected-client-settings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NfsClientsCacheModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NfsClientsCacheModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NfsClientsCacheModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NfsClientsGet Retrieves the NFS configuration of SVMs.

### Expensive properties
export_policy.id is expensive field. It is not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `export_policy.id`
*/
func (a *Client) NfsClientsGet(params *NfsClientsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsClientsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNfsClientsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nfs_clients_get",
		Method:             "GET",
		PathPattern:        "/protocols/nfs/connected-clients",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NfsClientsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NfsClientsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NfsClientsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NfsClientsMapGet Retrieves NFS clients information.
*/
func (a *Client) NfsClientsMapGet(params *NfsClientsMapGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsClientsMapGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNfsClientsMapGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nfs_clients_map_get",
		Method:             "GET",
		PathPattern:        "/protocols/nfs/connected-client-maps",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NfsClientsMapGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NfsClientsMapGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NfsClientsMapGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NfsCollectionGet Retrieves the NFS configuration of SVMs.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `statistics.*`
* `metric.*`
### Advanced properties
* `security.rpcsec_context_idle`
* `security.ntfs_unix_security`
* `security.chown_mode`
* `security.nt_acl_display_permission`
* `protocol.v3_features.ejukebox_enabled`
* `protocol.v3_features.connection_drop`
* `protocol.v3_features.fsid_change`
* `protocol.v3_features.mount_daemon_port`
* `protocol.v3_features.network_lock_manager_port`
* `protocol.v3_features.network_status_monitor_port`
* `protocol.v3_features.rquota_daemon_port`
* `protocol.v3_features.hide_snapshot_enabled`
* `protocol.v41_features.implementation_domain`
* `protocol.v41_features.implementation_name`
* `protocol.v40_features.acl_max_aces`
* `windows.map_unknown_uid_to_default_user`
* `exports.netgroup_trust_any_nsswitch_no_match`
* `credential_cache.negative_ttl`
* `transport.tcp_max_transfer_size`
* `root.*`
* `protocol.v41_features.trunking_enabled`
* `protocol.v42_features.seclabel_enabled`
* `protocol.v42_features.sparsefile_ops_enabled`
* `protocol.v42_features.xattrs_enabled`
* `protocol.v40_features.referrals_enabled`
* `protocol.v41_features.referrals_enabled`
* `protocol.v4_lease_seconds`
* `protocol.v4_session_slots`
* `protocol.v4_session_slot_reply_cache_size`
* `protocol.v4_fsid_change`
### Diagnostic properties
* `credential_cache.transient_error_ttl`
* `access_cache_config.ttl_failure`
* `credential_cache.harvest_timeout`
### Related ONTAP commands
* `vserver nfs show`
* `vserver nfs status`
* `vserver export-policy check-access`
### Learn more
* [`DOC /protocols/nfs/services`](#docs-NAS-protocols_nfs_services)
*/
func (a *Client) NfsCollectionGet(params *NfsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNfsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nfs_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/nfs/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NfsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NfsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NfsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NfsCollectionPerformanceMetricsGet Retrieves historical performance metrics for the NFS protocol of an SVM.
*/
func (a *Client) NfsCollectionPerformanceMetricsGet(params *NfsCollectionPerformanceMetricsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsCollectionPerformanceMetricsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNfsCollectionPerformanceMetricsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nfs_collection_performance_metrics_get",
		Method:             "GET",
		PathPattern:        "/protocols/nfs/services/{svm.uuid}/metrics",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NfsCollectionPerformanceMetricsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NfsCollectionPerformanceMetricsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NfsCollectionPerformanceMetricsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NfsCreate Creates an NFS configuration for an SVM.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM for which to create the NFS configuration.
### Default property values
If not specified in POST, the following default property values are assigned:
* `enabled` - _true_
* `state` - online
* `transport.udp_enabled` - _true_
* `transport.tcp_enabled` - _true_
* `transport.rdma_enabled` - _true_
* `protocol.v3_enabled` - _true_
* `protocol.v3_64bit_identifiers_enabled` - _false_
* `protocol.v4_id_domain` - defaultv4iddomain.com
* `protocol.v4_64bit_identifiers_enabled` - _true_
* `protocol.v4_enabled` - _false_
* `protocol.v41_enabled` - _false_
* `protocol.v40_features.acl_enabled` - _false_
* `protocol.v40_features.read_delegation_enabled` - _false_
* `protocol.v40_features.write_delegation_enabled` - _false_
* `protocol.v41_features.acl_enabled` - _false_
* `protocol.v41_features.read_delegation_enabled` - _false_
* `protocol.v41_features.write_delegation_enabled` - _false_
* `protocol.v41_features.pnfs_enabled` - _false_
* `protocol.v4_features.subnet_filter_enabled` - _false_
* `vstorage_enabled` - _false_
* `rquota_enabled` - _false_
* `showmount_enabled` - _true_
* `auth_sys_extended_groups_enabled` - _false_
* `extended_groups_limit` - _32_
* `qtree.export_enabled` - _false_
* `qtree.validate_export` - _true_
* `access_cache_config.ttl_positive` - _60_
* `access_cache_config.ttl_negative` - _30_
* `access_cache_config.ttl_failure` - _1_
* `access_cache_config.harvest_timeout` - _3600_
* `access_cache_config.isDnsTTLEnabled` - _false_
* `file_session_io_grouping_count` - _5000_
* `file_session_io_grouping_duration` - _120_
* `security.nt_acl_display_permission` - _false_
* `exports.netgroup_trust_any_nsswitch_no_match` - _false_
* `exports.name_service_lookup_protocol` - _udp_
* `security.permitted_encryption_types` - [aes-256,aes-128,des3,des]
* `security.rpcsec_context_idle` - _0_
* `security.chown_mode` - _use_export_policy_
* `security.ntfs_unix_security` - _use_export_policy_
* `windows.v3_ms_dos_client_enabled` - _false_
* `windows.default_user` - ""
* `windows.map_unknown_uid_to_default_user` - _true_
* `credential_cache.positive_ttl` - _3600000_
* `credential_cache.negative_ttl` - _3600000_
* `credential_cache.transient_error_ttl` - _30000_
* `credential_cache.harvest_timeout` - _86400000_
* `protocol.v40_features.acl_preserve` - _true_
* `protocol.v41_features.implementation_domain` - 'netapp.com'
* `protocol.v40_features.acl_max_aces` - _400_
* `protocol.v3_features.ejukebox_enabled` - _true_
* `protocol.v3_features.connection_drop` - _true_
* `protocol.v3_features.fsid_change` - _true_
* `protocol.v3_features.mount_daemon_port` - _635_
* `protocol.v3_features.network_lock_manager_port` - _4045_
* `protocol.v3_features.network_status_monitor_port` - _4046_
* `protocol.v3_features.rquota_daemon_port` - _4046_
* `protocol.v3_features.mount_root_only` - _true_
* `transport.tcp_max_transfer_size` - _65536_
* `root.ignore_nt_acl` - _false_
* `root.skip_write_permission_check` - _false_
* `protocol.v40_features.referrals_enabled` - _false_
* `protocol.v41_features.referrals_enabled` - _false_
* `protocol.v4_fsid_change` - _true_
* `protocol.v4_lease_seconds` - 30
* `protocol.v4_grace_seconds` - 45
* `protocol.v4_session_slots` - 180
* `protocol.v4_session_slot_reply_cache_size` - 640
### Related ONTAP commands
* `vserver nfs create`
* `export-policy access-cache config show`
### Learn more
* [`DOC /protocols/nfs/services`](#docs-NAS-protocols_nfs_services)
*/
func (a *Client) NfsCreate(params *NfsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNfsCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nfs_create",
		Method:             "POST",
		PathPattern:        "/protocols/nfs/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NfsCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NfsCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NfsCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NfsDelete Deletes the NFS configuration of an SVM.

### Related ONTAP commands
* `vserver nfs delete`
### Learn more
* [`DOC /protocols/nfs/services`](#docs-NAS-protocols_nfs_services)
*/
func (a *Client) NfsDelete(params *NfsDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNfsDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nfs_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/nfs/services/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NfsDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NfsDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NfsDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NfsDeleteCollection nfs delete collection API
*/
func (a *Client) NfsDeleteCollection(params *NfsDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNfsDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nfs_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/nfs/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NfsDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NfsDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NfsDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NfsGet Retrieves the NFS configuration of an SVM.

### Related ONTAP commands
* `vserver nfs show`
* `vserver nfs status`
### Learn more
* [`DOC /protocols/nfs/services`](#docs-NAS-protocols_nfs_services)
*/
func (a *Client) NfsGet(params *NfsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNfsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nfs_get",
		Method:             "GET",
		PathPattern:        "/protocols/nfs/services/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NfsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NfsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NfsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NfsModify Updates the NFS configuration of an SVM.

### Related ONTAP commands
* `vserver nfs modify`
* `vserver nfs on`
* `vserver nfs off`
* `vserver nfs start`
* `vserver nfs stop`
### Learn more
* [`DOC /protocols/nfs/services`](#docs-NAS-protocols_nfs_services)
*/
func (a *Client) NfsModify(params *NfsModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNfsModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nfs_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/nfs/services/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NfsModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NfsModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NfsModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NfsModifyCollection nfs modify collection API
*/
func (a *Client) NfsModifyCollection(params *NfsModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNfsModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nfs_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/nfs/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NfsModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NfsModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NfsModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NfsTLSInterfaceCollectionGet Retrieves NFS over TLS interfaces.

### Related ONTAP commands
* `vserver nfs tls interface show`
### Learn more
* [`DOC /protocols/nfs/tls/interfaces`](#docs-NAS-protocols_nfs_tls_interfaces)
*/
func (a *Client) NfsTLSInterfaceCollectionGet(params *NfsTLSInterfaceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsTLSInterfaceCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNfsTLSInterfaceCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nfs_tls_interface_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/nfs/tls/interfaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NfsTLSInterfaceCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NfsTLSInterfaceCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NfsTLSInterfaceCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NfsTLSInterfaceGet Retrieves an NFS over TLS interface.

### Related ONTAP commands
* `vserver nfs tls interface show`
### Learn more
* [`DOC /protocols/nfs/tls/interfaces`](#docs-NAS-protocols_nfs_tls_interfaces)
*/
func (a *Client) NfsTLSInterfaceGet(params *NfsTLSInterfaceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsTLSInterfaceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNfsTLSInterfaceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nfs_tls_interface_get",
		Method:             "GET",
		PathPattern:        "/protocols/nfs/tls/interfaces/{interface.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NfsTLSInterfaceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NfsTLSInterfaceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NfsTLSInterfaceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NfsTLSInterfaceModify Updates the properties of an NFS over TLS interface.

### Optional query parameter
* `skip-san-validation` - Specifies whether the server should ignore validating the certificate for Subject Alternate Name.
### Related ONTAP commands
* `vserver nfs tls interface modify`
* `vserver nfs tls interface enable`
* `vserver nfs tls interface disable`
### Learn more
* [`DOC /protocols/nfs/tls/interfaces`](#docs-NAS-protocols_nfs_tls_interfaces)
*/
func (a *Client) NfsTLSInterfaceModify(params *NfsTLSInterfaceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsTLSInterfaceModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNfsTLSInterfaceModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nfs_tls_interface_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/nfs/tls/interfaces/{interface.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NfsTLSInterfaceModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NfsTLSInterfaceModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NfsTLSInterfaceModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NfsTLSInterfaceModifyCollection nfs tls interface modify collection API
*/
func (a *Client) NfsTLSInterfaceModifyCollection(params *NfsTLSInterfaceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NfsTLSInterfaceModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNfsTLSInterfaceModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nfs_tls_interface_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/nfs/tls/interfaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NfsTLSInterfaceModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NfsTLSInterfaceModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NfsTLSInterfaceModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	PoliciesAndRulesToBeAppliedCollectionGet Retrieves group policy objects that are yet to be applied for all SVMs.

### Related ONTAP commands
* `vserver cifs group-policy show-defined`
*/
func (a *Client) PoliciesAndRulesToBeAppliedCollectionGet(params *PoliciesAndRulesToBeAppliedCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PoliciesAndRulesToBeAppliedCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPoliciesAndRulesToBeAppliedCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "policies_and_rules_to_be_applied_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/group-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PoliciesAndRulesToBeAppliedCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PoliciesAndRulesToBeAppliedCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PoliciesAndRulesToBeAppliedCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	PoliciesAndRulesToBeAppliedGet Retrieves group policy objects that are yet to be applied for specified SVM.

### Related ONTAP commands
* `vserver cifs group-policy show-defined`
*/
func (a *Client) PoliciesAndRulesToBeAppliedGet(params *PoliciesAndRulesToBeAppliedGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PoliciesAndRulesToBeAppliedGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPoliciesAndRulesToBeAppliedGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "policies_and_rules_to_be_applied_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/group-policies/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PoliciesAndRulesToBeAppliedGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PoliciesAndRulesToBeAppliedGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PoliciesAndRulesToBeAppliedGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3AuditCreate Creates an S3 audit configuration.

### Required properties
* `log_path` - Path in the owning SVM namespace that is used to store audit logs.
### Default property values
If not specified in POST, the following default property values are assigned:
* `enabled` - _true_
* `events.data` - _true_
* `events.management` - _false_
* `log.format` - _json_
* `log.retention.count` - _0_
* `log.retention.duration` - _PT0S_
* `log.rotation.size` - _100MB_
* `log.rotation.now` - _false_
### Related ONTAP commands
* `vserver object-store-server audit create`
* `vserver object-store-server audit enable`
### Learn more
* [`DOC /protocols/audit/{svm.uuid}/object-store`](#docs-NAS-protocols_audit_{svm.uuid}_object-store)
*/
func (a *Client) S3AuditCreate(params *S3AuditCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3AuditCreateCreated, *S3AuditCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3AuditCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_audit_create",
		Method:             "POST",
		PathPattern:        "/protocols/audit/{svm.uuid}/object-store",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3AuditCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *S3AuditCreateCreated:
		return value, nil, nil
	case *S3AuditCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3AuditCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3AuditDelete Deletes an S3 audit configuration.

### Related ONTAP commands
* `vserver object-store-server audit disable`
* `vserver object-store-server audit delete`
### Learn more
* [`DOC /protocols/audit/{svm.uuid}/object-store`](#docs-NAS-protocols_audit_{svm.uuid}_object-store)
*/
func (a *Client) S3AuditDelete(params *S3AuditDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3AuditDeleteOK, *S3AuditDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3AuditDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_audit_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/audit/{svm.uuid}/object-store",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3AuditDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *S3AuditDeleteOK:
		return value, nil, nil
	case *S3AuditDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3AuditDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3AuditGet Retrieves S3 audit configurations.

### Related ONTAP commands
* `vserver object-store-server audit show`
### Learn more
* [`DOC /protocols/audit/{svm.uuid}/object-store`](#docs-NAS-protocols_audit_{svm.uuid}_object-store)
*/
func (a *Client) S3AuditGet(params *S3AuditGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3AuditGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3AuditGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_audit_get",
		Method:             "GET",
		PathPattern:        "/protocols/audit/{svm.uuid}/object-store",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3AuditGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3AuditGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3AuditGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3AuditModify Updates an S3 audit configuration for an SVM.

### Important notes
* `events` - Not specifying either data or management is equivalent to setting it to false.
### Related ONTAP commands
* `vserver object-store-server audit modify`
### Learn more
* [`DOC /protocols/audit/{svm.uuid}/object-store`](#docs-NAS-protocols_audit_{svm.uuid}_object-store)
*/
func (a *Client) S3AuditModify(params *S3AuditModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3AuditModifyOK, *S3AuditModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3AuditModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_audit_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/audit/{svm.uuid}/object-store",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3AuditModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *S3AuditModifyOK:
		return value, nil, nil
	case *S3AuditModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3AuditModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ShadowcopyCollectionGet Retrieves Shadowcopies

### Related ONTAP commands
* `vserver cifs shadowcopy show-shares`
### Learn more
* [`DOC /protocols/cifs/shadow-copies`](#docs-NAS-protocols_cifs_shadow-copies)
*/
func (a *Client) ShadowcopyCollectionGet(params *ShadowcopyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShadowcopyCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewShadowcopyCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "shadowcopy_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/shadow-copies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ShadowcopyCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ShadowcopyCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ShadowcopyCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ShadowcopyGet Retrieves a Shadowcopy

### Related ONTAP commands
* `vserver cifs shadowcopy show-shares`
### Learn more
* [`DOC /protocols/cifs/shadow-copies`](#docs-NAS-protocols_cifs_shadow-copies)
*/
func (a *Client) ShadowcopyGet(params *ShadowcopyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShadowcopyGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewShadowcopyGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "shadowcopy_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/shadow-copies/{client_uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ShadowcopyGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ShadowcopyGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ShadowcopyGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ShadowcopyModify Specify list Files to be added as a part of Shadowcopy creation

### Learn more
* [`DOC /protocols/cifs/shadow-copies`](#docs-NAS-protocols_cifs_shadow-copies)
*/
func (a *Client) ShadowcopyModify(params *ShadowcopyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShadowcopyModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewShadowcopyModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "shadowcopy_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/shadow-copies/{client_uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ShadowcopyModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ShadowcopyModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ShadowcopyModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ShadowcopyModifyCollection shadowcopy modify collection API
*/
func (a *Client) ShadowcopyModifyCollection(params *ShadowcopyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShadowcopyModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewShadowcopyModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "shadowcopy_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/shadow-copies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ShadowcopyModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ShadowcopyModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ShadowcopyModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ShadowcopySetCollectionGet Retrieves Shadowcopy Sets.

### Related ONTAP commands
* `vserver cifs shadowcopy show-sets`
### Learn more
* [`DOC /protocols/cifs/shadow-copies`](#docs-NAS-protocols_cifs_shadow-copies)
*/
func (a *Client) ShadowcopySetCollectionGet(params *ShadowcopySetCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShadowcopySetCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewShadowcopySetCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "shadowcopy_set_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/shadowcopy-sets",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ShadowcopySetCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ShadowcopySetCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ShadowcopySetCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ShadowcopySetGet Retrieves a Shadowcopy set

### Related ONTAP commands
* `vserver cifs shadowcopy show-sets`
### Learn more
* [`DOC /protocols/cifs/shadow-copies`](#docs-NAS-protocols_cifs_shadow-copies)
*/
func (a *Client) ShadowcopySetGet(params *ShadowcopySetGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShadowcopySetGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewShadowcopySetGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "shadowcopy_set_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/shadowcopy-sets/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ShadowcopySetGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ShadowcopySetGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ShadowcopySetGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ShadowcopySetModify Updates a Shadowcopy set

### Learn more
* [`DOC /protocols/cifs/shadowcopy`](#docs-NAS-protocols_cifs_shadowcopy)
*/
func (a *Client) ShadowcopySetModify(params *ShadowcopySetModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShadowcopySetModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewShadowcopySetModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "shadowcopy_set_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/shadowcopy-sets/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ShadowcopySetModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ShadowcopySetModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ShadowcopySetModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ShadowcopySetModifyCollection shadowcopy set modify collection API
*/
func (a *Client) ShadowcopySetModifyCollection(params *ShadowcopySetModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ShadowcopySetModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewShadowcopySetModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "shadowcopy_set_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/shadowcopy-sets",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ShadowcopySetModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ShadowcopySetModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ShadowcopySetModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	UserGroupPrivilegesCollectionGet Retrieves privileges of the specified local or Active Directory user or group and SVM.

### Related ONTAP commands
* `vserver cifs users-and-groups privilege show`
### Learn more
* [`DOC /protocols/cifs/users-and-groups/privileges`](#docs-NAS-protocols_cifs_users-and-groups_privileges)
*/
func (a *Client) UserGroupPrivilegesCollectionGet(params *UserGroupPrivilegesCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UserGroupPrivilegesCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUserGroupPrivilegesCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "user_group_privileges_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/users-and-groups/privileges",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UserGroupPrivilegesCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UserGroupPrivilegesCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UserGroupPrivilegesCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	UserGroupPrivilegesCreate Adds privileges to the specified local or Active Directory user or group and SVM.

### Important note
* Specified privileges are appended to the existing list of privileges.
### Required properties
* `svm.uuid` or `svm.name` - Existing SVM for which privileges are added to user or group.
* `name` - Existing local or Active Directory user or group for which privileges are to be added.
* `privileges` - List of privileges to be added to a user or group.
### Related ONTAP commands
* `vserver cifs users-and-groups privilege add-privilege`
### Learn more
* [`DOC /protocols/cifs/users-and-groups/privileges`](#docs-NAS-protocols_cifs_users-and-groups_privileges)
*/
func (a *Client) UserGroupPrivilegesCreate(params *UserGroupPrivilegesCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UserGroupPrivilegesCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUserGroupPrivilegesCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "user_group_privileges_create",
		Method:             "POST",
		PathPattern:        "/protocols/cifs/users-and-groups/privileges",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UserGroupPrivilegesCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UserGroupPrivilegesCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UserGroupPrivilegesCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	UserGroupPrivilegesGet Retrieves privileges of the specified local or Active Directory user or group and SVM.

### Related ONTAP commands
* `vserver cifs users-and-groups privilege show`
### Learn more
* [`DOC /protocols/cifs/users-and-groups/privileges`](#docs-NAS-protocols_cifs_users-and-groups_privileges)
*/
func (a *Client) UserGroupPrivilegesGet(params *UserGroupPrivilegesGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UserGroupPrivilegesGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUserGroupPrivilegesGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "user_group_privileges_get",
		Method:             "GET",
		PathPattern:        "/protocols/cifs/users-and-groups/privileges/{svm.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UserGroupPrivilegesGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UserGroupPrivilegesGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UserGroupPrivilegesGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	UserGroupPrivilegesModify Updates privileges of the specified local or Active Directory user or group and SVM.

### Important note
* Specified privileges will replace all the existing privileges associated with the user or group.
* To reset privileges associated with the user or group, specify the privileges list as empty.
### Related ONTAP commands
* `vserver cifs users-and-groups privilege reset-privilege`
### Learn more
* [`DOC /protocols/cifs/users-and-groups/privileges`](#docs-NAS-protocols_cifs_users-and-groups_privileges)
*/
func (a *Client) UserGroupPrivilegesModify(params *UserGroupPrivilegesModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UserGroupPrivilegesModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUserGroupPrivilegesModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "user_group_privileges_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/users-and-groups/privileges/{svm.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UserGroupPrivilegesModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UserGroupPrivilegesModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UserGroupPrivilegesModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UserGroupPrivilegesModifyCollection user group privileges modify collection API
*/
func (a *Client) UserGroupPrivilegesModifyCollection(params *UserGroupPrivilegesModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UserGroupPrivilegesModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUserGroupPrivilegesModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "user_group_privileges_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/cifs/users-and-groups/privileges",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UserGroupPrivilegesModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UserGroupPrivilegesModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UserGroupPrivilegesModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VscanCollectionGet Retrieves the Vscan configuration.

This includes scanner-pools, On-Access policies, On-Demand policies, and information about whether a Vscan is enabled or disabled on an SVM.<br/>
Important notes:
* You can enable only one Vscan configuration at a time for an SVM.
* You can only query using `svm.uuid` or `svm.name`.
### Related ONTAP commands
* `vserver vscan show`
* `vserver vscan scanner-pool show`
* `vserver vscan scanner-pool servers show`
* `vserver vscan scanner-pool privileged-users show`
* `vserver vscan on-access-policy show`
* `vserver vscan on-access-policy file-ext-to-exclude show`
* `vserver vscan on-access-policy file-ext-to-include show`
* `vserver vscan on-access-policy paths-to-exclude show`
* `vserver vscan on-demand-task show`
### Learn more
* [`DOC /protocols/vscan`](#docs-NAS-protocols_vscan)
* [`DOC /protocols/vscan/{svm.uuid}/scanner-pools`](#docs-NAS-protocols_vscan_{svm.uuid}_scanner-pools)
*/
func (a *Client) VscanCollectionGet(params *VscanCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/vscan",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VscanConfigDelete Deletes a Vscan configuration.<br/>

Important notes:
* The Vscan DELETE endpoint deletes all of the Vscan configuration of an SVM. It first disables the Vscan and then deletes all of the SVM scanner-pools, On-Access policies, and On-Demand policies.
* Disable the active Vscan On-Access policy on an SVM before performing the Vscan delete operation on that SVM.
### Related ONTAP commands
* `vserver vscan scanner-pool delete`
* `vserver vscan on-access-policy delete`
* `vserver vscan on-demand-policy delete`
### Learn more
* [`DOC /protocols/vscan`](#docs-NAS-protocols_vscan)
* [`DOC /protocols/vscan/{svm.uuid}/scanner-pools`](#docs-NAS-protocols_vscan_{svm.uuid}_scanner-pools)
*/
func (a *Client) VscanConfigDelete(params *VscanConfigDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanConfigDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanConfigDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_config_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/vscan/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanConfigDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanConfigDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanConfigDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
VscanConfigDeleteCollection vscan config delete collection API
*/
func (a *Client) VscanConfigDeleteCollection(params *VscanConfigDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanConfigDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanConfigDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_config_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/vscan",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanConfigDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanConfigDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanConfigDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VscanCreate Creates a Vscan configuration, which includes a list of scanner-pools, Vscan On-Access policies and Vscan On-Demand policies. Defines whether the Vscan configuration you create is enabled or disabled for a specified SVM.<br/>

Important notes:
* You can enable only one Vscan configuration at a time for an SVM.
* There needs to be at least one active scanner-pool and one enabled On-Access policy to enable Vscan successfully.
* By default, a Vscan is enabled when it’s created.
* By default, the Vscan On-Access policies created from this endpoint are in the disabled state. You can use the On-Access policy PATCH endpoint to enable a particular On-Access policy. In ONTAP 9.6, only one Vscan On-Access policy can be enabled and only one Vscan On-Demand policy can be scheduled on an SVM.
* Vscan is not supported on continuous availability (CA) shares.
### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the Vscan configuration.
### Recommended optional properties
* `scanner_pools` - There must be at least one active scanner-pool for Vscan configuration. Created either through Vscan POST operation or scanner-pools POST operation.
### Default property values
If not specified in POST, the following default property value is assigned:
* `enabled` - _true_
### Related ONTAP commands
* `vserver vscan enable`
* `vserver vscan scanner-pool create`
* `vserver vscan scanner-pool apply-policy`
* `vserver vscan scanner-pool servers add`
* `vserver vscan scanner-pool privileged-users add`
* `vserver vscan on-access-policy create`
* `vserver vscan on-access-policy file-ext-to-exclude add`
* `vserver vscan on-access-policy file-ext-to-include add`
* `vserver vscan on-access-policy paths-to-exclude add`
* `vserver vscan on-demand-task create`
### Learn more
* [`DOC /protocols/vscan`](#docs-NAS-protocols_vscan)
* [`DOC /protocols/vscan/{svm.uuid}/scanner-pools`](#docs-NAS-protocols_vscan_{svm.uuid}_scanner-pools)
*/
func (a *Client) VscanCreate(params *VscanCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_create",
		Method:             "POST",
		PathPattern:        "/protocols/vscan",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VscanEventCollectionGet Retrieves Vscan events, which are generated by the cluster to capture important events.

### Related ONTAP commands
* `vserver vscan show-events`
*/
func (a *Client) VscanEventCollectionGet(params *VscanEventCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanEventCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanEventCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_event_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/vscan/{svm.uuid}/events",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanEventCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanEventCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanEventCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VscanGet Retrieves the Vscan configuration for a specified SVM.

This includes scanner-pools, On-Access policies, On-Demand policies, and information about whether a Vscan is enabled or disabled on an SVM.<br/>
Important note:
* You can enable only one Vscan configuration at a time for an SVM.
### Related ONTAP commands
* `vserver vscan show`
* `vserver vscan scanner-pool show`
* `vserver vscan scanner-pool servers show`
* `vserver vscan scanner-pool privileged-users show`
* `vserver vscan on-access-policy show`
* `vserver vscan on-access-policy file-ext-to-exclude show`
* `vserver vscan on-access-policy file-ext-to-include show`
* `vserver vscan on-access-policy paths-to-exclude show`
* `vserver vscan on-demand-task show`
### Learn more
* [`DOC /protocols/vscan`](#docs-NAS-protocols_vscan)
* [`DOC /protocols/vscan/{svm.uuid}/scanner-pools`](#docs-NAS-protocols_vscan_{svm.uuid}_scanner-pools)
*/
func (a *Client) VscanGet(params *VscanGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_get",
		Method:             "GET",
		PathPattern:        "/protocols/vscan/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VscanModify Updates the Vscan configuration of an SVM. Allows you to either enable or disable a Vscan, and allows you to clear the Vscan cache that stores the past scanning data for an SVM.<br/>

Important note:
* The Vscan PATCH endpoint does not allow you to modify scanner-pools, On-Demand policies or On-Access policies. Those modifications can only be done through their respective endpoints.
### Related ONTAP commands
* `vserver vscan enable`
* `vserver vscan disable`
* `vserver vscan reset`
### Learn more
* [`DOC /protocols/vscan`](#docs-NAS-protocols_vscan)
* [`DOC /protocols/vscan/{svm.uuid}/scanner-pools`](#docs-NAS-protocols_vscan_{svm.uuid}_scanner-pools)
*/
func (a *Client) VscanModify(params *VscanModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/vscan/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
VscanModifyCollection vscan modify collection API
*/
func (a *Client) VscanModifyCollection(params *VscanModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/vscan",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VscanOnAccessCreate Creates a Vscan On-Access policy.

</b>Important notes:
* You must enable the policy on an SVM before its files can be scanned.
* You can enable only one On-Access policy at a time on an SVM. By default, the policy is enabled on creation. * If the Vscan On-Access policy has been created successfully on an SVM but cannot be enabled due to an error, the Vscan On-Access policy configurations are saved. The Vscan On-Access policy is then enabled using the PATCH operation.
### Required properties
* `svm.uuid` - Existing SVM in which to create the Vscan On-Access policy.
* `name` - Name of the Vscan On-Access policy. Maximum length is 256 characters.
### Default property values
If not specified in POST, the following default property values are assigned:
* `enabled` - _true_
* `mandatory` - _true_
* `include_extensions` - _*_
* `max_file_size` - _2147483648_
* `only_execute_access` - _false_
* `scan_readonly_volumes` - _false_
* `scan_without_extension` - _true_
* `protocol` - _CIFS_
### Related ONTAP commands
* `vserver vscan on-access-policy create`
* `vserver vscan on-access-policy enable`
* `vserver vscan on-access-policy disable`
* `vserver vscan on-access-policy file-ext-to-include add`
* `vserver vscan on-access-policy file-ext-to-exclude add`
* `vserver vscan on-access-policy paths-to-exclude add`
### Learn more
* [`DOC /protocols/vscan/{svm.uuid}/on-access-policies`](#docs-NAS-protocols_vscan_{svm.uuid}_on-access-policies)
*/
func (a *Client) VscanOnAccessCreate(params *VscanOnAccessCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnAccessCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanOnAccessCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_on_access_create",
		Method:             "POST",
		PathPattern:        "/protocols/vscan/{svm.uuid}/on-access-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanOnAccessCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanOnAccessCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanOnAccessCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VscanOnAccessDelete Deletes the anti-virus On-Access policy configuration.

### Related ONTAP commands
* `vserver vscan on-access-policy delete`
### Learn more
* [`DOC /protocols/vscan/{svm.uuid}/on-access-policies`](#docs-NAS-protocols_vscan_{svm.uuid}_on-access-policies)
*/
func (a *Client) VscanOnAccessDelete(params *VscanOnAccessDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnAccessDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanOnAccessDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_on_access_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/vscan/{svm.uuid}/on-access-policies/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanOnAccessDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanOnAccessDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanOnAccessDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
VscanOnAccessDeleteCollection vscan on access delete collection API
*/
func (a *Client) VscanOnAccessDeleteCollection(params *VscanOnAccessDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnAccessDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanOnAccessDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_on_access_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/vscan/{svm.uuid}/on-access-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanOnAccessDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanOnAccessDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanOnAccessDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VscanOnAccessGet Retrieves the Vscan On-Access policy configuration of an SVM.

### Related ONTAP commands
* `vserver vscan on-access-policy show`
* `vserver vscan on-access-policy file-ext-to-include show`
* `vserver vscan on-access-policy file-ext-to-exclude show`
* `vserver vscan on-access-policy paths-to-exclude show`
### Learn more
* [`DOC /protocols/vscan/{svm.uuid}/on-access-policies`](#docs-NAS-protocols_vscan_{svm.uuid}_on-access-policies)
*/
func (a *Client) VscanOnAccessGet(params *VscanOnAccessGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnAccessGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanOnAccessGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_on_access_get",
		Method:             "GET",
		PathPattern:        "/protocols/vscan/{svm.uuid}/on-access-policies/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanOnAccessGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanOnAccessGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanOnAccessGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VscanOnAccessModify Updates the Vscan On-Access policy configuration and/or enables/disables the Vscan On-Access policy of an SVM. You cannot modify the configurations for an On-Access policy associated with a data SVM which was created by SVM owned by the cluster, although you can enable and disable the policy associated with cluster SVM.

### Related ONTAP commands
* `vserver vscan on-access-policy modify`
* `vserver vscan on-access-policy enable`
* `vserver vscan on-access-policy disable`
* `vserver vscan on-access-policy file-ext-to-include add`
* `vserver vscan on-access-policy file-ext-to-exclude add`
* `vserver vscan on-access-policy paths-to-exclude add`
* `vserver vscan on-access-policy file-ext-to-include remove`
* `vserver vscan on-access-policy file-ext-to-exclude remove`
* `vserver vscan on-access-policy paths-to-exclude remove`
### Learn more
* [`DOC /protocols/vscan/{svm.uuid}/on-access-policies`](#docs-NAS-protocols_vscan_{svm.uuid}_on-access-policies)
*/
func (a *Client) VscanOnAccessModify(params *VscanOnAccessModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnAccessModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanOnAccessModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_on_access_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/vscan/{svm.uuid}/on-access-policies/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanOnAccessModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanOnAccessModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanOnAccessModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
VscanOnAccessModifyCollection vscan on access modify collection API
*/
func (a *Client) VscanOnAccessModifyCollection(params *VscanOnAccessModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnAccessModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanOnAccessModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_on_access_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/vscan/{svm.uuid}/on-access-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanOnAccessModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanOnAccessModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanOnAccessModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VscanOnAccessPolicyCollectionGet Retrieves the Vscan On-Access policy.

### Related ONTAP commands
* `vserver vscan on-access-policy show`
* `vserver vscan on-access-policy file-ext-to-include show`
* `vserver vscan on-access-policy file-ext-to-exclude show`
* `vserver vscan on-access-policy paths-to-exclude show`
### Learn more
* [`DOC /protocols/vscan/{svm.uuid}/on-access-policies`](#docs-NAS-protocols_vscan_{svm.uuid}_on-access-policies)
*/
func (a *Client) VscanOnAccessPolicyCollectionGet(params *VscanOnAccessPolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnAccessPolicyCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanOnAccessPolicyCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_on_access_policy_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/vscan/{svm.uuid}/on-access-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanOnAccessPolicyCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanOnAccessPolicyCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanOnAccessPolicyCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VscanOnDemandCreate Creates a Vscan On-Demand policy. Created only on a data SVM.

</br> Important notes:
  - Only one policy can be scheduled at a time on an SVM. Use schedule name or schedule uuid to schedule an On-Demand policy.
  - Scanning must be enabled on the SVM before the policy is scheduled to run.
  - The exclude_extensions setting overrides the include_extensions setting. Set scan_without_extension to true to scan files without extensions.

### Required properties
* `svm.uuid` - Existing SVM in which to create the Vscan On-Demand policy.
* `name` - Name of the Vscan On-Demand policy. Maximum length is 256 characters.
* `log_path` - Path from the Vserver root where the On-Demand policy report is created.
* `scan_paths` - List of paths that need to be scanned.
### Recommended optional properties
* `schedule` - Scan schedule. It is recommended to set the schedule property, as it dictates when to scan for viruses.
### Default property values
If not specified in POST, the following default property values are assigned:
* `include_extensions` - _*_
* `max_file_size` - _10737418240_
* `scan_without_extension` - _true_
### Related ONTAP commands
* `vserver vscan on-demand-task create`
* `vserver vscan on-demand-task schedule`
### Learn more
* [`DOC /protocols/vscan/{svm.uuid}/on-demand-policies`](#docs-NAS-protocols_vscan_{svm.uuid}_on-demand-policies)
*/
func (a *Client) VscanOnDemandCreate(params *VscanOnDemandCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnDemandCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanOnDemandCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_on_demand_create",
		Method:             "POST",
		PathPattern:        "/protocols/vscan/{svm.uuid}/on-demand-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanOnDemandCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanOnDemandCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanOnDemandCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VscanOnDemandDelete Deletes the Vscan On-Demand configuration.

### Related ONTAP commands
* `vserver vscan on-demand-task delete`
### Learn more
* [`DOC /protocols/vscan/{svm.uuid}/on-demand-policies`](#docs-NAS-protocols_vscan_{svm.uuid}_on-demand-policies)
*/
func (a *Client) VscanOnDemandDelete(params *VscanOnDemandDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnDemandDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanOnDemandDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_on_demand_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/vscan/{svm.uuid}/on-demand-policies/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanOnDemandDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanOnDemandDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanOnDemandDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
VscanOnDemandDeleteCollection vscan on demand delete collection API
*/
func (a *Client) VscanOnDemandDeleteCollection(params *VscanOnDemandDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnDemandDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanOnDemandDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_on_demand_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/vscan/{svm.uuid}/on-demand-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanOnDemandDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanOnDemandDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanOnDemandDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VscanOnDemandGet Retrieves the Vscan On-Demand configuration of an SVM.

### Related ONTAP commands
* `vserver vscan on-demand-task show`
### Learn more
* [`DOC /protocols/vscan/{svm.uuid}/on-demand-policies`](#docs-NAS-protocols_vscan_{svm.uuid}_on-demand-policies)
*/
func (a *Client) VscanOnDemandGet(params *VscanOnDemandGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnDemandGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanOnDemandGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_on_demand_get",
		Method:             "GET",
		PathPattern:        "/protocols/vscan/{svm.uuid}/on-demand-policies/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanOnDemandGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanOnDemandGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanOnDemandGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VscanOnDemandModify Updates the Vscan On-Demand policy configuration of an SVM. Use schedule name or schedule UUID to schedule an On-Demand scan.

### Related ONTAP commands
* `vserver vscan on-demand-task modify`
* `vserver vscan on-demand-task schedule`
* `vserver vscan on-demand-task unschedule`
### Learn more
* [`DOC /protocols/vscan/{svm.uuid}/on-demand-policies`](#docs-NAS-protocols_vscan_{svm.uuid}_on-demand-policies)
*/
func (a *Client) VscanOnDemandModify(params *VscanOnDemandModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnDemandModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanOnDemandModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_on_demand_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/vscan/{svm.uuid}/on-demand-policies/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanOnDemandModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanOnDemandModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanOnDemandModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
VscanOnDemandModifyCollection vscan on demand modify collection API
*/
func (a *Client) VscanOnDemandModifyCollection(params *VscanOnDemandModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnDemandModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanOnDemandModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_on_demand_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/vscan/{svm.uuid}/on-demand-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanOnDemandModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanOnDemandModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanOnDemandModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VscanOnDemandPolicyCollectionGet Retrieves the Vscan On-Demand policy.

### Related ONTAP commands
* `vserver vscan on-demand-task show`
### Learn more
* [`DOC /protocols/vscan/{svm.uuid}/on-demand-policies`](#docs-NAS-protocols_vscan_{svm.uuid}_on-demand-policies)
*/
func (a *Client) VscanOnDemandPolicyCollectionGet(params *VscanOnDemandPolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanOnDemandPolicyCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanOnDemandPolicyCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_on_demand_policy_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/vscan/{svm.uuid}/on-demand-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanOnDemandPolicyCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanOnDemandPolicyCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanOnDemandPolicyCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VscanScannerCollectionGet Retrieves the Vscan scanner-pool configuration of an SVM.

### Related ONTAP commands
* `vserver vscan scanner-pool show`
* `vserver vscan scanner-pool privileged-users show`
* `vserver vscan scanner-pool servers show`
### Learn more
* [`DOC /protocols/vscan/{svm.uuid}/scanner-pools`](#docs-NAS-protocols_vscan_{svm.uuid}_scanner-pools)
*/
func (a *Client) VscanScannerCollectionGet(params *VscanScannerCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanScannerCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanScannerCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_scanner_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/vscan/{svm.uuid}/scanner-pools",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanScannerCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanScannerCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanScannerCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VscanScannerCreate Creates a Vscan scanner-pool configuration for a specified SVM. You can create a scanner-pool with all fields specified or only mandatory fields specified.<br/>

Important notes:
* A scanner-pool must have servers and privileged users specified.
* If the role or cluster is not specified, the scanner-pool is created on the local cluster with the role set as primary.
*`Only one of the fields cluster-uuid or cluster-name is required.
### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the Vscan configuration.
* `name` - Scanner-pool name.
* `privileged_users` - List of privileged users.
* `servers` - List of server IP addresses or FQDNs.
### Recommended optional properties
* `role` - Setting a role for a scanner-pool is recommended.
* `cluster` - Passing the cluster name or UUID (or both) in a multi-cluster environment is recommended.
### Default property values
If not specified in POST, the following default property values are assigned:
* `role` - _primary_
* `cluster.name` - Local cluster name.
* `cluster.uuid` - Local cluster UUID.
### Related ONTAP commands
* `vserver vscan scanner-pool create`
* `vserver vscan scanner-pool apply-policy`
* `vserver vscan scanner-pool privileged-users add`
* `vserver vscan scanner-pool servers add`
### Learn more
* [`DOC /protocols/vscan/{svm.uuid}/scanner-pools`](#docs-NAS-protocols_vscan_{svm.uuid}_scanner-pools)
*/
func (a *Client) VscanScannerCreate(params *VscanScannerCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanScannerCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanScannerCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_scanner_create",
		Method:             "POST",
		PathPattern:        "/protocols/vscan/{svm.uuid}/scanner-pools",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanScannerCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanScannerCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanScannerCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VscanScannerDelete Deletes a Vscan scanner-pool configuration.<br/>

Important notes:
* The Vscan scanner-pool DELETE endpoint deletes all of the Vscan scanner-pools for a specified SVM.
* If a Vscan is enabled, it requires at least one scanner-pool to be in the active state. Therefore, disable Vscan on the specified SVM so all the scanner-pools configured on that SVM can be deleted.
### Related ONTAP commands
* `vserver vscan scanner-pool delete`
### Learn more
* [`DOC /protocols/vscan/{svm.uuid}/scanner-pools`](#docs-NAS-protocols_vscan_{svm.uuid}_scanner-pools)
*/
func (a *Client) VscanScannerDelete(params *VscanScannerDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanScannerDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanScannerDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_scanner_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/vscan/{svm.uuid}/scanner-pools/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanScannerDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanScannerDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanScannerDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
VscanScannerDeleteCollection vscan scanner delete collection API
*/
func (a *Client) VscanScannerDeleteCollection(params *VscanScannerDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanScannerDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanScannerDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_scanner_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/vscan/{svm.uuid}/scanner-pools",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanScannerDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanScannerDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanScannerDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VscanScannerModify Updates the Vscan scanner-pool configuration of an SVM.<br/>

Important notes:
* Along with servers and privileged-users, the role of a scanner-pool can also be updated with the cluster on which a scanner-pool is allowed.
* If role is specified and cluster isn't, then role is applied to the local cluster.
### Related ONTAP commands
* `vserver vscan scanner-pool modify`
* `vserver vscan scanner-pool apply-policy`
* `vserver vscan scanner-pool privileged-users add`
* `vserver vscan scanner-pool privileged-users remove`
* `vserver vscan scanner-pool servers remove`
* `vserver vscan scanner-pool servers add`
### Learn more
* [`DOC /protocols/vscan/{svm.uuid}/scanner-pools`](#docs-NAS-protocols_vscan_{svm.uuid}_scanner-pools)
*/
func (a *Client) VscanScannerModify(params *VscanScannerModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanScannerModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanScannerModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_scanner_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/vscan/{svm.uuid}/scanner-pools/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanScannerModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanScannerModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanScannerModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
VscanScannerModifyCollection vscan scanner modify collection API
*/
func (a *Client) VscanScannerModifyCollection(params *VscanScannerModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanScannerModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanScannerModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_scanner_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/vscan/{svm.uuid}/scanner-pools",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanScannerModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanScannerModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanScannerModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VscanScannerPoolGet Retrieves the configuration of a specified scanner-pool of an SVM.

### Related ONTAP commands
* `vserver vscan scanner-pool show`
* `vserver vscan scanner-pool privileged-users show`
* `vserver vscan scanner-pool servers show`
### Learn more
* [`DOC /protocols/vscan/{svm.uuid}/scanner-pools`](#docs-NAS-protocols_vscan_{svm.uuid}_scanner-pools)
*/
func (a *Client) VscanScannerPoolGet(params *VscanScannerPoolGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanScannerPoolGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanScannerPoolGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_scanner_pool_get",
		Method:             "GET",
		PathPattern:        "/protocols/vscan/{svm.uuid}/scanner-pools/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanScannerPoolGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanScannerPoolGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanScannerPoolGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	VscanServerStatusGet Retrieves a Vscan server status.

### Related ONTAP commands
* `vserver vscan connection-status show-all`
### Learn more
* [`DOC /protocols/vscan/server-status`](#docs-NAS-protocols_vscan_server-status)
*/
func (a *Client) VscanServerStatusGet(params *VscanServerStatusGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*VscanServerStatusGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewVscanServerStatusGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "vscan_server_status_get",
		Method:             "GET",
		PathPattern:        "/protocols/vscan/server-status",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &VscanServerStatusGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*VscanServerStatusGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*VscanServerStatusGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
