// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNetbiosCollectionGetParams creates a new NetbiosCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNetbiosCollectionGetParams() *NetbiosCollectionGetParams {
	return &NetbiosCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNetbiosCollectionGetParamsWithTimeout creates a new NetbiosCollectionGetParams object
// with the ability to set a timeout on a request.
func NewNetbiosCollectionGetParamsWithTimeout(timeout time.Duration) *NetbiosCollectionGetParams {
	return &NetbiosCollectionGetParams{
		timeout: timeout,
	}
}

// NewNetbiosCollectionGetParamsWithContext creates a new NetbiosCollectionGetParams object
// with the ability to set a context for a request.
func NewNetbiosCollectionGetParamsWithContext(ctx context.Context) *NetbiosCollectionGetParams {
	return &NetbiosCollectionGetParams{
		Context: ctx,
	}
}

// NewNetbiosCollectionGetParamsWithHTTPClient creates a new NetbiosCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewNetbiosCollectionGetParamsWithHTTPClient(client *http.Client) *NetbiosCollectionGetParams {
	return &NetbiosCollectionGetParams{
		HTTPClient: client,
	}
}

/*
NetbiosCollectionGetParams contains all the parameters to send to the API endpoint

	for the netbios collection get operation.

	Typically these are written to a http.Request.
*/
type NetbiosCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Interfaces.

	   Filter by interfaces
	*/
	Interfaces *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Mode.

	   Filter by mode
	*/
	Mode *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NameRegistrationType.

	   Filter by name_registration_type
	*/
	NameRegistrationType *string

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* State.

	   Filter by state
	*/
	State *string

	/* Suffix.

	   Filter by suffix
	*/
	Suffix *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* TimeLeft.

	   Filter by time_left
	*/
	TimeLeft *int64

	/* WinsServersIP.

	   Filter by wins_servers.ip
	*/
	WinsServersIP *string

	/* WinsServersState.

	   Filter by wins_servers.state
	*/
	WinsServersState *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the netbios collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetbiosCollectionGetParams) WithDefaults() *NetbiosCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the netbios collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetbiosCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := NetbiosCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the netbios collection get params
func (o *NetbiosCollectionGetParams) WithTimeout(timeout time.Duration) *NetbiosCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the netbios collection get params
func (o *NetbiosCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the netbios collection get params
func (o *NetbiosCollectionGetParams) WithContext(ctx context.Context) *NetbiosCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the netbios collection get params
func (o *NetbiosCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the netbios collection get params
func (o *NetbiosCollectionGetParams) WithHTTPClient(client *http.Client) *NetbiosCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the netbios collection get params
func (o *NetbiosCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the netbios collection get params
func (o *NetbiosCollectionGetParams) WithFields(fields []string) *NetbiosCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the netbios collection get params
func (o *NetbiosCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithInterfaces adds the interfaces to the netbios collection get params
func (o *NetbiosCollectionGetParams) WithInterfaces(interfaces *string) *NetbiosCollectionGetParams {
	o.SetInterfaces(interfaces)
	return o
}

// SetInterfaces adds the interfaces to the netbios collection get params
func (o *NetbiosCollectionGetParams) SetInterfaces(interfaces *string) {
	o.Interfaces = interfaces
}

// WithMaxRecords adds the maxRecords to the netbios collection get params
func (o *NetbiosCollectionGetParams) WithMaxRecords(maxRecords *int64) *NetbiosCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the netbios collection get params
func (o *NetbiosCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMode adds the mode to the netbios collection get params
func (o *NetbiosCollectionGetParams) WithMode(mode *string) *NetbiosCollectionGetParams {
	o.SetMode(mode)
	return o
}

// SetMode adds the mode to the netbios collection get params
func (o *NetbiosCollectionGetParams) SetMode(mode *string) {
	o.Mode = mode
}

// WithName adds the name to the netbios collection get params
func (o *NetbiosCollectionGetParams) WithName(name *string) *NetbiosCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the netbios collection get params
func (o *NetbiosCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithNameRegistrationType adds the nameRegistrationType to the netbios collection get params
func (o *NetbiosCollectionGetParams) WithNameRegistrationType(nameRegistrationType *string) *NetbiosCollectionGetParams {
	o.SetNameRegistrationType(nameRegistrationType)
	return o
}

// SetNameRegistrationType adds the nameRegistrationType to the netbios collection get params
func (o *NetbiosCollectionGetParams) SetNameRegistrationType(nameRegistrationType *string) {
	o.NameRegistrationType = nameRegistrationType
}

// WithNodeName adds the nodeName to the netbios collection get params
func (o *NetbiosCollectionGetParams) WithNodeName(nodeName *string) *NetbiosCollectionGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the netbios collection get params
func (o *NetbiosCollectionGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the netbios collection get params
func (o *NetbiosCollectionGetParams) WithNodeUUID(nodeUUID *string) *NetbiosCollectionGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the netbios collection get params
func (o *NetbiosCollectionGetParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOrderBy adds the orderBy to the netbios collection get params
func (o *NetbiosCollectionGetParams) WithOrderBy(orderBy []string) *NetbiosCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the netbios collection get params
func (o *NetbiosCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the netbios collection get params
func (o *NetbiosCollectionGetParams) WithReturnRecords(returnRecords *bool) *NetbiosCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the netbios collection get params
func (o *NetbiosCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the netbios collection get params
func (o *NetbiosCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *NetbiosCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the netbios collection get params
func (o *NetbiosCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the netbios collection get params
func (o *NetbiosCollectionGetParams) WithScope(scope *string) *NetbiosCollectionGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the netbios collection get params
func (o *NetbiosCollectionGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithState adds the state to the netbios collection get params
func (o *NetbiosCollectionGetParams) WithState(state *string) *NetbiosCollectionGetParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the netbios collection get params
func (o *NetbiosCollectionGetParams) SetState(state *string) {
	o.State = state
}

// WithSuffix adds the suffix to the netbios collection get params
func (o *NetbiosCollectionGetParams) WithSuffix(suffix *string) *NetbiosCollectionGetParams {
	o.SetSuffix(suffix)
	return o
}

// SetSuffix adds the suffix to the netbios collection get params
func (o *NetbiosCollectionGetParams) SetSuffix(suffix *string) {
	o.Suffix = suffix
}

// WithSvmName adds the svmName to the netbios collection get params
func (o *NetbiosCollectionGetParams) WithSvmName(svmName *string) *NetbiosCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the netbios collection get params
func (o *NetbiosCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the netbios collection get params
func (o *NetbiosCollectionGetParams) WithSvmUUID(svmUUID *string) *NetbiosCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the netbios collection get params
func (o *NetbiosCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithTimeLeft adds the timeLeft to the netbios collection get params
func (o *NetbiosCollectionGetParams) WithTimeLeft(timeLeft *int64) *NetbiosCollectionGetParams {
	o.SetTimeLeft(timeLeft)
	return o
}

// SetTimeLeft adds the timeLeft to the netbios collection get params
func (o *NetbiosCollectionGetParams) SetTimeLeft(timeLeft *int64) {
	o.TimeLeft = timeLeft
}

// WithWinsServersIP adds the winsServersIP to the netbios collection get params
func (o *NetbiosCollectionGetParams) WithWinsServersIP(winsServersIP *string) *NetbiosCollectionGetParams {
	o.SetWinsServersIP(winsServersIP)
	return o
}

// SetWinsServersIP adds the winsServersIp to the netbios collection get params
func (o *NetbiosCollectionGetParams) SetWinsServersIP(winsServersIP *string) {
	o.WinsServersIP = winsServersIP
}

// WithWinsServersState adds the winsServersState to the netbios collection get params
func (o *NetbiosCollectionGetParams) WithWinsServersState(winsServersState *string) *NetbiosCollectionGetParams {
	o.SetWinsServersState(winsServersState)
	return o
}

// SetWinsServersState adds the winsServersState to the netbios collection get params
func (o *NetbiosCollectionGetParams) SetWinsServersState(winsServersState *string) {
	o.WinsServersState = winsServersState
}

// WriteToRequest writes these params to a swagger request
func (o *NetbiosCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Interfaces != nil {

		// query param interfaces
		var qrInterfaces string

		if o.Interfaces != nil {
			qrInterfaces = *o.Interfaces
		}
		qInterfaces := qrInterfaces
		if qInterfaces != "" {

			if err := r.SetQueryParam("interfaces", qInterfaces); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Mode != nil {

		// query param mode
		var qrMode string

		if o.Mode != nil {
			qrMode = *o.Mode
		}
		qMode := qrMode
		if qMode != "" {

			if err := r.SetQueryParam("mode", qMode); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NameRegistrationType != nil {

		// query param name_registration_type
		var qrNameRegistrationType string

		if o.NameRegistrationType != nil {
			qrNameRegistrationType = *o.NameRegistrationType
		}
		qNameRegistrationType := qrNameRegistrationType
		if qNameRegistrationType != "" {

			if err := r.SetQueryParam("name_registration_type", qNameRegistrationType); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.Suffix != nil {

		// query param suffix
		var qrSuffix string

		if o.Suffix != nil {
			qrSuffix = *o.Suffix
		}
		qSuffix := qrSuffix
		if qSuffix != "" {

			if err := r.SetQueryParam("suffix", qSuffix); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.TimeLeft != nil {

		// query param time_left
		var qrTimeLeft int64

		if o.TimeLeft != nil {
			qrTimeLeft = *o.TimeLeft
		}
		qTimeLeft := swag.FormatInt64(qrTimeLeft)
		if qTimeLeft != "" {

			if err := r.SetQueryParam("time_left", qTimeLeft); err != nil {
				return err
			}
		}
	}

	if o.WinsServersIP != nil {

		// query param wins_servers.ip
		var qrWinsServersIP string

		if o.WinsServersIP != nil {
			qrWinsServersIP = *o.WinsServersIP
		}
		qWinsServersIP := qrWinsServersIP
		if qWinsServersIP != "" {

			if err := r.SetQueryParam("wins_servers.ip", qWinsServersIP); err != nil {
				return err
			}
		}
	}

	if o.WinsServersState != nil {

		// query param wins_servers.state
		var qrWinsServersState string

		if o.WinsServersState != nil {
			qrWinsServersState = *o.WinsServersState
		}
		qWinsServersState := qrWinsServersState
		if qWinsServersState != "" {

			if err := r.SetQueryParam("wins_servers.state", qWinsServersState); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamNetbiosCollectionGet binds the parameter fields
func (o *NetbiosCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamNetbiosCollectionGet binds the parameter order_by
func (o *NetbiosCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
