// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNfsClientsMapGetParams creates a new NfsClientsMapGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNfsClientsMapGetParams() *NfsClientsMapGetParams {
	return &NfsClientsMapGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNfsClientsMapGetParamsWithTimeout creates a new NfsClientsMapGetParams object
// with the ability to set a timeout on a request.
func NewNfsClientsMapGetParamsWithTimeout(timeout time.Duration) *NfsClientsMapGetParams {
	return &NfsClientsMapGetParams{
		timeout: timeout,
	}
}

// NewNfsClientsMapGetParamsWithContext creates a new NfsClientsMapGetParams object
// with the ability to set a context for a request.
func NewNfsClientsMapGetParamsWithContext(ctx context.Context) *NfsClientsMapGetParams {
	return &NfsClientsMapGetParams{
		Context: ctx,
	}
}

// NewNfsClientsMapGetParamsWithHTTPClient creates a new NfsClientsMapGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewNfsClientsMapGetParamsWithHTTPClient(client *http.Client) *NfsClientsMapGetParams {
	return &NfsClientsMapGetParams{
		HTTPClient: client,
	}
}

/*
NfsClientsMapGetParams contains all the parameters to send to the API endpoint

	for the nfs clients map get operation.

	Typically these are written to a http.Request.
*/
type NfsClientsMapGetParams struct {

	/* ClientIps.

	   Filter by client_ips
	*/
	ClientIps *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* ServerIP.

	   Filter by server_ip
	*/
	ServerIP *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the nfs clients map get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NfsClientsMapGetParams) WithDefaults() *NfsClientsMapGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the nfs clients map get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NfsClientsMapGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := NfsClientsMapGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the nfs clients map get params
func (o *NfsClientsMapGetParams) WithTimeout(timeout time.Duration) *NfsClientsMapGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the nfs clients map get params
func (o *NfsClientsMapGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the nfs clients map get params
func (o *NfsClientsMapGetParams) WithContext(ctx context.Context) *NfsClientsMapGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the nfs clients map get params
func (o *NfsClientsMapGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the nfs clients map get params
func (o *NfsClientsMapGetParams) WithHTTPClient(client *http.Client) *NfsClientsMapGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the nfs clients map get params
func (o *NfsClientsMapGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClientIps adds the clientIps to the nfs clients map get params
func (o *NfsClientsMapGetParams) WithClientIps(clientIps *string) *NfsClientsMapGetParams {
	o.SetClientIps(clientIps)
	return o
}

// SetClientIps adds the clientIps to the nfs clients map get params
func (o *NfsClientsMapGetParams) SetClientIps(clientIps *string) {
	o.ClientIps = clientIps
}

// WithFields adds the fields to the nfs clients map get params
func (o *NfsClientsMapGetParams) WithFields(fields []string) *NfsClientsMapGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the nfs clients map get params
func (o *NfsClientsMapGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the nfs clients map get params
func (o *NfsClientsMapGetParams) WithMaxRecords(maxRecords *int64) *NfsClientsMapGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the nfs clients map get params
func (o *NfsClientsMapGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithNodeName adds the nodeName to the nfs clients map get params
func (o *NfsClientsMapGetParams) WithNodeName(nodeName *string) *NfsClientsMapGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the nfs clients map get params
func (o *NfsClientsMapGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the nfs clients map get params
func (o *NfsClientsMapGetParams) WithNodeUUID(nodeUUID *string) *NfsClientsMapGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the nfs clients map get params
func (o *NfsClientsMapGetParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOrderBy adds the orderBy to the nfs clients map get params
func (o *NfsClientsMapGetParams) WithOrderBy(orderBy []string) *NfsClientsMapGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the nfs clients map get params
func (o *NfsClientsMapGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the nfs clients map get params
func (o *NfsClientsMapGetParams) WithReturnRecords(returnRecords *bool) *NfsClientsMapGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the nfs clients map get params
func (o *NfsClientsMapGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the nfs clients map get params
func (o *NfsClientsMapGetParams) WithReturnTimeout(returnTimeout *int64) *NfsClientsMapGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the nfs clients map get params
func (o *NfsClientsMapGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithServerIP adds the serverIP to the nfs clients map get params
func (o *NfsClientsMapGetParams) WithServerIP(serverIP *string) *NfsClientsMapGetParams {
	o.SetServerIP(serverIP)
	return o
}

// SetServerIP adds the serverIp to the nfs clients map get params
func (o *NfsClientsMapGetParams) SetServerIP(serverIP *string) {
	o.ServerIP = serverIP
}

// WithSvmName adds the svmName to the nfs clients map get params
func (o *NfsClientsMapGetParams) WithSvmName(svmName *string) *NfsClientsMapGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the nfs clients map get params
func (o *NfsClientsMapGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the nfs clients map get params
func (o *NfsClientsMapGetParams) WithSvmUUID(svmUUID *string) *NfsClientsMapGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the nfs clients map get params
func (o *NfsClientsMapGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *NfsClientsMapGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ClientIps != nil {

		// query param client_ips
		var qrClientIps string

		if o.ClientIps != nil {
			qrClientIps = *o.ClientIps
		}
		qClientIps := qrClientIps
		if qClientIps != "" {

			if err := r.SetQueryParam("client_ips", qClientIps); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.ServerIP != nil {

		// query param server_ip
		var qrServerIP string

		if o.ServerIP != nil {
			qrServerIP = *o.ServerIP
		}
		qServerIP := qrServerIP
		if qServerIP != "" {

			if err := r.SetQueryParam("server_ip", qServerIP); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamNfsClientsMapGet binds the parameter fields
func (o *NfsClientsMapGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamNfsClientsMapGet binds the parameter order_by
func (o *NfsClientsMapGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
