// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNfsCollectionPerformanceMetricsGetParams creates a new NfsCollectionPerformanceMetricsGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNfsCollectionPerformanceMetricsGetParams() *NfsCollectionPerformanceMetricsGetParams {
	return &NfsCollectionPerformanceMetricsGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNfsCollectionPerformanceMetricsGetParamsWithTimeout creates a new NfsCollectionPerformanceMetricsGetParams object
// with the ability to set a timeout on a request.
func NewNfsCollectionPerformanceMetricsGetParamsWithTimeout(timeout time.Duration) *NfsCollectionPerformanceMetricsGetParams {
	return &NfsCollectionPerformanceMetricsGetParams{
		timeout: timeout,
	}
}

// NewNfsCollectionPerformanceMetricsGetParamsWithContext creates a new NfsCollectionPerformanceMetricsGetParams object
// with the ability to set a context for a request.
func NewNfsCollectionPerformanceMetricsGetParamsWithContext(ctx context.Context) *NfsCollectionPerformanceMetricsGetParams {
	return &NfsCollectionPerformanceMetricsGetParams{
		Context: ctx,
	}
}

// NewNfsCollectionPerformanceMetricsGetParamsWithHTTPClient creates a new NfsCollectionPerformanceMetricsGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewNfsCollectionPerformanceMetricsGetParamsWithHTTPClient(client *http.Client) *NfsCollectionPerformanceMetricsGetParams {
	return &NfsCollectionPerformanceMetricsGetParams{
		HTTPClient: client,
	}
}

/*
NfsCollectionPerformanceMetricsGetParams contains all the parameters to send to the API endpoint

	for the nfs collection performance metrics get operation.

	Typically these are written to a http.Request.
*/
type NfsCollectionPerformanceMetricsGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Interval.

	     The time range for the data. Examples can be 1h, 1d, 1m, 1w, 1y.
	The period for each time range is as follows:
	* 1h: Metrics over the most recent hour sampled over 15 seconds.
	* 1d: Metrics over the most recent day sampled over 5 minutes.
	* 1w: Metrics over the most recent week sampled over 30 minutes.
	* 1m: Metrics over the most recent month sampled over 2 hours.
	* 1y: Metrics over the most recent year sampled over a day.


	     Default: "1h"
	*/
	Interval *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmUUID.

	   Unique identifier of the SVM.
	*/
	SvmUUID string

	/* Timestamp.

	   Filter by timestamp
	*/
	Timestamp *string

	/* V3Duration.

	   Filter by v3.duration
	*/
	V3Duration *string

	/* V3IopsOther.

	   Filter by v3.iops.other
	*/
	V3IopsOther *int64

	/* V3IopsRead.

	   Filter by v3.iops.read
	*/
	V3IopsRead *int64

	/* V3IopsTotal.

	   Filter by v3.iops.total
	*/
	V3IopsTotal *int64

	/* V3IopsWrite.

	   Filter by v3.iops.write
	*/
	V3IopsWrite *int64

	/* V3LatencyOther.

	   Filter by v3.latency.other
	*/
	V3LatencyOther *int64

	/* V3LatencyRead.

	   Filter by v3.latency.read
	*/
	V3LatencyRead *int64

	/* V3LatencyTotal.

	   Filter by v3.latency.total
	*/
	V3LatencyTotal *int64

	/* V3LatencyWrite.

	   Filter by v3.latency.write
	*/
	V3LatencyWrite *int64

	/* V3Status.

	   Filter by v3.status
	*/
	V3Status *string

	/* V3ThroughputRead.

	   Filter by v3.throughput.read
	*/
	V3ThroughputRead *int64

	/* V3ThroughputTotal.

	   Filter by v3.throughput.total
	*/
	V3ThroughputTotal *int64

	/* V3ThroughputWrite.

	   Filter by v3.throughput.write
	*/
	V3ThroughputWrite *int64

	/* V4Duration.

	   Filter by v4.duration
	*/
	V4Duration *string

	/* V4IopsOther.

	   Filter by v4.iops.other
	*/
	V4IopsOther *int64

	/* V4IopsRead.

	   Filter by v4.iops.read
	*/
	V4IopsRead *int64

	/* V4IopsTotal.

	   Filter by v4.iops.total
	*/
	V4IopsTotal *int64

	/* V4IopsWrite.

	   Filter by v4.iops.write
	*/
	V4IopsWrite *int64

	/* V4LatencyOther.

	   Filter by v4.latency.other
	*/
	V4LatencyOther *int64

	/* V4LatencyRead.

	   Filter by v4.latency.read
	*/
	V4LatencyRead *int64

	/* V4LatencyTotal.

	   Filter by v4.latency.total
	*/
	V4LatencyTotal *int64

	/* V4LatencyWrite.

	   Filter by v4.latency.write
	*/
	V4LatencyWrite *int64

	/* V4Status.

	   Filter by v4.status
	*/
	V4Status *string

	/* V4ThroughputRead.

	   Filter by v4.throughput.read
	*/
	V4ThroughputRead *int64

	/* V4ThroughputTotal.

	   Filter by v4.throughput.total
	*/
	V4ThroughputTotal *int64

	/* V4ThroughputWrite.

	   Filter by v4.throughput.write
	*/
	V4ThroughputWrite *int64

	/* V41Duration.

	   Filter by v41.duration
	*/
	V41Duration *string

	/* V41IopsOther.

	   Filter by v41.iops.other
	*/
	V41IopsOther *int64

	/* V41IopsRead.

	   Filter by v41.iops.read
	*/
	V41IopsRead *int64

	/* V41IopsTotal.

	   Filter by v41.iops.total
	*/
	V41IopsTotal *int64

	/* V41IopsWrite.

	   Filter by v41.iops.write
	*/
	V41IopsWrite *int64

	/* V41LatencyOther.

	   Filter by v41.latency.other
	*/
	V41LatencyOther *int64

	/* V41LatencyRead.

	   Filter by v41.latency.read
	*/
	V41LatencyRead *int64

	/* V41LatencyTotal.

	   Filter by v41.latency.total
	*/
	V41LatencyTotal *int64

	/* V41LatencyWrite.

	   Filter by v41.latency.write
	*/
	V41LatencyWrite *int64

	/* V41Status.

	   Filter by v41.status
	*/
	V41Status *string

	/* V41ThroughputRead.

	   Filter by v41.throughput.read
	*/
	V41ThroughputRead *int64

	/* V41ThroughputTotal.

	   Filter by v41.throughput.total
	*/
	V41ThroughputTotal *int64

	/* V41ThroughputWrite.

	   Filter by v41.throughput.write
	*/
	V41ThroughputWrite *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the nfs collection performance metrics get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NfsCollectionPerformanceMetricsGetParams) WithDefaults() *NfsCollectionPerformanceMetricsGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the nfs collection performance metrics get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NfsCollectionPerformanceMetricsGetParams) SetDefaults() {
	var (
		intervalDefault = string("1h")

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := NfsCollectionPerformanceMetricsGetParams{
		Interval:      &intervalDefault,
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithTimeout(timeout time.Duration) *NfsCollectionPerformanceMetricsGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithContext(ctx context.Context) *NfsCollectionPerformanceMetricsGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithHTTPClient(client *http.Client) *NfsCollectionPerformanceMetricsGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithFields(fields []string) *NfsCollectionPerformanceMetricsGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithInterval adds the interval to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithInterval(interval *string) *NfsCollectionPerformanceMetricsGetParams {
	o.SetInterval(interval)
	return o
}

// SetInterval adds the interval to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetInterval(interval *string) {
	o.Interval = interval
}

// WithMaxRecords adds the maxRecords to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithMaxRecords(maxRecords *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithOrderBy(orderBy []string) *NfsCollectionPerformanceMetricsGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithReturnRecords(returnRecords *bool) *NfsCollectionPerformanceMetricsGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithReturnTimeout(returnTimeout *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmUUID adds the svmUUID to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithSvmUUID(svmUUID string) *NfsCollectionPerformanceMetricsGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithTimestamp adds the timestamp to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithTimestamp(timestamp *string) *NfsCollectionPerformanceMetricsGetParams {
	o.SetTimestamp(timestamp)
	return o
}

// SetTimestamp adds the timestamp to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetTimestamp(timestamp *string) {
	o.Timestamp = timestamp
}

// WithV3Duration adds the v3Duration to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV3Duration(v3Duration *string) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV3Duration(v3Duration)
	return o
}

// SetV3Duration adds the v3Duration to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV3Duration(v3Duration *string) {
	o.V3Duration = v3Duration
}

// WithV3IopsOther adds the v3IopsOther to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV3IopsOther(v3IopsOther *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV3IopsOther(v3IopsOther)
	return o
}

// SetV3IopsOther adds the v3IopsOther to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV3IopsOther(v3IopsOther *int64) {
	o.V3IopsOther = v3IopsOther
}

// WithV3IopsRead adds the v3IopsRead to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV3IopsRead(v3IopsRead *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV3IopsRead(v3IopsRead)
	return o
}

// SetV3IopsRead adds the v3IopsRead to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV3IopsRead(v3IopsRead *int64) {
	o.V3IopsRead = v3IopsRead
}

// WithV3IopsTotal adds the v3IopsTotal to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV3IopsTotal(v3IopsTotal *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV3IopsTotal(v3IopsTotal)
	return o
}

// SetV3IopsTotal adds the v3IopsTotal to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV3IopsTotal(v3IopsTotal *int64) {
	o.V3IopsTotal = v3IopsTotal
}

// WithV3IopsWrite adds the v3IopsWrite to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV3IopsWrite(v3IopsWrite *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV3IopsWrite(v3IopsWrite)
	return o
}

// SetV3IopsWrite adds the v3IopsWrite to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV3IopsWrite(v3IopsWrite *int64) {
	o.V3IopsWrite = v3IopsWrite
}

// WithV3LatencyOther adds the v3LatencyOther to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV3LatencyOther(v3LatencyOther *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV3LatencyOther(v3LatencyOther)
	return o
}

// SetV3LatencyOther adds the v3LatencyOther to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV3LatencyOther(v3LatencyOther *int64) {
	o.V3LatencyOther = v3LatencyOther
}

// WithV3LatencyRead adds the v3LatencyRead to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV3LatencyRead(v3LatencyRead *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV3LatencyRead(v3LatencyRead)
	return o
}

// SetV3LatencyRead adds the v3LatencyRead to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV3LatencyRead(v3LatencyRead *int64) {
	o.V3LatencyRead = v3LatencyRead
}

// WithV3LatencyTotal adds the v3LatencyTotal to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV3LatencyTotal(v3LatencyTotal *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV3LatencyTotal(v3LatencyTotal)
	return o
}

// SetV3LatencyTotal adds the v3LatencyTotal to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV3LatencyTotal(v3LatencyTotal *int64) {
	o.V3LatencyTotal = v3LatencyTotal
}

// WithV3LatencyWrite adds the v3LatencyWrite to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV3LatencyWrite(v3LatencyWrite *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV3LatencyWrite(v3LatencyWrite)
	return o
}

// SetV3LatencyWrite adds the v3LatencyWrite to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV3LatencyWrite(v3LatencyWrite *int64) {
	o.V3LatencyWrite = v3LatencyWrite
}

// WithV3Status adds the v3Status to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV3Status(v3Status *string) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV3Status(v3Status)
	return o
}

// SetV3Status adds the v3Status to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV3Status(v3Status *string) {
	o.V3Status = v3Status
}

// WithV3ThroughputRead adds the v3ThroughputRead to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV3ThroughputRead(v3ThroughputRead *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV3ThroughputRead(v3ThroughputRead)
	return o
}

// SetV3ThroughputRead adds the v3ThroughputRead to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV3ThroughputRead(v3ThroughputRead *int64) {
	o.V3ThroughputRead = v3ThroughputRead
}

// WithV3ThroughputTotal adds the v3ThroughputTotal to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV3ThroughputTotal(v3ThroughputTotal *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV3ThroughputTotal(v3ThroughputTotal)
	return o
}

// SetV3ThroughputTotal adds the v3ThroughputTotal to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV3ThroughputTotal(v3ThroughputTotal *int64) {
	o.V3ThroughputTotal = v3ThroughputTotal
}

// WithV3ThroughputWrite adds the v3ThroughputWrite to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV3ThroughputWrite(v3ThroughputWrite *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV3ThroughputWrite(v3ThroughputWrite)
	return o
}

// SetV3ThroughputWrite adds the v3ThroughputWrite to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV3ThroughputWrite(v3ThroughputWrite *int64) {
	o.V3ThroughputWrite = v3ThroughputWrite
}

// WithV4Duration adds the v4Duration to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV4Duration(v4Duration *string) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV4Duration(v4Duration)
	return o
}

// SetV4Duration adds the v4Duration to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV4Duration(v4Duration *string) {
	o.V4Duration = v4Duration
}

// WithV4IopsOther adds the v4IopsOther to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV4IopsOther(v4IopsOther *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV4IopsOther(v4IopsOther)
	return o
}

// SetV4IopsOther adds the v4IopsOther to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV4IopsOther(v4IopsOther *int64) {
	o.V4IopsOther = v4IopsOther
}

// WithV4IopsRead adds the v4IopsRead to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV4IopsRead(v4IopsRead *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV4IopsRead(v4IopsRead)
	return o
}

// SetV4IopsRead adds the v4IopsRead to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV4IopsRead(v4IopsRead *int64) {
	o.V4IopsRead = v4IopsRead
}

// WithV4IopsTotal adds the v4IopsTotal to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV4IopsTotal(v4IopsTotal *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV4IopsTotal(v4IopsTotal)
	return o
}

// SetV4IopsTotal adds the v4IopsTotal to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV4IopsTotal(v4IopsTotal *int64) {
	o.V4IopsTotal = v4IopsTotal
}

// WithV4IopsWrite adds the v4IopsWrite to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV4IopsWrite(v4IopsWrite *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV4IopsWrite(v4IopsWrite)
	return o
}

// SetV4IopsWrite adds the v4IopsWrite to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV4IopsWrite(v4IopsWrite *int64) {
	o.V4IopsWrite = v4IopsWrite
}

// WithV4LatencyOther adds the v4LatencyOther to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV4LatencyOther(v4LatencyOther *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV4LatencyOther(v4LatencyOther)
	return o
}

// SetV4LatencyOther adds the v4LatencyOther to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV4LatencyOther(v4LatencyOther *int64) {
	o.V4LatencyOther = v4LatencyOther
}

// WithV4LatencyRead adds the v4LatencyRead to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV4LatencyRead(v4LatencyRead *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV4LatencyRead(v4LatencyRead)
	return o
}

// SetV4LatencyRead adds the v4LatencyRead to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV4LatencyRead(v4LatencyRead *int64) {
	o.V4LatencyRead = v4LatencyRead
}

// WithV4LatencyTotal adds the v4LatencyTotal to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV4LatencyTotal(v4LatencyTotal *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV4LatencyTotal(v4LatencyTotal)
	return o
}

// SetV4LatencyTotal adds the v4LatencyTotal to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV4LatencyTotal(v4LatencyTotal *int64) {
	o.V4LatencyTotal = v4LatencyTotal
}

// WithV4LatencyWrite adds the v4LatencyWrite to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV4LatencyWrite(v4LatencyWrite *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV4LatencyWrite(v4LatencyWrite)
	return o
}

// SetV4LatencyWrite adds the v4LatencyWrite to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV4LatencyWrite(v4LatencyWrite *int64) {
	o.V4LatencyWrite = v4LatencyWrite
}

// WithV4Status adds the v4Status to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV4Status(v4Status *string) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV4Status(v4Status)
	return o
}

// SetV4Status adds the v4Status to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV4Status(v4Status *string) {
	o.V4Status = v4Status
}

// WithV4ThroughputRead adds the v4ThroughputRead to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV4ThroughputRead(v4ThroughputRead *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV4ThroughputRead(v4ThroughputRead)
	return o
}

// SetV4ThroughputRead adds the v4ThroughputRead to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV4ThroughputRead(v4ThroughputRead *int64) {
	o.V4ThroughputRead = v4ThroughputRead
}

// WithV4ThroughputTotal adds the v4ThroughputTotal to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV4ThroughputTotal(v4ThroughputTotal *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV4ThroughputTotal(v4ThroughputTotal)
	return o
}

// SetV4ThroughputTotal adds the v4ThroughputTotal to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV4ThroughputTotal(v4ThroughputTotal *int64) {
	o.V4ThroughputTotal = v4ThroughputTotal
}

// WithV4ThroughputWrite adds the v4ThroughputWrite to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV4ThroughputWrite(v4ThroughputWrite *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV4ThroughputWrite(v4ThroughputWrite)
	return o
}

// SetV4ThroughputWrite adds the v4ThroughputWrite to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV4ThroughputWrite(v4ThroughputWrite *int64) {
	o.V4ThroughputWrite = v4ThroughputWrite
}

// WithV41Duration adds the v41Duration to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV41Duration(v41Duration *string) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV41Duration(v41Duration)
	return o
}

// SetV41Duration adds the v41Duration to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV41Duration(v41Duration *string) {
	o.V41Duration = v41Duration
}

// WithV41IopsOther adds the v41IopsOther to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV41IopsOther(v41IopsOther *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV41IopsOther(v41IopsOther)
	return o
}

// SetV41IopsOther adds the v41IopsOther to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV41IopsOther(v41IopsOther *int64) {
	o.V41IopsOther = v41IopsOther
}

// WithV41IopsRead adds the v41IopsRead to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV41IopsRead(v41IopsRead *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV41IopsRead(v41IopsRead)
	return o
}

// SetV41IopsRead adds the v41IopsRead to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV41IopsRead(v41IopsRead *int64) {
	o.V41IopsRead = v41IopsRead
}

// WithV41IopsTotal adds the v41IopsTotal to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV41IopsTotal(v41IopsTotal *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV41IopsTotal(v41IopsTotal)
	return o
}

// SetV41IopsTotal adds the v41IopsTotal to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV41IopsTotal(v41IopsTotal *int64) {
	o.V41IopsTotal = v41IopsTotal
}

// WithV41IopsWrite adds the v41IopsWrite to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV41IopsWrite(v41IopsWrite *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV41IopsWrite(v41IopsWrite)
	return o
}

// SetV41IopsWrite adds the v41IopsWrite to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV41IopsWrite(v41IopsWrite *int64) {
	o.V41IopsWrite = v41IopsWrite
}

// WithV41LatencyOther adds the v41LatencyOther to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV41LatencyOther(v41LatencyOther *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV41LatencyOther(v41LatencyOther)
	return o
}

// SetV41LatencyOther adds the v41LatencyOther to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV41LatencyOther(v41LatencyOther *int64) {
	o.V41LatencyOther = v41LatencyOther
}

// WithV41LatencyRead adds the v41LatencyRead to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV41LatencyRead(v41LatencyRead *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV41LatencyRead(v41LatencyRead)
	return o
}

// SetV41LatencyRead adds the v41LatencyRead to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV41LatencyRead(v41LatencyRead *int64) {
	o.V41LatencyRead = v41LatencyRead
}

// WithV41LatencyTotal adds the v41LatencyTotal to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV41LatencyTotal(v41LatencyTotal *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV41LatencyTotal(v41LatencyTotal)
	return o
}

// SetV41LatencyTotal adds the v41LatencyTotal to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV41LatencyTotal(v41LatencyTotal *int64) {
	o.V41LatencyTotal = v41LatencyTotal
}

// WithV41LatencyWrite adds the v41LatencyWrite to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV41LatencyWrite(v41LatencyWrite *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV41LatencyWrite(v41LatencyWrite)
	return o
}

// SetV41LatencyWrite adds the v41LatencyWrite to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV41LatencyWrite(v41LatencyWrite *int64) {
	o.V41LatencyWrite = v41LatencyWrite
}

// WithV41Status adds the v41Status to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV41Status(v41Status *string) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV41Status(v41Status)
	return o
}

// SetV41Status adds the v41Status to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV41Status(v41Status *string) {
	o.V41Status = v41Status
}

// WithV41ThroughputRead adds the v41ThroughputRead to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV41ThroughputRead(v41ThroughputRead *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV41ThroughputRead(v41ThroughputRead)
	return o
}

// SetV41ThroughputRead adds the v41ThroughputRead to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV41ThroughputRead(v41ThroughputRead *int64) {
	o.V41ThroughputRead = v41ThroughputRead
}

// WithV41ThroughputTotal adds the v41ThroughputTotal to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV41ThroughputTotal(v41ThroughputTotal *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV41ThroughputTotal(v41ThroughputTotal)
	return o
}

// SetV41ThroughputTotal adds the v41ThroughputTotal to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV41ThroughputTotal(v41ThroughputTotal *int64) {
	o.V41ThroughputTotal = v41ThroughputTotal
}

// WithV41ThroughputWrite adds the v41ThroughputWrite to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) WithV41ThroughputWrite(v41ThroughputWrite *int64) *NfsCollectionPerformanceMetricsGetParams {
	o.SetV41ThroughputWrite(v41ThroughputWrite)
	return o
}

// SetV41ThroughputWrite adds the v41ThroughputWrite to the nfs collection performance metrics get params
func (o *NfsCollectionPerformanceMetricsGetParams) SetV41ThroughputWrite(v41ThroughputWrite *int64) {
	o.V41ThroughputWrite = v41ThroughputWrite
}

// WriteToRequest writes these params to a swagger request
func (o *NfsCollectionPerformanceMetricsGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Interval != nil {

		// query param interval
		var qrInterval string

		if o.Interval != nil {
			qrInterval = *o.Interval
		}
		qInterval := qrInterval
		if qInterval != "" {

			if err := r.SetQueryParam("interval", qInterval); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if o.Timestamp != nil {

		// query param timestamp
		var qrTimestamp string

		if o.Timestamp != nil {
			qrTimestamp = *o.Timestamp
		}
		qTimestamp := qrTimestamp
		if qTimestamp != "" {

			if err := r.SetQueryParam("timestamp", qTimestamp); err != nil {
				return err
			}
		}
	}

	if o.V3Duration != nil {

		// query param v3.duration
		var qrV3Duration string

		if o.V3Duration != nil {
			qrV3Duration = *o.V3Duration
		}
		qV3Duration := qrV3Duration
		if qV3Duration != "" {

			if err := r.SetQueryParam("v3.duration", qV3Duration); err != nil {
				return err
			}
		}
	}

	if o.V3IopsOther != nil {

		// query param v3.iops.other
		var qrV3IopsOther int64

		if o.V3IopsOther != nil {
			qrV3IopsOther = *o.V3IopsOther
		}
		qV3IopsOther := swag.FormatInt64(qrV3IopsOther)
		if qV3IopsOther != "" {

			if err := r.SetQueryParam("v3.iops.other", qV3IopsOther); err != nil {
				return err
			}
		}
	}

	if o.V3IopsRead != nil {

		// query param v3.iops.read
		var qrV3IopsRead int64

		if o.V3IopsRead != nil {
			qrV3IopsRead = *o.V3IopsRead
		}
		qV3IopsRead := swag.FormatInt64(qrV3IopsRead)
		if qV3IopsRead != "" {

			if err := r.SetQueryParam("v3.iops.read", qV3IopsRead); err != nil {
				return err
			}
		}
	}

	if o.V3IopsTotal != nil {

		// query param v3.iops.total
		var qrV3IopsTotal int64

		if o.V3IopsTotal != nil {
			qrV3IopsTotal = *o.V3IopsTotal
		}
		qV3IopsTotal := swag.FormatInt64(qrV3IopsTotal)
		if qV3IopsTotal != "" {

			if err := r.SetQueryParam("v3.iops.total", qV3IopsTotal); err != nil {
				return err
			}
		}
	}

	if o.V3IopsWrite != nil {

		// query param v3.iops.write
		var qrV3IopsWrite int64

		if o.V3IopsWrite != nil {
			qrV3IopsWrite = *o.V3IopsWrite
		}
		qV3IopsWrite := swag.FormatInt64(qrV3IopsWrite)
		if qV3IopsWrite != "" {

			if err := r.SetQueryParam("v3.iops.write", qV3IopsWrite); err != nil {
				return err
			}
		}
	}

	if o.V3LatencyOther != nil {

		// query param v3.latency.other
		var qrV3LatencyOther int64

		if o.V3LatencyOther != nil {
			qrV3LatencyOther = *o.V3LatencyOther
		}
		qV3LatencyOther := swag.FormatInt64(qrV3LatencyOther)
		if qV3LatencyOther != "" {

			if err := r.SetQueryParam("v3.latency.other", qV3LatencyOther); err != nil {
				return err
			}
		}
	}

	if o.V3LatencyRead != nil {

		// query param v3.latency.read
		var qrV3LatencyRead int64

		if o.V3LatencyRead != nil {
			qrV3LatencyRead = *o.V3LatencyRead
		}
		qV3LatencyRead := swag.FormatInt64(qrV3LatencyRead)
		if qV3LatencyRead != "" {

			if err := r.SetQueryParam("v3.latency.read", qV3LatencyRead); err != nil {
				return err
			}
		}
	}

	if o.V3LatencyTotal != nil {

		// query param v3.latency.total
		var qrV3LatencyTotal int64

		if o.V3LatencyTotal != nil {
			qrV3LatencyTotal = *o.V3LatencyTotal
		}
		qV3LatencyTotal := swag.FormatInt64(qrV3LatencyTotal)
		if qV3LatencyTotal != "" {

			if err := r.SetQueryParam("v3.latency.total", qV3LatencyTotal); err != nil {
				return err
			}
		}
	}

	if o.V3LatencyWrite != nil {

		// query param v3.latency.write
		var qrV3LatencyWrite int64

		if o.V3LatencyWrite != nil {
			qrV3LatencyWrite = *o.V3LatencyWrite
		}
		qV3LatencyWrite := swag.FormatInt64(qrV3LatencyWrite)
		if qV3LatencyWrite != "" {

			if err := r.SetQueryParam("v3.latency.write", qV3LatencyWrite); err != nil {
				return err
			}
		}
	}

	if o.V3Status != nil {

		// query param v3.status
		var qrV3Status string

		if o.V3Status != nil {
			qrV3Status = *o.V3Status
		}
		qV3Status := qrV3Status
		if qV3Status != "" {

			if err := r.SetQueryParam("v3.status", qV3Status); err != nil {
				return err
			}
		}
	}

	if o.V3ThroughputRead != nil {

		// query param v3.throughput.read
		var qrV3ThroughputRead int64

		if o.V3ThroughputRead != nil {
			qrV3ThroughputRead = *o.V3ThroughputRead
		}
		qV3ThroughputRead := swag.FormatInt64(qrV3ThroughputRead)
		if qV3ThroughputRead != "" {

			if err := r.SetQueryParam("v3.throughput.read", qV3ThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.V3ThroughputTotal != nil {

		// query param v3.throughput.total
		var qrV3ThroughputTotal int64

		if o.V3ThroughputTotal != nil {
			qrV3ThroughputTotal = *o.V3ThroughputTotal
		}
		qV3ThroughputTotal := swag.FormatInt64(qrV3ThroughputTotal)
		if qV3ThroughputTotal != "" {

			if err := r.SetQueryParam("v3.throughput.total", qV3ThroughputTotal); err != nil {
				return err
			}
		}
	}

	if o.V3ThroughputWrite != nil {

		// query param v3.throughput.write
		var qrV3ThroughputWrite int64

		if o.V3ThroughputWrite != nil {
			qrV3ThroughputWrite = *o.V3ThroughputWrite
		}
		qV3ThroughputWrite := swag.FormatInt64(qrV3ThroughputWrite)
		if qV3ThroughputWrite != "" {

			if err := r.SetQueryParam("v3.throughput.write", qV3ThroughputWrite); err != nil {
				return err
			}
		}
	}

	if o.V4Duration != nil {

		// query param v4.duration
		var qrV4Duration string

		if o.V4Duration != nil {
			qrV4Duration = *o.V4Duration
		}
		qV4Duration := qrV4Duration
		if qV4Duration != "" {

			if err := r.SetQueryParam("v4.duration", qV4Duration); err != nil {
				return err
			}
		}
	}

	if o.V4IopsOther != nil {

		// query param v4.iops.other
		var qrV4IopsOther int64

		if o.V4IopsOther != nil {
			qrV4IopsOther = *o.V4IopsOther
		}
		qV4IopsOther := swag.FormatInt64(qrV4IopsOther)
		if qV4IopsOther != "" {

			if err := r.SetQueryParam("v4.iops.other", qV4IopsOther); err != nil {
				return err
			}
		}
	}

	if o.V4IopsRead != nil {

		// query param v4.iops.read
		var qrV4IopsRead int64

		if o.V4IopsRead != nil {
			qrV4IopsRead = *o.V4IopsRead
		}
		qV4IopsRead := swag.FormatInt64(qrV4IopsRead)
		if qV4IopsRead != "" {

			if err := r.SetQueryParam("v4.iops.read", qV4IopsRead); err != nil {
				return err
			}
		}
	}

	if o.V4IopsTotal != nil {

		// query param v4.iops.total
		var qrV4IopsTotal int64

		if o.V4IopsTotal != nil {
			qrV4IopsTotal = *o.V4IopsTotal
		}
		qV4IopsTotal := swag.FormatInt64(qrV4IopsTotal)
		if qV4IopsTotal != "" {

			if err := r.SetQueryParam("v4.iops.total", qV4IopsTotal); err != nil {
				return err
			}
		}
	}

	if o.V4IopsWrite != nil {

		// query param v4.iops.write
		var qrV4IopsWrite int64

		if o.V4IopsWrite != nil {
			qrV4IopsWrite = *o.V4IopsWrite
		}
		qV4IopsWrite := swag.FormatInt64(qrV4IopsWrite)
		if qV4IopsWrite != "" {

			if err := r.SetQueryParam("v4.iops.write", qV4IopsWrite); err != nil {
				return err
			}
		}
	}

	if o.V4LatencyOther != nil {

		// query param v4.latency.other
		var qrV4LatencyOther int64

		if o.V4LatencyOther != nil {
			qrV4LatencyOther = *o.V4LatencyOther
		}
		qV4LatencyOther := swag.FormatInt64(qrV4LatencyOther)
		if qV4LatencyOther != "" {

			if err := r.SetQueryParam("v4.latency.other", qV4LatencyOther); err != nil {
				return err
			}
		}
	}

	if o.V4LatencyRead != nil {

		// query param v4.latency.read
		var qrV4LatencyRead int64

		if o.V4LatencyRead != nil {
			qrV4LatencyRead = *o.V4LatencyRead
		}
		qV4LatencyRead := swag.FormatInt64(qrV4LatencyRead)
		if qV4LatencyRead != "" {

			if err := r.SetQueryParam("v4.latency.read", qV4LatencyRead); err != nil {
				return err
			}
		}
	}

	if o.V4LatencyTotal != nil {

		// query param v4.latency.total
		var qrV4LatencyTotal int64

		if o.V4LatencyTotal != nil {
			qrV4LatencyTotal = *o.V4LatencyTotal
		}
		qV4LatencyTotal := swag.FormatInt64(qrV4LatencyTotal)
		if qV4LatencyTotal != "" {

			if err := r.SetQueryParam("v4.latency.total", qV4LatencyTotal); err != nil {
				return err
			}
		}
	}

	if o.V4LatencyWrite != nil {

		// query param v4.latency.write
		var qrV4LatencyWrite int64

		if o.V4LatencyWrite != nil {
			qrV4LatencyWrite = *o.V4LatencyWrite
		}
		qV4LatencyWrite := swag.FormatInt64(qrV4LatencyWrite)
		if qV4LatencyWrite != "" {

			if err := r.SetQueryParam("v4.latency.write", qV4LatencyWrite); err != nil {
				return err
			}
		}
	}

	if o.V4Status != nil {

		// query param v4.status
		var qrV4Status string

		if o.V4Status != nil {
			qrV4Status = *o.V4Status
		}
		qV4Status := qrV4Status
		if qV4Status != "" {

			if err := r.SetQueryParam("v4.status", qV4Status); err != nil {
				return err
			}
		}
	}

	if o.V4ThroughputRead != nil {

		// query param v4.throughput.read
		var qrV4ThroughputRead int64

		if o.V4ThroughputRead != nil {
			qrV4ThroughputRead = *o.V4ThroughputRead
		}
		qV4ThroughputRead := swag.FormatInt64(qrV4ThroughputRead)
		if qV4ThroughputRead != "" {

			if err := r.SetQueryParam("v4.throughput.read", qV4ThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.V4ThroughputTotal != nil {

		// query param v4.throughput.total
		var qrV4ThroughputTotal int64

		if o.V4ThroughputTotal != nil {
			qrV4ThroughputTotal = *o.V4ThroughputTotal
		}
		qV4ThroughputTotal := swag.FormatInt64(qrV4ThroughputTotal)
		if qV4ThroughputTotal != "" {

			if err := r.SetQueryParam("v4.throughput.total", qV4ThroughputTotal); err != nil {
				return err
			}
		}
	}

	if o.V4ThroughputWrite != nil {

		// query param v4.throughput.write
		var qrV4ThroughputWrite int64

		if o.V4ThroughputWrite != nil {
			qrV4ThroughputWrite = *o.V4ThroughputWrite
		}
		qV4ThroughputWrite := swag.FormatInt64(qrV4ThroughputWrite)
		if qV4ThroughputWrite != "" {

			if err := r.SetQueryParam("v4.throughput.write", qV4ThroughputWrite); err != nil {
				return err
			}
		}
	}

	if o.V41Duration != nil {

		// query param v41.duration
		var qrV41Duration string

		if o.V41Duration != nil {
			qrV41Duration = *o.V41Duration
		}
		qV41Duration := qrV41Duration
		if qV41Duration != "" {

			if err := r.SetQueryParam("v41.duration", qV41Duration); err != nil {
				return err
			}
		}
	}

	if o.V41IopsOther != nil {

		// query param v41.iops.other
		var qrV41IopsOther int64

		if o.V41IopsOther != nil {
			qrV41IopsOther = *o.V41IopsOther
		}
		qV41IopsOther := swag.FormatInt64(qrV41IopsOther)
		if qV41IopsOther != "" {

			if err := r.SetQueryParam("v41.iops.other", qV41IopsOther); err != nil {
				return err
			}
		}
	}

	if o.V41IopsRead != nil {

		// query param v41.iops.read
		var qrV41IopsRead int64

		if o.V41IopsRead != nil {
			qrV41IopsRead = *o.V41IopsRead
		}
		qV41IopsRead := swag.FormatInt64(qrV41IopsRead)
		if qV41IopsRead != "" {

			if err := r.SetQueryParam("v41.iops.read", qV41IopsRead); err != nil {
				return err
			}
		}
	}

	if o.V41IopsTotal != nil {

		// query param v41.iops.total
		var qrV41IopsTotal int64

		if o.V41IopsTotal != nil {
			qrV41IopsTotal = *o.V41IopsTotal
		}
		qV41IopsTotal := swag.FormatInt64(qrV41IopsTotal)
		if qV41IopsTotal != "" {

			if err := r.SetQueryParam("v41.iops.total", qV41IopsTotal); err != nil {
				return err
			}
		}
	}

	if o.V41IopsWrite != nil {

		// query param v41.iops.write
		var qrV41IopsWrite int64

		if o.V41IopsWrite != nil {
			qrV41IopsWrite = *o.V41IopsWrite
		}
		qV41IopsWrite := swag.FormatInt64(qrV41IopsWrite)
		if qV41IopsWrite != "" {

			if err := r.SetQueryParam("v41.iops.write", qV41IopsWrite); err != nil {
				return err
			}
		}
	}

	if o.V41LatencyOther != nil {

		// query param v41.latency.other
		var qrV41LatencyOther int64

		if o.V41LatencyOther != nil {
			qrV41LatencyOther = *o.V41LatencyOther
		}
		qV41LatencyOther := swag.FormatInt64(qrV41LatencyOther)
		if qV41LatencyOther != "" {

			if err := r.SetQueryParam("v41.latency.other", qV41LatencyOther); err != nil {
				return err
			}
		}
	}

	if o.V41LatencyRead != nil {

		// query param v41.latency.read
		var qrV41LatencyRead int64

		if o.V41LatencyRead != nil {
			qrV41LatencyRead = *o.V41LatencyRead
		}
		qV41LatencyRead := swag.FormatInt64(qrV41LatencyRead)
		if qV41LatencyRead != "" {

			if err := r.SetQueryParam("v41.latency.read", qV41LatencyRead); err != nil {
				return err
			}
		}
	}

	if o.V41LatencyTotal != nil {

		// query param v41.latency.total
		var qrV41LatencyTotal int64

		if o.V41LatencyTotal != nil {
			qrV41LatencyTotal = *o.V41LatencyTotal
		}
		qV41LatencyTotal := swag.FormatInt64(qrV41LatencyTotal)
		if qV41LatencyTotal != "" {

			if err := r.SetQueryParam("v41.latency.total", qV41LatencyTotal); err != nil {
				return err
			}
		}
	}

	if o.V41LatencyWrite != nil {

		// query param v41.latency.write
		var qrV41LatencyWrite int64

		if o.V41LatencyWrite != nil {
			qrV41LatencyWrite = *o.V41LatencyWrite
		}
		qV41LatencyWrite := swag.FormatInt64(qrV41LatencyWrite)
		if qV41LatencyWrite != "" {

			if err := r.SetQueryParam("v41.latency.write", qV41LatencyWrite); err != nil {
				return err
			}
		}
	}

	if o.V41Status != nil {

		// query param v41.status
		var qrV41Status string

		if o.V41Status != nil {
			qrV41Status = *o.V41Status
		}
		qV41Status := qrV41Status
		if qV41Status != "" {

			if err := r.SetQueryParam("v41.status", qV41Status); err != nil {
				return err
			}
		}
	}

	if o.V41ThroughputRead != nil {

		// query param v41.throughput.read
		var qrV41ThroughputRead int64

		if o.V41ThroughputRead != nil {
			qrV41ThroughputRead = *o.V41ThroughputRead
		}
		qV41ThroughputRead := swag.FormatInt64(qrV41ThroughputRead)
		if qV41ThroughputRead != "" {

			if err := r.SetQueryParam("v41.throughput.read", qV41ThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.V41ThroughputTotal != nil {

		// query param v41.throughput.total
		var qrV41ThroughputTotal int64

		if o.V41ThroughputTotal != nil {
			qrV41ThroughputTotal = *o.V41ThroughputTotal
		}
		qV41ThroughputTotal := swag.FormatInt64(qrV41ThroughputTotal)
		if qV41ThroughputTotal != "" {

			if err := r.SetQueryParam("v41.throughput.total", qV41ThroughputTotal); err != nil {
				return err
			}
		}
	}

	if o.V41ThroughputWrite != nil {

		// query param v41.throughput.write
		var qrV41ThroughputWrite int64

		if o.V41ThroughputWrite != nil {
			qrV41ThroughputWrite = *o.V41ThroughputWrite
		}
		qV41ThroughputWrite := swag.FormatInt64(qrV41ThroughputWrite)
		if qV41ThroughputWrite != "" {

			if err := r.SetQueryParam("v41.throughput.write", qV41ThroughputWrite); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamNfsCollectionPerformanceMetricsGet binds the parameter fields
func (o *NfsCollectionPerformanceMetricsGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamNfsCollectionPerformanceMetricsGet binds the parameter order_by
func (o *NfsCollectionPerformanceMetricsGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
