// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NfsDeleteCollectionReader is a Reader for the NfsDeleteCollection structure.
type NfsDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NfsDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNfsDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNfsDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNfsDeleteCollectionOK creates a NfsDeleteCollectionOK with default headers values
func NewNfsDeleteCollectionOK() *NfsDeleteCollectionOK {
	return &NfsDeleteCollectionOK{}
}

/*
NfsDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type NfsDeleteCollectionOK struct {
}

// IsSuccess returns true when this nfs delete collection o k response has a 2xx status code
func (o *NfsDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this nfs delete collection o k response has a 3xx status code
func (o *NfsDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nfs delete collection o k response has a 4xx status code
func (o *NfsDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this nfs delete collection o k response has a 5xx status code
func (o *NfsDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this nfs delete collection o k response a status code equal to that given
func (o *NfsDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the nfs delete collection o k response
func (o *NfsDeleteCollectionOK) Code() int {
	return 200
}

func (o *NfsDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/nfs/services][%d] nfsDeleteCollectionOK", 200)
}

func (o *NfsDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/nfs/services][%d] nfsDeleteCollectionOK", 200)
}

func (o *NfsDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNfsDeleteCollectionDefault creates a NfsDeleteCollectionDefault with default headers values
func NewNfsDeleteCollectionDefault(code int) *NfsDeleteCollectionDefault {
	return &NfsDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	NfsDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 3276916    | Vserver is not running |
| 3277008    | NFS Kerberos must be disabled on all LIFs of Vserver before deleting the NFS configuration. When all LIFs are disabled, try the operation |
| 3277009    | NFS Kerberos realms associated with the Vserver are deleted |
| 3277111    | Internal error. Failed to remove NFS-specific security trace filter for Vserver |
| 3277112    | Internal error. Failed to modify the protocols field of a security trace filter for Vserver  |
*/
type NfsDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nfs delete collection default response has a 2xx status code
func (o *NfsDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this nfs delete collection default response has a 3xx status code
func (o *NfsDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this nfs delete collection default response has a 4xx status code
func (o *NfsDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this nfs delete collection default response has a 5xx status code
func (o *NfsDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this nfs delete collection default response a status code equal to that given
func (o *NfsDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the nfs delete collection default response
func (o *NfsDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *NfsDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nfs/services][%d] nfs_delete_collection default %s", o._statusCode, payload)
}

func (o *NfsDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nfs/services][%d] nfs_delete_collection default %s", o._statusCode, payload)
}

func (o *NfsDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NfsDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NfsDeleteCollectionBody nfs delete collection body
swagger:model NfsDeleteCollectionBody
*/
type NfsDeleteCollectionBody struct {

	// nfs service response inline records
	NfsServiceResponseInlineRecords []*models.NfsService `json:"records,omitempty"`
}

// Validate validates this nfs delete collection body
func (o *NfsDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateNfsServiceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NfsDeleteCollectionBody) validateNfsServiceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.NfsServiceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.NfsServiceResponseInlineRecords); i++ {
		if swag.IsZero(o.NfsServiceResponseInlineRecords[i]) { // not required
			continue
		}

		if o.NfsServiceResponseInlineRecords[i] != nil {
			if err := o.NfsServiceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this nfs delete collection body based on the context it is used
func (o *NfsDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNfsServiceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NfsDeleteCollectionBody) contextValidateNfsServiceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.NfsServiceResponseInlineRecords); i++ {

		if o.NfsServiceResponseInlineRecords[i] != nil {
			if err := o.NfsServiceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *NfsDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NfsDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res NfsDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
