// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NfsDeleteReader is a Reader for the NfsDelete structure.
type NfsDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NfsDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNfsDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNfsDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNfsDeleteOK creates a NfsDeleteOK with default headers values
func NewNfsDeleteOK() *NfsDeleteOK {
	return &NfsDeleteOK{}
}

/*
NfsDeleteOK describes a response with status code 200, with default header values.

OK
*/
type NfsDeleteOK struct {
}

// IsSuccess returns true when this nfs delete o k response has a 2xx status code
func (o *NfsDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this nfs delete o k response has a 3xx status code
func (o *NfsDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nfs delete o k response has a 4xx status code
func (o *NfsDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this nfs delete o k response has a 5xx status code
func (o *NfsDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this nfs delete o k response a status code equal to that given
func (o *NfsDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the nfs delete o k response
func (o *NfsDeleteOK) Code() int {
	return 200
}

func (o *NfsDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/nfs/services/{svm.uuid}][%d] nfsDeleteOK", 200)
}

func (o *NfsDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/nfs/services/{svm.uuid}][%d] nfsDeleteOK", 200)
}

func (o *NfsDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNfsDeleteDefault creates a NfsDeleteDefault with default headers values
func NewNfsDeleteDefault(code int) *NfsDeleteDefault {
	return &NfsDeleteDefault{
		_statusCode: code,
	}
}

/*
	NfsDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 3276916    | Vserver is not running |
| 3277008    | NFS Kerberos must be disabled on all LIFs of Vserver before deleting the NFS configuration. When all LIFs are disabled, try the operation |
| 3277009    | NFS Kerberos realms associated with the Vserver are deleted |
| 3277111    | Internal error. Failed to remove NFS-specific security trace filter for Vserver |
| 3277112    | Internal error. Failed to modify the protocols field of a security trace filter for Vserver  |
*/
type NfsDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nfs delete default response has a 2xx status code
func (o *NfsDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this nfs delete default response has a 3xx status code
func (o *NfsDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this nfs delete default response has a 4xx status code
func (o *NfsDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this nfs delete default response has a 5xx status code
func (o *NfsDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this nfs delete default response a status code equal to that given
func (o *NfsDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the nfs delete default response
func (o *NfsDeleteDefault) Code() int {
	return o._statusCode
}

func (o *NfsDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nfs/services/{svm.uuid}][%d] nfs_delete default %s", o._statusCode, payload)
}

func (o *NfsDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/nfs/services/{svm.uuid}][%d] nfs_delete default %s", o._statusCode, payload)
}

func (o *NfsDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NfsDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
