// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NfsModifyReader is a Reader for the NfsModify structure.
type NfsModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NfsModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNfsModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNfsModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNfsModifyOK creates a NfsModifyOK with default headers values
func NewNfsModifyOK() *NfsModifyOK {
	return &NfsModifyOK{}
}

/*
NfsModifyOK describes a response with status code 200, with default header values.

OK
*/
type NfsModifyOK struct {
}

// IsSuccess returns true when this nfs modify o k response has a 2xx status code
func (o *NfsModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this nfs modify o k response has a 3xx status code
func (o *NfsModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nfs modify o k response has a 4xx status code
func (o *NfsModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this nfs modify o k response has a 5xx status code
func (o *NfsModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this nfs modify o k response a status code equal to that given
func (o *NfsModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the nfs modify o k response
func (o *NfsModifyOK) Code() int {
	return 200
}

func (o *NfsModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/nfs/services/{svm.uuid}][%d] nfsModifyOK", 200)
}

func (o *NfsModifyOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/nfs/services/{svm.uuid}][%d] nfsModifyOK", 200)
}

func (o *NfsModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNfsModifyDefault creates a NfsModifyDefault with default headers values
func NewNfsModifyDefault(code int) *NfsModifyDefault {
	return &NfsModifyDefault{
		_statusCode: code,
	}
}

/*
	NfsModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1534829    | The port numbers allowed are 635 (the default) and 1024 through 9999 |
| 2621516    | This operation is only supported on a data SVM |
| 2621574    | This operation is not permitted on a SVM that is configured as the destination of a MetroCluster SVM relationship |
| 3276852    | NFSv4.1 implementation name length for the SVM must be less than 256 bytes.|
| 3276872    | NFSv4 lease timeout value must not be less than 10. |
| 3276873    | NFSv4 lease timeout value must be between 10 and (protocol.v4_grace_seconds-1). |
| 3276874    | NFSv4 grace timeout value must not be greater than 180. |
| 3276875    | NFSv4 grace timeout value must be between (protocol.v4_lease_seconds+1) and 180. |
| 3276916    | Vserver is not running |
| 3276969    | Ports cannot be modified when NFS access is enabled. Disable NFS access before changing port settings |
| 3276994    | Kerberos must be disabled on all LIFs on the SVM before adding or removing any encryption. Disable Kerberos on the LIF and retry the operation. |
| 3277048    | The port numbers allowed are 635 (the default) and 1024 through 9999 |
| 3277069    | Cannot disable TCP because the SnapDiff RPC server is in the \\\"on\\\" state |
| 3277085    | The port numbers allowed are 1024 through 9999. |
| 3277087    | Attempting to reduce the number of bits used for NFSv3 FSIDs and File IDs from 64 to 32 on Vserver. This could result in collisions between different File IDs and is not recommended |
| 3277088    | Attempting to increase the number of bits used for NFSv3 FSIDs and File IDs from 32 to 64 on Vserver. This could result in older client software no longer working with the volumes owned by Vserver  |
| 3277090    | Attempting to disallow multiple FSIDs per mount point on Vserver. Since this Vserver currently uses 32-bit NFSv3 FSIDs and File IDs, this could result in collisions between different File IDs and is not recommended |
| 3277099    | Domain name contains invalid characters or its too short. Allowed characters are: alphabetical characters (A-Za-z), numeric characters (0-9), minus sign (-), and the period (.). The first character must be alphabetical or numeric, last character must not be a minus sign or a period. Minimum supported length: 2 characters, maximum of 256 characters |
| 3277140    | Cannot set \"transport.tcp_max_transfer_size\" to a value other than multiples of 4096 |
*/
type NfsModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nfs modify default response has a 2xx status code
func (o *NfsModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this nfs modify default response has a 3xx status code
func (o *NfsModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this nfs modify default response has a 4xx status code
func (o *NfsModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this nfs modify default response has a 5xx status code
func (o *NfsModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this nfs modify default response a status code equal to that given
func (o *NfsModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the nfs modify default response
func (o *NfsModifyDefault) Code() int {
	return o._statusCode
}

func (o *NfsModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/nfs/services/{svm.uuid}][%d] nfs_modify default %s", o._statusCode, payload)
}

func (o *NfsModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/nfs/services/{svm.uuid}][%d] nfs_modify default %s", o._statusCode, payload)
}

func (o *NfsModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NfsModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
