// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNfsTLSInterfaceCollectionGetParams creates a new NfsTLSInterfaceCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNfsTLSInterfaceCollectionGetParams() *NfsTLSInterfaceCollectionGetParams {
	return &NfsTLSInterfaceCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNfsTLSInterfaceCollectionGetParamsWithTimeout creates a new NfsTLSInterfaceCollectionGetParams object
// with the ability to set a timeout on a request.
func NewNfsTLSInterfaceCollectionGetParamsWithTimeout(timeout time.Duration) *NfsTLSInterfaceCollectionGetParams {
	return &NfsTLSInterfaceCollectionGetParams{
		timeout: timeout,
	}
}

// NewNfsTLSInterfaceCollectionGetParamsWithContext creates a new NfsTLSInterfaceCollectionGetParams object
// with the ability to set a context for a request.
func NewNfsTLSInterfaceCollectionGetParamsWithContext(ctx context.Context) *NfsTLSInterfaceCollectionGetParams {
	return &NfsTLSInterfaceCollectionGetParams{
		Context: ctx,
	}
}

// NewNfsTLSInterfaceCollectionGetParamsWithHTTPClient creates a new NfsTLSInterfaceCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewNfsTLSInterfaceCollectionGetParamsWithHTTPClient(client *http.Client) *NfsTLSInterfaceCollectionGetParams {
	return &NfsTLSInterfaceCollectionGetParams{
		HTTPClient: client,
	}
}

/*
NfsTLSInterfaceCollectionGetParams contains all the parameters to send to the API endpoint

	for the nfs tls interface collection get operation.

	Typically these are written to a http.Request.
*/
type NfsTLSInterfaceCollectionGetParams struct {

	/* CertificateName.

	   Filter by certificate.name
	*/
	CertificateName *string

	/* CertificateUUID.

	   Filter by certificate.uuid
	*/
	CertificateUUID *string

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* InterfaceIPAddress.

	   Filter by interface.ip.address
	*/
	InterfaceIPAddress *string

	/* InterfaceName.

	   Filter by interface.name
	*/
	InterfaceName *string

	/* InterfaceUUID.

	   Filter by interface.uuid
	*/
	InterfaceUUID *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the nfs tls interface collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NfsTLSInterfaceCollectionGetParams) WithDefaults() *NfsTLSInterfaceCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the nfs tls interface collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NfsTLSInterfaceCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := NfsTLSInterfaceCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) WithTimeout(timeout time.Duration) *NfsTLSInterfaceCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) WithContext(ctx context.Context) *NfsTLSInterfaceCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) WithHTTPClient(client *http.Client) *NfsTLSInterfaceCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCertificateName adds the certificateName to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) WithCertificateName(certificateName *string) *NfsTLSInterfaceCollectionGetParams {
	o.SetCertificateName(certificateName)
	return o
}

// SetCertificateName adds the certificateName to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) SetCertificateName(certificateName *string) {
	o.CertificateName = certificateName
}

// WithCertificateUUID adds the certificateUUID to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) WithCertificateUUID(certificateUUID *string) *NfsTLSInterfaceCollectionGetParams {
	o.SetCertificateUUID(certificateUUID)
	return o
}

// SetCertificateUUID adds the certificateUuid to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) SetCertificateUUID(certificateUUID *string) {
	o.CertificateUUID = certificateUUID
}

// WithEnabled adds the enabled to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) WithEnabled(enabled *bool) *NfsTLSInterfaceCollectionGetParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithFields adds the fields to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) WithFields(fields []string) *NfsTLSInterfaceCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithInterfaceIPAddress adds the interfaceIPAddress to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) WithInterfaceIPAddress(interfaceIPAddress *string) *NfsTLSInterfaceCollectionGetParams {
	o.SetInterfaceIPAddress(interfaceIPAddress)
	return o
}

// SetInterfaceIPAddress adds the interfaceIpAddress to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) SetInterfaceIPAddress(interfaceIPAddress *string) {
	o.InterfaceIPAddress = interfaceIPAddress
}

// WithInterfaceName adds the interfaceName to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) WithInterfaceName(interfaceName *string) *NfsTLSInterfaceCollectionGetParams {
	o.SetInterfaceName(interfaceName)
	return o
}

// SetInterfaceName adds the interfaceName to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) SetInterfaceName(interfaceName *string) {
	o.InterfaceName = interfaceName
}

// WithInterfaceUUID adds the interfaceUUID to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) WithInterfaceUUID(interfaceUUID *string) *NfsTLSInterfaceCollectionGetParams {
	o.SetInterfaceUUID(interfaceUUID)
	return o
}

// SetInterfaceUUID adds the interfaceUuid to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) SetInterfaceUUID(interfaceUUID *string) {
	o.InterfaceUUID = interfaceUUID
}

// WithMaxRecords adds the maxRecords to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) WithMaxRecords(maxRecords *int64) *NfsTLSInterfaceCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) WithOrderBy(orderBy []string) *NfsTLSInterfaceCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) WithReturnRecords(returnRecords *bool) *NfsTLSInterfaceCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *NfsTLSInterfaceCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmName adds the svmName to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) WithSvmName(svmName *string) *NfsTLSInterfaceCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) WithSvmUUID(svmUUID *string) *NfsTLSInterfaceCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the nfs tls interface collection get params
func (o *NfsTLSInterfaceCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *NfsTLSInterfaceCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CertificateName != nil {

		// query param certificate.name
		var qrCertificateName string

		if o.CertificateName != nil {
			qrCertificateName = *o.CertificateName
		}
		qCertificateName := qrCertificateName
		if qCertificateName != "" {

			if err := r.SetQueryParam("certificate.name", qCertificateName); err != nil {
				return err
			}
		}
	}

	if o.CertificateUUID != nil {

		// query param certificate.uuid
		var qrCertificateUUID string

		if o.CertificateUUID != nil {
			qrCertificateUUID = *o.CertificateUUID
		}
		qCertificateUUID := qrCertificateUUID
		if qCertificateUUID != "" {

			if err := r.SetQueryParam("certificate.uuid", qCertificateUUID); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.InterfaceIPAddress != nil {

		// query param interface.ip.address
		var qrInterfaceIPAddress string

		if o.InterfaceIPAddress != nil {
			qrInterfaceIPAddress = *o.InterfaceIPAddress
		}
		qInterfaceIPAddress := qrInterfaceIPAddress
		if qInterfaceIPAddress != "" {

			if err := r.SetQueryParam("interface.ip.address", qInterfaceIPAddress); err != nil {
				return err
			}
		}
	}

	if o.InterfaceName != nil {

		// query param interface.name
		var qrInterfaceName string

		if o.InterfaceName != nil {
			qrInterfaceName = *o.InterfaceName
		}
		qInterfaceName := qrInterfaceName
		if qInterfaceName != "" {

			if err := r.SetQueryParam("interface.name", qInterfaceName); err != nil {
				return err
			}
		}
	}

	if o.InterfaceUUID != nil {

		// query param interface.uuid
		var qrInterfaceUUID string

		if o.InterfaceUUID != nil {
			qrInterfaceUUID = *o.InterfaceUUID
		}
		qInterfaceUUID := qrInterfaceUUID
		if qInterfaceUUID != "" {

			if err := r.SetQueryParam("interface.uuid", qInterfaceUUID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamNfsTLSInterfaceCollectionGet binds the parameter fields
func (o *NfsTLSInterfaceCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamNfsTLSInterfaceCollectionGet binds the parameter order_by
func (o *NfsTLSInterfaceCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
