// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNfsTLSInterfaceModifyCollectionParams creates a new NfsTLSInterfaceModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNfsTLSInterfaceModifyCollectionParams() *NfsTLSInterfaceModifyCollectionParams {
	return &NfsTLSInterfaceModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNfsTLSInterfaceModifyCollectionParamsWithTimeout creates a new NfsTLSInterfaceModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewNfsTLSInterfaceModifyCollectionParamsWithTimeout(timeout time.Duration) *NfsTLSInterfaceModifyCollectionParams {
	return &NfsTLSInterfaceModifyCollectionParams{
		timeout: timeout,
	}
}

// NewNfsTLSInterfaceModifyCollectionParamsWithContext creates a new NfsTLSInterfaceModifyCollectionParams object
// with the ability to set a context for a request.
func NewNfsTLSInterfaceModifyCollectionParamsWithContext(ctx context.Context) *NfsTLSInterfaceModifyCollectionParams {
	return &NfsTLSInterfaceModifyCollectionParams{
		Context: ctx,
	}
}

// NewNfsTLSInterfaceModifyCollectionParamsWithHTTPClient creates a new NfsTLSInterfaceModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewNfsTLSInterfaceModifyCollectionParamsWithHTTPClient(client *http.Client) *NfsTLSInterfaceModifyCollectionParams {
	return &NfsTLSInterfaceModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
NfsTLSInterfaceModifyCollectionParams contains all the parameters to send to the API endpoint

	for the nfs tls interface modify collection operation.

	Typically these are written to a http.Request.
*/
type NfsTLSInterfaceModifyCollectionParams struct {

	/* CertificateName.

	   Filter by certificate.name
	*/
	CertificateName *string

	/* CertificateUUID.

	   Filter by certificate.uuid
	*/
	CertificateUUID *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Info.

	   Info specification
	*/
	Info NfsTLSInterfaceModifyCollectionBody

	/* InterfaceIPAddress.

	   Filter by interface.ip.address
	*/
	InterfaceIPAddress *string

	/* InterfaceName.

	   Filter by interface.name
	*/
	InterfaceName *string

	/* InterfaceUUID.

	   Filter by interface.uuid
	*/
	InterfaceUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SkipSanValidation.

	   Indicates whether Subject Alternate Name (SAN) validation has to be skipped.
	*/
	SkipSanValidation *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the nfs tls interface modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NfsTLSInterfaceModifyCollectionParams) WithDefaults() *NfsTLSInterfaceModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the nfs tls interface modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NfsTLSInterfaceModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := NfsTLSInterfaceModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) WithTimeout(timeout time.Duration) *NfsTLSInterfaceModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) WithContext(ctx context.Context) *NfsTLSInterfaceModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) WithHTTPClient(client *http.Client) *NfsTLSInterfaceModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCertificateName adds the certificateName to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) WithCertificateName(certificateName *string) *NfsTLSInterfaceModifyCollectionParams {
	o.SetCertificateName(certificateName)
	return o
}

// SetCertificateName adds the certificateName to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) SetCertificateName(certificateName *string) {
	o.CertificateName = certificateName
}

// WithCertificateUUID adds the certificateUUID to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) WithCertificateUUID(certificateUUID *string) *NfsTLSInterfaceModifyCollectionParams {
	o.SetCertificateUUID(certificateUUID)
	return o
}

// SetCertificateUUID adds the certificateUuid to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) SetCertificateUUID(certificateUUID *string) {
	o.CertificateUUID = certificateUUID
}

// WithContinueOnFailure adds the continueOnFailure to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *NfsTLSInterfaceModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithEnabled adds the enabled to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) WithEnabled(enabled *bool) *NfsTLSInterfaceModifyCollectionParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithInfo adds the info to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) WithInfo(info NfsTLSInterfaceModifyCollectionBody) *NfsTLSInterfaceModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) SetInfo(info NfsTLSInterfaceModifyCollectionBody) {
	o.Info = info
}

// WithInterfaceIPAddress adds the interfaceIPAddress to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) WithInterfaceIPAddress(interfaceIPAddress *string) *NfsTLSInterfaceModifyCollectionParams {
	o.SetInterfaceIPAddress(interfaceIPAddress)
	return o
}

// SetInterfaceIPAddress adds the interfaceIpAddress to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) SetInterfaceIPAddress(interfaceIPAddress *string) {
	o.InterfaceIPAddress = interfaceIPAddress
}

// WithInterfaceName adds the interfaceName to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) WithInterfaceName(interfaceName *string) *NfsTLSInterfaceModifyCollectionParams {
	o.SetInterfaceName(interfaceName)
	return o
}

// SetInterfaceName adds the interfaceName to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) SetInterfaceName(interfaceName *string) {
	o.InterfaceName = interfaceName
}

// WithInterfaceUUID adds the interfaceUUID to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) WithInterfaceUUID(interfaceUUID *string) *NfsTLSInterfaceModifyCollectionParams {
	o.SetInterfaceUUID(interfaceUUID)
	return o
}

// SetInterfaceUUID adds the interfaceUuid to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) SetInterfaceUUID(interfaceUUID *string) {
	o.InterfaceUUID = interfaceUUID
}

// WithReturnRecords adds the returnRecords to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) WithReturnRecords(returnRecords *bool) *NfsTLSInterfaceModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *NfsTLSInterfaceModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) WithSerialRecords(serialRecords *bool) *NfsTLSInterfaceModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSkipSanValidation adds the skipSanValidation to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) WithSkipSanValidation(skipSanValidation *bool) *NfsTLSInterfaceModifyCollectionParams {
	o.SetSkipSanValidation(skipSanValidation)
	return o
}

// SetSkipSanValidation adds the skipSanValidation to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) SetSkipSanValidation(skipSanValidation *bool) {
	o.SkipSanValidation = skipSanValidation
}

// WithSvmName adds the svmName to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) WithSvmName(svmName *string) *NfsTLSInterfaceModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) WithSvmUUID(svmUUID *string) *NfsTLSInterfaceModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the nfs tls interface modify collection params
func (o *NfsTLSInterfaceModifyCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *NfsTLSInterfaceModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CertificateName != nil {

		// query param certificate.name
		var qrCertificateName string

		if o.CertificateName != nil {
			qrCertificateName = *o.CertificateName
		}
		qCertificateName := qrCertificateName
		if qCertificateName != "" {

			if err := r.SetQueryParam("certificate.name", qCertificateName); err != nil {
				return err
			}
		}
	}

	if o.CertificateUUID != nil {

		// query param certificate.uuid
		var qrCertificateUUID string

		if o.CertificateUUID != nil {
			qrCertificateUUID = *o.CertificateUUID
		}
		qCertificateUUID := qrCertificateUUID
		if qCertificateUUID != "" {

			if err := r.SetQueryParam("certificate.uuid", qCertificateUUID); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.InterfaceIPAddress != nil {

		// query param interface.ip.address
		var qrInterfaceIPAddress string

		if o.InterfaceIPAddress != nil {
			qrInterfaceIPAddress = *o.InterfaceIPAddress
		}
		qInterfaceIPAddress := qrInterfaceIPAddress
		if qInterfaceIPAddress != "" {

			if err := r.SetQueryParam("interface.ip.address", qInterfaceIPAddress); err != nil {
				return err
			}
		}
	}

	if o.InterfaceName != nil {

		// query param interface.name
		var qrInterfaceName string

		if o.InterfaceName != nil {
			qrInterfaceName = *o.InterfaceName
		}
		qInterfaceName := qrInterfaceName
		if qInterfaceName != "" {

			if err := r.SetQueryParam("interface.name", qInterfaceName); err != nil {
				return err
			}
		}
	}

	if o.InterfaceUUID != nil {

		// query param interface.uuid
		var qrInterfaceUUID string

		if o.InterfaceUUID != nil {
			qrInterfaceUUID = *o.InterfaceUUID
		}
		qInterfaceUUID := qrInterfaceUUID
		if qInterfaceUUID != "" {

			if err := r.SetQueryParam("interface.uuid", qInterfaceUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SkipSanValidation != nil {

		// query param skip_san_validation
		var qrSkipSanValidation bool

		if o.SkipSanValidation != nil {
			qrSkipSanValidation = *o.SkipSanValidation
		}
		qSkipSanValidation := swag.FormatBool(qrSkipSanValidation)
		if qSkipSanValidation != "" {

			if err := r.SetQueryParam("skip_san_validation", qSkipSanValidation); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
