// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NfsTLSInterfaceModifyCollectionReader is a Reader for the NfsTLSInterfaceModifyCollection structure.
type NfsTLSInterfaceModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NfsTLSInterfaceModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNfsTLSInterfaceModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNfsTLSInterfaceModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNfsTLSInterfaceModifyCollectionOK creates a NfsTLSInterfaceModifyCollectionOK with default headers values
func NewNfsTLSInterfaceModifyCollectionOK() *NfsTLSInterfaceModifyCollectionOK {
	return &NfsTLSInterfaceModifyCollectionOK{}
}

/*
NfsTLSInterfaceModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type NfsTLSInterfaceModifyCollectionOK struct {
}

// IsSuccess returns true when this nfs Tls interface modify collection o k response has a 2xx status code
func (o *NfsTLSInterfaceModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this nfs Tls interface modify collection o k response has a 3xx status code
func (o *NfsTLSInterfaceModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nfs Tls interface modify collection o k response has a 4xx status code
func (o *NfsTLSInterfaceModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this nfs Tls interface modify collection o k response has a 5xx status code
func (o *NfsTLSInterfaceModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this nfs Tls interface modify collection o k response a status code equal to that given
func (o *NfsTLSInterfaceModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the nfs Tls interface modify collection o k response
func (o *NfsTLSInterfaceModifyCollectionOK) Code() int {
	return 200
}

func (o *NfsTLSInterfaceModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/nfs/tls/interfaces][%d] nfsTlsInterfaceModifyCollectionOK", 200)
}

func (o *NfsTLSInterfaceModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/nfs/tls/interfaces][%d] nfsTlsInterfaceModifyCollectionOK", 200)
}

func (o *NfsTLSInterfaceModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNfsTLSInterfaceModifyCollectionDefault creates a NfsTLSInterfaceModifyCollectionDefault with default headers values
func NewNfsTLSInterfaceModifyCollectionDefault(code int) *NfsTLSInterfaceModifyCollectionDefault {
	return &NfsTLSInterfaceModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	NfsTLSInterfaceModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error codes | Description |
| ----------- | ----------- |
| 2           | The value provided is an invalid value for field \"interface.uuid\".|
| 4           | The entry doesn't exist|
| 3277204     | TLS already enabled/disabled on this LIF.|
| 3277205     | Cannot enable TLS because no certificate was provided.|
| 3277206     | The "enabled" is a required field.|
| 3277210     | The FQDN of the LIF IP address and the common name present in the certificate do not match. Update the certificate so that the common name and LIF FQDN match and retry the operation.|
| 3277217     | Failed to enable TLS on LIF on vserver because the certificate does not have LIF as subject alternate name.|
| 92405900    | Certificate not found for the SVM.|
| 92406020    | Only certificates of type 'server' are supported on the SVM.|
*/
type NfsTLSInterfaceModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nfs tls interface modify collection default response has a 2xx status code
func (o *NfsTLSInterfaceModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this nfs tls interface modify collection default response has a 3xx status code
func (o *NfsTLSInterfaceModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this nfs tls interface modify collection default response has a 4xx status code
func (o *NfsTLSInterfaceModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this nfs tls interface modify collection default response has a 5xx status code
func (o *NfsTLSInterfaceModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this nfs tls interface modify collection default response a status code equal to that given
func (o *NfsTLSInterfaceModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the nfs tls interface modify collection default response
func (o *NfsTLSInterfaceModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *NfsTLSInterfaceModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/nfs/tls/interfaces][%d] nfs_tls_interface_modify_collection default %s", o._statusCode, payload)
}

func (o *NfsTLSInterfaceModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/nfs/tls/interfaces][%d] nfs_tls_interface_modify_collection default %s", o._statusCode, payload)
}

func (o *NfsTLSInterfaceModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NfsTLSInterfaceModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NfsTLSInterfaceModifyCollectionBody nfs TLS interface modify collection body
swagger:model NfsTLSInterfaceModifyCollectionBody
*/
type NfsTLSInterfaceModifyCollectionBody struct {

	// links
	Links *models.NfsTLSInterfaceInlineLinks `json:"_links,omitempty"`

	// certificate
	Certificate *models.NfsTLSInterfaceInlineCertificate `json:"certificate,omitempty"`

	// Indicates whether NFS over TLS is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// interface
	Interface *models.NfsTLSInterfaceInlineInterface `json:"interface,omitempty"`

	// nfs tls interface response inline records
	NfsTLSInterfaceResponseInlineRecords []*models.NfsTLSInterface `json:"records,omitempty"`

	// svm
	Svm *models.NfsTLSInterfaceInlineSvm `json:"svm,omitempty"`
}

// Validate validates this nfs TLS interface modify collection body
func (o *NfsTLSInterfaceModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateInterface(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNfsTLSInterfaceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NfsTLSInterfaceModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NfsTLSInterfaceModifyCollectionBody) validateCertificate(formats strfmt.Registry) error {
	if swag.IsZero(o.Certificate) { // not required
		return nil
	}

	if o.Certificate != nil {
		if err := o.Certificate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate")
			}
			return err
		}
	}

	return nil
}

func (o *NfsTLSInterfaceModifyCollectionBody) validateInterface(formats strfmt.Registry) error {
	if swag.IsZero(o.Interface) { // not required
		return nil
	}

	if o.Interface != nil {
		if err := o.Interface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "interface")
			}
			return err
		}
	}

	return nil
}

func (o *NfsTLSInterfaceModifyCollectionBody) validateNfsTLSInterfaceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.NfsTLSInterfaceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.NfsTLSInterfaceResponseInlineRecords); i++ {
		if swag.IsZero(o.NfsTLSInterfaceResponseInlineRecords[i]) { // not required
			continue
		}

		if o.NfsTLSInterfaceResponseInlineRecords[i] != nil {
			if err := o.NfsTLSInterfaceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NfsTLSInterfaceModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nfs TLS interface modify collection body based on the context it is used
func (o *NfsTLSInterfaceModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCertificate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNfsTLSInterfaceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NfsTLSInterfaceModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NfsTLSInterfaceModifyCollectionBody) contextValidateCertificate(ctx context.Context, formats strfmt.Registry) error {

	if o.Certificate != nil {
		if err := o.Certificate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate")
			}
			return err
		}
	}

	return nil
}

func (o *NfsTLSInterfaceModifyCollectionBody) contextValidateInterface(ctx context.Context, formats strfmt.Registry) error {

	if o.Interface != nil {
		if err := o.Interface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "interface")
			}
			return err
		}
	}

	return nil
}

func (o *NfsTLSInterfaceModifyCollectionBody) contextValidateNfsTLSInterfaceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.NfsTLSInterfaceResponseInlineRecords); i++ {

		if o.NfsTLSInterfaceResponseInlineRecords[i] != nil {
			if err := o.NfsTLSInterfaceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *NfsTLSInterfaceModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NfsTLSInterfaceModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NfsTLSInterfaceModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res NfsTLSInterfaceModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NfsTLSInterfaceInlineLinks nfs tls interface inline links
swagger:model nfs_tls_interface_inline__links
*/
type NfsTLSInterfaceInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nfs tls interface inline links
func (o *NfsTLSInterfaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NfsTLSInterfaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nfs tls interface inline links based on the context it is used
func (o *NfsTLSInterfaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NfsTLSInterfaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NfsTLSInterfaceInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NfsTLSInterfaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res NfsTLSInterfaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NfsTLSInterfaceInlineCertificate Specifies the certificate that is used for creating NFS over TLS connections.
swagger:model nfs_tls_interface_inline_certificate
*/
type NfsTLSInterfaceInlineCertificate struct {

	// links
	Links *models.NfsTLSInterfaceInlineCertificateInlineLinks `json:"_links,omitempty"`

	// Certificate name
	Name *string `json:"name,omitempty"`

	// Certificate UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nfs tls interface inline certificate
func (o *NfsTLSInterfaceInlineCertificate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NfsTLSInterfaceInlineCertificate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nfs tls interface inline certificate based on the context it is used
func (o *NfsTLSInterfaceInlineCertificate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NfsTLSInterfaceInlineCertificate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NfsTLSInterfaceInlineCertificate) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NfsTLSInterfaceInlineCertificate) UnmarshalBinary(b []byte) error {
	var res NfsTLSInterfaceInlineCertificate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NfsTLSInterfaceInlineCertificateInlineLinks nfs tls interface inline certificate inline links
swagger:model nfs_tls_interface_inline_certificate_inline__links
*/
type NfsTLSInterfaceInlineCertificateInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nfs tls interface inline certificate inline links
func (o *NfsTLSInterfaceInlineCertificateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NfsTLSInterfaceInlineCertificateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nfs tls interface inline certificate inline links based on the context it is used
func (o *NfsTLSInterfaceInlineCertificateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NfsTLSInterfaceInlineCertificateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NfsTLSInterfaceInlineCertificateInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NfsTLSInterfaceInlineCertificateInlineLinks) UnmarshalBinary(b []byte) error {
	var res NfsTLSInterfaceInlineCertificateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NfsTLSInterfaceInlineInterface Network interface.
swagger:model nfs_tls_interface_inline_interface
*/
type NfsTLSInterfaceInlineInterface struct {

	// links
	Links *models.NfsTLSInterfaceInlineInterfaceInlineLinks `json:"_links,omitempty"`

	// ip
	IP *models.NfsTLSInterfaceInlineInterfaceInlineIP `json:"ip,omitempty"`

	// The name of the interface. If only the name is provided, the SVM scope
	// must be provided by the object this object is embedded in.
	//
	// Example: lif1
	Name *string `json:"name,omitempty"`

	// The UUID that uniquely identifies the interface.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nfs tls interface inline interface
func (o *NfsTLSInterfaceInlineInterface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NfsTLSInterfaceInlineInterface) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "interface" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NfsTLSInterfaceInlineInterface) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(o.IP) { // not required
		return nil
	}

	if o.IP != nil {
		if err := o.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nfs tls interface inline interface based on the context it is used
func (o *NfsTLSInterfaceInlineInterface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NfsTLSInterfaceInlineInterface) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "interface" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *NfsTLSInterfaceInlineInterface) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if o.IP != nil {
		if err := o.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NfsTLSInterfaceInlineInterface) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NfsTLSInterfaceInlineInterface) UnmarshalBinary(b []byte) error {
	var res NfsTLSInterfaceInlineInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NfsTLSInterfaceInlineInterfaceInlineLinks nfs tls interface inline interface inline links
swagger:model nfs_tls_interface_inline_interface_inline__links
*/
type NfsTLSInterfaceInlineInterfaceInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nfs tls interface inline interface inline links
func (o *NfsTLSInterfaceInlineInterfaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NfsTLSInterfaceInlineInterfaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "interface" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nfs tls interface inline interface inline links based on the context it is used
func (o *NfsTLSInterfaceInlineInterfaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NfsTLSInterfaceInlineInterfaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "interface" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NfsTLSInterfaceInlineInterfaceInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NfsTLSInterfaceInlineInterfaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res NfsTLSInterfaceInlineInterfaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NfsTLSInterfaceInlineInterfaceInlineIP IP information
swagger:model nfs_tls_interface_inline_interface_inline_ip
*/
type NfsTLSInterfaceInlineInterfaceInlineIP struct {

	// address
	Address *models.IPAddressReadonly `json:"address,omitempty"`
}

// Validate validates this nfs tls interface inline interface inline ip
func (o *NfsTLSInterfaceInlineInterfaceInlineIP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NfsTLSInterfaceInlineInterfaceInlineIP) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(o.Address) { // not required
		return nil
	}

	if o.Address != nil {
		if err := o.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "interface" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nfs tls interface inline interface inline ip based on the context it is used
func (o *NfsTLSInterfaceInlineInterfaceInlineIP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NfsTLSInterfaceInlineInterfaceInlineIP) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if o.Address != nil {
		if err := o.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "interface" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NfsTLSInterfaceInlineInterfaceInlineIP) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NfsTLSInterfaceInlineInterfaceInlineIP) UnmarshalBinary(b []byte) error {
	var res NfsTLSInterfaceInlineInterfaceInlineIP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NfsTLSInterfaceInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model nfs_tls_interface_inline_svm
*/
type NfsTLSInterfaceInlineSvm struct {

	// links
	Links *models.NfsTLSInterfaceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this nfs tls interface inline svm
func (o *NfsTLSInterfaceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NfsTLSInterfaceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nfs tls interface inline svm based on the context it is used
func (o *NfsTLSInterfaceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NfsTLSInterfaceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NfsTLSInterfaceInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NfsTLSInterfaceInlineSvm) UnmarshalBinary(b []byte) error {
	var res NfsTLSInterfaceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NfsTLSInterfaceInlineSvmInlineLinks nfs tls interface inline svm inline links
swagger:model nfs_tls_interface_inline_svm_inline__links
*/
type NfsTLSInterfaceInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this nfs tls interface inline svm inline links
func (o *NfsTLSInterfaceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NfsTLSInterfaceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this nfs tls interface inline svm inline links based on the context it is used
func (o *NfsTLSInterfaceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NfsTLSInterfaceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *NfsTLSInterfaceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NfsTLSInterfaceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res NfsTLSInterfaceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
