// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewNfsTLSInterfaceModifyParams creates a new NfsTLSInterfaceModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNfsTLSInterfaceModifyParams() *NfsTLSInterfaceModifyParams {
	return &NfsTLSInterfaceModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNfsTLSInterfaceModifyParamsWithTimeout creates a new NfsTLSInterfaceModifyParams object
// with the ability to set a timeout on a request.
func NewNfsTLSInterfaceModifyParamsWithTimeout(timeout time.Duration) *NfsTLSInterfaceModifyParams {
	return &NfsTLSInterfaceModifyParams{
		timeout: timeout,
	}
}

// NewNfsTLSInterfaceModifyParamsWithContext creates a new NfsTLSInterfaceModifyParams object
// with the ability to set a context for a request.
func NewNfsTLSInterfaceModifyParamsWithContext(ctx context.Context) *NfsTLSInterfaceModifyParams {
	return &NfsTLSInterfaceModifyParams{
		Context: ctx,
	}
}

// NewNfsTLSInterfaceModifyParamsWithHTTPClient creates a new NfsTLSInterfaceModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewNfsTLSInterfaceModifyParamsWithHTTPClient(client *http.Client) *NfsTLSInterfaceModifyParams {
	return &NfsTLSInterfaceModifyParams{
		HTTPClient: client,
	}
}

/*
NfsTLSInterfaceModifyParams contains all the parameters to send to the API endpoint

	for the nfs tls interface modify operation.

	Typically these are written to a http.Request.
*/
type NfsTLSInterfaceModifyParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.NfsTLSInterface

	/* InterfaceUUID.

	   Network interface UUID.
	*/
	InterfaceUUID string

	/* SkipSanValidation.

	   Indicates whether Subject Alternate Name (SAN) validation has to be skipped.
	*/
	SkipSanValidation *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the nfs tls interface modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NfsTLSInterfaceModifyParams) WithDefaults() *NfsTLSInterfaceModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the nfs tls interface modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NfsTLSInterfaceModifyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the nfs tls interface modify params
func (o *NfsTLSInterfaceModifyParams) WithTimeout(timeout time.Duration) *NfsTLSInterfaceModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the nfs tls interface modify params
func (o *NfsTLSInterfaceModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the nfs tls interface modify params
func (o *NfsTLSInterfaceModifyParams) WithContext(ctx context.Context) *NfsTLSInterfaceModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the nfs tls interface modify params
func (o *NfsTLSInterfaceModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the nfs tls interface modify params
func (o *NfsTLSInterfaceModifyParams) WithHTTPClient(client *http.Client) *NfsTLSInterfaceModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the nfs tls interface modify params
func (o *NfsTLSInterfaceModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the nfs tls interface modify params
func (o *NfsTLSInterfaceModifyParams) WithInfo(info *models.NfsTLSInterface) *NfsTLSInterfaceModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the nfs tls interface modify params
func (o *NfsTLSInterfaceModifyParams) SetInfo(info *models.NfsTLSInterface) {
	o.Info = info
}

// WithInterfaceUUID adds the interfaceUUID to the nfs tls interface modify params
func (o *NfsTLSInterfaceModifyParams) WithInterfaceUUID(interfaceUUID string) *NfsTLSInterfaceModifyParams {
	o.SetInterfaceUUID(interfaceUUID)
	return o
}

// SetInterfaceUUID adds the interfaceUuid to the nfs tls interface modify params
func (o *NfsTLSInterfaceModifyParams) SetInterfaceUUID(interfaceUUID string) {
	o.InterfaceUUID = interfaceUUID
}

// WithSkipSanValidation adds the skipSanValidation to the nfs tls interface modify params
func (o *NfsTLSInterfaceModifyParams) WithSkipSanValidation(skipSanValidation *bool) *NfsTLSInterfaceModifyParams {
	o.SetSkipSanValidation(skipSanValidation)
	return o
}

// SetSkipSanValidation adds the skipSanValidation to the nfs tls interface modify params
func (o *NfsTLSInterfaceModifyParams) SetSkipSanValidation(skipSanValidation *bool) {
	o.SkipSanValidation = skipSanValidation
}

// WriteToRequest writes these params to a swagger request
func (o *NfsTLSInterfaceModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param interface.uuid
	if err := r.SetPathParam("interface.uuid", o.InterfaceUUID); err != nil {
		return err
	}

	if o.SkipSanValidation != nil {

		// query param skip_san_validation
		var qrSkipSanValidation bool

		if o.SkipSanValidation != nil {
			qrSkipSanValidation = *o.SkipSanValidation
		}
		qSkipSanValidation := swag.FormatBool(qrSkipSanValidation)
		if qSkipSanValidation != "" {

			if err := r.SetQueryParam("skip_san_validation", qSkipSanValidation); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
