// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewPoliciesAndRulesToBeAppliedCollectionGetParams creates a new PoliciesAndRulesToBeAppliedCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPoliciesAndRulesToBeAppliedCollectionGetParams() *PoliciesAndRulesToBeAppliedCollectionGetParams {
	return &PoliciesAndRulesToBeAppliedCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPoliciesAndRulesToBeAppliedCollectionGetParamsWithTimeout creates a new PoliciesAndRulesToBeAppliedCollectionGetParams object
// with the ability to set a timeout on a request.
func NewPoliciesAndRulesToBeAppliedCollectionGetParamsWithTimeout(timeout time.Duration) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	return &PoliciesAndRulesToBeAppliedCollectionGetParams{
		timeout: timeout,
	}
}

// NewPoliciesAndRulesToBeAppliedCollectionGetParamsWithContext creates a new PoliciesAndRulesToBeAppliedCollectionGetParams object
// with the ability to set a context for a request.
func NewPoliciesAndRulesToBeAppliedCollectionGetParamsWithContext(ctx context.Context) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	return &PoliciesAndRulesToBeAppliedCollectionGetParams{
		Context: ctx,
	}
}

// NewPoliciesAndRulesToBeAppliedCollectionGetParamsWithHTTPClient creates a new PoliciesAndRulesToBeAppliedCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewPoliciesAndRulesToBeAppliedCollectionGetParamsWithHTTPClient(client *http.Client) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	return &PoliciesAndRulesToBeAppliedCollectionGetParams{
		HTTPClient: client,
	}
}

/*
PoliciesAndRulesToBeAppliedCollectionGetParams contains all the parameters to send to the API endpoint

	for the policies and rules to be applied collection get operation.

	Typically these are written to a http.Request.
*/
type PoliciesAndRulesToBeAppliedCollectionGetParams struct {

	/* CentralAccessPolicySettings.

	   Filter by central_access_policy_settings
	*/
	CentralAccessPolicySettings *string

	/* CentralAccessPolicyStagingAuditType.

	   Filter by central_access_policy_staging_audit_type
	*/
	CentralAccessPolicyStagingAuditType *string

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Extensions.

	   Filter by extensions
	*/
	Extensions *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* FileSystemPath.

	   Filter by file_system_path
	*/
	FileSystemPath *string

	/* Index.

	   Filter by index
	*/
	Index *int64

	/* LdapPath.

	   Filter by ldap_path
	*/
	LdapPath *string

	/* Link.

	   Filter by link
	*/
	Link *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* RegistrySettingsBranchcacheHashPublicationMode.

	   Filter by registry_settings.branchcache.hash_publication_mode
	*/
	RegistrySettingsBranchcacheHashPublicationMode *string

	/* RegistrySettingsBranchcacheSupportedHashVersion.

	   Filter by registry_settings.branchcache.supported_hash_version
	*/
	RegistrySettingsBranchcacheSupportedHashVersion *string

	/* RegistrySettingsRefreshTimeInterval.

	   Filter by registry_settings.refresh_time_interval
	*/
	RegistrySettingsRefreshTimeInterval *string

	/* RegistrySettingsRefreshTimeRandomOffset.

	   Filter by registry_settings.refresh_time_random_offset
	*/
	RegistrySettingsRefreshTimeRandomOffset *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SecuritySettingsEventAuditSettingsLogonType.

	   Filter by security_settings.event_audit_settings.logon_type
	*/
	SecuritySettingsEventAuditSettingsLogonType *string

	/* SecuritySettingsEventAuditSettingsObjectAccessType.

	   Filter by security_settings.event_audit_settings.object_access_type
	*/
	SecuritySettingsEventAuditSettingsObjectAccessType *string

	/* SecuritySettingsEventLogSettingsMaxSize.

	   Filter by security_settings.event_log_settings.max_size
	*/
	SecuritySettingsEventLogSettingsMaxSize *int64

	/* SecuritySettingsEventLogSettingsRetentionMethod.

	   Filter by security_settings.event_log_settings.retention_method
	*/
	SecuritySettingsEventLogSettingsRetentionMethod *string

	/* SecuritySettingsFilesOrFolders.

	   Filter by security_settings.files_or_folders
	*/
	SecuritySettingsFilesOrFolders *string

	/* SecuritySettingsKerberosMaxClockSkew.

	   Filter by security_settings.kerberos.max_clock_skew
	*/
	SecuritySettingsKerberosMaxClockSkew *string

	/* SecuritySettingsKerberosMaxRenewAge.

	   Filter by security_settings.kerberos.max_renew_age
	*/
	SecuritySettingsKerberosMaxRenewAge *string

	/* SecuritySettingsKerberosMaxTicketAge.

	   Filter by security_settings.kerberos.max_ticket_age
	*/
	SecuritySettingsKerberosMaxTicketAge *string

	/* SecuritySettingsPrivilegeRightsChangeNotifyUsers.

	   Filter by security_settings.privilege_rights.change_notify_users
	*/
	SecuritySettingsPrivilegeRightsChangeNotifyUsers *string

	/* SecuritySettingsPrivilegeRightsSecurityPrivilegeUsers.

	   Filter by security_settings.privilege_rights.security_privilege_users
	*/
	SecuritySettingsPrivilegeRightsSecurityPrivilegeUsers *string

	/* SecuritySettingsPrivilegeRightsTakeOwnershipUsers.

	   Filter by security_settings.privilege_rights.take_ownership_users
	*/
	SecuritySettingsPrivilegeRightsTakeOwnershipUsers *string

	/* SecuritySettingsRegistryValuesSigningRequired.

	   Filter by security_settings.registry_values.signing_required
	*/
	SecuritySettingsRegistryValuesSigningRequired *bool

	/* SecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted.

	   Filter by security_settings.restrict_anonymous.anonymous_access_to_shares_and_named_pipes_restricted
	*/
	SecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted *bool

	/* SecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser.

	   Filter by security_settings.restrict_anonymous.combined_restriction_for_anonymous_user
	*/
	SecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser *string

	/* SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts.

	   Filter by security_settings.restrict_anonymous.no_enumeration_of_sam_accounts
	*/
	SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts *bool

	/* SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares.

	   Filter by security_settings.restrict_anonymous.no_enumeration_of_sam_accounts_and_shares
	*/
	SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares *bool

	/* SecuritySettingsRestrictedGroups.

	   Filter by security_settings.restricted_groups
	*/
	SecuritySettingsRestrictedGroups *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* Version.

	   Filter by version
	*/
	Version *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the policies and rules to be applied collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithDefaults() *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the policies and rules to be applied collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := PoliciesAndRulesToBeAppliedCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithTimeout(timeout time.Duration) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithContext(ctx context.Context) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithHTTPClient(client *http.Client) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCentralAccessPolicySettings adds the centralAccessPolicySettings to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithCentralAccessPolicySettings(centralAccessPolicySettings *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetCentralAccessPolicySettings(centralAccessPolicySettings)
	return o
}

// SetCentralAccessPolicySettings adds the centralAccessPolicySettings to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetCentralAccessPolicySettings(centralAccessPolicySettings *string) {
	o.CentralAccessPolicySettings = centralAccessPolicySettings
}

// WithCentralAccessPolicyStagingAuditType adds the centralAccessPolicyStagingAuditType to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithCentralAccessPolicyStagingAuditType(centralAccessPolicyStagingAuditType *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetCentralAccessPolicyStagingAuditType(centralAccessPolicyStagingAuditType)
	return o
}

// SetCentralAccessPolicyStagingAuditType adds the centralAccessPolicyStagingAuditType to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetCentralAccessPolicyStagingAuditType(centralAccessPolicyStagingAuditType *string) {
	o.CentralAccessPolicyStagingAuditType = centralAccessPolicyStagingAuditType
}

// WithEnabled adds the enabled to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithEnabled(enabled *bool) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithExtensions adds the extensions to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithExtensions(extensions *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetExtensions(extensions)
	return o
}

// SetExtensions adds the extensions to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetExtensions(extensions *string) {
	o.Extensions = extensions
}

// WithFields adds the fields to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithFields(fields []string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFileSystemPath adds the fileSystemPath to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithFileSystemPath(fileSystemPath *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetFileSystemPath(fileSystemPath)
	return o
}

// SetFileSystemPath adds the fileSystemPath to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetFileSystemPath(fileSystemPath *string) {
	o.FileSystemPath = fileSystemPath
}

// WithIndex adds the index to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithIndex(index *int64) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetIndex(index *int64) {
	o.Index = index
}

// WithLdapPath adds the ldapPath to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithLdapPath(ldapPath *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetLdapPath(ldapPath)
	return o
}

// SetLdapPath adds the ldapPath to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetLdapPath(ldapPath *string) {
	o.LdapPath = ldapPath
}

// WithLink adds the link to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithLink(link *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetLink(link)
	return o
}

// SetLink adds the link to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetLink(link *string) {
	o.Link = link
}

// WithMaxRecords adds the maxRecords to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithMaxRecords(maxRecords *int64) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithName(name *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithOrderBy(orderBy []string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithRegistrySettingsBranchcacheHashPublicationMode adds the registrySettingsBranchcacheHashPublicationMode to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithRegistrySettingsBranchcacheHashPublicationMode(registrySettingsBranchcacheHashPublicationMode *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetRegistrySettingsBranchcacheHashPublicationMode(registrySettingsBranchcacheHashPublicationMode)
	return o
}

// SetRegistrySettingsBranchcacheHashPublicationMode adds the registrySettingsBranchcacheHashPublicationMode to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetRegistrySettingsBranchcacheHashPublicationMode(registrySettingsBranchcacheHashPublicationMode *string) {
	o.RegistrySettingsBranchcacheHashPublicationMode = registrySettingsBranchcacheHashPublicationMode
}

// WithRegistrySettingsBranchcacheSupportedHashVersion adds the registrySettingsBranchcacheSupportedHashVersion to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithRegistrySettingsBranchcacheSupportedHashVersion(registrySettingsBranchcacheSupportedHashVersion *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetRegistrySettingsBranchcacheSupportedHashVersion(registrySettingsBranchcacheSupportedHashVersion)
	return o
}

// SetRegistrySettingsBranchcacheSupportedHashVersion adds the registrySettingsBranchcacheSupportedHashVersion to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetRegistrySettingsBranchcacheSupportedHashVersion(registrySettingsBranchcacheSupportedHashVersion *string) {
	o.RegistrySettingsBranchcacheSupportedHashVersion = registrySettingsBranchcacheSupportedHashVersion
}

// WithRegistrySettingsRefreshTimeInterval adds the registrySettingsRefreshTimeInterval to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithRegistrySettingsRefreshTimeInterval(registrySettingsRefreshTimeInterval *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetRegistrySettingsRefreshTimeInterval(registrySettingsRefreshTimeInterval)
	return o
}

// SetRegistrySettingsRefreshTimeInterval adds the registrySettingsRefreshTimeInterval to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetRegistrySettingsRefreshTimeInterval(registrySettingsRefreshTimeInterval *string) {
	o.RegistrySettingsRefreshTimeInterval = registrySettingsRefreshTimeInterval
}

// WithRegistrySettingsRefreshTimeRandomOffset adds the registrySettingsRefreshTimeRandomOffset to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithRegistrySettingsRefreshTimeRandomOffset(registrySettingsRefreshTimeRandomOffset *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetRegistrySettingsRefreshTimeRandomOffset(registrySettingsRefreshTimeRandomOffset)
	return o
}

// SetRegistrySettingsRefreshTimeRandomOffset adds the registrySettingsRefreshTimeRandomOffset to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetRegistrySettingsRefreshTimeRandomOffset(registrySettingsRefreshTimeRandomOffset *string) {
	o.RegistrySettingsRefreshTimeRandomOffset = registrySettingsRefreshTimeRandomOffset
}

// WithReturnRecords adds the returnRecords to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithReturnRecords(returnRecords *bool) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSecuritySettingsEventAuditSettingsLogonType adds the securitySettingsEventAuditSettingsLogonType to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithSecuritySettingsEventAuditSettingsLogonType(securitySettingsEventAuditSettingsLogonType *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetSecuritySettingsEventAuditSettingsLogonType(securitySettingsEventAuditSettingsLogonType)
	return o
}

// SetSecuritySettingsEventAuditSettingsLogonType adds the securitySettingsEventAuditSettingsLogonType to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetSecuritySettingsEventAuditSettingsLogonType(securitySettingsEventAuditSettingsLogonType *string) {
	o.SecuritySettingsEventAuditSettingsLogonType = securitySettingsEventAuditSettingsLogonType
}

// WithSecuritySettingsEventAuditSettingsObjectAccessType adds the securitySettingsEventAuditSettingsObjectAccessType to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithSecuritySettingsEventAuditSettingsObjectAccessType(securitySettingsEventAuditSettingsObjectAccessType *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetSecuritySettingsEventAuditSettingsObjectAccessType(securitySettingsEventAuditSettingsObjectAccessType)
	return o
}

// SetSecuritySettingsEventAuditSettingsObjectAccessType adds the securitySettingsEventAuditSettingsObjectAccessType to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetSecuritySettingsEventAuditSettingsObjectAccessType(securitySettingsEventAuditSettingsObjectAccessType *string) {
	o.SecuritySettingsEventAuditSettingsObjectAccessType = securitySettingsEventAuditSettingsObjectAccessType
}

// WithSecuritySettingsEventLogSettingsMaxSize adds the securitySettingsEventLogSettingsMaxSize to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithSecuritySettingsEventLogSettingsMaxSize(securitySettingsEventLogSettingsMaxSize *int64) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetSecuritySettingsEventLogSettingsMaxSize(securitySettingsEventLogSettingsMaxSize)
	return o
}

// SetSecuritySettingsEventLogSettingsMaxSize adds the securitySettingsEventLogSettingsMaxSize to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetSecuritySettingsEventLogSettingsMaxSize(securitySettingsEventLogSettingsMaxSize *int64) {
	o.SecuritySettingsEventLogSettingsMaxSize = securitySettingsEventLogSettingsMaxSize
}

// WithSecuritySettingsEventLogSettingsRetentionMethod adds the securitySettingsEventLogSettingsRetentionMethod to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithSecuritySettingsEventLogSettingsRetentionMethod(securitySettingsEventLogSettingsRetentionMethod *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetSecuritySettingsEventLogSettingsRetentionMethod(securitySettingsEventLogSettingsRetentionMethod)
	return o
}

// SetSecuritySettingsEventLogSettingsRetentionMethod adds the securitySettingsEventLogSettingsRetentionMethod to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetSecuritySettingsEventLogSettingsRetentionMethod(securitySettingsEventLogSettingsRetentionMethod *string) {
	o.SecuritySettingsEventLogSettingsRetentionMethod = securitySettingsEventLogSettingsRetentionMethod
}

// WithSecuritySettingsFilesOrFolders adds the securitySettingsFilesOrFolders to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithSecuritySettingsFilesOrFolders(securitySettingsFilesOrFolders *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetSecuritySettingsFilesOrFolders(securitySettingsFilesOrFolders)
	return o
}

// SetSecuritySettingsFilesOrFolders adds the securitySettingsFilesOrFolders to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetSecuritySettingsFilesOrFolders(securitySettingsFilesOrFolders *string) {
	o.SecuritySettingsFilesOrFolders = securitySettingsFilesOrFolders
}

// WithSecuritySettingsKerberosMaxClockSkew adds the securitySettingsKerberosMaxClockSkew to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithSecuritySettingsKerberosMaxClockSkew(securitySettingsKerberosMaxClockSkew *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetSecuritySettingsKerberosMaxClockSkew(securitySettingsKerberosMaxClockSkew)
	return o
}

// SetSecuritySettingsKerberosMaxClockSkew adds the securitySettingsKerberosMaxClockSkew to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetSecuritySettingsKerberosMaxClockSkew(securitySettingsKerberosMaxClockSkew *string) {
	o.SecuritySettingsKerberosMaxClockSkew = securitySettingsKerberosMaxClockSkew
}

// WithSecuritySettingsKerberosMaxRenewAge adds the securitySettingsKerberosMaxRenewAge to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithSecuritySettingsKerberosMaxRenewAge(securitySettingsKerberosMaxRenewAge *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetSecuritySettingsKerberosMaxRenewAge(securitySettingsKerberosMaxRenewAge)
	return o
}

// SetSecuritySettingsKerberosMaxRenewAge adds the securitySettingsKerberosMaxRenewAge to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetSecuritySettingsKerberosMaxRenewAge(securitySettingsKerberosMaxRenewAge *string) {
	o.SecuritySettingsKerberosMaxRenewAge = securitySettingsKerberosMaxRenewAge
}

// WithSecuritySettingsKerberosMaxTicketAge adds the securitySettingsKerberosMaxTicketAge to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithSecuritySettingsKerberosMaxTicketAge(securitySettingsKerberosMaxTicketAge *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetSecuritySettingsKerberosMaxTicketAge(securitySettingsKerberosMaxTicketAge)
	return o
}

// SetSecuritySettingsKerberosMaxTicketAge adds the securitySettingsKerberosMaxTicketAge to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetSecuritySettingsKerberosMaxTicketAge(securitySettingsKerberosMaxTicketAge *string) {
	o.SecuritySettingsKerberosMaxTicketAge = securitySettingsKerberosMaxTicketAge
}

// WithSecuritySettingsPrivilegeRightsChangeNotifyUsers adds the securitySettingsPrivilegeRightsChangeNotifyUsers to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithSecuritySettingsPrivilegeRightsChangeNotifyUsers(securitySettingsPrivilegeRightsChangeNotifyUsers *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetSecuritySettingsPrivilegeRightsChangeNotifyUsers(securitySettingsPrivilegeRightsChangeNotifyUsers)
	return o
}

// SetSecuritySettingsPrivilegeRightsChangeNotifyUsers adds the securitySettingsPrivilegeRightsChangeNotifyUsers to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetSecuritySettingsPrivilegeRightsChangeNotifyUsers(securitySettingsPrivilegeRightsChangeNotifyUsers *string) {
	o.SecuritySettingsPrivilegeRightsChangeNotifyUsers = securitySettingsPrivilegeRightsChangeNotifyUsers
}

// WithSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers adds the securitySettingsPrivilegeRightsSecurityPrivilegeUsers to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers(securitySettingsPrivilegeRightsSecurityPrivilegeUsers *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers(securitySettingsPrivilegeRightsSecurityPrivilegeUsers)
	return o
}

// SetSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers adds the securitySettingsPrivilegeRightsSecurityPrivilegeUsers to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers(securitySettingsPrivilegeRightsSecurityPrivilegeUsers *string) {
	o.SecuritySettingsPrivilegeRightsSecurityPrivilegeUsers = securitySettingsPrivilegeRightsSecurityPrivilegeUsers
}

// WithSecuritySettingsPrivilegeRightsTakeOwnershipUsers adds the securitySettingsPrivilegeRightsTakeOwnershipUsers to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithSecuritySettingsPrivilegeRightsTakeOwnershipUsers(securitySettingsPrivilegeRightsTakeOwnershipUsers *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetSecuritySettingsPrivilegeRightsTakeOwnershipUsers(securitySettingsPrivilegeRightsTakeOwnershipUsers)
	return o
}

// SetSecuritySettingsPrivilegeRightsTakeOwnershipUsers adds the securitySettingsPrivilegeRightsTakeOwnershipUsers to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetSecuritySettingsPrivilegeRightsTakeOwnershipUsers(securitySettingsPrivilegeRightsTakeOwnershipUsers *string) {
	o.SecuritySettingsPrivilegeRightsTakeOwnershipUsers = securitySettingsPrivilegeRightsTakeOwnershipUsers
}

// WithSecuritySettingsRegistryValuesSigningRequired adds the securitySettingsRegistryValuesSigningRequired to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithSecuritySettingsRegistryValuesSigningRequired(securitySettingsRegistryValuesSigningRequired *bool) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetSecuritySettingsRegistryValuesSigningRequired(securitySettingsRegistryValuesSigningRequired)
	return o
}

// SetSecuritySettingsRegistryValuesSigningRequired adds the securitySettingsRegistryValuesSigningRequired to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetSecuritySettingsRegistryValuesSigningRequired(securitySettingsRegistryValuesSigningRequired *bool) {
	o.SecuritySettingsRegistryValuesSigningRequired = securitySettingsRegistryValuesSigningRequired
}

// WithSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted adds the securitySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted(securitySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted *bool) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted(securitySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted)
	return o
}

// SetSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted adds the securitySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted(securitySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted *bool) {
	o.SecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted = securitySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted
}

// WithSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser adds the securitySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser(securitySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser(securitySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser)
	return o
}

// SetSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser adds the securitySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser(securitySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser *string) {
	o.SecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser = securitySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser
}

// WithSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts adds the securitySettingsRestrictAnonymousNoEnumerationOfSamAccounts to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts(securitySettingsRestrictAnonymousNoEnumerationOfSamAccounts *bool) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts(securitySettingsRestrictAnonymousNoEnumerationOfSamAccounts)
	return o
}

// SetSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts adds the securitySettingsRestrictAnonymousNoEnumerationOfSamAccounts to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts(securitySettingsRestrictAnonymousNoEnumerationOfSamAccounts *bool) {
	o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts = securitySettingsRestrictAnonymousNoEnumerationOfSamAccounts
}

// WithSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares adds the securitySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares(securitySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares *bool) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares(securitySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares)
	return o
}

// SetSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares adds the securitySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares(securitySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares *bool) {
	o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares = securitySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares
}

// WithSecuritySettingsRestrictedGroups adds the securitySettingsRestrictedGroups to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithSecuritySettingsRestrictedGroups(securitySettingsRestrictedGroups *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetSecuritySettingsRestrictedGroups(securitySettingsRestrictedGroups)
	return o
}

// SetSecuritySettingsRestrictedGroups adds the securitySettingsRestrictedGroups to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetSecuritySettingsRestrictedGroups(securitySettingsRestrictedGroups *string) {
	o.SecuritySettingsRestrictedGroups = securitySettingsRestrictedGroups
}

// WithSvmName adds the svmName to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithSvmName(svmName *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithSvmUUID(svmUUID *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithUUID(uuid *string) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVersion adds the version to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WithVersion(version *int64) *PoliciesAndRulesToBeAppliedCollectionGetParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the policies and rules to be applied collection get params
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) SetVersion(version *int64) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CentralAccessPolicySettings != nil {

		// query param central_access_policy_settings
		var qrCentralAccessPolicySettings string

		if o.CentralAccessPolicySettings != nil {
			qrCentralAccessPolicySettings = *o.CentralAccessPolicySettings
		}
		qCentralAccessPolicySettings := qrCentralAccessPolicySettings
		if qCentralAccessPolicySettings != "" {

			if err := r.SetQueryParam("central_access_policy_settings", qCentralAccessPolicySettings); err != nil {
				return err
			}
		}
	}

	if o.CentralAccessPolicyStagingAuditType != nil {

		// query param central_access_policy_staging_audit_type
		var qrCentralAccessPolicyStagingAuditType string

		if o.CentralAccessPolicyStagingAuditType != nil {
			qrCentralAccessPolicyStagingAuditType = *o.CentralAccessPolicyStagingAuditType
		}
		qCentralAccessPolicyStagingAuditType := qrCentralAccessPolicyStagingAuditType
		if qCentralAccessPolicyStagingAuditType != "" {

			if err := r.SetQueryParam("central_access_policy_staging_audit_type", qCentralAccessPolicyStagingAuditType); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.Extensions != nil {

		// query param extensions
		var qrExtensions string

		if o.Extensions != nil {
			qrExtensions = *o.Extensions
		}
		qExtensions := qrExtensions
		if qExtensions != "" {

			if err := r.SetQueryParam("extensions", qExtensions); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.FileSystemPath != nil {

		// query param file_system_path
		var qrFileSystemPath string

		if o.FileSystemPath != nil {
			qrFileSystemPath = *o.FileSystemPath
		}
		qFileSystemPath := qrFileSystemPath
		if qFileSystemPath != "" {

			if err := r.SetQueryParam("file_system_path", qFileSystemPath); err != nil {
				return err
			}
		}
	}

	if o.Index != nil {

		// query param index
		var qrIndex int64

		if o.Index != nil {
			qrIndex = *o.Index
		}
		qIndex := swag.FormatInt64(qrIndex)
		if qIndex != "" {

			if err := r.SetQueryParam("index", qIndex); err != nil {
				return err
			}
		}
	}

	if o.LdapPath != nil {

		// query param ldap_path
		var qrLdapPath string

		if o.LdapPath != nil {
			qrLdapPath = *o.LdapPath
		}
		qLdapPath := qrLdapPath
		if qLdapPath != "" {

			if err := r.SetQueryParam("ldap_path", qLdapPath); err != nil {
				return err
			}
		}
	}

	if o.Link != nil {

		// query param link
		var qrLink string

		if o.Link != nil {
			qrLink = *o.Link
		}
		qLink := qrLink
		if qLink != "" {

			if err := r.SetQueryParam("link", qLink); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.RegistrySettingsBranchcacheHashPublicationMode != nil {

		// query param registry_settings.branchcache.hash_publication_mode
		var qrRegistrySettingsBranchcacheHashPublicationMode string

		if o.RegistrySettingsBranchcacheHashPublicationMode != nil {
			qrRegistrySettingsBranchcacheHashPublicationMode = *o.RegistrySettingsBranchcacheHashPublicationMode
		}
		qRegistrySettingsBranchcacheHashPublicationMode := qrRegistrySettingsBranchcacheHashPublicationMode
		if qRegistrySettingsBranchcacheHashPublicationMode != "" {

			if err := r.SetQueryParam("registry_settings.branchcache.hash_publication_mode", qRegistrySettingsBranchcacheHashPublicationMode); err != nil {
				return err
			}
		}
	}

	if o.RegistrySettingsBranchcacheSupportedHashVersion != nil {

		// query param registry_settings.branchcache.supported_hash_version
		var qrRegistrySettingsBranchcacheSupportedHashVersion string

		if o.RegistrySettingsBranchcacheSupportedHashVersion != nil {
			qrRegistrySettingsBranchcacheSupportedHashVersion = *o.RegistrySettingsBranchcacheSupportedHashVersion
		}
		qRegistrySettingsBranchcacheSupportedHashVersion := qrRegistrySettingsBranchcacheSupportedHashVersion
		if qRegistrySettingsBranchcacheSupportedHashVersion != "" {

			if err := r.SetQueryParam("registry_settings.branchcache.supported_hash_version", qRegistrySettingsBranchcacheSupportedHashVersion); err != nil {
				return err
			}
		}
	}

	if o.RegistrySettingsRefreshTimeInterval != nil {

		// query param registry_settings.refresh_time_interval
		var qrRegistrySettingsRefreshTimeInterval string

		if o.RegistrySettingsRefreshTimeInterval != nil {
			qrRegistrySettingsRefreshTimeInterval = *o.RegistrySettingsRefreshTimeInterval
		}
		qRegistrySettingsRefreshTimeInterval := qrRegistrySettingsRefreshTimeInterval
		if qRegistrySettingsRefreshTimeInterval != "" {

			if err := r.SetQueryParam("registry_settings.refresh_time_interval", qRegistrySettingsRefreshTimeInterval); err != nil {
				return err
			}
		}
	}

	if o.RegistrySettingsRefreshTimeRandomOffset != nil {

		// query param registry_settings.refresh_time_random_offset
		var qrRegistrySettingsRefreshTimeRandomOffset string

		if o.RegistrySettingsRefreshTimeRandomOffset != nil {
			qrRegistrySettingsRefreshTimeRandomOffset = *o.RegistrySettingsRefreshTimeRandomOffset
		}
		qRegistrySettingsRefreshTimeRandomOffset := qrRegistrySettingsRefreshTimeRandomOffset
		if qRegistrySettingsRefreshTimeRandomOffset != "" {

			if err := r.SetQueryParam("registry_settings.refresh_time_random_offset", qRegistrySettingsRefreshTimeRandomOffset); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsEventAuditSettingsLogonType != nil {

		// query param security_settings.event_audit_settings.logon_type
		var qrSecuritySettingsEventAuditSettingsLogonType string

		if o.SecuritySettingsEventAuditSettingsLogonType != nil {
			qrSecuritySettingsEventAuditSettingsLogonType = *o.SecuritySettingsEventAuditSettingsLogonType
		}
		qSecuritySettingsEventAuditSettingsLogonType := qrSecuritySettingsEventAuditSettingsLogonType
		if qSecuritySettingsEventAuditSettingsLogonType != "" {

			if err := r.SetQueryParam("security_settings.event_audit_settings.logon_type", qSecuritySettingsEventAuditSettingsLogonType); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsEventAuditSettingsObjectAccessType != nil {

		// query param security_settings.event_audit_settings.object_access_type
		var qrSecuritySettingsEventAuditSettingsObjectAccessType string

		if o.SecuritySettingsEventAuditSettingsObjectAccessType != nil {
			qrSecuritySettingsEventAuditSettingsObjectAccessType = *o.SecuritySettingsEventAuditSettingsObjectAccessType
		}
		qSecuritySettingsEventAuditSettingsObjectAccessType := qrSecuritySettingsEventAuditSettingsObjectAccessType
		if qSecuritySettingsEventAuditSettingsObjectAccessType != "" {

			if err := r.SetQueryParam("security_settings.event_audit_settings.object_access_type", qSecuritySettingsEventAuditSettingsObjectAccessType); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsEventLogSettingsMaxSize != nil {

		// query param security_settings.event_log_settings.max_size
		var qrSecuritySettingsEventLogSettingsMaxSize int64

		if o.SecuritySettingsEventLogSettingsMaxSize != nil {
			qrSecuritySettingsEventLogSettingsMaxSize = *o.SecuritySettingsEventLogSettingsMaxSize
		}
		qSecuritySettingsEventLogSettingsMaxSize := swag.FormatInt64(qrSecuritySettingsEventLogSettingsMaxSize)
		if qSecuritySettingsEventLogSettingsMaxSize != "" {

			if err := r.SetQueryParam("security_settings.event_log_settings.max_size", qSecuritySettingsEventLogSettingsMaxSize); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsEventLogSettingsRetentionMethod != nil {

		// query param security_settings.event_log_settings.retention_method
		var qrSecuritySettingsEventLogSettingsRetentionMethod string

		if o.SecuritySettingsEventLogSettingsRetentionMethod != nil {
			qrSecuritySettingsEventLogSettingsRetentionMethod = *o.SecuritySettingsEventLogSettingsRetentionMethod
		}
		qSecuritySettingsEventLogSettingsRetentionMethod := qrSecuritySettingsEventLogSettingsRetentionMethod
		if qSecuritySettingsEventLogSettingsRetentionMethod != "" {

			if err := r.SetQueryParam("security_settings.event_log_settings.retention_method", qSecuritySettingsEventLogSettingsRetentionMethod); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsFilesOrFolders != nil {

		// query param security_settings.files_or_folders
		var qrSecuritySettingsFilesOrFolders string

		if o.SecuritySettingsFilesOrFolders != nil {
			qrSecuritySettingsFilesOrFolders = *o.SecuritySettingsFilesOrFolders
		}
		qSecuritySettingsFilesOrFolders := qrSecuritySettingsFilesOrFolders
		if qSecuritySettingsFilesOrFolders != "" {

			if err := r.SetQueryParam("security_settings.files_or_folders", qSecuritySettingsFilesOrFolders); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsKerberosMaxClockSkew != nil {

		// query param security_settings.kerberos.max_clock_skew
		var qrSecuritySettingsKerberosMaxClockSkew string

		if o.SecuritySettingsKerberosMaxClockSkew != nil {
			qrSecuritySettingsKerberosMaxClockSkew = *o.SecuritySettingsKerberosMaxClockSkew
		}
		qSecuritySettingsKerberosMaxClockSkew := qrSecuritySettingsKerberosMaxClockSkew
		if qSecuritySettingsKerberosMaxClockSkew != "" {

			if err := r.SetQueryParam("security_settings.kerberos.max_clock_skew", qSecuritySettingsKerberosMaxClockSkew); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsKerberosMaxRenewAge != nil {

		// query param security_settings.kerberos.max_renew_age
		var qrSecuritySettingsKerberosMaxRenewAge string

		if o.SecuritySettingsKerberosMaxRenewAge != nil {
			qrSecuritySettingsKerberosMaxRenewAge = *o.SecuritySettingsKerberosMaxRenewAge
		}
		qSecuritySettingsKerberosMaxRenewAge := qrSecuritySettingsKerberosMaxRenewAge
		if qSecuritySettingsKerberosMaxRenewAge != "" {

			if err := r.SetQueryParam("security_settings.kerberos.max_renew_age", qSecuritySettingsKerberosMaxRenewAge); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsKerberosMaxTicketAge != nil {

		// query param security_settings.kerberos.max_ticket_age
		var qrSecuritySettingsKerberosMaxTicketAge string

		if o.SecuritySettingsKerberosMaxTicketAge != nil {
			qrSecuritySettingsKerberosMaxTicketAge = *o.SecuritySettingsKerberosMaxTicketAge
		}
		qSecuritySettingsKerberosMaxTicketAge := qrSecuritySettingsKerberosMaxTicketAge
		if qSecuritySettingsKerberosMaxTicketAge != "" {

			if err := r.SetQueryParam("security_settings.kerberos.max_ticket_age", qSecuritySettingsKerberosMaxTicketAge); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsPrivilegeRightsChangeNotifyUsers != nil {

		// query param security_settings.privilege_rights.change_notify_users
		var qrSecuritySettingsPrivilegeRightsChangeNotifyUsers string

		if o.SecuritySettingsPrivilegeRightsChangeNotifyUsers != nil {
			qrSecuritySettingsPrivilegeRightsChangeNotifyUsers = *o.SecuritySettingsPrivilegeRightsChangeNotifyUsers
		}
		qSecuritySettingsPrivilegeRightsChangeNotifyUsers := qrSecuritySettingsPrivilegeRightsChangeNotifyUsers
		if qSecuritySettingsPrivilegeRightsChangeNotifyUsers != "" {

			if err := r.SetQueryParam("security_settings.privilege_rights.change_notify_users", qSecuritySettingsPrivilegeRightsChangeNotifyUsers); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsPrivilegeRightsSecurityPrivilegeUsers != nil {

		// query param security_settings.privilege_rights.security_privilege_users
		var qrSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers string

		if o.SecuritySettingsPrivilegeRightsSecurityPrivilegeUsers != nil {
			qrSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers = *o.SecuritySettingsPrivilegeRightsSecurityPrivilegeUsers
		}
		qSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers := qrSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers
		if qSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers != "" {

			if err := r.SetQueryParam("security_settings.privilege_rights.security_privilege_users", qSecuritySettingsPrivilegeRightsSecurityPrivilegeUsers); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsPrivilegeRightsTakeOwnershipUsers != nil {

		// query param security_settings.privilege_rights.take_ownership_users
		var qrSecuritySettingsPrivilegeRightsTakeOwnershipUsers string

		if o.SecuritySettingsPrivilegeRightsTakeOwnershipUsers != nil {
			qrSecuritySettingsPrivilegeRightsTakeOwnershipUsers = *o.SecuritySettingsPrivilegeRightsTakeOwnershipUsers
		}
		qSecuritySettingsPrivilegeRightsTakeOwnershipUsers := qrSecuritySettingsPrivilegeRightsTakeOwnershipUsers
		if qSecuritySettingsPrivilegeRightsTakeOwnershipUsers != "" {

			if err := r.SetQueryParam("security_settings.privilege_rights.take_ownership_users", qSecuritySettingsPrivilegeRightsTakeOwnershipUsers); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsRegistryValuesSigningRequired != nil {

		// query param security_settings.registry_values.signing_required
		var qrSecuritySettingsRegistryValuesSigningRequired bool

		if o.SecuritySettingsRegistryValuesSigningRequired != nil {
			qrSecuritySettingsRegistryValuesSigningRequired = *o.SecuritySettingsRegistryValuesSigningRequired
		}
		qSecuritySettingsRegistryValuesSigningRequired := swag.FormatBool(qrSecuritySettingsRegistryValuesSigningRequired)
		if qSecuritySettingsRegistryValuesSigningRequired != "" {

			if err := r.SetQueryParam("security_settings.registry_values.signing_required", qSecuritySettingsRegistryValuesSigningRequired); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted != nil {

		// query param security_settings.restrict_anonymous.anonymous_access_to_shares_and_named_pipes_restricted
		var qrSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted bool

		if o.SecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted != nil {
			qrSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted = *o.SecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted
		}
		qSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted := swag.FormatBool(qrSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted)
		if qSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted != "" {

			if err := r.SetQueryParam("security_settings.restrict_anonymous.anonymous_access_to_shares_and_named_pipes_restricted", qSecuritySettingsRestrictAnonymousAnonymousAccessToSharesAndNamedPipesRestricted); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser != nil {

		// query param security_settings.restrict_anonymous.combined_restriction_for_anonymous_user
		var qrSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser string

		if o.SecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser != nil {
			qrSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser = *o.SecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser
		}
		qSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser := qrSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser
		if qSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser != "" {

			if err := r.SetQueryParam("security_settings.restrict_anonymous.combined_restriction_for_anonymous_user", qSecuritySettingsRestrictAnonymousCombinedRestrictionForAnonymousUser); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts != nil {

		// query param security_settings.restrict_anonymous.no_enumeration_of_sam_accounts
		var qrSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts bool

		if o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts != nil {
			qrSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts = *o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts
		}
		qSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts := swag.FormatBool(qrSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts)
		if qSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts != "" {

			if err := r.SetQueryParam("security_settings.restrict_anonymous.no_enumeration_of_sam_accounts", qSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccounts); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares != nil {

		// query param security_settings.restrict_anonymous.no_enumeration_of_sam_accounts_and_shares
		var qrSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares bool

		if o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares != nil {
			qrSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares = *o.SecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares
		}
		qSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares := swag.FormatBool(qrSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares)
		if qSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares != "" {

			if err := r.SetQueryParam("security_settings.restrict_anonymous.no_enumeration_of_sam_accounts_and_shares", qSecuritySettingsRestrictAnonymousNoEnumerationOfSamAccountsAndShares); err != nil {
				return err
			}
		}
	}

	if o.SecuritySettingsRestrictedGroups != nil {

		// query param security_settings.restricted_groups
		var qrSecuritySettingsRestrictedGroups string

		if o.SecuritySettingsRestrictedGroups != nil {
			qrSecuritySettingsRestrictedGroups = *o.SecuritySettingsRestrictedGroups
		}
		qSecuritySettingsRestrictedGroups := qrSecuritySettingsRestrictedGroups
		if qSecuritySettingsRestrictedGroups != "" {

			if err := r.SetQueryParam("security_settings.restricted_groups", qSecuritySettingsRestrictedGroups); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.Version != nil {

		// query param version
		var qrVersion int64

		if o.Version != nil {
			qrVersion = *o.Version
		}
		qVersion := swag.FormatInt64(qrVersion)
		if qVersion != "" {

			if err := r.SetQueryParam("version", qVersion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamPoliciesAndRulesToBeAppliedCollectionGet binds the parameter fields
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamPoliciesAndRulesToBeAppliedCollectionGet binds the parameter order_by
func (o *PoliciesAndRulesToBeAppliedCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
