// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3AuditCreateReader is a Reader for the S3AuditCreate structure.
type S3AuditCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3AuditCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewS3AuditCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewS3AuditCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3AuditCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3AuditCreateCreated creates a S3AuditCreateCreated with default headers values
func NewS3AuditCreateCreated() *S3AuditCreateCreated {
	return &S3AuditCreateCreated{}
}

/*
S3AuditCreateCreated describes a response with status code 201, with default header values.

Created
*/
type S3AuditCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.S3AuditResponse
}

// IsSuccess returns true when this s3 audit create created response has a 2xx status code
func (o *S3AuditCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 audit create created response has a 3xx status code
func (o *S3AuditCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 audit create created response has a 4xx status code
func (o *S3AuditCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 audit create created response has a 5xx status code
func (o *S3AuditCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 audit create created response a status code equal to that given
func (o *S3AuditCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the s3 audit create created response
func (o *S3AuditCreateCreated) Code() int {
	return 201
}

func (o *S3AuditCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/audit/{svm.uuid}/object-store][%d] s3AuditCreateCreated %s", 201, payload)
}

func (o *S3AuditCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/audit/{svm.uuid}/object-store][%d] s3AuditCreateCreated %s", 201, payload)
}

func (o *S3AuditCreateCreated) GetPayload() *models.S3AuditResponse {
	return o.Payload
}

func (o *S3AuditCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.S3AuditResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3AuditCreateAccepted creates a S3AuditCreateAccepted with default headers values
func NewS3AuditCreateAccepted() *S3AuditCreateAccepted {
	return &S3AuditCreateAccepted{}
}

/*
S3AuditCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type S3AuditCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.S3AuditResponse
}

// IsSuccess returns true when this s3 audit create accepted response has a 2xx status code
func (o *S3AuditCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 audit create accepted response has a 3xx status code
func (o *S3AuditCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 audit create accepted response has a 4xx status code
func (o *S3AuditCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 audit create accepted response has a 5xx status code
func (o *S3AuditCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 audit create accepted response a status code equal to that given
func (o *S3AuditCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the s3 audit create accepted response
func (o *S3AuditCreateAccepted) Code() int {
	return 202
}

func (o *S3AuditCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/audit/{svm.uuid}/object-store][%d] s3AuditCreateAccepted %s", 202, payload)
}

func (o *S3AuditCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/audit/{svm.uuid}/object-store][%d] s3AuditCreateAccepted %s", 202, payload)
}

func (o *S3AuditCreateAccepted) GetPayload() *models.S3AuditResponse {
	return o.Payload
}

func (o *S3AuditCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.S3AuditResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3AuditCreateDefault creates a S3AuditCreateDefault with default headers values
func NewS3AuditCreateDefault(code int) *S3AuditCreateDefault {
	return &S3AuditCreateDefault{
		_statusCode: code,
	}
}

/*
	S3AuditCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 140902401 | Failed to create an audit configuration for the SVM. |
| 140902402 | Audit configuration is already present. |
| 140902402 | Audit configuration is already enabled. |
| 140902403 | Failed to create staging volume. |
| 140902415 | Failed to modify an audit configuration because no audit configuration exists for the SVM. |
| 140902416 | Failed to modify audit configuration for SVM. |
| 140902422 | Final consolidation is in progress, audit delete failed. |
| 140902423 | Failed to delete the audit configuration for the SVM. |
| 140902425 | Audit configuration is not available for disabling. |
| 140902430 | Audit configuration is not available for enabling. |
| 140902431 | Audit enable failed, audit configuration already enabled for the SVM. |
| 140902432 | Final consolidation is in progress, audit enable failed. |
| 140902445 | Audit disable failed, audit configuration does not exist for the SVM. |
| 140902446 | Audit disable failed, audit configuration does not exist for the SVM. |
| 140902447 | Audit disable failed. |
| 140902456 | The specified log_path does not exist. |
| 140902457 | The log_path must be a directory. |
| 140902458 | The log_path must be a canonical path in the SVM's namespace. |
| 140902459 | The log_path cannot be empty. |
| 140902460 | Rotate size must be greater than or equal to 1024 KB. |
| 140902461 | The destination path must not contain a symbolic link. |
| 140902470 | The log_path exceeds a maximum supported length of characters. |
| 140902471 | The log_path contains an unsupported read-only (DP/LS) volume. |
| 140902472 | The log_path is not a valid destination for the SVM. |
| 140902474 | The log_path contains an unsupported Snaplock volume. |
| 140902478 | The log_path validation failed. |
| 140902478 | The log_path cannot be accessed for validation. |
| 140902490 | Audit configuration is absent for rotate. |
| 140902491 | Failed to rotate audit log. |
| 140902492 | Cannot rotate audit log, auditing is not enabled for this SVM. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
ONTAP Error Response Codes
| Error Code | Description |
| ---------- | ----------- |
| 262186     | Field "log.retention.duration" cannot be used with field "log.retention.count" |
| 9699340    | SVM UUID lookup failed                                                         |
| 9699407    | Additional fields are provided                                                 |
*/
type S3AuditCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 audit create default response has a 2xx status code
func (o *S3AuditCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 audit create default response has a 3xx status code
func (o *S3AuditCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 audit create default response has a 4xx status code
func (o *S3AuditCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 audit create default response has a 5xx status code
func (o *S3AuditCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 audit create default response a status code equal to that given
func (o *S3AuditCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 audit create default response
func (o *S3AuditCreateDefault) Code() int {
	return o._statusCode
}

func (o *S3AuditCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/audit/{svm.uuid}/object-store][%d] s3_audit_create default %s", o._statusCode, payload)
}

func (o *S3AuditCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/audit/{svm.uuid}/object-store][%d] s3_audit_create default %s", o._statusCode, payload)
}

func (o *S3AuditCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3AuditCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
