// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3AuditDeleteReader is a Reader for the S3AuditDelete structure.
type S3AuditDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3AuditDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewS3AuditDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewS3AuditDeleteAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3AuditDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3AuditDeleteOK creates a S3AuditDeleteOK with default headers values
func NewS3AuditDeleteOK() *S3AuditDeleteOK {
	return &S3AuditDeleteOK{}
}

/*
S3AuditDeleteOK describes a response with status code 200, with default header values.

OK
*/
type S3AuditDeleteOK struct {
	Payload *models.S3AuditJobLinkResponse
}

// IsSuccess returns true when this s3 audit delete o k response has a 2xx status code
func (o *S3AuditDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 audit delete o k response has a 3xx status code
func (o *S3AuditDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 audit delete o k response has a 4xx status code
func (o *S3AuditDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 audit delete o k response has a 5xx status code
func (o *S3AuditDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 audit delete o k response a status code equal to that given
func (o *S3AuditDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s3 audit delete o k response
func (o *S3AuditDeleteOK) Code() int {
	return 200
}

func (o *S3AuditDeleteOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/audit/{svm.uuid}/object-store][%d] s3AuditDeleteOK %s", 200, payload)
}

func (o *S3AuditDeleteOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/audit/{svm.uuid}/object-store][%d] s3AuditDeleteOK %s", 200, payload)
}

func (o *S3AuditDeleteOK) GetPayload() *models.S3AuditJobLinkResponse {
	return o.Payload
}

func (o *S3AuditDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.S3AuditJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3AuditDeleteAccepted creates a S3AuditDeleteAccepted with default headers values
func NewS3AuditDeleteAccepted() *S3AuditDeleteAccepted {
	return &S3AuditDeleteAccepted{}
}

/*
S3AuditDeleteAccepted describes a response with status code 202, with default header values.

Accepted
*/
type S3AuditDeleteAccepted struct {
	Payload *models.S3AuditJobLinkResponse
}

// IsSuccess returns true when this s3 audit delete accepted response has a 2xx status code
func (o *S3AuditDeleteAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 audit delete accepted response has a 3xx status code
func (o *S3AuditDeleteAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 audit delete accepted response has a 4xx status code
func (o *S3AuditDeleteAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 audit delete accepted response has a 5xx status code
func (o *S3AuditDeleteAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 audit delete accepted response a status code equal to that given
func (o *S3AuditDeleteAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the s3 audit delete accepted response
func (o *S3AuditDeleteAccepted) Code() int {
	return 202
}

func (o *S3AuditDeleteAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/audit/{svm.uuid}/object-store][%d] s3AuditDeleteAccepted %s", 202, payload)
}

func (o *S3AuditDeleteAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/audit/{svm.uuid}/object-store][%d] s3AuditDeleteAccepted %s", 202, payload)
}

func (o *S3AuditDeleteAccepted) GetPayload() *models.S3AuditJobLinkResponse {
	return o.Payload
}

func (o *S3AuditDeleteAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.S3AuditJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3AuditDeleteDefault creates a S3AuditDeleteDefault with default headers values
func NewS3AuditDeleteDefault(code int) *S3AuditDeleteDefault {
	return &S3AuditDeleteDefault{
		_statusCode: code,
	}
}

/*
	S3AuditDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 140902420 | Failed to delete audit configuration for the SVM. |
| 140902421 | Failed to delete audit configuration for the SVM because audit is enabled for the SVM. |
| 140902422 | Failed to delete audit configuration for the SVM because final consolidation is in progress. Wait a few minutes, and try the operation again. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type S3AuditDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 audit delete default response has a 2xx status code
func (o *S3AuditDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 audit delete default response has a 3xx status code
func (o *S3AuditDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 audit delete default response has a 4xx status code
func (o *S3AuditDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 audit delete default response has a 5xx status code
func (o *S3AuditDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 audit delete default response a status code equal to that given
func (o *S3AuditDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 audit delete default response
func (o *S3AuditDeleteDefault) Code() int {
	return o._statusCode
}

func (o *S3AuditDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/audit/{svm.uuid}/object-store][%d] s3_audit_delete default %s", o._statusCode, payload)
}

func (o *S3AuditDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/audit/{svm.uuid}/object-store][%d] s3_audit_delete default %s", o._statusCode, payload)
}

func (o *S3AuditDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3AuditDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
