// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3AuditModifyReader is a Reader for the S3AuditModify structure.
type S3AuditModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3AuditModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewS3AuditModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewS3AuditModifyAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3AuditModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3AuditModifyOK creates a S3AuditModifyOK with default headers values
func NewS3AuditModifyOK() *S3AuditModifyOK {
	return &S3AuditModifyOK{}
}

/*
S3AuditModifyOK describes a response with status code 200, with default header values.

OK
*/
type S3AuditModifyOK struct {
	Payload *models.S3AuditJobLinkResponse
}

// IsSuccess returns true when this s3 audit modify o k response has a 2xx status code
func (o *S3AuditModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 audit modify o k response has a 3xx status code
func (o *S3AuditModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 audit modify o k response has a 4xx status code
func (o *S3AuditModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 audit modify o k response has a 5xx status code
func (o *S3AuditModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 audit modify o k response a status code equal to that given
func (o *S3AuditModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s3 audit modify o k response
func (o *S3AuditModifyOK) Code() int {
	return 200
}

func (o *S3AuditModifyOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/audit/{svm.uuid}/object-store][%d] s3AuditModifyOK %s", 200, payload)
}

func (o *S3AuditModifyOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/audit/{svm.uuid}/object-store][%d] s3AuditModifyOK %s", 200, payload)
}

func (o *S3AuditModifyOK) GetPayload() *models.S3AuditJobLinkResponse {
	return o.Payload
}

func (o *S3AuditModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.S3AuditJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3AuditModifyAccepted creates a S3AuditModifyAccepted with default headers values
func NewS3AuditModifyAccepted() *S3AuditModifyAccepted {
	return &S3AuditModifyAccepted{}
}

/*
S3AuditModifyAccepted describes a response with status code 202, with default header values.

Accepted
*/
type S3AuditModifyAccepted struct {
	Payload *models.S3AuditJobLinkResponse
}

// IsSuccess returns true when this s3 audit modify accepted response has a 2xx status code
func (o *S3AuditModifyAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 audit modify accepted response has a 3xx status code
func (o *S3AuditModifyAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 audit modify accepted response has a 4xx status code
func (o *S3AuditModifyAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 audit modify accepted response has a 5xx status code
func (o *S3AuditModifyAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 audit modify accepted response a status code equal to that given
func (o *S3AuditModifyAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the s3 audit modify accepted response
func (o *S3AuditModifyAccepted) Code() int {
	return 202
}

func (o *S3AuditModifyAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/audit/{svm.uuid}/object-store][%d] s3AuditModifyAccepted %s", 202, payload)
}

func (o *S3AuditModifyAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/audit/{svm.uuid}/object-store][%d] s3AuditModifyAccepted %s", 202, payload)
}

func (o *S3AuditModifyAccepted) GetPayload() *models.S3AuditJobLinkResponse {
	return o.Payload
}

func (o *S3AuditModifyAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.S3AuditJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3AuditModifyDefault creates a S3AuditModifyDefault with default headers values
func NewS3AuditModifyDefault(code int) *S3AuditModifyDefault {
	return &S3AuditModifyDefault{
		_statusCode: code,
	}
}

/*
	S3AuditModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 140902401 | Failed to create an audit configuration for the SVM. |
| 140902402 | Audit configuration is already present. |
| 140902402 | Audit configuration is already enabled. |
| 140902403 | Failed to create staging volume. |
| 140902415 | Failed to modify an audit configuration because no audit configuration exists for SVM. |
| 140902416 | Failed to modify audit configuration for SVM. |
| 140902422 | Final consolidation is in progress, audit delete failed. |
| 140902423 | Failed to delete the audit configuration for the SVM. |
| 140902425 | Audit configuration is not available for disabling. |
| 140902430 | Audit configuration is not available for enabling. |
| 140902431 | Audit enable failed, audit configuration already enabled for the SVM. |
| 140902432 | Final consolidation is in progress, audit enable failed. |
| 140902445 | Audit disable failed, audit configuration does not exist for the SVM. |
| 140902446 | Audit configuration is already disabled. |
| 140902446 | Audit disable failed, audit configuration does not exist for the SVM. |
| 140902456 | The specified log_path does not exist. |
| 140902457 | The log_path must be a directory. |
| 140902458 | The log_path must be a canonical path in the SVM's namespace. |
| 140902459 | The log_path cannot be empty. |
| 140902460 | Rotate size must be greater than or equal to 1024 KB. |
| 140902461 | The destination path must not contain a symbolic link. |
| 140902470 | The log_path exceeds a maximum supported length of characters. |
| 140902471 | The log_path contains an unsupported read-only (DP/LS) volume. |
| 140902472 | The log_path is not a valid destination for the SVM. |
| 140902474 | The log_path contains an unsupported Snaplock volume. |
| 140902478 | The log_path validation failed. |
| 140902478 | The log_path cannot be accessed for validation. |
| 140902479 | No other fields can be specified when \"enabled\" is specified. |
| 140902490 | Audit configuration is absent for rotate. |
| 140902491 | Failed to rotate audit log. |
| 140902492 | Cannot rotate audit log, auditing is not enabled for this SVM. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
ONTAP Error Response Codes
| Error Code | Description |
| ---------- | ----------- |
| 262186     | Field "log.retention.duration" cannot be used with field "log.retention.count" |
| 9699340    | SVM UUID lookup failed                                                         |
| 9699407    | Additional fields are provided                                                 |
*/
type S3AuditModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 audit modify default response has a 2xx status code
func (o *S3AuditModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 audit modify default response has a 3xx status code
func (o *S3AuditModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 audit modify default response has a 4xx status code
func (o *S3AuditModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 audit modify default response has a 5xx status code
func (o *S3AuditModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 audit modify default response a status code equal to that given
func (o *S3AuditModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 audit modify default response
func (o *S3AuditModifyDefault) Code() int {
	return o._statusCode
}

func (o *S3AuditModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/audit/{svm.uuid}/object-store][%d] s3_audit_modify default %s", o._statusCode, payload)
}

func (o *S3AuditModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/audit/{svm.uuid}/object-store][%d] s3_audit_modify default %s", o._statusCode, payload)
}

func (o *S3AuditModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3AuditModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
