// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ShadowcopyModifyCollectionReader is a Reader for the ShadowcopyModifyCollection structure.
type ShadowcopyModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ShadowcopyModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewShadowcopyModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewShadowcopyModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewShadowcopyModifyCollectionOK creates a ShadowcopyModifyCollectionOK with default headers values
func NewShadowcopyModifyCollectionOK() *ShadowcopyModifyCollectionOK {
	return &ShadowcopyModifyCollectionOK{}
}

/*
ShadowcopyModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ShadowcopyModifyCollectionOK struct {
	Payload *models.ShadowcopyAddFiles
}

// IsSuccess returns true when this shadowcopy modify collection o k response has a 2xx status code
func (o *ShadowcopyModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this shadowcopy modify collection o k response has a 3xx status code
func (o *ShadowcopyModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this shadowcopy modify collection o k response has a 4xx status code
func (o *ShadowcopyModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this shadowcopy modify collection o k response has a 5xx status code
func (o *ShadowcopyModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this shadowcopy modify collection o k response a status code equal to that given
func (o *ShadowcopyModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the shadowcopy modify collection o k response
func (o *ShadowcopyModifyCollectionOK) Code() int {
	return 200
}

func (o *ShadowcopyModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/shadow-copies][%d] shadowcopyModifyCollectionOK %s", 200, payload)
}

func (o *ShadowcopyModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/shadow-copies][%d] shadowcopyModifyCollectionOK %s", 200, payload)
}

func (o *ShadowcopyModifyCollectionOK) GetPayload() *models.ShadowcopyAddFiles {
	return o.Payload
}

func (o *ShadowcopyModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ShadowcopyAddFiles)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewShadowcopyModifyCollectionDefault creates a ShadowcopyModifyCollectionDefault with default headers values
func NewShadowcopyModifyCollectionDefault(code int) *ShadowcopyModifyCollectionDefault {
	return &ShadowcopyModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	ShadowcopyModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262196     | The 'svm' field is not supported in the body of a PATCH request. |
*/
type ShadowcopyModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this shadowcopy modify collection default response has a 2xx status code
func (o *ShadowcopyModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this shadowcopy modify collection default response has a 3xx status code
func (o *ShadowcopyModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this shadowcopy modify collection default response has a 4xx status code
func (o *ShadowcopyModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this shadowcopy modify collection default response has a 5xx status code
func (o *ShadowcopyModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this shadowcopy modify collection default response a status code equal to that given
func (o *ShadowcopyModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the shadowcopy modify collection default response
func (o *ShadowcopyModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ShadowcopyModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/shadow-copies][%d] shadowcopy_modify_collection default %s", o._statusCode, payload)
}

func (o *ShadowcopyModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/shadow-copies][%d] shadowcopy_modify_collection default %s", o._statusCode, payload)
}

func (o *ShadowcopyModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ShadowcopyModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ShadowcopyModifyCollectionBody shadowcopy modify collection body
swagger:model ShadowcopyModifyCollectionBody
*/
type ShadowcopyModifyCollectionBody struct {

	// links
	Links *models.ShadowcopyInlineLinks `json:"_links,omitempty"`

	// The universally-unique identifier of the client's shadow copy.
	// Example: abc13450-1f19-40ba-9b82-ebf277517e7e
	// Read Only: true
	ClientUUID *string `json:"client_uuid,omitempty"`

	// The path of the destination directory. The path is in UTF8 and uses forward
	// slash as a directory separator. The path is relative to the root of the volume.
	//
	// Example: /dir2
	DestinationDir *string `json:"destination_dir,omitempty"`

	// The list of files to shadow copy in the share. The path is in UTF8 and uses forward
	// slash as a directory separator. The path is relative to the root of the share.
	//
	// Example: ["/vhd1","/vhd2"]
	ShadowcopyInlineFiles []*string `json:"files,omitempty"`

	// shadowcopy response inline records
	ShadowcopyResponseInlineRecords []*models.Shadowcopy `json:"records,omitempty"`

	// shadowcopy set
	ShadowcopySet *models.ShadowcopyInlineShadowcopySet `json:"shadowcopy_set,omitempty"`

	// share
	Share *models.ShadowcopyInlineShare `json:"share,omitempty"`

	// The path of the source directory. The path is in UTF8 and uses forward slash
	// as a directory separator. The path is relative to the root of the volume.
	//
	// Example: /dir1
	SourceDir *string `json:"source_dir,omitempty"`

	// svm
	Svm *models.ShadowcopyInlineSvm `json:"svm,omitempty"`

	// The universally-unique identifier of the storage's shadow copy.
	// Example: fef32805-1f19-40ba-9b82-ebf277517e7e
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// volume
	Volume *models.ShadowcopyInlineVolume `json:"volume,omitempty"`

	// Specifies what needs to be restored. False specifies the directory only.
	// True indicates the directory and its content.
	//
	WithContent *bool `json:"with_content,omitempty"`
}

// Validate validates this shadowcopy modify collection body
func (o *ShadowcopyModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateShadowcopyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateShadowcopySet(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateShare(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopyModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ShadowcopyModifyCollectionBody) validateShadowcopyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.ShadowcopyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.ShadowcopyResponseInlineRecords); i++ {
		if swag.IsZero(o.ShadowcopyResponseInlineRecords[i]) { // not required
			continue
		}

		if o.ShadowcopyResponseInlineRecords[i] != nil {
			if err := o.ShadowcopyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShadowcopyModifyCollectionBody) validateShadowcopySet(formats strfmt.Registry) error {
	if swag.IsZero(o.ShadowcopySet) { // not required
		return nil
	}

	if o.ShadowcopySet != nil {
		if err := o.ShadowcopySet.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "shadowcopy_set")
			}
			return err
		}
	}

	return nil
}

func (o *ShadowcopyModifyCollectionBody) validateShare(formats strfmt.Registry) error {
	if swag.IsZero(o.Share) { // not required
		return nil
	}

	if o.Share != nil {
		if err := o.Share.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "share")
			}
			return err
		}
	}

	return nil
}

func (o *ShadowcopyModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *ShadowcopyModifyCollectionBody) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(o.Volume) { // not required
		return nil
	}

	if o.Volume != nil {
		if err := o.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shadowcopy modify collection body based on the context it is used
func (o *ShadowcopyModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateClientUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateShadowcopyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateShadowcopySet(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateShare(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopyModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ShadowcopyModifyCollectionBody) contextValidateClientUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"client_uuid", "body", o.ClientUUID); err != nil {
		return err
	}

	return nil
}

func (o *ShadowcopyModifyCollectionBody) contextValidateShadowcopyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ShadowcopyResponseInlineRecords); i++ {

		if o.ShadowcopyResponseInlineRecords[i] != nil {
			if err := o.ShadowcopyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShadowcopyModifyCollectionBody) contextValidateShadowcopySet(ctx context.Context, formats strfmt.Registry) error {

	if o.ShadowcopySet != nil {
		if err := o.ShadowcopySet.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "shadowcopy_set")
			}
			return err
		}
	}

	return nil
}

func (o *ShadowcopyModifyCollectionBody) contextValidateShare(ctx context.Context, formats strfmt.Registry) error {

	if o.Share != nil {
		if err := o.Share.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "share")
			}
			return err
		}
	}

	return nil
}

func (o *ShadowcopyModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *ShadowcopyModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *ShadowcopyModifyCollectionBody) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if o.Volume != nil {
		if err := o.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShadowcopyModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShadowcopyModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res ShadowcopyModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShadowcopyInlineLinks shadowcopy inline links
swagger:model shadowcopy_inline__links
*/
type ShadowcopyInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this shadowcopy inline links
func (o *ShadowcopyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shadowcopy inline links based on the context it is used
func (o *ShadowcopyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShadowcopyInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShadowcopyInlineLinks) UnmarshalBinary(b []byte) error {
	var res ShadowcopyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShadowcopyInlineShadowcopySet shadowcopy inline shadowcopy set
swagger:model shadowcopy_inline_shadowcopy_set
*/
type ShadowcopyInlineShadowcopySet struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// uuid
	// Example: 5f4e19f3-5e2d-11ec-8766-005056a7c134
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this shadowcopy inline shadowcopy set
func (o *ShadowcopyInlineShadowcopySet) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopyInlineShadowcopySet) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "shadowcopy_set" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shadowcopy inline shadowcopy set based on the context it is used
func (o *ShadowcopyInlineShadowcopySet) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopyInlineShadowcopySet) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "shadowcopy_set" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShadowcopyInlineShadowcopySet) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShadowcopyInlineShadowcopySet) UnmarshalBinary(b []byte) error {
	var res ShadowcopyInlineShadowcopySet
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShadowcopyInlineShare shadowcopy inline share
swagger:model shadowcopy_inline_share
*/
type ShadowcopyInlineShare struct {

	// links
	Links *models.ShadowcopyInlineShareInlineLinks `json:"_links,omitempty"`

	// Share name
	// Example: sh1
	Name *string `json:"name,omitempty"`
}

// Validate validates this shadowcopy inline share
func (o *ShadowcopyInlineShare) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopyInlineShare) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "share" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shadowcopy inline share based on the context it is used
func (o *ShadowcopyInlineShare) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopyInlineShare) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "share" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShadowcopyInlineShare) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShadowcopyInlineShare) UnmarshalBinary(b []byte) error {
	var res ShadowcopyInlineShare
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShadowcopyInlineShareInlineLinks shadowcopy inline share inline links
swagger:model shadowcopy_inline_share_inline__links
*/
type ShadowcopyInlineShareInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this shadowcopy inline share inline links
func (o *ShadowcopyInlineShareInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopyInlineShareInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "share" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shadowcopy inline share inline links based on the context it is used
func (o *ShadowcopyInlineShareInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopyInlineShareInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "share" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShadowcopyInlineShareInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShadowcopyInlineShareInlineLinks) UnmarshalBinary(b []byte) error {
	var res ShadowcopyInlineShareInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShadowcopyInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model shadowcopy_inline_svm
*/
type ShadowcopyInlineSvm struct {

	// links
	Links *models.ShadowcopyInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this shadowcopy inline svm
func (o *ShadowcopyInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopyInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shadowcopy inline svm based on the context it is used
func (o *ShadowcopyInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopyInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShadowcopyInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShadowcopyInlineSvm) UnmarshalBinary(b []byte) error {
	var res ShadowcopyInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShadowcopyInlineSvmInlineLinks shadowcopy inline svm inline links
swagger:model shadowcopy_inline_svm_inline__links
*/
type ShadowcopyInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this shadowcopy inline svm inline links
func (o *ShadowcopyInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopyInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shadowcopy inline svm inline links based on the context it is used
func (o *ShadowcopyInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopyInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShadowcopyInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShadowcopyInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res ShadowcopyInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShadowcopyInlineVolume The name of the volume where the source and destination directories reside.
swagger:model shadowcopy_inline_volume
*/
type ShadowcopyInlineVolume struct {

	// links
	Links *models.ShadowcopyInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this shadowcopy inline volume
func (o *ShadowcopyInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopyInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shadowcopy inline volume based on the context it is used
func (o *ShadowcopyInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopyInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShadowcopyInlineVolume) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShadowcopyInlineVolume) UnmarshalBinary(b []byte) error {
	var res ShadowcopyInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShadowcopyInlineVolumeInlineLinks shadowcopy inline volume inline links
swagger:model shadowcopy_inline_volume_inline__links
*/
type ShadowcopyInlineVolumeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this shadowcopy inline volume inline links
func (o *ShadowcopyInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopyInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shadowcopy inline volume inline links based on the context it is used
func (o *ShadowcopyInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopyInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShadowcopyInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShadowcopyInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res ShadowcopyInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
