// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ShadowcopySetModifyCollectionReader is a Reader for the ShadowcopySetModifyCollection structure.
type ShadowcopySetModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ShadowcopySetModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewShadowcopySetModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewShadowcopySetModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewShadowcopySetModifyCollectionOK creates a ShadowcopySetModifyCollectionOK with default headers values
func NewShadowcopySetModifyCollectionOK() *ShadowcopySetModifyCollectionOK {
	return &ShadowcopySetModifyCollectionOK{}
}

/*
ShadowcopySetModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ShadowcopySetModifyCollectionOK struct {
}

// IsSuccess returns true when this shadowcopy set modify collection o k response has a 2xx status code
func (o *ShadowcopySetModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this shadowcopy set modify collection o k response has a 3xx status code
func (o *ShadowcopySetModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this shadowcopy set modify collection o k response has a 4xx status code
func (o *ShadowcopySetModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this shadowcopy set modify collection o k response has a 5xx status code
func (o *ShadowcopySetModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this shadowcopy set modify collection o k response a status code equal to that given
func (o *ShadowcopySetModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the shadowcopy set modify collection o k response
func (o *ShadowcopySetModifyCollectionOK) Code() int {
	return 200
}

func (o *ShadowcopySetModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/cifs/shadowcopy-sets][%d] shadowcopySetModifyCollectionOK", 200)
}

func (o *ShadowcopySetModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/cifs/shadowcopy-sets][%d] shadowcopySetModifyCollectionOK", 200)
}

func (o *ShadowcopySetModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewShadowcopySetModifyCollectionDefault creates a ShadowcopySetModifyCollectionDefault with default headers values
func NewShadowcopySetModifyCollectionDefault(code int) *ShadowcopySetModifyCollectionDefault {
	return &ShadowcopySetModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	ShadowcopySetModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262196     | The 'svm' field is not supported in the body of a PATCH request. |
*/
type ShadowcopySetModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this shadowcopy set modify collection default response has a 2xx status code
func (o *ShadowcopySetModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this shadowcopy set modify collection default response has a 3xx status code
func (o *ShadowcopySetModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this shadowcopy set modify collection default response has a 4xx status code
func (o *ShadowcopySetModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this shadowcopy set modify collection default response has a 5xx status code
func (o *ShadowcopySetModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this shadowcopy set modify collection default response a status code equal to that given
func (o *ShadowcopySetModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the shadowcopy set modify collection default response
func (o *ShadowcopySetModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ShadowcopySetModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/shadowcopy-sets][%d] shadowcopy_set_modify_collection default %s", o._statusCode, payload)
}

func (o *ShadowcopySetModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/cifs/shadowcopy-sets][%d] shadowcopy_set_modify_collection default %s", o._statusCode, payload)
}

func (o *ShadowcopySetModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ShadowcopySetModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ShadowcopySetModifyCollectionBody shadowcopy set modify collection body
swagger:model ShadowcopySetModifyCollectionBody
*/
type ShadowcopySetModifyCollectionBody struct {

	// Request the storage system to keep the snapshot copies taken as a part of the shadow copy set creation.
	// Example: true
	KeepSnapshots *bool `json:"keep_snapshots,omitempty"`

	// shadowcopy set response inline records
	ShadowcopySetResponseInlineRecords []*models.ShadowcopySet `json:"records,omitempty"`

	// svm
	Svm *models.ShadowcopySetInlineSvm `json:"svm,omitempty"`

	// The universally-unique identifier of the storage's shadow copy set.
	// Example: f8328660-00e6-11e6-80d9-005056bd65a9
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this shadowcopy set modify collection body
func (o *ShadowcopySetModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateShadowcopySetResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopySetModifyCollectionBody) validateShadowcopySetResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.ShadowcopySetResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.ShadowcopySetResponseInlineRecords); i++ {
		if swag.IsZero(o.ShadowcopySetResponseInlineRecords[i]) { // not required
			continue
		}

		if o.ShadowcopySetResponseInlineRecords[i] != nil {
			if err := o.ShadowcopySetResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShadowcopySetModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shadowcopy set modify collection body based on the context it is used
func (o *ShadowcopySetModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateShadowcopySetResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopySetModifyCollectionBody) contextValidateShadowcopySetResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ShadowcopySetResponseInlineRecords); i++ {

		if o.ShadowcopySetResponseInlineRecords[i] != nil {
			if err := o.ShadowcopySetResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ShadowcopySetModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *ShadowcopySetModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShadowcopySetModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShadowcopySetModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res ShadowcopySetModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShadowcopySetInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model shadowcopy_set_inline_svm
*/
type ShadowcopySetInlineSvm struct {

	// links
	Links *models.ShadowcopySetInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this shadowcopy set inline svm
func (o *ShadowcopySetInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopySetInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shadowcopy set inline svm based on the context it is used
func (o *ShadowcopySetInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopySetInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShadowcopySetInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShadowcopySetInlineSvm) UnmarshalBinary(b []byte) error {
	var res ShadowcopySetInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ShadowcopySetInlineSvmInlineLinks shadowcopy set inline svm inline links
swagger:model shadowcopy_set_inline_svm_inline__links
*/
type ShadowcopySetInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this shadowcopy set inline svm inline links
func (o *ShadowcopySetInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopySetInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this shadowcopy set inline svm inline links based on the context it is used
func (o *ShadowcopySetInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ShadowcopySetInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ShadowcopySetInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ShadowcopySetInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res ShadowcopySetInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
