// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewUserGroupPrivilegesCollectionGetParams creates a new UserGroupPrivilegesCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUserGroupPrivilegesCollectionGetParams() *UserGroupPrivilegesCollectionGetParams {
	return &UserGroupPrivilegesCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUserGroupPrivilegesCollectionGetParamsWithTimeout creates a new UserGroupPrivilegesCollectionGetParams object
// with the ability to set a timeout on a request.
func NewUserGroupPrivilegesCollectionGetParamsWithTimeout(timeout time.Duration) *UserGroupPrivilegesCollectionGetParams {
	return &UserGroupPrivilegesCollectionGetParams{
		timeout: timeout,
	}
}

// NewUserGroupPrivilegesCollectionGetParamsWithContext creates a new UserGroupPrivilegesCollectionGetParams object
// with the ability to set a context for a request.
func NewUserGroupPrivilegesCollectionGetParamsWithContext(ctx context.Context) *UserGroupPrivilegesCollectionGetParams {
	return &UserGroupPrivilegesCollectionGetParams{
		Context: ctx,
	}
}

// NewUserGroupPrivilegesCollectionGetParamsWithHTTPClient creates a new UserGroupPrivilegesCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewUserGroupPrivilegesCollectionGetParamsWithHTTPClient(client *http.Client) *UserGroupPrivilegesCollectionGetParams {
	return &UserGroupPrivilegesCollectionGetParams{
		HTTPClient: client,
	}
}

/*
UserGroupPrivilegesCollectionGetParams contains all the parameters to send to the API endpoint

	for the user group privileges collection get operation.

	Typically these are written to a http.Request.
*/
type UserGroupPrivilegesCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* Privileges.

	   Filter by privileges
	*/
	Privileges *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the user group privileges collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UserGroupPrivilegesCollectionGetParams) WithDefaults() *UserGroupPrivilegesCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the user group privileges collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UserGroupPrivilegesCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := UserGroupPrivilegesCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) WithTimeout(timeout time.Duration) *UserGroupPrivilegesCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) WithContext(ctx context.Context) *UserGroupPrivilegesCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) WithHTTPClient(client *http.Client) *UserGroupPrivilegesCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) WithFields(fields []string) *UserGroupPrivilegesCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) WithMaxRecords(maxRecords *int64) *UserGroupPrivilegesCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) WithName(name *string) *UserGroupPrivilegesCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) WithOrderBy(orderBy []string) *UserGroupPrivilegesCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPrivileges adds the privileges to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) WithPrivileges(privileges *string) *UserGroupPrivilegesCollectionGetParams {
	o.SetPrivileges(privileges)
	return o
}

// SetPrivileges adds the privileges to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) SetPrivileges(privileges *string) {
	o.Privileges = privileges
}

// WithReturnRecords adds the returnRecords to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) WithReturnRecords(returnRecords *bool) *UserGroupPrivilegesCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *UserGroupPrivilegesCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmName adds the svmName to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) WithSvmName(svmName *string) *UserGroupPrivilegesCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) WithSvmUUID(svmUUID *string) *UserGroupPrivilegesCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the user group privileges collection get params
func (o *UserGroupPrivilegesCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *UserGroupPrivilegesCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.Privileges != nil {

		// query param privileges
		var qrPrivileges string

		if o.Privileges != nil {
			qrPrivileges = *o.Privileges
		}
		qPrivileges := qrPrivileges
		if qPrivileges != "" {

			if err := r.SetQueryParam("privileges", qPrivileges); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamUserGroupPrivilegesCollectionGet binds the parameter fields
func (o *UserGroupPrivilegesCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamUserGroupPrivilegesCollectionGet binds the parameter order_by
func (o *UserGroupPrivilegesCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
