// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewUserGroupPrivilegesModifyCollectionParams creates a new UserGroupPrivilegesModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUserGroupPrivilegesModifyCollectionParams() *UserGroupPrivilegesModifyCollectionParams {
	return &UserGroupPrivilegesModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUserGroupPrivilegesModifyCollectionParamsWithTimeout creates a new UserGroupPrivilegesModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewUserGroupPrivilegesModifyCollectionParamsWithTimeout(timeout time.Duration) *UserGroupPrivilegesModifyCollectionParams {
	return &UserGroupPrivilegesModifyCollectionParams{
		timeout: timeout,
	}
}

// NewUserGroupPrivilegesModifyCollectionParamsWithContext creates a new UserGroupPrivilegesModifyCollectionParams object
// with the ability to set a context for a request.
func NewUserGroupPrivilegesModifyCollectionParamsWithContext(ctx context.Context) *UserGroupPrivilegesModifyCollectionParams {
	return &UserGroupPrivilegesModifyCollectionParams{
		Context: ctx,
	}
}

// NewUserGroupPrivilegesModifyCollectionParamsWithHTTPClient creates a new UserGroupPrivilegesModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewUserGroupPrivilegesModifyCollectionParamsWithHTTPClient(client *http.Client) *UserGroupPrivilegesModifyCollectionParams {
	return &UserGroupPrivilegesModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
UserGroupPrivilegesModifyCollectionParams contains all the parameters to send to the API endpoint

	for the user group privileges modify collection operation.

	Typically these are written to a http.Request.
*/
type UserGroupPrivilegesModifyCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info UserGroupPrivilegesModifyCollectionBody

	/* Name.

	   Filter by name
	*/
	Name *string

	/* Privileges.

	   Filter by privileges
	*/
	Privileges *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the user group privileges modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UserGroupPrivilegesModifyCollectionParams) WithDefaults() *UserGroupPrivilegesModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the user group privileges modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UserGroupPrivilegesModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := UserGroupPrivilegesModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) WithTimeout(timeout time.Duration) *UserGroupPrivilegesModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) WithContext(ctx context.Context) *UserGroupPrivilegesModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) WithHTTPClient(client *http.Client) *UserGroupPrivilegesModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *UserGroupPrivilegesModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) WithInfo(info UserGroupPrivilegesModifyCollectionBody) *UserGroupPrivilegesModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) SetInfo(info UserGroupPrivilegesModifyCollectionBody) {
	o.Info = info
}

// WithName adds the name to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) WithName(name *string) *UserGroupPrivilegesModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithPrivileges adds the privileges to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) WithPrivileges(privileges *string) *UserGroupPrivilegesModifyCollectionParams {
	o.SetPrivileges(privileges)
	return o
}

// SetPrivileges adds the privileges to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) SetPrivileges(privileges *string) {
	o.Privileges = privileges
}

// WithReturnRecords adds the returnRecords to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) WithReturnRecords(returnRecords *bool) *UserGroupPrivilegesModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *UserGroupPrivilegesModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) WithSerialRecords(serialRecords *bool) *UserGroupPrivilegesModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) WithSvmName(svmName *string) *UserGroupPrivilegesModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) WithSvmUUID(svmUUID *string) *UserGroupPrivilegesModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the user group privileges modify collection params
func (o *UserGroupPrivilegesModifyCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *UserGroupPrivilegesModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.Privileges != nil {

		// query param privileges
		var qrPrivileges string

		if o.Privileges != nil {
			qrPrivileges = *o.Privileges
		}
		qPrivileges := qrPrivileges
		if qPrivileges != "" {

			if err := r.SetQueryParam("privileges", qPrivileges); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
