// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewVscanCollectionGetParams creates a new VscanCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewVscanCollectionGetParams() *VscanCollectionGetParams {
	return &VscanCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewVscanCollectionGetParamsWithTimeout creates a new VscanCollectionGetParams object
// with the ability to set a timeout on a request.
func NewVscanCollectionGetParamsWithTimeout(timeout time.Duration) *VscanCollectionGetParams {
	return &VscanCollectionGetParams{
		timeout: timeout,
	}
}

// NewVscanCollectionGetParamsWithContext creates a new VscanCollectionGetParams object
// with the ability to set a context for a request.
func NewVscanCollectionGetParamsWithContext(ctx context.Context) *VscanCollectionGetParams {
	return &VscanCollectionGetParams{
		Context: ctx,
	}
}

// NewVscanCollectionGetParamsWithHTTPClient creates a new VscanCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewVscanCollectionGetParamsWithHTTPClient(client *http.Client) *VscanCollectionGetParams {
	return &VscanCollectionGetParams{
		HTTPClient: client,
	}
}

/*
VscanCollectionGetParams contains all the parameters to send to the API endpoint

	for the vscan collection get operation.

	Typically these are written to a http.Request.
*/
type VscanCollectionGetParams struct {

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OnAccessPoliciesEnabled.

	   Filter by on_access_policies.enabled
	*/
	OnAccessPoliciesEnabled *bool

	/* OnAccessPoliciesMandatory.

	   Filter by on_access_policies.mandatory
	*/
	OnAccessPoliciesMandatory *bool

	/* OnAccessPoliciesName.

	   Filter by on_access_policies.name
	*/
	OnAccessPoliciesName *string

	/* OnAccessPoliciesProtocol.

	   Filter by on_access_policies.protocol
	*/
	OnAccessPoliciesProtocol *string

	/* OnAccessPoliciesScopeExcludeExtensions.

	   Filter by on_access_policies.scope.exclude_extensions
	*/
	OnAccessPoliciesScopeExcludeExtensions *string

	/* OnAccessPoliciesScopeExcludePaths.

	   Filter by on_access_policies.scope.exclude_paths
	*/
	OnAccessPoliciesScopeExcludePaths *string

	/* OnAccessPoliciesScopeIncludeExtensions.

	   Filter by on_access_policies.scope.include_extensions
	*/
	OnAccessPoliciesScopeIncludeExtensions *string

	/* OnAccessPoliciesScopeMaxFileSize.

	   Filter by on_access_policies.scope.max_file_size
	*/
	OnAccessPoliciesScopeMaxFileSize *int64

	/* OnAccessPoliciesScopeOnlyExecuteAccess.

	   Filter by on_access_policies.scope.only_execute_access
	*/
	OnAccessPoliciesScopeOnlyExecuteAccess *bool

	/* OnAccessPoliciesScopeScanReadonlyVolumes.

	   Filter by on_access_policies.scope.scan_readonly_volumes
	*/
	OnAccessPoliciesScopeScanReadonlyVolumes *bool

	/* OnAccessPoliciesScopeScanWithoutExtension.

	   Filter by on_access_policies.scope.scan_without_extension
	*/
	OnAccessPoliciesScopeScanWithoutExtension *bool

	/* OnDemandPoliciesLogPath.

	   Filter by on_demand_policies.log_path
	*/
	OnDemandPoliciesLogPath *string

	/* OnDemandPoliciesName.

	   Filter by on_demand_policies.name
	*/
	OnDemandPoliciesName *string

	/* OnDemandPoliciesScanPaths.

	   Filter by on_demand_policies.scan_paths
	*/
	OnDemandPoliciesScanPaths *string

	/* OnDemandPoliciesScheduleName.

	   Filter by on_demand_policies.schedule.name
	*/
	OnDemandPoliciesScheduleName *string

	/* OnDemandPoliciesScheduleUUID.

	   Filter by on_demand_policies.schedule.uuid
	*/
	OnDemandPoliciesScheduleUUID *string

	/* OnDemandPoliciesScopeExcludeExtensions.

	   Filter by on_demand_policies.scope.exclude_extensions
	*/
	OnDemandPoliciesScopeExcludeExtensions *string

	/* OnDemandPoliciesScopeExcludePaths.

	   Filter by on_demand_policies.scope.exclude_paths
	*/
	OnDemandPoliciesScopeExcludePaths *string

	/* OnDemandPoliciesScopeIncludeExtensions.

	   Filter by on_demand_policies.scope.include_extensions
	*/
	OnDemandPoliciesScopeIncludeExtensions *string

	/* OnDemandPoliciesScopeMaxFileSize.

	   Filter by on_demand_policies.scope.max_file_size
	*/
	OnDemandPoliciesScopeMaxFileSize *int64

	/* OnDemandPoliciesScopeScanWithoutExtension.

	   Filter by on_demand_policies.scope.scan_without_extension
	*/
	OnDemandPoliciesScopeScanWithoutExtension *bool

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* ScannerPoolsClusterName.

	   Filter by scanner_pools.cluster.name
	*/
	ScannerPoolsClusterName *string

	/* ScannerPoolsClusterUUID.

	   Filter by scanner_pools.cluster.uuid
	*/
	ScannerPoolsClusterUUID *string

	/* ScannerPoolsName.

	   Filter by scanner_pools.name
	*/
	ScannerPoolsName *string

	/* ScannerPoolsPrivilegedUsers.

	   Filter by scanner_pools.privileged_users
	*/
	ScannerPoolsPrivilegedUsers *string

	/* ScannerPoolsRole.

	   Filter by scanner_pools.role
	*/
	ScannerPoolsRole *string

	/* ScannerPoolsServers.

	   Filter by scanner_pools.servers
	*/
	ScannerPoolsServers *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the vscan collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VscanCollectionGetParams) WithDefaults() *VscanCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the vscan collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VscanCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := VscanCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the vscan collection get params
func (o *VscanCollectionGetParams) WithTimeout(timeout time.Duration) *VscanCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the vscan collection get params
func (o *VscanCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the vscan collection get params
func (o *VscanCollectionGetParams) WithContext(ctx context.Context) *VscanCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the vscan collection get params
func (o *VscanCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the vscan collection get params
func (o *VscanCollectionGetParams) WithHTTPClient(client *http.Client) *VscanCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the vscan collection get params
func (o *VscanCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithEnabled adds the enabled to the vscan collection get params
func (o *VscanCollectionGetParams) WithEnabled(enabled *bool) *VscanCollectionGetParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the vscan collection get params
func (o *VscanCollectionGetParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithFields adds the fields to the vscan collection get params
func (o *VscanCollectionGetParams) WithFields(fields []string) *VscanCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the vscan collection get params
func (o *VscanCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the vscan collection get params
func (o *VscanCollectionGetParams) WithMaxRecords(maxRecords *int64) *VscanCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the vscan collection get params
func (o *VscanCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOnAccessPoliciesEnabled adds the onAccessPoliciesEnabled to the vscan collection get params
func (o *VscanCollectionGetParams) WithOnAccessPoliciesEnabled(onAccessPoliciesEnabled *bool) *VscanCollectionGetParams {
	o.SetOnAccessPoliciesEnabled(onAccessPoliciesEnabled)
	return o
}

// SetOnAccessPoliciesEnabled adds the onAccessPoliciesEnabled to the vscan collection get params
func (o *VscanCollectionGetParams) SetOnAccessPoliciesEnabled(onAccessPoliciesEnabled *bool) {
	o.OnAccessPoliciesEnabled = onAccessPoliciesEnabled
}

// WithOnAccessPoliciesMandatory adds the onAccessPoliciesMandatory to the vscan collection get params
func (o *VscanCollectionGetParams) WithOnAccessPoliciesMandatory(onAccessPoliciesMandatory *bool) *VscanCollectionGetParams {
	o.SetOnAccessPoliciesMandatory(onAccessPoliciesMandatory)
	return o
}

// SetOnAccessPoliciesMandatory adds the onAccessPoliciesMandatory to the vscan collection get params
func (o *VscanCollectionGetParams) SetOnAccessPoliciesMandatory(onAccessPoliciesMandatory *bool) {
	o.OnAccessPoliciesMandatory = onAccessPoliciesMandatory
}

// WithOnAccessPoliciesName adds the onAccessPoliciesName to the vscan collection get params
func (o *VscanCollectionGetParams) WithOnAccessPoliciesName(onAccessPoliciesName *string) *VscanCollectionGetParams {
	o.SetOnAccessPoliciesName(onAccessPoliciesName)
	return o
}

// SetOnAccessPoliciesName adds the onAccessPoliciesName to the vscan collection get params
func (o *VscanCollectionGetParams) SetOnAccessPoliciesName(onAccessPoliciesName *string) {
	o.OnAccessPoliciesName = onAccessPoliciesName
}

// WithOnAccessPoliciesProtocol adds the onAccessPoliciesProtocol to the vscan collection get params
func (o *VscanCollectionGetParams) WithOnAccessPoliciesProtocol(onAccessPoliciesProtocol *string) *VscanCollectionGetParams {
	o.SetOnAccessPoliciesProtocol(onAccessPoliciesProtocol)
	return o
}

// SetOnAccessPoliciesProtocol adds the onAccessPoliciesProtocol to the vscan collection get params
func (o *VscanCollectionGetParams) SetOnAccessPoliciesProtocol(onAccessPoliciesProtocol *string) {
	o.OnAccessPoliciesProtocol = onAccessPoliciesProtocol
}

// WithOnAccessPoliciesScopeExcludeExtensions adds the onAccessPoliciesScopeExcludeExtensions to the vscan collection get params
func (o *VscanCollectionGetParams) WithOnAccessPoliciesScopeExcludeExtensions(onAccessPoliciesScopeExcludeExtensions *string) *VscanCollectionGetParams {
	o.SetOnAccessPoliciesScopeExcludeExtensions(onAccessPoliciesScopeExcludeExtensions)
	return o
}

// SetOnAccessPoliciesScopeExcludeExtensions adds the onAccessPoliciesScopeExcludeExtensions to the vscan collection get params
func (o *VscanCollectionGetParams) SetOnAccessPoliciesScopeExcludeExtensions(onAccessPoliciesScopeExcludeExtensions *string) {
	o.OnAccessPoliciesScopeExcludeExtensions = onAccessPoliciesScopeExcludeExtensions
}

// WithOnAccessPoliciesScopeExcludePaths adds the onAccessPoliciesScopeExcludePaths to the vscan collection get params
func (o *VscanCollectionGetParams) WithOnAccessPoliciesScopeExcludePaths(onAccessPoliciesScopeExcludePaths *string) *VscanCollectionGetParams {
	o.SetOnAccessPoliciesScopeExcludePaths(onAccessPoliciesScopeExcludePaths)
	return o
}

// SetOnAccessPoliciesScopeExcludePaths adds the onAccessPoliciesScopeExcludePaths to the vscan collection get params
func (o *VscanCollectionGetParams) SetOnAccessPoliciesScopeExcludePaths(onAccessPoliciesScopeExcludePaths *string) {
	o.OnAccessPoliciesScopeExcludePaths = onAccessPoliciesScopeExcludePaths
}

// WithOnAccessPoliciesScopeIncludeExtensions adds the onAccessPoliciesScopeIncludeExtensions to the vscan collection get params
func (o *VscanCollectionGetParams) WithOnAccessPoliciesScopeIncludeExtensions(onAccessPoliciesScopeIncludeExtensions *string) *VscanCollectionGetParams {
	o.SetOnAccessPoliciesScopeIncludeExtensions(onAccessPoliciesScopeIncludeExtensions)
	return o
}

// SetOnAccessPoliciesScopeIncludeExtensions adds the onAccessPoliciesScopeIncludeExtensions to the vscan collection get params
func (o *VscanCollectionGetParams) SetOnAccessPoliciesScopeIncludeExtensions(onAccessPoliciesScopeIncludeExtensions *string) {
	o.OnAccessPoliciesScopeIncludeExtensions = onAccessPoliciesScopeIncludeExtensions
}

// WithOnAccessPoliciesScopeMaxFileSize adds the onAccessPoliciesScopeMaxFileSize to the vscan collection get params
func (o *VscanCollectionGetParams) WithOnAccessPoliciesScopeMaxFileSize(onAccessPoliciesScopeMaxFileSize *int64) *VscanCollectionGetParams {
	o.SetOnAccessPoliciesScopeMaxFileSize(onAccessPoliciesScopeMaxFileSize)
	return o
}

// SetOnAccessPoliciesScopeMaxFileSize adds the onAccessPoliciesScopeMaxFileSize to the vscan collection get params
func (o *VscanCollectionGetParams) SetOnAccessPoliciesScopeMaxFileSize(onAccessPoliciesScopeMaxFileSize *int64) {
	o.OnAccessPoliciesScopeMaxFileSize = onAccessPoliciesScopeMaxFileSize
}

// WithOnAccessPoliciesScopeOnlyExecuteAccess adds the onAccessPoliciesScopeOnlyExecuteAccess to the vscan collection get params
func (o *VscanCollectionGetParams) WithOnAccessPoliciesScopeOnlyExecuteAccess(onAccessPoliciesScopeOnlyExecuteAccess *bool) *VscanCollectionGetParams {
	o.SetOnAccessPoliciesScopeOnlyExecuteAccess(onAccessPoliciesScopeOnlyExecuteAccess)
	return o
}

// SetOnAccessPoliciesScopeOnlyExecuteAccess adds the onAccessPoliciesScopeOnlyExecuteAccess to the vscan collection get params
func (o *VscanCollectionGetParams) SetOnAccessPoliciesScopeOnlyExecuteAccess(onAccessPoliciesScopeOnlyExecuteAccess *bool) {
	o.OnAccessPoliciesScopeOnlyExecuteAccess = onAccessPoliciesScopeOnlyExecuteAccess
}

// WithOnAccessPoliciesScopeScanReadonlyVolumes adds the onAccessPoliciesScopeScanReadonlyVolumes to the vscan collection get params
func (o *VscanCollectionGetParams) WithOnAccessPoliciesScopeScanReadonlyVolumes(onAccessPoliciesScopeScanReadonlyVolumes *bool) *VscanCollectionGetParams {
	o.SetOnAccessPoliciesScopeScanReadonlyVolumes(onAccessPoliciesScopeScanReadonlyVolumes)
	return o
}

// SetOnAccessPoliciesScopeScanReadonlyVolumes adds the onAccessPoliciesScopeScanReadonlyVolumes to the vscan collection get params
func (o *VscanCollectionGetParams) SetOnAccessPoliciesScopeScanReadonlyVolumes(onAccessPoliciesScopeScanReadonlyVolumes *bool) {
	o.OnAccessPoliciesScopeScanReadonlyVolumes = onAccessPoliciesScopeScanReadonlyVolumes
}

// WithOnAccessPoliciesScopeScanWithoutExtension adds the onAccessPoliciesScopeScanWithoutExtension to the vscan collection get params
func (o *VscanCollectionGetParams) WithOnAccessPoliciesScopeScanWithoutExtension(onAccessPoliciesScopeScanWithoutExtension *bool) *VscanCollectionGetParams {
	o.SetOnAccessPoliciesScopeScanWithoutExtension(onAccessPoliciesScopeScanWithoutExtension)
	return o
}

// SetOnAccessPoliciesScopeScanWithoutExtension adds the onAccessPoliciesScopeScanWithoutExtension to the vscan collection get params
func (o *VscanCollectionGetParams) SetOnAccessPoliciesScopeScanWithoutExtension(onAccessPoliciesScopeScanWithoutExtension *bool) {
	o.OnAccessPoliciesScopeScanWithoutExtension = onAccessPoliciesScopeScanWithoutExtension
}

// WithOnDemandPoliciesLogPath adds the onDemandPoliciesLogPath to the vscan collection get params
func (o *VscanCollectionGetParams) WithOnDemandPoliciesLogPath(onDemandPoliciesLogPath *string) *VscanCollectionGetParams {
	o.SetOnDemandPoliciesLogPath(onDemandPoliciesLogPath)
	return o
}

// SetOnDemandPoliciesLogPath adds the onDemandPoliciesLogPath to the vscan collection get params
func (o *VscanCollectionGetParams) SetOnDemandPoliciesLogPath(onDemandPoliciesLogPath *string) {
	o.OnDemandPoliciesLogPath = onDemandPoliciesLogPath
}

// WithOnDemandPoliciesName adds the onDemandPoliciesName to the vscan collection get params
func (o *VscanCollectionGetParams) WithOnDemandPoliciesName(onDemandPoliciesName *string) *VscanCollectionGetParams {
	o.SetOnDemandPoliciesName(onDemandPoliciesName)
	return o
}

// SetOnDemandPoliciesName adds the onDemandPoliciesName to the vscan collection get params
func (o *VscanCollectionGetParams) SetOnDemandPoliciesName(onDemandPoliciesName *string) {
	o.OnDemandPoliciesName = onDemandPoliciesName
}

// WithOnDemandPoliciesScanPaths adds the onDemandPoliciesScanPaths to the vscan collection get params
func (o *VscanCollectionGetParams) WithOnDemandPoliciesScanPaths(onDemandPoliciesScanPaths *string) *VscanCollectionGetParams {
	o.SetOnDemandPoliciesScanPaths(onDemandPoliciesScanPaths)
	return o
}

// SetOnDemandPoliciesScanPaths adds the onDemandPoliciesScanPaths to the vscan collection get params
func (o *VscanCollectionGetParams) SetOnDemandPoliciesScanPaths(onDemandPoliciesScanPaths *string) {
	o.OnDemandPoliciesScanPaths = onDemandPoliciesScanPaths
}

// WithOnDemandPoliciesScheduleName adds the onDemandPoliciesScheduleName to the vscan collection get params
func (o *VscanCollectionGetParams) WithOnDemandPoliciesScheduleName(onDemandPoliciesScheduleName *string) *VscanCollectionGetParams {
	o.SetOnDemandPoliciesScheduleName(onDemandPoliciesScheduleName)
	return o
}

// SetOnDemandPoliciesScheduleName adds the onDemandPoliciesScheduleName to the vscan collection get params
func (o *VscanCollectionGetParams) SetOnDemandPoliciesScheduleName(onDemandPoliciesScheduleName *string) {
	o.OnDemandPoliciesScheduleName = onDemandPoliciesScheduleName
}

// WithOnDemandPoliciesScheduleUUID adds the onDemandPoliciesScheduleUUID to the vscan collection get params
func (o *VscanCollectionGetParams) WithOnDemandPoliciesScheduleUUID(onDemandPoliciesScheduleUUID *string) *VscanCollectionGetParams {
	o.SetOnDemandPoliciesScheduleUUID(onDemandPoliciesScheduleUUID)
	return o
}

// SetOnDemandPoliciesScheduleUUID adds the onDemandPoliciesScheduleUuid to the vscan collection get params
func (o *VscanCollectionGetParams) SetOnDemandPoliciesScheduleUUID(onDemandPoliciesScheduleUUID *string) {
	o.OnDemandPoliciesScheduleUUID = onDemandPoliciesScheduleUUID
}

// WithOnDemandPoliciesScopeExcludeExtensions adds the onDemandPoliciesScopeExcludeExtensions to the vscan collection get params
func (o *VscanCollectionGetParams) WithOnDemandPoliciesScopeExcludeExtensions(onDemandPoliciesScopeExcludeExtensions *string) *VscanCollectionGetParams {
	o.SetOnDemandPoliciesScopeExcludeExtensions(onDemandPoliciesScopeExcludeExtensions)
	return o
}

// SetOnDemandPoliciesScopeExcludeExtensions adds the onDemandPoliciesScopeExcludeExtensions to the vscan collection get params
func (o *VscanCollectionGetParams) SetOnDemandPoliciesScopeExcludeExtensions(onDemandPoliciesScopeExcludeExtensions *string) {
	o.OnDemandPoliciesScopeExcludeExtensions = onDemandPoliciesScopeExcludeExtensions
}

// WithOnDemandPoliciesScopeExcludePaths adds the onDemandPoliciesScopeExcludePaths to the vscan collection get params
func (o *VscanCollectionGetParams) WithOnDemandPoliciesScopeExcludePaths(onDemandPoliciesScopeExcludePaths *string) *VscanCollectionGetParams {
	o.SetOnDemandPoliciesScopeExcludePaths(onDemandPoliciesScopeExcludePaths)
	return o
}

// SetOnDemandPoliciesScopeExcludePaths adds the onDemandPoliciesScopeExcludePaths to the vscan collection get params
func (o *VscanCollectionGetParams) SetOnDemandPoliciesScopeExcludePaths(onDemandPoliciesScopeExcludePaths *string) {
	o.OnDemandPoliciesScopeExcludePaths = onDemandPoliciesScopeExcludePaths
}

// WithOnDemandPoliciesScopeIncludeExtensions adds the onDemandPoliciesScopeIncludeExtensions to the vscan collection get params
func (o *VscanCollectionGetParams) WithOnDemandPoliciesScopeIncludeExtensions(onDemandPoliciesScopeIncludeExtensions *string) *VscanCollectionGetParams {
	o.SetOnDemandPoliciesScopeIncludeExtensions(onDemandPoliciesScopeIncludeExtensions)
	return o
}

// SetOnDemandPoliciesScopeIncludeExtensions adds the onDemandPoliciesScopeIncludeExtensions to the vscan collection get params
func (o *VscanCollectionGetParams) SetOnDemandPoliciesScopeIncludeExtensions(onDemandPoliciesScopeIncludeExtensions *string) {
	o.OnDemandPoliciesScopeIncludeExtensions = onDemandPoliciesScopeIncludeExtensions
}

// WithOnDemandPoliciesScopeMaxFileSize adds the onDemandPoliciesScopeMaxFileSize to the vscan collection get params
func (o *VscanCollectionGetParams) WithOnDemandPoliciesScopeMaxFileSize(onDemandPoliciesScopeMaxFileSize *int64) *VscanCollectionGetParams {
	o.SetOnDemandPoliciesScopeMaxFileSize(onDemandPoliciesScopeMaxFileSize)
	return o
}

// SetOnDemandPoliciesScopeMaxFileSize adds the onDemandPoliciesScopeMaxFileSize to the vscan collection get params
func (o *VscanCollectionGetParams) SetOnDemandPoliciesScopeMaxFileSize(onDemandPoliciesScopeMaxFileSize *int64) {
	o.OnDemandPoliciesScopeMaxFileSize = onDemandPoliciesScopeMaxFileSize
}

// WithOnDemandPoliciesScopeScanWithoutExtension adds the onDemandPoliciesScopeScanWithoutExtension to the vscan collection get params
func (o *VscanCollectionGetParams) WithOnDemandPoliciesScopeScanWithoutExtension(onDemandPoliciesScopeScanWithoutExtension *bool) *VscanCollectionGetParams {
	o.SetOnDemandPoliciesScopeScanWithoutExtension(onDemandPoliciesScopeScanWithoutExtension)
	return o
}

// SetOnDemandPoliciesScopeScanWithoutExtension adds the onDemandPoliciesScopeScanWithoutExtension to the vscan collection get params
func (o *VscanCollectionGetParams) SetOnDemandPoliciesScopeScanWithoutExtension(onDemandPoliciesScopeScanWithoutExtension *bool) {
	o.OnDemandPoliciesScopeScanWithoutExtension = onDemandPoliciesScopeScanWithoutExtension
}

// WithOrderBy adds the orderBy to the vscan collection get params
func (o *VscanCollectionGetParams) WithOrderBy(orderBy []string) *VscanCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the vscan collection get params
func (o *VscanCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the vscan collection get params
func (o *VscanCollectionGetParams) WithReturnRecords(returnRecords *bool) *VscanCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the vscan collection get params
func (o *VscanCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the vscan collection get params
func (o *VscanCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *VscanCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the vscan collection get params
func (o *VscanCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScannerPoolsClusterName adds the scannerPoolsClusterName to the vscan collection get params
func (o *VscanCollectionGetParams) WithScannerPoolsClusterName(scannerPoolsClusterName *string) *VscanCollectionGetParams {
	o.SetScannerPoolsClusterName(scannerPoolsClusterName)
	return o
}

// SetScannerPoolsClusterName adds the scannerPoolsClusterName to the vscan collection get params
func (o *VscanCollectionGetParams) SetScannerPoolsClusterName(scannerPoolsClusterName *string) {
	o.ScannerPoolsClusterName = scannerPoolsClusterName
}

// WithScannerPoolsClusterUUID adds the scannerPoolsClusterUUID to the vscan collection get params
func (o *VscanCollectionGetParams) WithScannerPoolsClusterUUID(scannerPoolsClusterUUID *string) *VscanCollectionGetParams {
	o.SetScannerPoolsClusterUUID(scannerPoolsClusterUUID)
	return o
}

// SetScannerPoolsClusterUUID adds the scannerPoolsClusterUuid to the vscan collection get params
func (o *VscanCollectionGetParams) SetScannerPoolsClusterUUID(scannerPoolsClusterUUID *string) {
	o.ScannerPoolsClusterUUID = scannerPoolsClusterUUID
}

// WithScannerPoolsName adds the scannerPoolsName to the vscan collection get params
func (o *VscanCollectionGetParams) WithScannerPoolsName(scannerPoolsName *string) *VscanCollectionGetParams {
	o.SetScannerPoolsName(scannerPoolsName)
	return o
}

// SetScannerPoolsName adds the scannerPoolsName to the vscan collection get params
func (o *VscanCollectionGetParams) SetScannerPoolsName(scannerPoolsName *string) {
	o.ScannerPoolsName = scannerPoolsName
}

// WithScannerPoolsPrivilegedUsers adds the scannerPoolsPrivilegedUsers to the vscan collection get params
func (o *VscanCollectionGetParams) WithScannerPoolsPrivilegedUsers(scannerPoolsPrivilegedUsers *string) *VscanCollectionGetParams {
	o.SetScannerPoolsPrivilegedUsers(scannerPoolsPrivilegedUsers)
	return o
}

// SetScannerPoolsPrivilegedUsers adds the scannerPoolsPrivilegedUsers to the vscan collection get params
func (o *VscanCollectionGetParams) SetScannerPoolsPrivilegedUsers(scannerPoolsPrivilegedUsers *string) {
	o.ScannerPoolsPrivilegedUsers = scannerPoolsPrivilegedUsers
}

// WithScannerPoolsRole adds the scannerPoolsRole to the vscan collection get params
func (o *VscanCollectionGetParams) WithScannerPoolsRole(scannerPoolsRole *string) *VscanCollectionGetParams {
	o.SetScannerPoolsRole(scannerPoolsRole)
	return o
}

// SetScannerPoolsRole adds the scannerPoolsRole to the vscan collection get params
func (o *VscanCollectionGetParams) SetScannerPoolsRole(scannerPoolsRole *string) {
	o.ScannerPoolsRole = scannerPoolsRole
}

// WithScannerPoolsServers adds the scannerPoolsServers to the vscan collection get params
func (o *VscanCollectionGetParams) WithScannerPoolsServers(scannerPoolsServers *string) *VscanCollectionGetParams {
	o.SetScannerPoolsServers(scannerPoolsServers)
	return o
}

// SetScannerPoolsServers adds the scannerPoolsServers to the vscan collection get params
func (o *VscanCollectionGetParams) SetScannerPoolsServers(scannerPoolsServers *string) {
	o.ScannerPoolsServers = scannerPoolsServers
}

// WithSvmName adds the svmName to the vscan collection get params
func (o *VscanCollectionGetParams) WithSvmName(svmName *string) *VscanCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the vscan collection get params
func (o *VscanCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the vscan collection get params
func (o *VscanCollectionGetParams) WithSvmUUID(svmUUID *string) *VscanCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the vscan collection get params
func (o *VscanCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *VscanCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OnAccessPoliciesEnabled != nil {

		// query param on_access_policies.enabled
		var qrOnAccessPoliciesEnabled bool

		if o.OnAccessPoliciesEnabled != nil {
			qrOnAccessPoliciesEnabled = *o.OnAccessPoliciesEnabled
		}
		qOnAccessPoliciesEnabled := swag.FormatBool(qrOnAccessPoliciesEnabled)
		if qOnAccessPoliciesEnabled != "" {

			if err := r.SetQueryParam("on_access_policies.enabled", qOnAccessPoliciesEnabled); err != nil {
				return err
			}
		}
	}

	if o.OnAccessPoliciesMandatory != nil {

		// query param on_access_policies.mandatory
		var qrOnAccessPoliciesMandatory bool

		if o.OnAccessPoliciesMandatory != nil {
			qrOnAccessPoliciesMandatory = *o.OnAccessPoliciesMandatory
		}
		qOnAccessPoliciesMandatory := swag.FormatBool(qrOnAccessPoliciesMandatory)
		if qOnAccessPoliciesMandatory != "" {

			if err := r.SetQueryParam("on_access_policies.mandatory", qOnAccessPoliciesMandatory); err != nil {
				return err
			}
		}
	}

	if o.OnAccessPoliciesName != nil {

		// query param on_access_policies.name
		var qrOnAccessPoliciesName string

		if o.OnAccessPoliciesName != nil {
			qrOnAccessPoliciesName = *o.OnAccessPoliciesName
		}
		qOnAccessPoliciesName := qrOnAccessPoliciesName
		if qOnAccessPoliciesName != "" {

			if err := r.SetQueryParam("on_access_policies.name", qOnAccessPoliciesName); err != nil {
				return err
			}
		}
	}

	if o.OnAccessPoliciesProtocol != nil {

		// query param on_access_policies.protocol
		var qrOnAccessPoliciesProtocol string

		if o.OnAccessPoliciesProtocol != nil {
			qrOnAccessPoliciesProtocol = *o.OnAccessPoliciesProtocol
		}
		qOnAccessPoliciesProtocol := qrOnAccessPoliciesProtocol
		if qOnAccessPoliciesProtocol != "" {

			if err := r.SetQueryParam("on_access_policies.protocol", qOnAccessPoliciesProtocol); err != nil {
				return err
			}
		}
	}

	if o.OnAccessPoliciesScopeExcludeExtensions != nil {

		// query param on_access_policies.scope.exclude_extensions
		var qrOnAccessPoliciesScopeExcludeExtensions string

		if o.OnAccessPoliciesScopeExcludeExtensions != nil {
			qrOnAccessPoliciesScopeExcludeExtensions = *o.OnAccessPoliciesScopeExcludeExtensions
		}
		qOnAccessPoliciesScopeExcludeExtensions := qrOnAccessPoliciesScopeExcludeExtensions
		if qOnAccessPoliciesScopeExcludeExtensions != "" {

			if err := r.SetQueryParam("on_access_policies.scope.exclude_extensions", qOnAccessPoliciesScopeExcludeExtensions); err != nil {
				return err
			}
		}
	}

	if o.OnAccessPoliciesScopeExcludePaths != nil {

		// query param on_access_policies.scope.exclude_paths
		var qrOnAccessPoliciesScopeExcludePaths string

		if o.OnAccessPoliciesScopeExcludePaths != nil {
			qrOnAccessPoliciesScopeExcludePaths = *o.OnAccessPoliciesScopeExcludePaths
		}
		qOnAccessPoliciesScopeExcludePaths := qrOnAccessPoliciesScopeExcludePaths
		if qOnAccessPoliciesScopeExcludePaths != "" {

			if err := r.SetQueryParam("on_access_policies.scope.exclude_paths", qOnAccessPoliciesScopeExcludePaths); err != nil {
				return err
			}
		}
	}

	if o.OnAccessPoliciesScopeIncludeExtensions != nil {

		// query param on_access_policies.scope.include_extensions
		var qrOnAccessPoliciesScopeIncludeExtensions string

		if o.OnAccessPoliciesScopeIncludeExtensions != nil {
			qrOnAccessPoliciesScopeIncludeExtensions = *o.OnAccessPoliciesScopeIncludeExtensions
		}
		qOnAccessPoliciesScopeIncludeExtensions := qrOnAccessPoliciesScopeIncludeExtensions
		if qOnAccessPoliciesScopeIncludeExtensions != "" {

			if err := r.SetQueryParam("on_access_policies.scope.include_extensions", qOnAccessPoliciesScopeIncludeExtensions); err != nil {
				return err
			}
		}
	}

	if o.OnAccessPoliciesScopeMaxFileSize != nil {

		// query param on_access_policies.scope.max_file_size
		var qrOnAccessPoliciesScopeMaxFileSize int64

		if o.OnAccessPoliciesScopeMaxFileSize != nil {
			qrOnAccessPoliciesScopeMaxFileSize = *o.OnAccessPoliciesScopeMaxFileSize
		}
		qOnAccessPoliciesScopeMaxFileSize := swag.FormatInt64(qrOnAccessPoliciesScopeMaxFileSize)
		if qOnAccessPoliciesScopeMaxFileSize != "" {

			if err := r.SetQueryParam("on_access_policies.scope.max_file_size", qOnAccessPoliciesScopeMaxFileSize); err != nil {
				return err
			}
		}
	}

	if o.OnAccessPoliciesScopeOnlyExecuteAccess != nil {

		// query param on_access_policies.scope.only_execute_access
		var qrOnAccessPoliciesScopeOnlyExecuteAccess bool

		if o.OnAccessPoliciesScopeOnlyExecuteAccess != nil {
			qrOnAccessPoliciesScopeOnlyExecuteAccess = *o.OnAccessPoliciesScopeOnlyExecuteAccess
		}
		qOnAccessPoliciesScopeOnlyExecuteAccess := swag.FormatBool(qrOnAccessPoliciesScopeOnlyExecuteAccess)
		if qOnAccessPoliciesScopeOnlyExecuteAccess != "" {

			if err := r.SetQueryParam("on_access_policies.scope.only_execute_access", qOnAccessPoliciesScopeOnlyExecuteAccess); err != nil {
				return err
			}
		}
	}

	if o.OnAccessPoliciesScopeScanReadonlyVolumes != nil {

		// query param on_access_policies.scope.scan_readonly_volumes
		var qrOnAccessPoliciesScopeScanReadonlyVolumes bool

		if o.OnAccessPoliciesScopeScanReadonlyVolumes != nil {
			qrOnAccessPoliciesScopeScanReadonlyVolumes = *o.OnAccessPoliciesScopeScanReadonlyVolumes
		}
		qOnAccessPoliciesScopeScanReadonlyVolumes := swag.FormatBool(qrOnAccessPoliciesScopeScanReadonlyVolumes)
		if qOnAccessPoliciesScopeScanReadonlyVolumes != "" {

			if err := r.SetQueryParam("on_access_policies.scope.scan_readonly_volumes", qOnAccessPoliciesScopeScanReadonlyVolumes); err != nil {
				return err
			}
		}
	}

	if o.OnAccessPoliciesScopeScanWithoutExtension != nil {

		// query param on_access_policies.scope.scan_without_extension
		var qrOnAccessPoliciesScopeScanWithoutExtension bool

		if o.OnAccessPoliciesScopeScanWithoutExtension != nil {
			qrOnAccessPoliciesScopeScanWithoutExtension = *o.OnAccessPoliciesScopeScanWithoutExtension
		}
		qOnAccessPoliciesScopeScanWithoutExtension := swag.FormatBool(qrOnAccessPoliciesScopeScanWithoutExtension)
		if qOnAccessPoliciesScopeScanWithoutExtension != "" {

			if err := r.SetQueryParam("on_access_policies.scope.scan_without_extension", qOnAccessPoliciesScopeScanWithoutExtension); err != nil {
				return err
			}
		}
	}

	if o.OnDemandPoliciesLogPath != nil {

		// query param on_demand_policies.log_path
		var qrOnDemandPoliciesLogPath string

		if o.OnDemandPoliciesLogPath != nil {
			qrOnDemandPoliciesLogPath = *o.OnDemandPoliciesLogPath
		}
		qOnDemandPoliciesLogPath := qrOnDemandPoliciesLogPath
		if qOnDemandPoliciesLogPath != "" {

			if err := r.SetQueryParam("on_demand_policies.log_path", qOnDemandPoliciesLogPath); err != nil {
				return err
			}
		}
	}

	if o.OnDemandPoliciesName != nil {

		// query param on_demand_policies.name
		var qrOnDemandPoliciesName string

		if o.OnDemandPoliciesName != nil {
			qrOnDemandPoliciesName = *o.OnDemandPoliciesName
		}
		qOnDemandPoliciesName := qrOnDemandPoliciesName
		if qOnDemandPoliciesName != "" {

			if err := r.SetQueryParam("on_demand_policies.name", qOnDemandPoliciesName); err != nil {
				return err
			}
		}
	}

	if o.OnDemandPoliciesScanPaths != nil {

		// query param on_demand_policies.scan_paths
		var qrOnDemandPoliciesScanPaths string

		if o.OnDemandPoliciesScanPaths != nil {
			qrOnDemandPoliciesScanPaths = *o.OnDemandPoliciesScanPaths
		}
		qOnDemandPoliciesScanPaths := qrOnDemandPoliciesScanPaths
		if qOnDemandPoliciesScanPaths != "" {

			if err := r.SetQueryParam("on_demand_policies.scan_paths", qOnDemandPoliciesScanPaths); err != nil {
				return err
			}
		}
	}

	if o.OnDemandPoliciesScheduleName != nil {

		// query param on_demand_policies.schedule.name
		var qrOnDemandPoliciesScheduleName string

		if o.OnDemandPoliciesScheduleName != nil {
			qrOnDemandPoliciesScheduleName = *o.OnDemandPoliciesScheduleName
		}
		qOnDemandPoliciesScheduleName := qrOnDemandPoliciesScheduleName
		if qOnDemandPoliciesScheduleName != "" {

			if err := r.SetQueryParam("on_demand_policies.schedule.name", qOnDemandPoliciesScheduleName); err != nil {
				return err
			}
		}
	}

	if o.OnDemandPoliciesScheduleUUID != nil {

		// query param on_demand_policies.schedule.uuid
		var qrOnDemandPoliciesScheduleUUID string

		if o.OnDemandPoliciesScheduleUUID != nil {
			qrOnDemandPoliciesScheduleUUID = *o.OnDemandPoliciesScheduleUUID
		}
		qOnDemandPoliciesScheduleUUID := qrOnDemandPoliciesScheduleUUID
		if qOnDemandPoliciesScheduleUUID != "" {

			if err := r.SetQueryParam("on_demand_policies.schedule.uuid", qOnDemandPoliciesScheduleUUID); err != nil {
				return err
			}
		}
	}

	if o.OnDemandPoliciesScopeExcludeExtensions != nil {

		// query param on_demand_policies.scope.exclude_extensions
		var qrOnDemandPoliciesScopeExcludeExtensions string

		if o.OnDemandPoliciesScopeExcludeExtensions != nil {
			qrOnDemandPoliciesScopeExcludeExtensions = *o.OnDemandPoliciesScopeExcludeExtensions
		}
		qOnDemandPoliciesScopeExcludeExtensions := qrOnDemandPoliciesScopeExcludeExtensions
		if qOnDemandPoliciesScopeExcludeExtensions != "" {

			if err := r.SetQueryParam("on_demand_policies.scope.exclude_extensions", qOnDemandPoliciesScopeExcludeExtensions); err != nil {
				return err
			}
		}
	}

	if o.OnDemandPoliciesScopeExcludePaths != nil {

		// query param on_demand_policies.scope.exclude_paths
		var qrOnDemandPoliciesScopeExcludePaths string

		if o.OnDemandPoliciesScopeExcludePaths != nil {
			qrOnDemandPoliciesScopeExcludePaths = *o.OnDemandPoliciesScopeExcludePaths
		}
		qOnDemandPoliciesScopeExcludePaths := qrOnDemandPoliciesScopeExcludePaths
		if qOnDemandPoliciesScopeExcludePaths != "" {

			if err := r.SetQueryParam("on_demand_policies.scope.exclude_paths", qOnDemandPoliciesScopeExcludePaths); err != nil {
				return err
			}
		}
	}

	if o.OnDemandPoliciesScopeIncludeExtensions != nil {

		// query param on_demand_policies.scope.include_extensions
		var qrOnDemandPoliciesScopeIncludeExtensions string

		if o.OnDemandPoliciesScopeIncludeExtensions != nil {
			qrOnDemandPoliciesScopeIncludeExtensions = *o.OnDemandPoliciesScopeIncludeExtensions
		}
		qOnDemandPoliciesScopeIncludeExtensions := qrOnDemandPoliciesScopeIncludeExtensions
		if qOnDemandPoliciesScopeIncludeExtensions != "" {

			if err := r.SetQueryParam("on_demand_policies.scope.include_extensions", qOnDemandPoliciesScopeIncludeExtensions); err != nil {
				return err
			}
		}
	}

	if o.OnDemandPoliciesScopeMaxFileSize != nil {

		// query param on_demand_policies.scope.max_file_size
		var qrOnDemandPoliciesScopeMaxFileSize int64

		if o.OnDemandPoliciesScopeMaxFileSize != nil {
			qrOnDemandPoliciesScopeMaxFileSize = *o.OnDemandPoliciesScopeMaxFileSize
		}
		qOnDemandPoliciesScopeMaxFileSize := swag.FormatInt64(qrOnDemandPoliciesScopeMaxFileSize)
		if qOnDemandPoliciesScopeMaxFileSize != "" {

			if err := r.SetQueryParam("on_demand_policies.scope.max_file_size", qOnDemandPoliciesScopeMaxFileSize); err != nil {
				return err
			}
		}
	}

	if o.OnDemandPoliciesScopeScanWithoutExtension != nil {

		// query param on_demand_policies.scope.scan_without_extension
		var qrOnDemandPoliciesScopeScanWithoutExtension bool

		if o.OnDemandPoliciesScopeScanWithoutExtension != nil {
			qrOnDemandPoliciesScopeScanWithoutExtension = *o.OnDemandPoliciesScopeScanWithoutExtension
		}
		qOnDemandPoliciesScopeScanWithoutExtension := swag.FormatBool(qrOnDemandPoliciesScopeScanWithoutExtension)
		if qOnDemandPoliciesScopeScanWithoutExtension != "" {

			if err := r.SetQueryParam("on_demand_policies.scope.scan_without_extension", qOnDemandPoliciesScopeScanWithoutExtension); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.ScannerPoolsClusterName != nil {

		// query param scanner_pools.cluster.name
		var qrScannerPoolsClusterName string

		if o.ScannerPoolsClusterName != nil {
			qrScannerPoolsClusterName = *o.ScannerPoolsClusterName
		}
		qScannerPoolsClusterName := qrScannerPoolsClusterName
		if qScannerPoolsClusterName != "" {

			if err := r.SetQueryParam("scanner_pools.cluster.name", qScannerPoolsClusterName); err != nil {
				return err
			}
		}
	}

	if o.ScannerPoolsClusterUUID != nil {

		// query param scanner_pools.cluster.uuid
		var qrScannerPoolsClusterUUID string

		if o.ScannerPoolsClusterUUID != nil {
			qrScannerPoolsClusterUUID = *o.ScannerPoolsClusterUUID
		}
		qScannerPoolsClusterUUID := qrScannerPoolsClusterUUID
		if qScannerPoolsClusterUUID != "" {

			if err := r.SetQueryParam("scanner_pools.cluster.uuid", qScannerPoolsClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.ScannerPoolsName != nil {

		// query param scanner_pools.name
		var qrScannerPoolsName string

		if o.ScannerPoolsName != nil {
			qrScannerPoolsName = *o.ScannerPoolsName
		}
		qScannerPoolsName := qrScannerPoolsName
		if qScannerPoolsName != "" {

			if err := r.SetQueryParam("scanner_pools.name", qScannerPoolsName); err != nil {
				return err
			}
		}
	}

	if o.ScannerPoolsPrivilegedUsers != nil {

		// query param scanner_pools.privileged_users
		var qrScannerPoolsPrivilegedUsers string

		if o.ScannerPoolsPrivilegedUsers != nil {
			qrScannerPoolsPrivilegedUsers = *o.ScannerPoolsPrivilegedUsers
		}
		qScannerPoolsPrivilegedUsers := qrScannerPoolsPrivilegedUsers
		if qScannerPoolsPrivilegedUsers != "" {

			if err := r.SetQueryParam("scanner_pools.privileged_users", qScannerPoolsPrivilegedUsers); err != nil {
				return err
			}
		}
	}

	if o.ScannerPoolsRole != nil {

		// query param scanner_pools.role
		var qrScannerPoolsRole string

		if o.ScannerPoolsRole != nil {
			qrScannerPoolsRole = *o.ScannerPoolsRole
		}
		qScannerPoolsRole := qrScannerPoolsRole
		if qScannerPoolsRole != "" {

			if err := r.SetQueryParam("scanner_pools.role", qScannerPoolsRole); err != nil {
				return err
			}
		}
	}

	if o.ScannerPoolsServers != nil {

		// query param scanner_pools.servers
		var qrScannerPoolsServers string

		if o.ScannerPoolsServers != nil {
			qrScannerPoolsServers = *o.ScannerPoolsServers
		}
		qScannerPoolsServers := qrScannerPoolsServers
		if qScannerPoolsServers != "" {

			if err := r.SetQueryParam("scanner_pools.servers", qScannerPoolsServers); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamVscanCollectionGet binds the parameter fields
func (o *VscanCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamVscanCollectionGet binds the parameter order_by
func (o *VscanCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
