// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewVscanConfigDeleteCollectionParams creates a new VscanConfigDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewVscanConfigDeleteCollectionParams() *VscanConfigDeleteCollectionParams {
	return &VscanConfigDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewVscanConfigDeleteCollectionParamsWithTimeout creates a new VscanConfigDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewVscanConfigDeleteCollectionParamsWithTimeout(timeout time.Duration) *VscanConfigDeleteCollectionParams {
	return &VscanConfigDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewVscanConfigDeleteCollectionParamsWithContext creates a new VscanConfigDeleteCollectionParams object
// with the ability to set a context for a request.
func NewVscanConfigDeleteCollectionParamsWithContext(ctx context.Context) *VscanConfigDeleteCollectionParams {
	return &VscanConfigDeleteCollectionParams{
		Context: ctx,
	}
}

// NewVscanConfigDeleteCollectionParamsWithHTTPClient creates a new VscanConfigDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewVscanConfigDeleteCollectionParamsWithHTTPClient(client *http.Client) *VscanConfigDeleteCollectionParams {
	return &VscanConfigDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
VscanConfigDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the vscan config delete collection operation.

	Typically these are written to a http.Request.
*/
type VscanConfigDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Info.

	   Info specification
	*/
	Info VscanConfigDeleteCollectionBody

	/* OnAccessPoliciesEnabled.

	   Filter by on_access_policies.enabled
	*/
	OnAccessPoliciesEnabled *bool

	/* OnAccessPoliciesMandatory.

	   Filter by on_access_policies.mandatory
	*/
	OnAccessPoliciesMandatory *bool

	/* OnAccessPoliciesName.

	   Filter by on_access_policies.name
	*/
	OnAccessPoliciesName *string

	/* OnAccessPoliciesProtocol.

	   Filter by on_access_policies.protocol
	*/
	OnAccessPoliciesProtocol *string

	/* OnAccessPoliciesScopeExcludeExtensions.

	   Filter by on_access_policies.scope.exclude_extensions
	*/
	OnAccessPoliciesScopeExcludeExtensions *string

	/* OnAccessPoliciesScopeExcludePaths.

	   Filter by on_access_policies.scope.exclude_paths
	*/
	OnAccessPoliciesScopeExcludePaths *string

	/* OnAccessPoliciesScopeIncludeExtensions.

	   Filter by on_access_policies.scope.include_extensions
	*/
	OnAccessPoliciesScopeIncludeExtensions *string

	/* OnAccessPoliciesScopeMaxFileSize.

	   Filter by on_access_policies.scope.max_file_size
	*/
	OnAccessPoliciesScopeMaxFileSize *int64

	/* OnAccessPoliciesScopeOnlyExecuteAccess.

	   Filter by on_access_policies.scope.only_execute_access
	*/
	OnAccessPoliciesScopeOnlyExecuteAccess *bool

	/* OnAccessPoliciesScopeScanReadonlyVolumes.

	   Filter by on_access_policies.scope.scan_readonly_volumes
	*/
	OnAccessPoliciesScopeScanReadonlyVolumes *bool

	/* OnAccessPoliciesScopeScanWithoutExtension.

	   Filter by on_access_policies.scope.scan_without_extension
	*/
	OnAccessPoliciesScopeScanWithoutExtension *bool

	/* OnDemandPoliciesLogPath.

	   Filter by on_demand_policies.log_path
	*/
	OnDemandPoliciesLogPath *string

	/* OnDemandPoliciesName.

	   Filter by on_demand_policies.name
	*/
	OnDemandPoliciesName *string

	/* OnDemandPoliciesScanPaths.

	   Filter by on_demand_policies.scan_paths
	*/
	OnDemandPoliciesScanPaths *string

	/* OnDemandPoliciesScheduleName.

	   Filter by on_demand_policies.schedule.name
	*/
	OnDemandPoliciesScheduleName *string

	/* OnDemandPoliciesScheduleUUID.

	   Filter by on_demand_policies.schedule.uuid
	*/
	OnDemandPoliciesScheduleUUID *string

	/* OnDemandPoliciesScopeExcludeExtensions.

	   Filter by on_demand_policies.scope.exclude_extensions
	*/
	OnDemandPoliciesScopeExcludeExtensions *string

	/* OnDemandPoliciesScopeExcludePaths.

	   Filter by on_demand_policies.scope.exclude_paths
	*/
	OnDemandPoliciesScopeExcludePaths *string

	/* OnDemandPoliciesScopeIncludeExtensions.

	   Filter by on_demand_policies.scope.include_extensions
	*/
	OnDemandPoliciesScopeIncludeExtensions *string

	/* OnDemandPoliciesScopeMaxFileSize.

	   Filter by on_demand_policies.scope.max_file_size
	*/
	OnDemandPoliciesScopeMaxFileSize *int64

	/* OnDemandPoliciesScopeScanWithoutExtension.

	   Filter by on_demand_policies.scope.scan_without_extension
	*/
	OnDemandPoliciesScopeScanWithoutExtension *bool

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* ScannerPoolsClusterName.

	   Filter by scanner_pools.cluster.name
	*/
	ScannerPoolsClusterName *string

	/* ScannerPoolsClusterUUID.

	   Filter by scanner_pools.cluster.uuid
	*/
	ScannerPoolsClusterUUID *string

	/* ScannerPoolsName.

	   Filter by scanner_pools.name
	*/
	ScannerPoolsName *string

	/* ScannerPoolsPrivilegedUsers.

	   Filter by scanner_pools.privileged_users
	*/
	ScannerPoolsPrivilegedUsers *string

	/* ScannerPoolsRole.

	   Filter by scanner_pools.role
	*/
	ScannerPoolsRole *string

	/* ScannerPoolsServers.

	   Filter by scanner_pools.servers
	*/
	ScannerPoolsServers *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the vscan config delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VscanConfigDeleteCollectionParams) WithDefaults() *VscanConfigDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the vscan config delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VscanConfigDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := VscanConfigDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithTimeout(timeout time.Duration) *VscanConfigDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithContext(ctx context.Context) *VscanConfigDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithHTTPClient(client *http.Client) *VscanConfigDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *VscanConfigDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithEnabled adds the enabled to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithEnabled(enabled *bool) *VscanConfigDeleteCollectionParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithInfo adds the info to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithInfo(info VscanConfigDeleteCollectionBody) *VscanConfigDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetInfo(info VscanConfigDeleteCollectionBody) {
	o.Info = info
}

// WithOnAccessPoliciesEnabled adds the onAccessPoliciesEnabled to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithOnAccessPoliciesEnabled(onAccessPoliciesEnabled *bool) *VscanConfigDeleteCollectionParams {
	o.SetOnAccessPoliciesEnabled(onAccessPoliciesEnabled)
	return o
}

// SetOnAccessPoliciesEnabled adds the onAccessPoliciesEnabled to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetOnAccessPoliciesEnabled(onAccessPoliciesEnabled *bool) {
	o.OnAccessPoliciesEnabled = onAccessPoliciesEnabled
}

// WithOnAccessPoliciesMandatory adds the onAccessPoliciesMandatory to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithOnAccessPoliciesMandatory(onAccessPoliciesMandatory *bool) *VscanConfigDeleteCollectionParams {
	o.SetOnAccessPoliciesMandatory(onAccessPoliciesMandatory)
	return o
}

// SetOnAccessPoliciesMandatory adds the onAccessPoliciesMandatory to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetOnAccessPoliciesMandatory(onAccessPoliciesMandatory *bool) {
	o.OnAccessPoliciesMandatory = onAccessPoliciesMandatory
}

// WithOnAccessPoliciesName adds the onAccessPoliciesName to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithOnAccessPoliciesName(onAccessPoliciesName *string) *VscanConfigDeleteCollectionParams {
	o.SetOnAccessPoliciesName(onAccessPoliciesName)
	return o
}

// SetOnAccessPoliciesName adds the onAccessPoliciesName to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetOnAccessPoliciesName(onAccessPoliciesName *string) {
	o.OnAccessPoliciesName = onAccessPoliciesName
}

// WithOnAccessPoliciesProtocol adds the onAccessPoliciesProtocol to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithOnAccessPoliciesProtocol(onAccessPoliciesProtocol *string) *VscanConfigDeleteCollectionParams {
	o.SetOnAccessPoliciesProtocol(onAccessPoliciesProtocol)
	return o
}

// SetOnAccessPoliciesProtocol adds the onAccessPoliciesProtocol to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetOnAccessPoliciesProtocol(onAccessPoliciesProtocol *string) {
	o.OnAccessPoliciesProtocol = onAccessPoliciesProtocol
}

// WithOnAccessPoliciesScopeExcludeExtensions adds the onAccessPoliciesScopeExcludeExtensions to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithOnAccessPoliciesScopeExcludeExtensions(onAccessPoliciesScopeExcludeExtensions *string) *VscanConfigDeleteCollectionParams {
	o.SetOnAccessPoliciesScopeExcludeExtensions(onAccessPoliciesScopeExcludeExtensions)
	return o
}

// SetOnAccessPoliciesScopeExcludeExtensions adds the onAccessPoliciesScopeExcludeExtensions to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetOnAccessPoliciesScopeExcludeExtensions(onAccessPoliciesScopeExcludeExtensions *string) {
	o.OnAccessPoliciesScopeExcludeExtensions = onAccessPoliciesScopeExcludeExtensions
}

// WithOnAccessPoliciesScopeExcludePaths adds the onAccessPoliciesScopeExcludePaths to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithOnAccessPoliciesScopeExcludePaths(onAccessPoliciesScopeExcludePaths *string) *VscanConfigDeleteCollectionParams {
	o.SetOnAccessPoliciesScopeExcludePaths(onAccessPoliciesScopeExcludePaths)
	return o
}

// SetOnAccessPoliciesScopeExcludePaths adds the onAccessPoliciesScopeExcludePaths to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetOnAccessPoliciesScopeExcludePaths(onAccessPoliciesScopeExcludePaths *string) {
	o.OnAccessPoliciesScopeExcludePaths = onAccessPoliciesScopeExcludePaths
}

// WithOnAccessPoliciesScopeIncludeExtensions adds the onAccessPoliciesScopeIncludeExtensions to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithOnAccessPoliciesScopeIncludeExtensions(onAccessPoliciesScopeIncludeExtensions *string) *VscanConfigDeleteCollectionParams {
	o.SetOnAccessPoliciesScopeIncludeExtensions(onAccessPoliciesScopeIncludeExtensions)
	return o
}

// SetOnAccessPoliciesScopeIncludeExtensions adds the onAccessPoliciesScopeIncludeExtensions to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetOnAccessPoliciesScopeIncludeExtensions(onAccessPoliciesScopeIncludeExtensions *string) {
	o.OnAccessPoliciesScopeIncludeExtensions = onAccessPoliciesScopeIncludeExtensions
}

// WithOnAccessPoliciesScopeMaxFileSize adds the onAccessPoliciesScopeMaxFileSize to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithOnAccessPoliciesScopeMaxFileSize(onAccessPoliciesScopeMaxFileSize *int64) *VscanConfigDeleteCollectionParams {
	o.SetOnAccessPoliciesScopeMaxFileSize(onAccessPoliciesScopeMaxFileSize)
	return o
}

// SetOnAccessPoliciesScopeMaxFileSize adds the onAccessPoliciesScopeMaxFileSize to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetOnAccessPoliciesScopeMaxFileSize(onAccessPoliciesScopeMaxFileSize *int64) {
	o.OnAccessPoliciesScopeMaxFileSize = onAccessPoliciesScopeMaxFileSize
}

// WithOnAccessPoliciesScopeOnlyExecuteAccess adds the onAccessPoliciesScopeOnlyExecuteAccess to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithOnAccessPoliciesScopeOnlyExecuteAccess(onAccessPoliciesScopeOnlyExecuteAccess *bool) *VscanConfigDeleteCollectionParams {
	o.SetOnAccessPoliciesScopeOnlyExecuteAccess(onAccessPoliciesScopeOnlyExecuteAccess)
	return o
}

// SetOnAccessPoliciesScopeOnlyExecuteAccess adds the onAccessPoliciesScopeOnlyExecuteAccess to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetOnAccessPoliciesScopeOnlyExecuteAccess(onAccessPoliciesScopeOnlyExecuteAccess *bool) {
	o.OnAccessPoliciesScopeOnlyExecuteAccess = onAccessPoliciesScopeOnlyExecuteAccess
}

// WithOnAccessPoliciesScopeScanReadonlyVolumes adds the onAccessPoliciesScopeScanReadonlyVolumes to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithOnAccessPoliciesScopeScanReadonlyVolumes(onAccessPoliciesScopeScanReadonlyVolumes *bool) *VscanConfigDeleteCollectionParams {
	o.SetOnAccessPoliciesScopeScanReadonlyVolumes(onAccessPoliciesScopeScanReadonlyVolumes)
	return o
}

// SetOnAccessPoliciesScopeScanReadonlyVolumes adds the onAccessPoliciesScopeScanReadonlyVolumes to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetOnAccessPoliciesScopeScanReadonlyVolumes(onAccessPoliciesScopeScanReadonlyVolumes *bool) {
	o.OnAccessPoliciesScopeScanReadonlyVolumes = onAccessPoliciesScopeScanReadonlyVolumes
}

// WithOnAccessPoliciesScopeScanWithoutExtension adds the onAccessPoliciesScopeScanWithoutExtension to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithOnAccessPoliciesScopeScanWithoutExtension(onAccessPoliciesScopeScanWithoutExtension *bool) *VscanConfigDeleteCollectionParams {
	o.SetOnAccessPoliciesScopeScanWithoutExtension(onAccessPoliciesScopeScanWithoutExtension)
	return o
}

// SetOnAccessPoliciesScopeScanWithoutExtension adds the onAccessPoliciesScopeScanWithoutExtension to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetOnAccessPoliciesScopeScanWithoutExtension(onAccessPoliciesScopeScanWithoutExtension *bool) {
	o.OnAccessPoliciesScopeScanWithoutExtension = onAccessPoliciesScopeScanWithoutExtension
}

// WithOnDemandPoliciesLogPath adds the onDemandPoliciesLogPath to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithOnDemandPoliciesLogPath(onDemandPoliciesLogPath *string) *VscanConfigDeleteCollectionParams {
	o.SetOnDemandPoliciesLogPath(onDemandPoliciesLogPath)
	return o
}

// SetOnDemandPoliciesLogPath adds the onDemandPoliciesLogPath to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetOnDemandPoliciesLogPath(onDemandPoliciesLogPath *string) {
	o.OnDemandPoliciesLogPath = onDemandPoliciesLogPath
}

// WithOnDemandPoliciesName adds the onDemandPoliciesName to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithOnDemandPoliciesName(onDemandPoliciesName *string) *VscanConfigDeleteCollectionParams {
	o.SetOnDemandPoliciesName(onDemandPoliciesName)
	return o
}

// SetOnDemandPoliciesName adds the onDemandPoliciesName to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetOnDemandPoliciesName(onDemandPoliciesName *string) {
	o.OnDemandPoliciesName = onDemandPoliciesName
}

// WithOnDemandPoliciesScanPaths adds the onDemandPoliciesScanPaths to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithOnDemandPoliciesScanPaths(onDemandPoliciesScanPaths *string) *VscanConfigDeleteCollectionParams {
	o.SetOnDemandPoliciesScanPaths(onDemandPoliciesScanPaths)
	return o
}

// SetOnDemandPoliciesScanPaths adds the onDemandPoliciesScanPaths to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetOnDemandPoliciesScanPaths(onDemandPoliciesScanPaths *string) {
	o.OnDemandPoliciesScanPaths = onDemandPoliciesScanPaths
}

// WithOnDemandPoliciesScheduleName adds the onDemandPoliciesScheduleName to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithOnDemandPoliciesScheduleName(onDemandPoliciesScheduleName *string) *VscanConfigDeleteCollectionParams {
	o.SetOnDemandPoliciesScheduleName(onDemandPoliciesScheduleName)
	return o
}

// SetOnDemandPoliciesScheduleName adds the onDemandPoliciesScheduleName to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetOnDemandPoliciesScheduleName(onDemandPoliciesScheduleName *string) {
	o.OnDemandPoliciesScheduleName = onDemandPoliciesScheduleName
}

// WithOnDemandPoliciesScheduleUUID adds the onDemandPoliciesScheduleUUID to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithOnDemandPoliciesScheduleUUID(onDemandPoliciesScheduleUUID *string) *VscanConfigDeleteCollectionParams {
	o.SetOnDemandPoliciesScheduleUUID(onDemandPoliciesScheduleUUID)
	return o
}

// SetOnDemandPoliciesScheduleUUID adds the onDemandPoliciesScheduleUuid to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetOnDemandPoliciesScheduleUUID(onDemandPoliciesScheduleUUID *string) {
	o.OnDemandPoliciesScheduleUUID = onDemandPoliciesScheduleUUID
}

// WithOnDemandPoliciesScopeExcludeExtensions adds the onDemandPoliciesScopeExcludeExtensions to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithOnDemandPoliciesScopeExcludeExtensions(onDemandPoliciesScopeExcludeExtensions *string) *VscanConfigDeleteCollectionParams {
	o.SetOnDemandPoliciesScopeExcludeExtensions(onDemandPoliciesScopeExcludeExtensions)
	return o
}

// SetOnDemandPoliciesScopeExcludeExtensions adds the onDemandPoliciesScopeExcludeExtensions to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetOnDemandPoliciesScopeExcludeExtensions(onDemandPoliciesScopeExcludeExtensions *string) {
	o.OnDemandPoliciesScopeExcludeExtensions = onDemandPoliciesScopeExcludeExtensions
}

// WithOnDemandPoliciesScopeExcludePaths adds the onDemandPoliciesScopeExcludePaths to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithOnDemandPoliciesScopeExcludePaths(onDemandPoliciesScopeExcludePaths *string) *VscanConfigDeleteCollectionParams {
	o.SetOnDemandPoliciesScopeExcludePaths(onDemandPoliciesScopeExcludePaths)
	return o
}

// SetOnDemandPoliciesScopeExcludePaths adds the onDemandPoliciesScopeExcludePaths to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetOnDemandPoliciesScopeExcludePaths(onDemandPoliciesScopeExcludePaths *string) {
	o.OnDemandPoliciesScopeExcludePaths = onDemandPoliciesScopeExcludePaths
}

// WithOnDemandPoliciesScopeIncludeExtensions adds the onDemandPoliciesScopeIncludeExtensions to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithOnDemandPoliciesScopeIncludeExtensions(onDemandPoliciesScopeIncludeExtensions *string) *VscanConfigDeleteCollectionParams {
	o.SetOnDemandPoliciesScopeIncludeExtensions(onDemandPoliciesScopeIncludeExtensions)
	return o
}

// SetOnDemandPoliciesScopeIncludeExtensions adds the onDemandPoliciesScopeIncludeExtensions to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetOnDemandPoliciesScopeIncludeExtensions(onDemandPoliciesScopeIncludeExtensions *string) {
	o.OnDemandPoliciesScopeIncludeExtensions = onDemandPoliciesScopeIncludeExtensions
}

// WithOnDemandPoliciesScopeMaxFileSize adds the onDemandPoliciesScopeMaxFileSize to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithOnDemandPoliciesScopeMaxFileSize(onDemandPoliciesScopeMaxFileSize *int64) *VscanConfigDeleteCollectionParams {
	o.SetOnDemandPoliciesScopeMaxFileSize(onDemandPoliciesScopeMaxFileSize)
	return o
}

// SetOnDemandPoliciesScopeMaxFileSize adds the onDemandPoliciesScopeMaxFileSize to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetOnDemandPoliciesScopeMaxFileSize(onDemandPoliciesScopeMaxFileSize *int64) {
	o.OnDemandPoliciesScopeMaxFileSize = onDemandPoliciesScopeMaxFileSize
}

// WithOnDemandPoliciesScopeScanWithoutExtension adds the onDemandPoliciesScopeScanWithoutExtension to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithOnDemandPoliciesScopeScanWithoutExtension(onDemandPoliciesScopeScanWithoutExtension *bool) *VscanConfigDeleteCollectionParams {
	o.SetOnDemandPoliciesScopeScanWithoutExtension(onDemandPoliciesScopeScanWithoutExtension)
	return o
}

// SetOnDemandPoliciesScopeScanWithoutExtension adds the onDemandPoliciesScopeScanWithoutExtension to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetOnDemandPoliciesScopeScanWithoutExtension(onDemandPoliciesScopeScanWithoutExtension *bool) {
	o.OnDemandPoliciesScopeScanWithoutExtension = onDemandPoliciesScopeScanWithoutExtension
}

// WithReturnRecords adds the returnRecords to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *VscanConfigDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *VscanConfigDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScannerPoolsClusterName adds the scannerPoolsClusterName to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithScannerPoolsClusterName(scannerPoolsClusterName *string) *VscanConfigDeleteCollectionParams {
	o.SetScannerPoolsClusterName(scannerPoolsClusterName)
	return o
}

// SetScannerPoolsClusterName adds the scannerPoolsClusterName to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetScannerPoolsClusterName(scannerPoolsClusterName *string) {
	o.ScannerPoolsClusterName = scannerPoolsClusterName
}

// WithScannerPoolsClusterUUID adds the scannerPoolsClusterUUID to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithScannerPoolsClusterUUID(scannerPoolsClusterUUID *string) *VscanConfigDeleteCollectionParams {
	o.SetScannerPoolsClusterUUID(scannerPoolsClusterUUID)
	return o
}

// SetScannerPoolsClusterUUID adds the scannerPoolsClusterUuid to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetScannerPoolsClusterUUID(scannerPoolsClusterUUID *string) {
	o.ScannerPoolsClusterUUID = scannerPoolsClusterUUID
}

// WithScannerPoolsName adds the scannerPoolsName to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithScannerPoolsName(scannerPoolsName *string) *VscanConfigDeleteCollectionParams {
	o.SetScannerPoolsName(scannerPoolsName)
	return o
}

// SetScannerPoolsName adds the scannerPoolsName to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetScannerPoolsName(scannerPoolsName *string) {
	o.ScannerPoolsName = scannerPoolsName
}

// WithScannerPoolsPrivilegedUsers adds the scannerPoolsPrivilegedUsers to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithScannerPoolsPrivilegedUsers(scannerPoolsPrivilegedUsers *string) *VscanConfigDeleteCollectionParams {
	o.SetScannerPoolsPrivilegedUsers(scannerPoolsPrivilegedUsers)
	return o
}

// SetScannerPoolsPrivilegedUsers adds the scannerPoolsPrivilegedUsers to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetScannerPoolsPrivilegedUsers(scannerPoolsPrivilegedUsers *string) {
	o.ScannerPoolsPrivilegedUsers = scannerPoolsPrivilegedUsers
}

// WithScannerPoolsRole adds the scannerPoolsRole to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithScannerPoolsRole(scannerPoolsRole *string) *VscanConfigDeleteCollectionParams {
	o.SetScannerPoolsRole(scannerPoolsRole)
	return o
}

// SetScannerPoolsRole adds the scannerPoolsRole to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetScannerPoolsRole(scannerPoolsRole *string) {
	o.ScannerPoolsRole = scannerPoolsRole
}

// WithScannerPoolsServers adds the scannerPoolsServers to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithScannerPoolsServers(scannerPoolsServers *string) *VscanConfigDeleteCollectionParams {
	o.SetScannerPoolsServers(scannerPoolsServers)
	return o
}

// SetScannerPoolsServers adds the scannerPoolsServers to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetScannerPoolsServers(scannerPoolsServers *string) {
	o.ScannerPoolsServers = scannerPoolsServers
}

// WithSerialRecords adds the serialRecords to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *VscanConfigDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithSvmName(svmName *string) *VscanConfigDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) WithSvmUUID(svmUUID *string) *VscanConfigDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the vscan config delete collection params
func (o *VscanConfigDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *VscanConfigDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.OnAccessPoliciesEnabled != nil {

		// query param on_access_policies.enabled
		var qrOnAccessPoliciesEnabled bool

		if o.OnAccessPoliciesEnabled != nil {
			qrOnAccessPoliciesEnabled = *o.OnAccessPoliciesEnabled
		}
		qOnAccessPoliciesEnabled := swag.FormatBool(qrOnAccessPoliciesEnabled)
		if qOnAccessPoliciesEnabled != "" {

			if err := r.SetQueryParam("on_access_policies.enabled", qOnAccessPoliciesEnabled); err != nil {
				return err
			}
		}
	}

	if o.OnAccessPoliciesMandatory != nil {

		// query param on_access_policies.mandatory
		var qrOnAccessPoliciesMandatory bool

		if o.OnAccessPoliciesMandatory != nil {
			qrOnAccessPoliciesMandatory = *o.OnAccessPoliciesMandatory
		}
		qOnAccessPoliciesMandatory := swag.FormatBool(qrOnAccessPoliciesMandatory)
		if qOnAccessPoliciesMandatory != "" {

			if err := r.SetQueryParam("on_access_policies.mandatory", qOnAccessPoliciesMandatory); err != nil {
				return err
			}
		}
	}

	if o.OnAccessPoliciesName != nil {

		// query param on_access_policies.name
		var qrOnAccessPoliciesName string

		if o.OnAccessPoliciesName != nil {
			qrOnAccessPoliciesName = *o.OnAccessPoliciesName
		}
		qOnAccessPoliciesName := qrOnAccessPoliciesName
		if qOnAccessPoliciesName != "" {

			if err := r.SetQueryParam("on_access_policies.name", qOnAccessPoliciesName); err != nil {
				return err
			}
		}
	}

	if o.OnAccessPoliciesProtocol != nil {

		// query param on_access_policies.protocol
		var qrOnAccessPoliciesProtocol string

		if o.OnAccessPoliciesProtocol != nil {
			qrOnAccessPoliciesProtocol = *o.OnAccessPoliciesProtocol
		}
		qOnAccessPoliciesProtocol := qrOnAccessPoliciesProtocol
		if qOnAccessPoliciesProtocol != "" {

			if err := r.SetQueryParam("on_access_policies.protocol", qOnAccessPoliciesProtocol); err != nil {
				return err
			}
		}
	}

	if o.OnAccessPoliciesScopeExcludeExtensions != nil {

		// query param on_access_policies.scope.exclude_extensions
		var qrOnAccessPoliciesScopeExcludeExtensions string

		if o.OnAccessPoliciesScopeExcludeExtensions != nil {
			qrOnAccessPoliciesScopeExcludeExtensions = *o.OnAccessPoliciesScopeExcludeExtensions
		}
		qOnAccessPoliciesScopeExcludeExtensions := qrOnAccessPoliciesScopeExcludeExtensions
		if qOnAccessPoliciesScopeExcludeExtensions != "" {

			if err := r.SetQueryParam("on_access_policies.scope.exclude_extensions", qOnAccessPoliciesScopeExcludeExtensions); err != nil {
				return err
			}
		}
	}

	if o.OnAccessPoliciesScopeExcludePaths != nil {

		// query param on_access_policies.scope.exclude_paths
		var qrOnAccessPoliciesScopeExcludePaths string

		if o.OnAccessPoliciesScopeExcludePaths != nil {
			qrOnAccessPoliciesScopeExcludePaths = *o.OnAccessPoliciesScopeExcludePaths
		}
		qOnAccessPoliciesScopeExcludePaths := qrOnAccessPoliciesScopeExcludePaths
		if qOnAccessPoliciesScopeExcludePaths != "" {

			if err := r.SetQueryParam("on_access_policies.scope.exclude_paths", qOnAccessPoliciesScopeExcludePaths); err != nil {
				return err
			}
		}
	}

	if o.OnAccessPoliciesScopeIncludeExtensions != nil {

		// query param on_access_policies.scope.include_extensions
		var qrOnAccessPoliciesScopeIncludeExtensions string

		if o.OnAccessPoliciesScopeIncludeExtensions != nil {
			qrOnAccessPoliciesScopeIncludeExtensions = *o.OnAccessPoliciesScopeIncludeExtensions
		}
		qOnAccessPoliciesScopeIncludeExtensions := qrOnAccessPoliciesScopeIncludeExtensions
		if qOnAccessPoliciesScopeIncludeExtensions != "" {

			if err := r.SetQueryParam("on_access_policies.scope.include_extensions", qOnAccessPoliciesScopeIncludeExtensions); err != nil {
				return err
			}
		}
	}

	if o.OnAccessPoliciesScopeMaxFileSize != nil {

		// query param on_access_policies.scope.max_file_size
		var qrOnAccessPoliciesScopeMaxFileSize int64

		if o.OnAccessPoliciesScopeMaxFileSize != nil {
			qrOnAccessPoliciesScopeMaxFileSize = *o.OnAccessPoliciesScopeMaxFileSize
		}
		qOnAccessPoliciesScopeMaxFileSize := swag.FormatInt64(qrOnAccessPoliciesScopeMaxFileSize)
		if qOnAccessPoliciesScopeMaxFileSize != "" {

			if err := r.SetQueryParam("on_access_policies.scope.max_file_size", qOnAccessPoliciesScopeMaxFileSize); err != nil {
				return err
			}
		}
	}

	if o.OnAccessPoliciesScopeOnlyExecuteAccess != nil {

		// query param on_access_policies.scope.only_execute_access
		var qrOnAccessPoliciesScopeOnlyExecuteAccess bool

		if o.OnAccessPoliciesScopeOnlyExecuteAccess != nil {
			qrOnAccessPoliciesScopeOnlyExecuteAccess = *o.OnAccessPoliciesScopeOnlyExecuteAccess
		}
		qOnAccessPoliciesScopeOnlyExecuteAccess := swag.FormatBool(qrOnAccessPoliciesScopeOnlyExecuteAccess)
		if qOnAccessPoliciesScopeOnlyExecuteAccess != "" {

			if err := r.SetQueryParam("on_access_policies.scope.only_execute_access", qOnAccessPoliciesScopeOnlyExecuteAccess); err != nil {
				return err
			}
		}
	}

	if o.OnAccessPoliciesScopeScanReadonlyVolumes != nil {

		// query param on_access_policies.scope.scan_readonly_volumes
		var qrOnAccessPoliciesScopeScanReadonlyVolumes bool

		if o.OnAccessPoliciesScopeScanReadonlyVolumes != nil {
			qrOnAccessPoliciesScopeScanReadonlyVolumes = *o.OnAccessPoliciesScopeScanReadonlyVolumes
		}
		qOnAccessPoliciesScopeScanReadonlyVolumes := swag.FormatBool(qrOnAccessPoliciesScopeScanReadonlyVolumes)
		if qOnAccessPoliciesScopeScanReadonlyVolumes != "" {

			if err := r.SetQueryParam("on_access_policies.scope.scan_readonly_volumes", qOnAccessPoliciesScopeScanReadonlyVolumes); err != nil {
				return err
			}
		}
	}

	if o.OnAccessPoliciesScopeScanWithoutExtension != nil {

		// query param on_access_policies.scope.scan_without_extension
		var qrOnAccessPoliciesScopeScanWithoutExtension bool

		if o.OnAccessPoliciesScopeScanWithoutExtension != nil {
			qrOnAccessPoliciesScopeScanWithoutExtension = *o.OnAccessPoliciesScopeScanWithoutExtension
		}
		qOnAccessPoliciesScopeScanWithoutExtension := swag.FormatBool(qrOnAccessPoliciesScopeScanWithoutExtension)
		if qOnAccessPoliciesScopeScanWithoutExtension != "" {

			if err := r.SetQueryParam("on_access_policies.scope.scan_without_extension", qOnAccessPoliciesScopeScanWithoutExtension); err != nil {
				return err
			}
		}
	}

	if o.OnDemandPoliciesLogPath != nil {

		// query param on_demand_policies.log_path
		var qrOnDemandPoliciesLogPath string

		if o.OnDemandPoliciesLogPath != nil {
			qrOnDemandPoliciesLogPath = *o.OnDemandPoliciesLogPath
		}
		qOnDemandPoliciesLogPath := qrOnDemandPoliciesLogPath
		if qOnDemandPoliciesLogPath != "" {

			if err := r.SetQueryParam("on_demand_policies.log_path", qOnDemandPoliciesLogPath); err != nil {
				return err
			}
		}
	}

	if o.OnDemandPoliciesName != nil {

		// query param on_demand_policies.name
		var qrOnDemandPoliciesName string

		if o.OnDemandPoliciesName != nil {
			qrOnDemandPoliciesName = *o.OnDemandPoliciesName
		}
		qOnDemandPoliciesName := qrOnDemandPoliciesName
		if qOnDemandPoliciesName != "" {

			if err := r.SetQueryParam("on_demand_policies.name", qOnDemandPoliciesName); err != nil {
				return err
			}
		}
	}

	if o.OnDemandPoliciesScanPaths != nil {

		// query param on_demand_policies.scan_paths
		var qrOnDemandPoliciesScanPaths string

		if o.OnDemandPoliciesScanPaths != nil {
			qrOnDemandPoliciesScanPaths = *o.OnDemandPoliciesScanPaths
		}
		qOnDemandPoliciesScanPaths := qrOnDemandPoliciesScanPaths
		if qOnDemandPoliciesScanPaths != "" {

			if err := r.SetQueryParam("on_demand_policies.scan_paths", qOnDemandPoliciesScanPaths); err != nil {
				return err
			}
		}
	}

	if o.OnDemandPoliciesScheduleName != nil {

		// query param on_demand_policies.schedule.name
		var qrOnDemandPoliciesScheduleName string

		if o.OnDemandPoliciesScheduleName != nil {
			qrOnDemandPoliciesScheduleName = *o.OnDemandPoliciesScheduleName
		}
		qOnDemandPoliciesScheduleName := qrOnDemandPoliciesScheduleName
		if qOnDemandPoliciesScheduleName != "" {

			if err := r.SetQueryParam("on_demand_policies.schedule.name", qOnDemandPoliciesScheduleName); err != nil {
				return err
			}
		}
	}

	if o.OnDemandPoliciesScheduleUUID != nil {

		// query param on_demand_policies.schedule.uuid
		var qrOnDemandPoliciesScheduleUUID string

		if o.OnDemandPoliciesScheduleUUID != nil {
			qrOnDemandPoliciesScheduleUUID = *o.OnDemandPoliciesScheduleUUID
		}
		qOnDemandPoliciesScheduleUUID := qrOnDemandPoliciesScheduleUUID
		if qOnDemandPoliciesScheduleUUID != "" {

			if err := r.SetQueryParam("on_demand_policies.schedule.uuid", qOnDemandPoliciesScheduleUUID); err != nil {
				return err
			}
		}
	}

	if o.OnDemandPoliciesScopeExcludeExtensions != nil {

		// query param on_demand_policies.scope.exclude_extensions
		var qrOnDemandPoliciesScopeExcludeExtensions string

		if o.OnDemandPoliciesScopeExcludeExtensions != nil {
			qrOnDemandPoliciesScopeExcludeExtensions = *o.OnDemandPoliciesScopeExcludeExtensions
		}
		qOnDemandPoliciesScopeExcludeExtensions := qrOnDemandPoliciesScopeExcludeExtensions
		if qOnDemandPoliciesScopeExcludeExtensions != "" {

			if err := r.SetQueryParam("on_demand_policies.scope.exclude_extensions", qOnDemandPoliciesScopeExcludeExtensions); err != nil {
				return err
			}
		}
	}

	if o.OnDemandPoliciesScopeExcludePaths != nil {

		// query param on_demand_policies.scope.exclude_paths
		var qrOnDemandPoliciesScopeExcludePaths string

		if o.OnDemandPoliciesScopeExcludePaths != nil {
			qrOnDemandPoliciesScopeExcludePaths = *o.OnDemandPoliciesScopeExcludePaths
		}
		qOnDemandPoliciesScopeExcludePaths := qrOnDemandPoliciesScopeExcludePaths
		if qOnDemandPoliciesScopeExcludePaths != "" {

			if err := r.SetQueryParam("on_demand_policies.scope.exclude_paths", qOnDemandPoliciesScopeExcludePaths); err != nil {
				return err
			}
		}
	}

	if o.OnDemandPoliciesScopeIncludeExtensions != nil {

		// query param on_demand_policies.scope.include_extensions
		var qrOnDemandPoliciesScopeIncludeExtensions string

		if o.OnDemandPoliciesScopeIncludeExtensions != nil {
			qrOnDemandPoliciesScopeIncludeExtensions = *o.OnDemandPoliciesScopeIncludeExtensions
		}
		qOnDemandPoliciesScopeIncludeExtensions := qrOnDemandPoliciesScopeIncludeExtensions
		if qOnDemandPoliciesScopeIncludeExtensions != "" {

			if err := r.SetQueryParam("on_demand_policies.scope.include_extensions", qOnDemandPoliciesScopeIncludeExtensions); err != nil {
				return err
			}
		}
	}

	if o.OnDemandPoliciesScopeMaxFileSize != nil {

		// query param on_demand_policies.scope.max_file_size
		var qrOnDemandPoliciesScopeMaxFileSize int64

		if o.OnDemandPoliciesScopeMaxFileSize != nil {
			qrOnDemandPoliciesScopeMaxFileSize = *o.OnDemandPoliciesScopeMaxFileSize
		}
		qOnDemandPoliciesScopeMaxFileSize := swag.FormatInt64(qrOnDemandPoliciesScopeMaxFileSize)
		if qOnDemandPoliciesScopeMaxFileSize != "" {

			if err := r.SetQueryParam("on_demand_policies.scope.max_file_size", qOnDemandPoliciesScopeMaxFileSize); err != nil {
				return err
			}
		}
	}

	if o.OnDemandPoliciesScopeScanWithoutExtension != nil {

		// query param on_demand_policies.scope.scan_without_extension
		var qrOnDemandPoliciesScopeScanWithoutExtension bool

		if o.OnDemandPoliciesScopeScanWithoutExtension != nil {
			qrOnDemandPoliciesScopeScanWithoutExtension = *o.OnDemandPoliciesScopeScanWithoutExtension
		}
		qOnDemandPoliciesScopeScanWithoutExtension := swag.FormatBool(qrOnDemandPoliciesScopeScanWithoutExtension)
		if qOnDemandPoliciesScopeScanWithoutExtension != "" {

			if err := r.SetQueryParam("on_demand_policies.scope.scan_without_extension", qOnDemandPoliciesScopeScanWithoutExtension); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.ScannerPoolsClusterName != nil {

		// query param scanner_pools.cluster.name
		var qrScannerPoolsClusterName string

		if o.ScannerPoolsClusterName != nil {
			qrScannerPoolsClusterName = *o.ScannerPoolsClusterName
		}
		qScannerPoolsClusterName := qrScannerPoolsClusterName
		if qScannerPoolsClusterName != "" {

			if err := r.SetQueryParam("scanner_pools.cluster.name", qScannerPoolsClusterName); err != nil {
				return err
			}
		}
	}

	if o.ScannerPoolsClusterUUID != nil {

		// query param scanner_pools.cluster.uuid
		var qrScannerPoolsClusterUUID string

		if o.ScannerPoolsClusterUUID != nil {
			qrScannerPoolsClusterUUID = *o.ScannerPoolsClusterUUID
		}
		qScannerPoolsClusterUUID := qrScannerPoolsClusterUUID
		if qScannerPoolsClusterUUID != "" {

			if err := r.SetQueryParam("scanner_pools.cluster.uuid", qScannerPoolsClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.ScannerPoolsName != nil {

		// query param scanner_pools.name
		var qrScannerPoolsName string

		if o.ScannerPoolsName != nil {
			qrScannerPoolsName = *o.ScannerPoolsName
		}
		qScannerPoolsName := qrScannerPoolsName
		if qScannerPoolsName != "" {

			if err := r.SetQueryParam("scanner_pools.name", qScannerPoolsName); err != nil {
				return err
			}
		}
	}

	if o.ScannerPoolsPrivilegedUsers != nil {

		// query param scanner_pools.privileged_users
		var qrScannerPoolsPrivilegedUsers string

		if o.ScannerPoolsPrivilegedUsers != nil {
			qrScannerPoolsPrivilegedUsers = *o.ScannerPoolsPrivilegedUsers
		}
		qScannerPoolsPrivilegedUsers := qrScannerPoolsPrivilegedUsers
		if qScannerPoolsPrivilegedUsers != "" {

			if err := r.SetQueryParam("scanner_pools.privileged_users", qScannerPoolsPrivilegedUsers); err != nil {
				return err
			}
		}
	}

	if o.ScannerPoolsRole != nil {

		// query param scanner_pools.role
		var qrScannerPoolsRole string

		if o.ScannerPoolsRole != nil {
			qrScannerPoolsRole = *o.ScannerPoolsRole
		}
		qScannerPoolsRole := qrScannerPoolsRole
		if qScannerPoolsRole != "" {

			if err := r.SetQueryParam("scanner_pools.role", qScannerPoolsRole); err != nil {
				return err
			}
		}
	}

	if o.ScannerPoolsServers != nil {

		// query param scanner_pools.servers
		var qrScannerPoolsServers string

		if o.ScannerPoolsServers != nil {
			qrScannerPoolsServers = *o.ScannerPoolsServers
		}
		qScannerPoolsServers := qrScannerPoolsServers
		if qScannerPoolsServers != "" {

			if err := r.SetQueryParam("scanner_pools.servers", qScannerPoolsServers); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
