// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// VscanCreateReader is a Reader for the VscanCreate structure.
type VscanCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VscanCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewVscanCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewVscanCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewVscanCreateCreated creates a VscanCreateCreated with default headers values
func NewVscanCreateCreated() *VscanCreateCreated {
	return &VscanCreateCreated{}
}

/*
VscanCreateCreated describes a response with status code 201, with default header values.

Created
*/
type VscanCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.VscanResponse
}

// IsSuccess returns true when this vscan create created response has a 2xx status code
func (o *VscanCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this vscan create created response has a 3xx status code
func (o *VscanCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this vscan create created response has a 4xx status code
func (o *VscanCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this vscan create created response has a 5xx status code
func (o *VscanCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this vscan create created response a status code equal to that given
func (o *VscanCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the vscan create created response
func (o *VscanCreateCreated) Code() int {
	return 201
}

func (o *VscanCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/vscan][%d] vscanCreateCreated %s", 201, payload)
}

func (o *VscanCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/vscan][%d] vscanCreateCreated %s", 201, payload)
}

func (o *VscanCreateCreated) GetPayload() *models.VscanResponse {
	return o.Payload
}

func (o *VscanCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.VscanResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewVscanCreateDefault creates a VscanCreateDefault with default headers values
func NewVscanCreateDefault(code int) *VscanCreateDefault {
	return &VscanCreateDefault{
		_statusCode: code,
	}
}

/*
	VscanCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 10027259   | A scanner-pool, an On-Access policy, or an On-Demand policy might fail to get created due to either a systematic error or some hardware failure. The error code returned details the failure along with the reason for the failure. For example, if a scanner-pool fails due to an incorrect cluster name, then the error might read: \"Failed to create scanner-pool \"scanner-1\". Reason: \"Cluster uuid points to different cluster name instead of the cluster-name supplied.\". Retry the operation.\"
| 10027260   | If a scanner-pool, an On-Access policy or an On-Demand policy specified in the input already exists, then a duplicate error is returned. For example, if a scanner-pool \"scanner-1\" already exists for an SVM and is again specified in the input, the error message will read: \" Failed to create scanner-pool \"scanner-1\" as the specified entry already exists. Delete the entry and retry the POST operation.\"
| 2621462    | The specified SVM name is invalid
| 2621706    | The specified svm.uuid is either invalid or belongs to a different SVM
| 10027015   | Attempting to enable a Vscan but no active scanner-pool exists for the specified SVM
| 10027011   | Attempting to enable a Vscan for an SVM for which no CIFS server exists
| 10027023   | Attempting to enable a Vscan for an SVM for which no active Vscan On-Access policy exist
| 10027086   | DNS resolution failed for one or more hostnames
| 10027012   | Cannot enable Vscan on an administrative SVM.
*/
type VscanCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this vscan create default response has a 2xx status code
func (o *VscanCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this vscan create default response has a 3xx status code
func (o *VscanCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this vscan create default response has a 4xx status code
func (o *VscanCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this vscan create default response has a 5xx status code
func (o *VscanCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this vscan create default response a status code equal to that given
func (o *VscanCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the vscan create default response
func (o *VscanCreateDefault) Code() int {
	return o._statusCode
}

func (o *VscanCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/vscan][%d] vscan_create default %s", o._statusCode, payload)
}

func (o *VscanCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/vscan][%d] vscan_create default %s", o._statusCode, payload)
}

func (o *VscanCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *VscanCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
