// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// VscanModifyReader is a Reader for the VscanModify structure.
type VscanModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VscanModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewVscanModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewVscanModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewVscanModifyOK creates a VscanModifyOK with default headers values
func NewVscanModifyOK() *VscanModifyOK {
	return &VscanModifyOK{}
}

/*
VscanModifyOK describes a response with status code 200, with default header values.

OK
*/
type VscanModifyOK struct {
}

// IsSuccess returns true when this vscan modify o k response has a 2xx status code
func (o *VscanModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this vscan modify o k response has a 3xx status code
func (o *VscanModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this vscan modify o k response has a 4xx status code
func (o *VscanModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this vscan modify o k response has a 5xx status code
func (o *VscanModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this vscan modify o k response a status code equal to that given
func (o *VscanModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the vscan modify o k response
func (o *VscanModifyOK) Code() int {
	return 200
}

func (o *VscanModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/vscan/{svm.uuid}][%d] vscanModifyOK", 200)
}

func (o *VscanModifyOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/vscan/{svm.uuid}][%d] vscanModifyOK", 200)
}

func (o *VscanModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewVscanModifyDefault creates a VscanModifyDefault with default headers values
func NewVscanModifyDefault(code int) *VscanModifyDefault {
	return &VscanModifyDefault{
		_statusCode: code,
	}
}

/*
	VscanModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 10027015   | Attempting to enable a Vscan but no active scanner-pool exists for the specified SVM
| 10027009   | Attempting to enable a Vscan for an SVM for which it's already enabled
| 10027010   | Attempting to disable a Vscan for an SVM for which it's already disabled
| 10027011   | Attempting to enable a Vscan for an SVM for which no CIFS server exists
| 10027023   | Attempting to enable a Vscan for an SVM for which no active Vscan On-Access policy exists
| 10027012   | Cannot enable Vscan on an administrative SVM.
*/
type VscanModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this vscan modify default response has a 2xx status code
func (o *VscanModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this vscan modify default response has a 3xx status code
func (o *VscanModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this vscan modify default response has a 4xx status code
func (o *VscanModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this vscan modify default response has a 5xx status code
func (o *VscanModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this vscan modify default response a status code equal to that given
func (o *VscanModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the vscan modify default response
func (o *VscanModifyDefault) Code() int {
	return o._statusCode
}

func (o *VscanModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/vscan/{svm.uuid}][%d] vscan_modify default %s", o._statusCode, payload)
}

func (o *VscanModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/vscan/{svm.uuid}][%d] vscan_modify default %s", o._statusCode, payload)
}

func (o *VscanModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *VscanModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
