// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewVscanOnAccessCreateParams creates a new VscanOnAccessCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewVscanOnAccessCreateParams() *VscanOnAccessCreateParams {
	return &VscanOnAccessCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewVscanOnAccessCreateParamsWithTimeout creates a new VscanOnAccessCreateParams object
// with the ability to set a timeout on a request.
func NewVscanOnAccessCreateParamsWithTimeout(timeout time.Duration) *VscanOnAccessCreateParams {
	return &VscanOnAccessCreateParams{
		timeout: timeout,
	}
}

// NewVscanOnAccessCreateParamsWithContext creates a new VscanOnAccessCreateParams object
// with the ability to set a context for a request.
func NewVscanOnAccessCreateParamsWithContext(ctx context.Context) *VscanOnAccessCreateParams {
	return &VscanOnAccessCreateParams{
		Context: ctx,
	}
}

// NewVscanOnAccessCreateParamsWithHTTPClient creates a new VscanOnAccessCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewVscanOnAccessCreateParamsWithHTTPClient(client *http.Client) *VscanOnAccessCreateParams {
	return &VscanOnAccessCreateParams{
		HTTPClient: client,
	}
}

/*
VscanOnAccessCreateParams contains all the parameters to send to the API endpoint

	for the vscan on access create operation.

	Typically these are written to a http.Request.
*/
type VscanOnAccessCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.VscanOnAccess

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the vscan on access create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VscanOnAccessCreateParams) WithDefaults() *VscanOnAccessCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the vscan on access create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VscanOnAccessCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := VscanOnAccessCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the vscan on access create params
func (o *VscanOnAccessCreateParams) WithTimeout(timeout time.Duration) *VscanOnAccessCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the vscan on access create params
func (o *VscanOnAccessCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the vscan on access create params
func (o *VscanOnAccessCreateParams) WithContext(ctx context.Context) *VscanOnAccessCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the vscan on access create params
func (o *VscanOnAccessCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the vscan on access create params
func (o *VscanOnAccessCreateParams) WithHTTPClient(client *http.Client) *VscanOnAccessCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the vscan on access create params
func (o *VscanOnAccessCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the vscan on access create params
func (o *VscanOnAccessCreateParams) WithInfo(info *models.VscanOnAccess) *VscanOnAccessCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the vscan on access create params
func (o *VscanOnAccessCreateParams) SetInfo(info *models.VscanOnAccess) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the vscan on access create params
func (o *VscanOnAccessCreateParams) WithReturnRecords(returnRecords *bool) *VscanOnAccessCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the vscan on access create params
func (o *VscanOnAccessCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithSvmUUID adds the svmUUID to the vscan on access create params
func (o *VscanOnAccessCreateParams) WithSvmUUID(svmUUID string) *VscanOnAccessCreateParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the vscan on access create params
func (o *VscanOnAccessCreateParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *VscanOnAccessCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
