// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// VscanOnDemandCreateReader is a Reader for the VscanOnDemandCreate structure.
type VscanOnDemandCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VscanOnDemandCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewVscanOnDemandCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewVscanOnDemandCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewVscanOnDemandCreateCreated creates a VscanOnDemandCreateCreated with default headers values
func NewVscanOnDemandCreateCreated() *VscanOnDemandCreateCreated {
	return &VscanOnDemandCreateCreated{}
}

/*
VscanOnDemandCreateCreated describes a response with status code 201, with default header values.

Created
*/
type VscanOnDemandCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.VscanOnDemandResponse
}

// IsSuccess returns true when this vscan on demand create created response has a 2xx status code
func (o *VscanOnDemandCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this vscan on demand create created response has a 3xx status code
func (o *VscanOnDemandCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this vscan on demand create created response has a 4xx status code
func (o *VscanOnDemandCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this vscan on demand create created response has a 5xx status code
func (o *VscanOnDemandCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this vscan on demand create created response a status code equal to that given
func (o *VscanOnDemandCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the vscan on demand create created response
func (o *VscanOnDemandCreateCreated) Code() int {
	return 201
}

func (o *VscanOnDemandCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/vscan/{svm.uuid}/on-demand-policies][%d] vscanOnDemandCreateCreated %s", 201, payload)
}

func (o *VscanOnDemandCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/vscan/{svm.uuid}/on-demand-policies][%d] vscanOnDemandCreateCreated %s", 201, payload)
}

func (o *VscanOnDemandCreateCreated) GetPayload() *models.VscanOnDemandResponse {
	return o.Payload
}

func (o *VscanOnDemandCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.VscanOnDemandResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewVscanOnDemandCreateDefault creates a VscanOnDemandCreateDefault with default headers values
func NewVscanOnDemandCreateDefault(code int) *VscanOnDemandCreateDefault {
	return &VscanOnDemandCreateDefault{
		_statusCode: code,
	}
}

/*
	VscanOnDemandCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 10027101   | The file size must be in the range 1KB to 1TB |
| 10027107   | The include extensions list cannot be empty. Specify at least one extension for inclusion. |
| 10027164   | An On-Demand policy cannot be scheduled, as the Vscan is disabled. Enable the Vscan and retry the operation. |
| 10027167   | The specified schedule does not exist. Create the schedule or create a policy without specifying the schedule. |
| 10027168   | The specified scan path does not exist. The scan path must be specified from the root of the SVM, and must begin with UNIX path delimiters (use “/” not “\\”) |
| 10027169   | The specified scan path is not supported for scanning. |
| 10027173   | The new On-Demand policy cannot be created because the SVM has reached the maximum limit of 10 On-Demand policies. Delete an existing policy in order to create a new policy. |
| 10027174   | The specified exclude path is invalid. The path must be specified from the root of the SVM, and must begin with UNIX path delimiters (use "/" not "\\") |
| 10027175   | An On-Demand policy cannot be scheduled as the Vserver is not in an operational state. |
| 10027176   | The log-path specified does not exist. The log path must be specified from the root of the SVM, and must begin with UNIX path delimiters (use “/” not “\”). |
| 10027177   | The log path specified is not supported. |
| 10027178   | The specified task-name is invalid. Valid characters are 0-9, A-Z, a-z, "_", ".", and "-"
| 10027253   | The number of paths specified exceeds the configured maximum number of paths. You cannot specify more than the maximum number of configured paths. |
| 10027254   | The number of extensions specified exceeds the configured maximum number of extensions. You cannot specify more than the maximum number of configured extensions. |
| 10027255   | Another policy is already scheduled. Only one policy per SVM is allowed to be scheduled at any one time. Create a policy without specifying a schedule. |
*/
type VscanOnDemandCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this vscan on demand create default response has a 2xx status code
func (o *VscanOnDemandCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this vscan on demand create default response has a 3xx status code
func (o *VscanOnDemandCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this vscan on demand create default response has a 4xx status code
func (o *VscanOnDemandCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this vscan on demand create default response has a 5xx status code
func (o *VscanOnDemandCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this vscan on demand create default response a status code equal to that given
func (o *VscanOnDemandCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the vscan on demand create default response
func (o *VscanOnDemandCreateDefault) Code() int {
	return o._statusCode
}

func (o *VscanOnDemandCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/vscan/{svm.uuid}/on-demand-policies][%d] vscan_on_demand_create default %s", o._statusCode, payload)
}

func (o *VscanOnDemandCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/vscan/{svm.uuid}/on-demand-policies][%d] vscan_on_demand_create default %s", o._statusCode, payload)
}

func (o *VscanOnDemandCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *VscanOnDemandCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
