// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// VscanOnDemandDeleteCollectionReader is a Reader for the VscanOnDemandDeleteCollection structure.
type VscanOnDemandDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VscanOnDemandDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewVscanOnDemandDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewVscanOnDemandDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewVscanOnDemandDeleteCollectionOK creates a VscanOnDemandDeleteCollectionOK with default headers values
func NewVscanOnDemandDeleteCollectionOK() *VscanOnDemandDeleteCollectionOK {
	return &VscanOnDemandDeleteCollectionOK{}
}

/*
VscanOnDemandDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type VscanOnDemandDeleteCollectionOK struct {
}

// IsSuccess returns true when this vscan on demand delete collection o k response has a 2xx status code
func (o *VscanOnDemandDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this vscan on demand delete collection o k response has a 3xx status code
func (o *VscanOnDemandDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this vscan on demand delete collection o k response has a 4xx status code
func (o *VscanOnDemandDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this vscan on demand delete collection o k response has a 5xx status code
func (o *VscanOnDemandDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this vscan on demand delete collection o k response a status code equal to that given
func (o *VscanOnDemandDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the vscan on demand delete collection o k response
func (o *VscanOnDemandDeleteCollectionOK) Code() int {
	return 200
}

func (o *VscanOnDemandDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/vscan/{svm.uuid}/on-demand-policies][%d] vscanOnDemandDeleteCollectionOK", 200)
}

func (o *VscanOnDemandDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/vscan/{svm.uuid}/on-demand-policies][%d] vscanOnDemandDeleteCollectionOK", 200)
}

func (o *VscanOnDemandDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewVscanOnDemandDeleteCollectionDefault creates a VscanOnDemandDeleteCollectionDefault with default headers values
func NewVscanOnDemandDeleteCollectionDefault(code int) *VscanOnDemandDeleteCollectionDefault {
	return &VscanOnDemandDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
VscanOnDemandDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type VscanOnDemandDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this vscan on demand delete collection default response has a 2xx status code
func (o *VscanOnDemandDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this vscan on demand delete collection default response has a 3xx status code
func (o *VscanOnDemandDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this vscan on demand delete collection default response has a 4xx status code
func (o *VscanOnDemandDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this vscan on demand delete collection default response has a 5xx status code
func (o *VscanOnDemandDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this vscan on demand delete collection default response a status code equal to that given
func (o *VscanOnDemandDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the vscan on demand delete collection default response
func (o *VscanOnDemandDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *VscanOnDemandDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/vscan/{svm.uuid}/on-demand-policies][%d] vscan_on_demand_delete_collection default %s", o._statusCode, payload)
}

func (o *VscanOnDemandDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/vscan/{svm.uuid}/on-demand-policies][%d] vscan_on_demand_delete_collection default %s", o._statusCode, payload)
}

func (o *VscanOnDemandDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *VscanOnDemandDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
VscanOnDemandDeleteCollectionBody vscan on demand delete collection body
swagger:model VscanOnDemandDeleteCollectionBody
*/
type VscanOnDemandDeleteCollectionBody struct {

	// vscan on demand response inline records
	VscanOnDemandResponseInlineRecords []*models.VscanOnDemand `json:"records,omitempty"`
}

// Validate validates this vscan on demand delete collection body
func (o *VscanOnDemandDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateVscanOnDemandResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VscanOnDemandDeleteCollectionBody) validateVscanOnDemandResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.VscanOnDemandResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.VscanOnDemandResponseInlineRecords); i++ {
		if swag.IsZero(o.VscanOnDemandResponseInlineRecords[i]) { // not required
			continue
		}

		if o.VscanOnDemandResponseInlineRecords[i] != nil {
			if err := o.VscanOnDemandResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this vscan on demand delete collection body based on the context it is used
func (o *VscanOnDemandDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateVscanOnDemandResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VscanOnDemandDeleteCollectionBody) contextValidateVscanOnDemandResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VscanOnDemandResponseInlineRecords); i++ {

		if o.VscanOnDemandResponseInlineRecords[i] != nil {
			if err := o.VscanOnDemandResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *VscanOnDemandDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VscanOnDemandDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res VscanOnDemandDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
