// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// VscanOnDemandModifyCollectionReader is a Reader for the VscanOnDemandModifyCollection structure.
type VscanOnDemandModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VscanOnDemandModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewVscanOnDemandModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewVscanOnDemandModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewVscanOnDemandModifyCollectionOK creates a VscanOnDemandModifyCollectionOK with default headers values
func NewVscanOnDemandModifyCollectionOK() *VscanOnDemandModifyCollectionOK {
	return &VscanOnDemandModifyCollectionOK{}
}

/*
VscanOnDemandModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type VscanOnDemandModifyCollectionOK struct {
}

// IsSuccess returns true when this vscan on demand modify collection o k response has a 2xx status code
func (o *VscanOnDemandModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this vscan on demand modify collection o k response has a 3xx status code
func (o *VscanOnDemandModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this vscan on demand modify collection o k response has a 4xx status code
func (o *VscanOnDemandModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this vscan on demand modify collection o k response has a 5xx status code
func (o *VscanOnDemandModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this vscan on demand modify collection o k response a status code equal to that given
func (o *VscanOnDemandModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the vscan on demand modify collection o k response
func (o *VscanOnDemandModifyCollectionOK) Code() int {
	return 200
}

func (o *VscanOnDemandModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/vscan/{svm.uuid}/on-demand-policies][%d] vscanOnDemandModifyCollectionOK", 200)
}

func (o *VscanOnDemandModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/vscan/{svm.uuid}/on-demand-policies][%d] vscanOnDemandModifyCollectionOK", 200)
}

func (o *VscanOnDemandModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewVscanOnDemandModifyCollectionDefault creates a VscanOnDemandModifyCollectionDefault with default headers values
func NewVscanOnDemandModifyCollectionDefault(code int) *VscanOnDemandModifyCollectionDefault {
	return &VscanOnDemandModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	VscanOnDemandModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 10027101   | The file size must be in the range 1KB to 1TB |
| 10027107   | The include extensions list cannot be empty. Specify at least one extension for inclusion. |
| 10027164   | An On-Demand policy cannot be scheduled, as the Vscan is disabled. Enable the Vscan and retry the operation. |
| 10027167   | The specified schedule does not exist. Create the schedule or create a policy without specifying the schedule. |
| 10027168   | The specified scan path does not exist. The scan path must be specified from the root of the SVM, and must begin with UNIX path delimiters (use “/” not “\\”) |
| 10027169   | The specified scan path is not supported for scanning. |
| 10027174   | The specified exclude path is invalid. The path must be specified from the root of the SVM, and must begin with UNIX path delimiters (use "/" not "\\") |
| 10027175   | An On-Demand policy cannot be scheduled as the SVM is not in an operational state. |
| 10027176   | The log-path specified does not exist. The log path must be specified from the root of the SVM, and must begin with UNIX path delimiters (use “/” not “\\”) |
| 10027177   | The log path specified is not supported. |
| 10027253   | The number of paths specified exceeds the configured maximum number of paths. You cannot specify more than the maximum number of configured paths. |
| 10027254   | The number of extensions specified exceeds the configured maximum number of extensions. You cannot specify more than the maximum number of configured extensions. |
| 10027255   | Another policy is already scheduled. Only one policy per SVM is allowed to be scheduled at any one time. Update a policy without specifying a schedule. |
*/
type VscanOnDemandModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this vscan on demand modify collection default response has a 2xx status code
func (o *VscanOnDemandModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this vscan on demand modify collection default response has a 3xx status code
func (o *VscanOnDemandModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this vscan on demand modify collection default response has a 4xx status code
func (o *VscanOnDemandModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this vscan on demand modify collection default response has a 5xx status code
func (o *VscanOnDemandModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this vscan on demand modify collection default response a status code equal to that given
func (o *VscanOnDemandModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the vscan on demand modify collection default response
func (o *VscanOnDemandModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *VscanOnDemandModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/vscan/{svm.uuid}/on-demand-policies][%d] vscan_on_demand_modify_collection default %s", o._statusCode, payload)
}

func (o *VscanOnDemandModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/vscan/{svm.uuid}/on-demand-policies][%d] vscan_on_demand_modify_collection default %s", o._statusCode, payload)
}

func (o *VscanOnDemandModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *VscanOnDemandModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
VscanOnDemandModifyCollectionBody vscan on demand modify collection body
swagger:model VscanOnDemandModifyCollectionBody
*/
type VscanOnDemandModifyCollectionBody struct {

	// The path from the Vserver root where the task report is created.
	// Example: /vol0/report_dir
	LogPath *string `json:"log_path,omitempty"`

	// On-Demand task name
	// Example: task-1
	// Max Length: 256
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// schedule
	Schedule *models.VscanOnDemandInlineSchedule `json:"schedule,omitempty"`

	// scope
	Scope *models.VscanOnDemandInlineScope `json:"scope,omitempty"`

	// svm
	Svm *models.VscanOnDemandInlineSvm `json:"svm,omitempty"`

	// List of paths that need to be scanned.
	// Example: ["/vol1/","/vol2/cifs/"]
	VscanOnDemandInlineScanPaths []*string `json:"scan_paths,omitempty"`

	// vscan on demand response inline records
	VscanOnDemandResponseInlineRecords []*models.VscanOnDemand `json:"records,omitempty"`
}

// Validate validates this vscan on demand modify collection body
func (o *VscanOnDemandModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSchedule(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVscanOnDemandResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VscanOnDemandModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"name", "body", *o.Name, 256); err != nil {
		return err
	}

	return nil
}

func (o *VscanOnDemandModifyCollectionBody) validateSchedule(formats strfmt.Registry) error {
	if swag.IsZero(o.Schedule) { // not required
		return nil
	}

	if o.Schedule != nil {
		if err := o.Schedule.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "schedule")
			}
			return err
		}
	}

	return nil
}

func (o *VscanOnDemandModifyCollectionBody) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(o.Scope) { // not required
		return nil
	}

	if o.Scope != nil {
		if err := o.Scope.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "scope")
			}
			return err
		}
	}

	return nil
}

func (o *VscanOnDemandModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *VscanOnDemandModifyCollectionBody) validateVscanOnDemandResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.VscanOnDemandResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.VscanOnDemandResponseInlineRecords); i++ {
		if swag.IsZero(o.VscanOnDemandResponseInlineRecords[i]) { // not required
			continue
		}

		if o.VscanOnDemandResponseInlineRecords[i] != nil {
			if err := o.VscanOnDemandResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this vscan on demand modify collection body based on the context it is used
func (o *VscanOnDemandModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSchedule(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVscanOnDemandResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VscanOnDemandModifyCollectionBody) contextValidateSchedule(ctx context.Context, formats strfmt.Registry) error {

	if o.Schedule != nil {
		if err := o.Schedule.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "schedule")
			}
			return err
		}
	}

	return nil
}

func (o *VscanOnDemandModifyCollectionBody) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if o.Scope != nil {
		if err := o.Scope.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "scope")
			}
			return err
		}
	}

	return nil
}

func (o *VscanOnDemandModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *VscanOnDemandModifyCollectionBody) contextValidateVscanOnDemandResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VscanOnDemandResponseInlineRecords); i++ {

		if o.VscanOnDemandResponseInlineRecords[i] != nil {
			if err := o.VscanOnDemandResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *VscanOnDemandModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VscanOnDemandModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res VscanOnDemandModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VscanOnDemandInlineSchedule Schedule of the task.
swagger:model vscan_on_demand_inline_schedule
*/
type VscanOnDemandInlineSchedule struct {

	// links
	Links *models.VscanOnDemandInlineScheduleInlineLinks `json:"_links,omitempty"`

	// Job schedule name
	// Example: weekly
	Name *string `json:"name,omitempty"`

	// Job schedule UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this vscan on demand inline schedule
func (o *VscanOnDemandInlineSchedule) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VscanOnDemandInlineSchedule) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "schedule" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this vscan on demand inline schedule based on the context it is used
func (o *VscanOnDemandInlineSchedule) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VscanOnDemandInlineSchedule) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "schedule" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VscanOnDemandInlineSchedule) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VscanOnDemandInlineSchedule) UnmarshalBinary(b []byte) error {
	var res VscanOnDemandInlineSchedule
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VscanOnDemandInlineScheduleInlineLinks vscan on demand inline schedule inline links
swagger:model vscan_on_demand_inline_schedule_inline__links
*/
type VscanOnDemandInlineScheduleInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this vscan on demand inline schedule inline links
func (o *VscanOnDemandInlineScheduleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VscanOnDemandInlineScheduleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "schedule" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this vscan on demand inline schedule inline links based on the context it is used
func (o *VscanOnDemandInlineScheduleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VscanOnDemandInlineScheduleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "schedule" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VscanOnDemandInlineScheduleInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VscanOnDemandInlineScheduleInlineLinks) UnmarshalBinary(b []byte) error {
	var res VscanOnDemandInlineScheduleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VscanOnDemandInlineScope vscan on demand inline scope
swagger:model vscan_on_demand_inline_scope
*/
type VscanOnDemandInlineScope struct {

	// List of file extensions for which scanning is not performed.
	// Example: ["mp3","mp4"]
	// Max Items: 300
	// Min Items: 1
	ExcludeExtensions []*string `json:"exclude_extensions,omitempty"`

	// List of file paths for which scanning must not be performed.
	// Example: ["/vol1/cold-files/","/vol1/cifs/names"]
	// Max Items: 100
	// Min Items: 1
	ExcludePaths []*string `json:"exclude_paths,omitempty"`

	// List of file extensions to be scanned.
	// Example: ["vmdk","mp*"]
	// Max Items: 300
	// Min Items: 1
	IncludeExtensions []*string `json:"include_extensions,omitempty"`

	// Maximum file size, in bytes, allowed for scanning.
	// Example: 10737418240
	// Maximum: 1.099511627776e+12
	// Minimum: 1024
	MaxFileSize *int64 `json:"max_file_size,omitempty"`

	// Specifies whether or not files without any extension can be scanned.
	ScanWithoutExtension *bool `json:"scan_without_extension,omitempty"`
}

// Validate validates this vscan on demand inline scope
func (o *VscanOnDemandInlineScope) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateExcludeExtensions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExcludePaths(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIncludeExtensions(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxFileSize(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VscanOnDemandInlineScope) validateExcludeExtensions(formats strfmt.Registry) error {
	if swag.IsZero(o.ExcludeExtensions) { // not required
		return nil
	}

	iExcludeExtensionsSize := int64(len(o.ExcludeExtensions))

	if err := validate.MinItems("info"+"."+"scope"+"."+"exclude_extensions", "body", iExcludeExtensionsSize, 1); err != nil {
		return err
	}

	if err := validate.MaxItems("info"+"."+"scope"+"."+"exclude_extensions", "body", iExcludeExtensionsSize, 300); err != nil {
		return err
	}

	return nil
}

func (o *VscanOnDemandInlineScope) validateExcludePaths(formats strfmt.Registry) error {
	if swag.IsZero(o.ExcludePaths) { // not required
		return nil
	}

	iExcludePathsSize := int64(len(o.ExcludePaths))

	if err := validate.MinItems("info"+"."+"scope"+"."+"exclude_paths", "body", iExcludePathsSize, 1); err != nil {
		return err
	}

	if err := validate.MaxItems("info"+"."+"scope"+"."+"exclude_paths", "body", iExcludePathsSize, 100); err != nil {
		return err
	}

	for i := 0; i < len(o.ExcludePaths); i++ {
		if swag.IsZero(o.ExcludePaths[i]) { // not required
			continue
		}

		if err := validate.MinLength("info"+"."+"scope"+"."+"exclude_paths"+"."+strconv.Itoa(i), "body", *o.ExcludePaths[i], 1); err != nil {
			return err
		}

		if err := validate.MaxLength("info"+"."+"scope"+"."+"exclude_paths"+"."+strconv.Itoa(i), "body", *o.ExcludePaths[i], 255); err != nil {
			return err
		}

	}

	return nil
}

func (o *VscanOnDemandInlineScope) validateIncludeExtensions(formats strfmt.Registry) error {
	if swag.IsZero(o.IncludeExtensions) { // not required
		return nil
	}

	iIncludeExtensionsSize := int64(len(o.IncludeExtensions))

	if err := validate.MinItems("info"+"."+"scope"+"."+"include_extensions", "body", iIncludeExtensionsSize, 1); err != nil {
		return err
	}

	if err := validate.MaxItems("info"+"."+"scope"+"."+"include_extensions", "body", iIncludeExtensionsSize, 300); err != nil {
		return err
	}

	return nil
}

func (o *VscanOnDemandInlineScope) validateMaxFileSize(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxFileSize) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"scope"+"."+"max_file_size", "body", *o.MaxFileSize, 1024, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"scope"+"."+"max_file_size", "body", *o.MaxFileSize, 1.099511627776e+12, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this vscan on demand inline scope based on context it is used
func (o *VscanOnDemandInlineScope) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *VscanOnDemandInlineScope) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VscanOnDemandInlineScope) UnmarshalBinary(b []byte) error {
	var res VscanOnDemandInlineScope
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VscanOnDemandInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model vscan_on_demand_inline_svm
*/
type VscanOnDemandInlineSvm struct {

	// links
	Links *models.VscanOnDemandInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this vscan on demand inline svm
func (o *VscanOnDemandInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VscanOnDemandInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this vscan on demand inline svm based on the context it is used
func (o *VscanOnDemandInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VscanOnDemandInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VscanOnDemandInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VscanOnDemandInlineSvm) UnmarshalBinary(b []byte) error {
	var res VscanOnDemandInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VscanOnDemandInlineSvmInlineLinks vscan on demand inline svm inline links
swagger:model vscan_on_demand_inline_svm_inline__links
*/
type VscanOnDemandInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this vscan on demand inline svm inline links
func (o *VscanOnDemandInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VscanOnDemandInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this vscan on demand inline svm inline links based on the context it is used
func (o *VscanOnDemandInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VscanOnDemandInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VscanOnDemandInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VscanOnDemandInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res VscanOnDemandInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
