// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewVscanScannerCollectionGetParams creates a new VscanScannerCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewVscanScannerCollectionGetParams() *VscanScannerCollectionGetParams {
	return &VscanScannerCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewVscanScannerCollectionGetParamsWithTimeout creates a new VscanScannerCollectionGetParams object
// with the ability to set a timeout on a request.
func NewVscanScannerCollectionGetParamsWithTimeout(timeout time.Duration) *VscanScannerCollectionGetParams {
	return &VscanScannerCollectionGetParams{
		timeout: timeout,
	}
}

// NewVscanScannerCollectionGetParamsWithContext creates a new VscanScannerCollectionGetParams object
// with the ability to set a context for a request.
func NewVscanScannerCollectionGetParamsWithContext(ctx context.Context) *VscanScannerCollectionGetParams {
	return &VscanScannerCollectionGetParams{
		Context: ctx,
	}
}

// NewVscanScannerCollectionGetParamsWithHTTPClient creates a new VscanScannerCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewVscanScannerCollectionGetParamsWithHTTPClient(client *http.Client) *VscanScannerCollectionGetParams {
	return &VscanScannerCollectionGetParams{
		HTTPClient: client,
	}
}

/*
VscanScannerCollectionGetParams contains all the parameters to send to the API endpoint

	for the vscan scanner collection get operation.

	Typically these are written to a http.Request.
*/
type VscanScannerCollectionGetParams struct {

	/* ClusterName.

	   Filter by cluster.name
	*/
	ClusterName *string

	/* ClusterUUID.

	   Filter by cluster.uuid
	*/
	ClusterUUID *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* PrivilegedUsers.

	   Filter by privileged_users
	*/
	PrivilegedUsers *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Role.

	   Filter by role
	*/
	Role *string

	/* Servers.

	   Filter by servers
	*/
	Servers *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the vscan scanner collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VscanScannerCollectionGetParams) WithDefaults() *VscanScannerCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the vscan scanner collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VscanScannerCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := VscanScannerCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) WithTimeout(timeout time.Duration) *VscanScannerCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) WithContext(ctx context.Context) *VscanScannerCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) WithHTTPClient(client *http.Client) *VscanScannerCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterName adds the clusterName to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) WithClusterName(clusterName *string) *VscanScannerCollectionGetParams {
	o.SetClusterName(clusterName)
	return o
}

// SetClusterName adds the clusterName to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) SetClusterName(clusterName *string) {
	o.ClusterName = clusterName
}

// WithClusterUUID adds the clusterUUID to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) WithClusterUUID(clusterUUID *string) *VscanScannerCollectionGetParams {
	o.SetClusterUUID(clusterUUID)
	return o
}

// SetClusterUUID adds the clusterUuid to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) SetClusterUUID(clusterUUID *string) {
	o.ClusterUUID = clusterUUID
}

// WithFields adds the fields to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) WithFields(fields []string) *VscanScannerCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) WithMaxRecords(maxRecords *int64) *VscanScannerCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) WithName(name *string) *VscanScannerCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) WithOrderBy(orderBy []string) *VscanScannerCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPrivilegedUsers adds the privilegedUsers to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) WithPrivilegedUsers(privilegedUsers *string) *VscanScannerCollectionGetParams {
	o.SetPrivilegedUsers(privilegedUsers)
	return o
}

// SetPrivilegedUsers adds the privilegedUsers to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) SetPrivilegedUsers(privilegedUsers *string) {
	o.PrivilegedUsers = privilegedUsers
}

// WithReturnRecords adds the returnRecords to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) WithReturnRecords(returnRecords *bool) *VscanScannerCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *VscanScannerCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithRole adds the role to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) WithRole(role *string) *VscanScannerCollectionGetParams {
	o.SetRole(role)
	return o
}

// SetRole adds the role to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) SetRole(role *string) {
	o.Role = role
}

// WithServers adds the servers to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) WithServers(servers *string) *VscanScannerCollectionGetParams {
	o.SetServers(servers)
	return o
}

// SetServers adds the servers to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) SetServers(servers *string) {
	o.Servers = servers
}

// WithSvmName adds the svmName to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) WithSvmName(svmName *string) *VscanScannerCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) WithSvmUUID(svmUUID string) *VscanScannerCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the vscan scanner collection get params
func (o *VscanScannerCollectionGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *VscanScannerCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ClusterName != nil {

		// query param cluster.name
		var qrClusterName string

		if o.ClusterName != nil {
			qrClusterName = *o.ClusterName
		}
		qClusterName := qrClusterName
		if qClusterName != "" {

			if err := r.SetQueryParam("cluster.name", qClusterName); err != nil {
				return err
			}
		}
	}

	if o.ClusterUUID != nil {

		// query param cluster.uuid
		var qrClusterUUID string

		if o.ClusterUUID != nil {
			qrClusterUUID = *o.ClusterUUID
		}
		qClusterUUID := qrClusterUUID
		if qClusterUUID != "" {

			if err := r.SetQueryParam("cluster.uuid", qClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PrivilegedUsers != nil {

		// query param privileged_users
		var qrPrivilegedUsers string

		if o.PrivilegedUsers != nil {
			qrPrivilegedUsers = *o.PrivilegedUsers
		}
		qPrivilegedUsers := qrPrivilegedUsers
		if qPrivilegedUsers != "" {

			if err := r.SetQueryParam("privileged_users", qPrivilegedUsers); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Role != nil {

		// query param role
		var qrRole string

		if o.Role != nil {
			qrRole = *o.Role
		}
		qRole := qrRole
		if qRole != "" {

			if err := r.SetQueryParam("role", qRole); err != nil {
				return err
			}
		}
	}

	if o.Servers != nil {

		// query param servers
		var qrServers string

		if o.Servers != nil {
			qrServers = *o.Servers
		}
		qServers := qrServers
		if qServers != "" {

			if err := r.SetQueryParam("servers", qServers); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamVscanScannerCollectionGet binds the parameter fields
func (o *VscanScannerCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamVscanScannerCollectionGet binds the parameter order_by
func (o *VscanScannerCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
