// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewVscanScannerCreateParams creates a new VscanScannerCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewVscanScannerCreateParams() *VscanScannerCreateParams {
	return &VscanScannerCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewVscanScannerCreateParamsWithTimeout creates a new VscanScannerCreateParams object
// with the ability to set a timeout on a request.
func NewVscanScannerCreateParamsWithTimeout(timeout time.Duration) *VscanScannerCreateParams {
	return &VscanScannerCreateParams{
		timeout: timeout,
	}
}

// NewVscanScannerCreateParamsWithContext creates a new VscanScannerCreateParams object
// with the ability to set a context for a request.
func NewVscanScannerCreateParamsWithContext(ctx context.Context) *VscanScannerCreateParams {
	return &VscanScannerCreateParams{
		Context: ctx,
	}
}

// NewVscanScannerCreateParamsWithHTTPClient creates a new VscanScannerCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewVscanScannerCreateParamsWithHTTPClient(client *http.Client) *VscanScannerCreateParams {
	return &VscanScannerCreateParams{
		HTTPClient: client,
	}
}

/*
VscanScannerCreateParams contains all the parameters to send to the API endpoint

	for the vscan scanner create operation.

	Typically these are written to a http.Request.
*/
type VscanScannerCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.VscanScannerPool

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the vscan scanner create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VscanScannerCreateParams) WithDefaults() *VscanScannerCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the vscan scanner create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VscanScannerCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := VscanScannerCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the vscan scanner create params
func (o *VscanScannerCreateParams) WithTimeout(timeout time.Duration) *VscanScannerCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the vscan scanner create params
func (o *VscanScannerCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the vscan scanner create params
func (o *VscanScannerCreateParams) WithContext(ctx context.Context) *VscanScannerCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the vscan scanner create params
func (o *VscanScannerCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the vscan scanner create params
func (o *VscanScannerCreateParams) WithHTTPClient(client *http.Client) *VscanScannerCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the vscan scanner create params
func (o *VscanScannerCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the vscan scanner create params
func (o *VscanScannerCreateParams) WithInfo(info *models.VscanScannerPool) *VscanScannerCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the vscan scanner create params
func (o *VscanScannerCreateParams) SetInfo(info *models.VscanScannerPool) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the vscan scanner create params
func (o *VscanScannerCreateParams) WithReturnRecords(returnRecords *bool) *VscanScannerCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the vscan scanner create params
func (o *VscanScannerCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithSvmUUID adds the svmUUID to the vscan scanner create params
func (o *VscanScannerCreateParams) WithSvmUUID(svmUUID string) *VscanScannerCreateParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the vscan scanner create params
func (o *VscanScannerCreateParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *VscanScannerCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
