// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// VscanScannerCreateReader is a Reader for the VscanScannerCreate structure.
type VscanScannerCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VscanScannerCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewVscanScannerCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewVscanScannerCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewVscanScannerCreateCreated creates a VscanScannerCreateCreated with default headers values
func NewVscanScannerCreateCreated() *VscanScannerCreateCreated {
	return &VscanScannerCreateCreated{}
}

/*
VscanScannerCreateCreated describes a response with status code 201, with default header values.

Created
*/
type VscanScannerCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.VscanScannerPoolResponse
}

// IsSuccess returns true when this vscan scanner create created response has a 2xx status code
func (o *VscanScannerCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this vscan scanner create created response has a 3xx status code
func (o *VscanScannerCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this vscan scanner create created response has a 4xx status code
func (o *VscanScannerCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this vscan scanner create created response has a 5xx status code
func (o *VscanScannerCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this vscan scanner create created response a status code equal to that given
func (o *VscanScannerCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the vscan scanner create created response
func (o *VscanScannerCreateCreated) Code() int {
	return 201
}

func (o *VscanScannerCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/vscan/{svm.uuid}/scanner-pools][%d] vscanScannerCreateCreated %s", 201, payload)
}

func (o *VscanScannerCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/vscan/{svm.uuid}/scanner-pools][%d] vscanScannerCreateCreated %s", 201, payload)
}

func (o *VscanScannerCreateCreated) GetPayload() *models.VscanScannerPoolResponse {
	return o.Payload
}

func (o *VscanScannerCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.VscanScannerPoolResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewVscanScannerCreateDefault creates a VscanScannerCreateDefault with default headers values
func NewVscanScannerCreateDefault(code int) *VscanScannerCreateDefault {
	return &VscanScannerCreateDefault{
		_statusCode: code,
	}
}

/*
	VscanScannerCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 10027076   | The new scanner-pool cannot be created because the SVM has reached the maximum limit of 20 scanner-pools. Delete an existing scanner-pool in order to create a new scanner-pool
| 10027086   | The specified list of servers contains one or more entries that cannot be resolved
| 10027258   | The specified cluster_name does not exist
| 10027256   | The specified cluster_uuid does not exist
| 10027257   | The specified cluster_name and cluster_uuid are valid but belong to different clusters
| 10027248   | Scanner-pool created successfully but failed to activate
| 10027107   | The list of privileged users or list of servers specified is empty
| 10027108   | The list of privileged users specified contains an invalid entry
| 10027063   | Attempting to modify a scanner-pool on an SVM owned by the cluster with a data SVM
| 10027086   | DNS resolution failed for one or more hostnames
| 10027119   | The privileged user contains characters that are not allowed
| 10027261   | One of the specified IPv4 addresses in the \\"-hostnames\\" is either a multicast, loopback, broadcast, or '0.0.0.0' address.
| 10027262   | One of the specified IPv6 addresses in the \\"-hostnames\\" is either a link-local, multicast, v4-compatible, v4-mapped, loopback or '::/0' address.
*/
type VscanScannerCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this vscan scanner create default response has a 2xx status code
func (o *VscanScannerCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this vscan scanner create default response has a 3xx status code
func (o *VscanScannerCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this vscan scanner create default response has a 4xx status code
func (o *VscanScannerCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this vscan scanner create default response has a 5xx status code
func (o *VscanScannerCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this vscan scanner create default response a status code equal to that given
func (o *VscanScannerCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the vscan scanner create default response
func (o *VscanScannerCreateDefault) Code() int {
	return o._statusCode
}

func (o *VscanScannerCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/vscan/{svm.uuid}/scanner-pools][%d] vscan_scanner_create default %s", o._statusCode, payload)
}

func (o *VscanScannerCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/vscan/{svm.uuid}/scanner-pools][%d] vscan_scanner_create default %s", o._statusCode, payload)
}

func (o *VscanScannerCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *VscanScannerCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
