// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// VscanScannerDeleteCollectionReader is a Reader for the VscanScannerDeleteCollection structure.
type VscanScannerDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VscanScannerDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewVscanScannerDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewVscanScannerDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewVscanScannerDeleteCollectionOK creates a VscanScannerDeleteCollectionOK with default headers values
func NewVscanScannerDeleteCollectionOK() *VscanScannerDeleteCollectionOK {
	return &VscanScannerDeleteCollectionOK{}
}

/*
VscanScannerDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type VscanScannerDeleteCollectionOK struct {
}

// IsSuccess returns true when this vscan scanner delete collection o k response has a 2xx status code
func (o *VscanScannerDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this vscan scanner delete collection o k response has a 3xx status code
func (o *VscanScannerDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this vscan scanner delete collection o k response has a 4xx status code
func (o *VscanScannerDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this vscan scanner delete collection o k response has a 5xx status code
func (o *VscanScannerDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this vscan scanner delete collection o k response a status code equal to that given
func (o *VscanScannerDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the vscan scanner delete collection o k response
func (o *VscanScannerDeleteCollectionOK) Code() int {
	return 200
}

func (o *VscanScannerDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/vscan/{svm.uuid}/scanner-pools][%d] vscanScannerDeleteCollectionOK", 200)
}

func (o *VscanScannerDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/vscan/{svm.uuid}/scanner-pools][%d] vscanScannerDeleteCollectionOK", 200)
}

func (o *VscanScannerDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewVscanScannerDeleteCollectionDefault creates a VscanScannerDeleteCollectionDefault with default headers values
func NewVscanScannerDeleteCollectionDefault(code int) *VscanScannerDeleteCollectionDefault {
	return &VscanScannerDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	VscanScannerDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 10027070   | Attempting to delete a scanner-pool but it is the only active scanner-pool for a Vscan enabled on the SVM
| 10027064   | Attempting to delete a scanner-pool with a data SVM which was created by the SVM owned by the cluster
*/
type VscanScannerDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this vscan scanner delete collection default response has a 2xx status code
func (o *VscanScannerDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this vscan scanner delete collection default response has a 3xx status code
func (o *VscanScannerDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this vscan scanner delete collection default response has a 4xx status code
func (o *VscanScannerDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this vscan scanner delete collection default response has a 5xx status code
func (o *VscanScannerDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this vscan scanner delete collection default response a status code equal to that given
func (o *VscanScannerDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the vscan scanner delete collection default response
func (o *VscanScannerDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *VscanScannerDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/vscan/{svm.uuid}/scanner-pools][%d] vscan_scanner_delete_collection default %s", o._statusCode, payload)
}

func (o *VscanScannerDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/vscan/{svm.uuid}/scanner-pools][%d] vscan_scanner_delete_collection default %s", o._statusCode, payload)
}

func (o *VscanScannerDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *VscanScannerDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
VscanScannerDeleteCollectionBody vscan scanner delete collection body
swagger:model VscanScannerDeleteCollectionBody
*/
type VscanScannerDeleteCollectionBody struct {

	// vscan scanner pool response inline records
	VscanScannerPoolResponseInlineRecords []*models.VscanScannerPool `json:"records,omitempty"`
}

// Validate validates this vscan scanner delete collection body
func (o *VscanScannerDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateVscanScannerPoolResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VscanScannerDeleteCollectionBody) validateVscanScannerPoolResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.VscanScannerPoolResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.VscanScannerPoolResponseInlineRecords); i++ {
		if swag.IsZero(o.VscanScannerPoolResponseInlineRecords[i]) { // not required
			continue
		}

		if o.VscanScannerPoolResponseInlineRecords[i] != nil {
			if err := o.VscanScannerPoolResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this vscan scanner delete collection body based on the context it is used
func (o *VscanScannerDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateVscanScannerPoolResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VscanScannerDeleteCollectionBody) contextValidateVscanScannerPoolResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VscanScannerPoolResponseInlineRecords); i++ {

		if o.VscanScannerPoolResponseInlineRecords[i] != nil {
			if err := o.VscanScannerPoolResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *VscanScannerDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VscanScannerDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res VscanScannerDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
