// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewVscanScannerModifyCollectionParams creates a new VscanScannerModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewVscanScannerModifyCollectionParams() *VscanScannerModifyCollectionParams {
	return &VscanScannerModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewVscanScannerModifyCollectionParamsWithTimeout creates a new VscanScannerModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewVscanScannerModifyCollectionParamsWithTimeout(timeout time.Duration) *VscanScannerModifyCollectionParams {
	return &VscanScannerModifyCollectionParams{
		timeout: timeout,
	}
}

// NewVscanScannerModifyCollectionParamsWithContext creates a new VscanScannerModifyCollectionParams object
// with the ability to set a context for a request.
func NewVscanScannerModifyCollectionParamsWithContext(ctx context.Context) *VscanScannerModifyCollectionParams {
	return &VscanScannerModifyCollectionParams{
		Context: ctx,
	}
}

// NewVscanScannerModifyCollectionParamsWithHTTPClient creates a new VscanScannerModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewVscanScannerModifyCollectionParamsWithHTTPClient(client *http.Client) *VscanScannerModifyCollectionParams {
	return &VscanScannerModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
VscanScannerModifyCollectionParams contains all the parameters to send to the API endpoint

	for the vscan scanner modify collection operation.

	Typically these are written to a http.Request.
*/
type VscanScannerModifyCollectionParams struct {

	/* ClusterName.

	   Filter by cluster.name
	*/
	ClusterName *string

	/* ClusterUUID.

	   Filter by cluster.uuid
	*/
	ClusterUUID *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info VscanScannerModifyCollectionBody

	/* Name.

	   Filter by name
	*/
	Name *string

	/* PrivilegedUsers.

	   Filter by privileged_users
	*/
	PrivilegedUsers *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Role.

	   Filter by role
	*/
	Role *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Servers.

	   Filter by servers
	*/
	Servers *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the vscan scanner modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VscanScannerModifyCollectionParams) WithDefaults() *VscanScannerModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the vscan scanner modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *VscanScannerModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := VscanScannerModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) WithTimeout(timeout time.Duration) *VscanScannerModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) WithContext(ctx context.Context) *VscanScannerModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) WithHTTPClient(client *http.Client) *VscanScannerModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterName adds the clusterName to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) WithClusterName(clusterName *string) *VscanScannerModifyCollectionParams {
	o.SetClusterName(clusterName)
	return o
}

// SetClusterName adds the clusterName to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) SetClusterName(clusterName *string) {
	o.ClusterName = clusterName
}

// WithClusterUUID adds the clusterUUID to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) WithClusterUUID(clusterUUID *string) *VscanScannerModifyCollectionParams {
	o.SetClusterUUID(clusterUUID)
	return o
}

// SetClusterUUID adds the clusterUuid to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) SetClusterUUID(clusterUUID *string) {
	o.ClusterUUID = clusterUUID
}

// WithContinueOnFailure adds the continueOnFailure to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *VscanScannerModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) WithInfo(info VscanScannerModifyCollectionBody) *VscanScannerModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) SetInfo(info VscanScannerModifyCollectionBody) {
	o.Info = info
}

// WithName adds the name to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) WithName(name *string) *VscanScannerModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithPrivilegedUsers adds the privilegedUsers to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) WithPrivilegedUsers(privilegedUsers *string) *VscanScannerModifyCollectionParams {
	o.SetPrivilegedUsers(privilegedUsers)
	return o
}

// SetPrivilegedUsers adds the privilegedUsers to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) SetPrivilegedUsers(privilegedUsers *string) {
	o.PrivilegedUsers = privilegedUsers
}

// WithReturnRecords adds the returnRecords to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) WithReturnRecords(returnRecords *bool) *VscanScannerModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *VscanScannerModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithRole adds the role to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) WithRole(role *string) *VscanScannerModifyCollectionParams {
	o.SetRole(role)
	return o
}

// SetRole adds the role to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) SetRole(role *string) {
	o.Role = role
}

// WithSerialRecords adds the serialRecords to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) WithSerialRecords(serialRecords *bool) *VscanScannerModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithServers adds the servers to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) WithServers(servers *string) *VscanScannerModifyCollectionParams {
	o.SetServers(servers)
	return o
}

// SetServers adds the servers to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) SetServers(servers *string) {
	o.Servers = servers
}

// WithSvmName adds the svmName to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) WithSvmName(svmName *string) *VscanScannerModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) WithSvmUUID(svmUUID string) *VscanScannerModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the vscan scanner modify collection params
func (o *VscanScannerModifyCollectionParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *VscanScannerModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ClusterName != nil {

		// query param cluster.name
		var qrClusterName string

		if o.ClusterName != nil {
			qrClusterName = *o.ClusterName
		}
		qClusterName := qrClusterName
		if qClusterName != "" {

			if err := r.SetQueryParam("cluster.name", qClusterName); err != nil {
				return err
			}
		}
	}

	if o.ClusterUUID != nil {

		// query param cluster.uuid
		var qrClusterUUID string

		if o.ClusterUUID != nil {
			qrClusterUUID = *o.ClusterUUID
		}
		qClusterUUID := qrClusterUUID
		if qClusterUUID != "" {

			if err := r.SetQueryParam("cluster.uuid", qClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.PrivilegedUsers != nil {

		// query param privileged_users
		var qrPrivilegedUsers string

		if o.PrivilegedUsers != nil {
			qrPrivilegedUsers = *o.PrivilegedUsers
		}
		qPrivilegedUsers := qrPrivilegedUsers
		if qPrivilegedUsers != "" {

			if err := r.SetQueryParam("privileged_users", qPrivilegedUsers); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Role != nil {

		// query param role
		var qrRole string

		if o.Role != nil {
			qrRole = *o.Role
		}
		qRole := qrRole
		if qRole != "" {

			if err := r.SetQueryParam("role", qRole); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.Servers != nil {

		// query param servers
		var qrServers string

		if o.Servers != nil {
			qrServers = *o.Servers
		}
		qServers := qrServers
		if qServers != "" {

			if err := r.SetQueryParam("servers", qServers); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
