// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// VscanScannerModifyCollectionReader is a Reader for the VscanScannerModifyCollection structure.
type VscanScannerModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VscanScannerModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewVscanScannerModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewVscanScannerModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewVscanScannerModifyCollectionOK creates a VscanScannerModifyCollectionOK with default headers values
func NewVscanScannerModifyCollectionOK() *VscanScannerModifyCollectionOK {
	return &VscanScannerModifyCollectionOK{}
}

/*
VscanScannerModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type VscanScannerModifyCollectionOK struct {
}

// IsSuccess returns true when this vscan scanner modify collection o k response has a 2xx status code
func (o *VscanScannerModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this vscan scanner modify collection o k response has a 3xx status code
func (o *VscanScannerModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this vscan scanner modify collection o k response has a 4xx status code
func (o *VscanScannerModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this vscan scanner modify collection o k response has a 5xx status code
func (o *VscanScannerModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this vscan scanner modify collection o k response a status code equal to that given
func (o *VscanScannerModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the vscan scanner modify collection o k response
func (o *VscanScannerModifyCollectionOK) Code() int {
	return 200
}

func (o *VscanScannerModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/vscan/{svm.uuid}/scanner-pools][%d] vscanScannerModifyCollectionOK", 200)
}

func (o *VscanScannerModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/vscan/{svm.uuid}/scanner-pools][%d] vscanScannerModifyCollectionOK", 200)
}

func (o *VscanScannerModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewVscanScannerModifyCollectionDefault creates a VscanScannerModifyCollectionDefault with default headers values
func NewVscanScannerModifyCollectionDefault(code int) *VscanScannerModifyCollectionDefault {
	return &VscanScannerModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	VscanScannerModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 10027258   | The specified cluster_name does not exist
| 10027256   | The specified cluster_uuid does not exist
| 10027257   | The specified cluster_name and cluster_uuid are valid but belong to different clusters
| 10027248   | Scanner-pool updated successfully but failed to apply the specified role
| 10027107   | The list of privileged users or list of servers specified is empty
| 10027108   | The list of privileged users specified contains an invalid entry
| 10027063   | Attempting to modify a scanner-pool on an SVM owned by the cluster with a data SVM
| 10027119   | The privileged user contains characters that are not allowed
| 10027261   | One of the specified IPv4 addresses in the \\"-hostnames\\" is either a multicast, loopback, broadcast, or '0.0.0.0' address.
| 10027262   | One of the specified IPv6 addresses in the \\"-hostnames\\" is either a link-local, multicast, v4-compatible, v4-mapped, loopback or '::/0' address.
*/
type VscanScannerModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this vscan scanner modify collection default response has a 2xx status code
func (o *VscanScannerModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this vscan scanner modify collection default response has a 3xx status code
func (o *VscanScannerModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this vscan scanner modify collection default response has a 4xx status code
func (o *VscanScannerModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this vscan scanner modify collection default response has a 5xx status code
func (o *VscanScannerModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this vscan scanner modify collection default response a status code equal to that given
func (o *VscanScannerModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the vscan scanner modify collection default response
func (o *VscanScannerModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *VscanScannerModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/vscan/{svm.uuid}/scanner-pools][%d] vscan_scanner_modify_collection default %s", o._statusCode, payload)
}

func (o *VscanScannerModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/vscan/{svm.uuid}/scanner-pools][%d] vscan_scanner_modify_collection default %s", o._statusCode, payload)
}

func (o *VscanScannerModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *VscanScannerModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
VscanScannerModifyCollectionBody vscan scanner modify collection body
swagger:model VscanScannerModifyCollectionBody
*/
type VscanScannerModifyCollectionBody struct {

	// cluster
	Cluster *models.ClusterReference `json:"cluster,omitempty"`

	// Specifies the name of the scanner pool. Scanner pool name can be up to 256 characters long and is a string that can only contain any combination of ASCII-range alphanumeric characters a-z, A-Z, 0-9), "_", "-" and ".".
	// Example: scanner-1
	// Max Length: 256
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// Specifies the role of the scanner pool. The possible values are:
	//   * primary   - Always active.
	//   * secondary - Active only when none of the primary external virus-scanning servers are connected.
	//   * idle      - Always inactive.
	//
	// Enum: ["primary","secondary","idle"]
	Role *string `json:"role,omitempty"`

	// svm
	Svm *models.VscanScannerPoolInlineSvm `json:"svm,omitempty"`

	// Specifies a list of privileged users. A valid form of privileged user-name is "domain-name\user-name". Privileged user-names are stored and treated as case-insensitive strings. Virus scanners must use one of the registered privileged users for connecting to clustered Data ONTAP for exchanging virus-scanning protocol messages and to access file for scanning, remedying and quarantining operations.
	// Example: ["cifs\\u1","cifs\\u2"]
	VscanScannerPoolInlinePrivilegedUsers []*string `json:"privileged_users,omitempty"`

	// Specifies a list of IP addresses or FQDN for each Vscan server host names which are allowed to connect to clustered ONTAP.
	// Example: ["1.1.1.1","10.72.204.27","vmwin204-27.fsct.nb"]
	VscanScannerPoolInlineServers []*string `json:"servers,omitempty"`

	// vscan scanner pool response inline records
	VscanScannerPoolResponseInlineRecords []*models.VscanScannerPool `json:"records,omitempty"`
}

// Validate validates this vscan scanner modify collection body
func (o *VscanScannerModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCluster(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRole(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVscanScannerPoolResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VscanScannerModifyCollectionBody) validateCluster(formats strfmt.Registry) error {
	if swag.IsZero(o.Cluster) { // not required
		return nil
	}

	if o.Cluster != nil {
		if err := o.Cluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cluster")
			}
			return err
		}
	}

	return nil
}

func (o *VscanScannerModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"name", "body", *o.Name, 256); err != nil {
		return err
	}

	return nil
}

var vscanScannerModifyCollectionBodyTypeRolePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["primary","secondary","idle"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		vscanScannerModifyCollectionBodyTypeRolePropEnum = append(vscanScannerModifyCollectionBodyTypeRolePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// VscanScannerModifyCollectionBody
	// VscanScannerModifyCollectionBody
	// role
	// Role
	// primary
	// END DEBUGGING
	// VscanScannerModifyCollectionBodyRolePrimary captures enum value "primary"
	VscanScannerModifyCollectionBodyRolePrimary string = "primary"

	// BEGIN DEBUGGING
	// VscanScannerModifyCollectionBody
	// VscanScannerModifyCollectionBody
	// role
	// Role
	// secondary
	// END DEBUGGING
	// VscanScannerModifyCollectionBodyRoleSecondary captures enum value "secondary"
	VscanScannerModifyCollectionBodyRoleSecondary string = "secondary"

	// BEGIN DEBUGGING
	// VscanScannerModifyCollectionBody
	// VscanScannerModifyCollectionBody
	// role
	// Role
	// idle
	// END DEBUGGING
	// VscanScannerModifyCollectionBodyRoleIdle captures enum value "idle"
	VscanScannerModifyCollectionBodyRoleIdle string = "idle"
)

// prop value enum
func (o *VscanScannerModifyCollectionBody) validateRoleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, vscanScannerModifyCollectionBodyTypeRolePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *VscanScannerModifyCollectionBody) validateRole(formats strfmt.Registry) error {
	if swag.IsZero(o.Role) { // not required
		return nil
	}

	// value enum
	if err := o.validateRoleEnum("info"+"."+"role", "body", *o.Role); err != nil {
		return err
	}

	return nil
}

func (o *VscanScannerModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *VscanScannerModifyCollectionBody) validateVscanScannerPoolResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.VscanScannerPoolResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.VscanScannerPoolResponseInlineRecords); i++ {
		if swag.IsZero(o.VscanScannerPoolResponseInlineRecords[i]) { // not required
			continue
		}

		if o.VscanScannerPoolResponseInlineRecords[i] != nil {
			if err := o.VscanScannerPoolResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this vscan scanner modify collection body based on the context it is used
func (o *VscanScannerModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVscanScannerPoolResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VscanScannerModifyCollectionBody) contextValidateCluster(ctx context.Context, formats strfmt.Registry) error {

	if o.Cluster != nil {
		if err := o.Cluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cluster")
			}
			return err
		}
	}

	return nil
}

func (o *VscanScannerModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *VscanScannerModifyCollectionBody) contextValidateVscanScannerPoolResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.VscanScannerPoolResponseInlineRecords); i++ {

		if o.VscanScannerPoolResponseInlineRecords[i] != nil {
			if err := o.VscanScannerPoolResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *VscanScannerModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VscanScannerModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res VscanScannerModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VscanScannerPoolInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model vscan_scanner_pool_inline_svm
*/
type VscanScannerPoolInlineSvm struct {

	// links
	Links *models.VscanScannerPoolInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this vscan scanner pool inline svm
func (o *VscanScannerPoolInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VscanScannerPoolInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this vscan scanner pool inline svm based on the context it is used
func (o *VscanScannerPoolInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VscanScannerPoolInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VscanScannerPoolInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VscanScannerPoolInlineSvm) UnmarshalBinary(b []byte) error {
	var res VscanScannerPoolInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
VscanScannerPoolInlineSvmInlineLinks vscan scanner pool inline svm inline links
swagger:model vscan_scanner_pool_inline_svm_inline__links
*/
type VscanScannerPoolInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this vscan scanner pool inline svm inline links
func (o *VscanScannerPoolInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VscanScannerPoolInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this vscan scanner pool inline svm inline links based on the context it is used
func (o *VscanScannerPoolInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *VscanScannerPoolInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *VscanScannerPoolInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *VscanScannerPoolInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res VscanScannerPoolInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
