// Code generated by go-swagger; DO NOT EDIT.

package n_a_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// VscanScannerModifyReader is a Reader for the VscanScannerModify structure.
type VscanScannerModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *VscanScannerModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewVscanScannerModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewVscanScannerModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewVscanScannerModifyOK creates a VscanScannerModifyOK with default headers values
func NewVscanScannerModifyOK() *VscanScannerModifyOK {
	return &VscanScannerModifyOK{}
}

/*
VscanScannerModifyOK describes a response with status code 200, with default header values.

OK
*/
type VscanScannerModifyOK struct {
}

// IsSuccess returns true when this vscan scanner modify o k response has a 2xx status code
func (o *VscanScannerModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this vscan scanner modify o k response has a 3xx status code
func (o *VscanScannerModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this vscan scanner modify o k response has a 4xx status code
func (o *VscanScannerModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this vscan scanner modify o k response has a 5xx status code
func (o *VscanScannerModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this vscan scanner modify o k response a status code equal to that given
func (o *VscanScannerModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the vscan scanner modify o k response
func (o *VscanScannerModifyOK) Code() int {
	return 200
}

func (o *VscanScannerModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/vscan/{svm.uuid}/scanner-pools/{name}][%d] vscanScannerModifyOK", 200)
}

func (o *VscanScannerModifyOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/vscan/{svm.uuid}/scanner-pools/{name}][%d] vscanScannerModifyOK", 200)
}

func (o *VscanScannerModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewVscanScannerModifyDefault creates a VscanScannerModifyDefault with default headers values
func NewVscanScannerModifyDefault(code int) *VscanScannerModifyDefault {
	return &VscanScannerModifyDefault{
		_statusCode: code,
	}
}

/*
	VscanScannerModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 10027258   | The specified cluster_name does not exist
| 10027256   | The specified cluster_uuid does not exist
| 10027257   | The specified cluster_name and cluster_uuid are valid but belong to different clusters
| 10027248   | Scanner-pool updated successfully but failed to apply the specified role
| 10027107   | The list of privileged users or list of servers specified is empty
| 10027108   | The list of privileged users specified contains an invalid entry
| 10027063   | Attempting to modify a scanner-pool on an SVM owned by the cluster with a data SVM
| 10027119   | The privileged user contains characters that are not allowed
| 10027261   | One of the specified IPv4 addresses in the \\"-hostnames\\" is either a multicast, loopback, broadcast, or '0.0.0.0' address.
| 10027262   | One of the specified IPv6 addresses in the \\"-hostnames\\" is either a link-local, multicast, v4-compatible, v4-mapped, loopback or '::/0' address.
*/
type VscanScannerModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this vscan scanner modify default response has a 2xx status code
func (o *VscanScannerModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this vscan scanner modify default response has a 3xx status code
func (o *VscanScannerModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this vscan scanner modify default response has a 4xx status code
func (o *VscanScannerModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this vscan scanner modify default response has a 5xx status code
func (o *VscanScannerModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this vscan scanner modify default response a status code equal to that given
func (o *VscanScannerModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the vscan scanner modify default response
func (o *VscanScannerModifyDefault) Code() int {
	return o._statusCode
}

func (o *VscanScannerModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/vscan/{svm.uuid}/scanner-pools/{name}][%d] vscan_scanner_modify default %s", o._statusCode, payload)
}

func (o *VscanScannerModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/vscan/{svm.uuid}/scanner-pools/{name}][%d] vscan_scanner_modify default %s", o._statusCode, payload)
}

func (o *VscanScannerModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *VscanScannerModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
