// Code generated by go-swagger; DO NOT EDIT.

package n_v_me

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new n v me API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for n v me API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	NvmeInterfaceCollectionGet(params *NvmeInterfaceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeInterfaceCollectionGetOK, error)

	NvmeInterfaceGet(params *NvmeInterfaceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeInterfaceGetOK, error)

	NvmeNamespaceCollectionGet(params *NvmeNamespaceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeNamespaceCollectionGetOK, error)

	NvmeNamespaceCreate(params *NvmeNamespaceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeNamespaceCreateCreated, *NvmeNamespaceCreateAccepted, error)

	NvmeNamespaceDelete(params *NvmeNamespaceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeNamespaceDeleteOK, *NvmeNamespaceDeleteAccepted, error)

	NvmeNamespaceDeleteCollection(params *NvmeNamespaceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeNamespaceDeleteCollectionOK, *NvmeNamespaceDeleteCollectionAccepted, error)

	NvmeNamespaceGet(params *NvmeNamespaceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeNamespaceGetOK, error)

	NvmeNamespaceModify(params *NvmeNamespaceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeNamespaceModifyOK, *NvmeNamespaceModifyAccepted, error)

	NvmeNamespaceModifyCollection(params *NvmeNamespaceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeNamespaceModifyCollectionOK, *NvmeNamespaceModifyCollectionAccepted, error)

	NvmeServiceCollectionGet(params *NvmeServiceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeServiceCollectionGetOK, error)

	NvmeServiceCreate(params *NvmeServiceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeServiceCreateCreated, error)

	NvmeServiceDelete(params *NvmeServiceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeServiceDeleteOK, error)

	NvmeServiceDeleteCollection(params *NvmeServiceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeServiceDeleteCollectionOK, error)

	NvmeServiceGet(params *NvmeServiceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeServiceGetOK, error)

	NvmeServiceModify(params *NvmeServiceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeServiceModifyOK, error)

	NvmeServiceModifyCollection(params *NvmeServiceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeServiceModifyCollectionOK, error)

	NvmeSubsystemCollectionGet(params *NvmeSubsystemCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemCollectionGetOK, error)

	NvmeSubsystemControllerCollectionGet(params *NvmeSubsystemControllerCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemControllerCollectionGetOK, error)

	NvmeSubsystemControllerGet(params *NvmeSubsystemControllerGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemControllerGetOK, error)

	NvmeSubsystemCreate(params *NvmeSubsystemCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemCreateCreated, error)

	NvmeSubsystemDelete(params *NvmeSubsystemDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemDeleteOK, error)

	NvmeSubsystemDeleteCollection(params *NvmeSubsystemDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemDeleteCollectionOK, error)

	NvmeSubsystemGet(params *NvmeSubsystemGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemGetOK, error)

	NvmeSubsystemHostCollectionGet(params *NvmeSubsystemHostCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemHostCollectionGetOK, error)

	NvmeSubsystemHostCreate(params *NvmeSubsystemHostCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemHostCreateCreated, error)

	NvmeSubsystemHostDelete(params *NvmeSubsystemHostDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemHostDeleteOK, error)

	NvmeSubsystemHostDeleteCollection(params *NvmeSubsystemHostDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemHostDeleteCollectionOK, error)

	NvmeSubsystemHostGet(params *NvmeSubsystemHostGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemHostGetOK, error)

	NvmeSubsystemHostModify(params *NvmeSubsystemHostModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemHostModifyOK, error)

	NvmeSubsystemHostModifyCollection(params *NvmeSubsystemHostModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemHostModifyCollectionOK, error)

	NvmeSubsystemMapCollectionGet(params *NvmeSubsystemMapCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemMapCollectionGetOK, error)

	NvmeSubsystemMapCreate(params *NvmeSubsystemMapCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemMapCreateCreated, error)

	NvmeSubsystemMapDelete(params *NvmeSubsystemMapDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemMapDeleteOK, error)

	NvmeSubsystemMapDeleteCollection(params *NvmeSubsystemMapDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemMapDeleteCollectionOK, error)

	NvmeSubsystemMapGet(params *NvmeSubsystemMapGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemMapGetOK, error)

	NvmeSubsystemModify(params *NvmeSubsystemModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemModifyOK, error)

	NvmeSubsystemModifyCollection(params *NvmeSubsystemModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemModifyCollectionOK, error)

	PerformanceNamespaceMetricCollectionGet(params *PerformanceNamespaceMetricCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceNamespaceMetricCollectionGetOK, error)

	PerformanceNamespaceMetricGet(params *PerformanceNamespaceMetricGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceNamespaceMetricGetOK, error)

	PerformanceNvmeMetricCollectionGet(params *PerformanceNvmeMetricCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceNvmeMetricCollectionGetOK, error)

	PerformanceNvmeMetricGet(params *PerformanceNvmeMetricGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceNvmeMetricGetOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
	NvmeInterfaceCollectionGet Retrieves NVMe interfaces.

### Related ONTAP commands
* `vserver nvme show-interface`
### Learn more
* [`DOC /protocols/nvme/interfaces`](#docs-NVMe-protocols_nvme_interfaces)
*/
func (a *Client) NvmeInterfaceCollectionGet(params *NvmeInterfaceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeInterfaceCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeInterfaceCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_interface_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/nvme/interfaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeInterfaceCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeInterfaceCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeInterfaceCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeInterfaceGet Retrieves an NVMe interface.

### Related ONTAP commands
* `vserver nvme show-interface`
### Learn more
* [`DOC /protocols/nvme/interfaces`](#docs-NVMe-protocols_nvme_interfaces)
*/
func (a *Client) NvmeInterfaceGet(params *NvmeInterfaceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeInterfaceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeInterfaceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_interface_get",
		Method:             "GET",
		PathPattern:        "/protocols/nvme/interfaces/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeInterfaceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeInterfaceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeInterfaceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeNamespaceCollectionGet Retrieves NVMe namespaces.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `auto_delete`
* `space.physical_used`
* `space.physical_used_by_snapshots`
* `space.efficiency_ratio`
* `space.snapshot.*`
* `subsystem_map.*`
* `status.mapped`
* `statistics.*`
* `metric.*`
### Related ONTAP commands
* `vserver nvme namespace show`
* `vserver nvme subsystem map show`
### Learn more
* [`DOC /storage/namespaces`](#docs-NVMe-storage_namespaces) to learn more and examples.
*/
func (a *Client) NvmeNamespaceCollectionGet(params *NvmeNamespaceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeNamespaceCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeNamespaceCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_namespace_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/namespaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeNamespaceCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeNamespaceCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeNamespaceCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeNamespaceCreate Creates an NVMe namespace.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the NVMe namespace.
* `name`, `location.volume.name` or `location.volume.uuid` - Existing volume in which to create the NVMe namespace.
* `name` or `location.namespace` - Base name for the NVMe namespace.
* `os_type` - Operating system from which the NVMe namespace will be accessed. (Not used for clones, which are created based on the `os_type` of the source NVMe namespace.)
* `space.size` - Size for the NVMe namespace. (Not used for clones, which are created based on the size of the source NVMe namespace.)
### Default property values
If not specified in POST, the following default property values are assigned:
* `auto_delete` - _false_
* `space.block_size` - _4096_ ( _512_ when 'os_type' is _vmware_ )
### Related ONTAP commands
* `volume file clone autodelete`
* `volume file clone create`
* `vserver nvme namespace convert-from-lun`
* `vserver nvme namespace create`
<personalities supports=asar2>
The `name` property is required when creating a new namespace. The name must start with an alphabetic character (a to z or A to Z) or an underscore (_). The name must be 203 characters or less in length. The `location` properties are not supported.
</personalities>
POST is asynchronous when creating a new namespace. It is synchronous when converting a LUN to a namespace via the `convert` property.
### Learn more
* [`DOC /storage/namespaces`](#docs-NVMe-storage_namespaces)
*/
func (a *Client) NvmeNamespaceCreate(params *NvmeNamespaceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeNamespaceCreateCreated, *NvmeNamespaceCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeNamespaceCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_namespace_create",
		Method:             "POST",
		PathPattern:        "/storage/namespaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeNamespaceCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *NvmeNamespaceCreateCreated:
		return value, nil, nil
	case *NvmeNamespaceCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeNamespaceCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeNamespaceDelete Deletes an NVMe namespace.

### Related ONTAP commands
* `vserver nvme namespace delete`
<personalities supports=asar2>
DELETE is asynchronous.
</personalities>
### Learn more
* [`DOC /storage/namespaces`](#docs-NVMe-storage_namespaces)
*/
func (a *Client) NvmeNamespaceDelete(params *NvmeNamespaceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeNamespaceDeleteOK, *NvmeNamespaceDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeNamespaceDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_namespace_delete",
		Method:             "DELETE",
		PathPattern:        "/storage/namespaces/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeNamespaceDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *NvmeNamespaceDeleteOK:
		return value, nil, nil
	case *NvmeNamespaceDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeNamespaceDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NvmeNamespaceDeleteCollection nvme namespace delete collection API
*/
func (a *Client) NvmeNamespaceDeleteCollection(params *NvmeNamespaceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeNamespaceDeleteCollectionOK, *NvmeNamespaceDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeNamespaceDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_namespace_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/storage/namespaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeNamespaceDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *NvmeNamespaceDeleteCollectionOK:
		return value, nil, nil
	case *NvmeNamespaceDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeNamespaceDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeNamespaceGet Retrieves an NVMe namespace.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `auto_delete`
* `space.physical_used`
* `space.physical_used_by_snapshots`
* `space.efficiency_ratio`
* `space.snapshot.*`
* `subsystem_map.*`
* `status.mapped`
* `statistics.*`
* `metric.*`
### Related ONTAP commands
* `vserver nvme namespace show`
* `vserver nvme subsystem map show`
### Learn more
* [`DOC /storage/namespaces`](#docs-NVMe-storage_namespaces)
*/
func (a *Client) NvmeNamespaceGet(params *NvmeNamespaceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeNamespaceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeNamespaceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_namespace_get",
		Method:             "GET",
		PathPattern:        "/storage/namespaces/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeNamespaceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeNamespaceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeNamespaceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeNamespaceModify Updates an NVMe namespace.

### Related ONTAP commands
* `volume file clone autodelete`
* `vserver nvme namespace modify`
<personalities supports=asar2>
PATCH is asynchronous when modifying `name` or `qos_policy`.
</personalities>
### Learn more
* [`DOC /storage/namespaces`](#docs-NVMe-storage_namespaces)
*/
func (a *Client) NvmeNamespaceModify(params *NvmeNamespaceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeNamespaceModifyOK, *NvmeNamespaceModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeNamespaceModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_namespace_modify",
		Method:             "PATCH",
		PathPattern:        "/storage/namespaces/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeNamespaceModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *NvmeNamespaceModifyOK:
		return value, nil, nil
	case *NvmeNamespaceModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeNamespaceModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NvmeNamespaceModifyCollection nvme namespace modify collection API
*/
func (a *Client) NvmeNamespaceModifyCollection(params *NvmeNamespaceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeNamespaceModifyCollectionOK, *NvmeNamespaceModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeNamespaceModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_namespace_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/storage/namespaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeNamespaceModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *NvmeNamespaceModifyCollectionOK:
		return value, nil, nil
	case *NvmeNamespaceModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeNamespaceModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeServiceCollectionGet Retrieves NVMe services.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `statistics.*`
* `metric.*`
### Related ONTAP commands
* `vserver nvme show`
### Learn more
* [`DOC /protocols/nvme/services`](#docs-NVMe-protocols_nvme_services)
*/
func (a *Client) NvmeServiceCollectionGet(params *NvmeServiceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeServiceCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeServiceCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_service_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/nvme/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeServiceCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeServiceCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeServiceCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeServiceCreate Creates an NVMe service.

### Required properties
* `svm.uuid` or `svm.name` - The existing SVM in which to create the NVMe service.
### Related ONTAP commands
* `vserver nvme create`
### Learn more
* [`DOC /protocols/nvme/services`](#docs-NVMe-protocols_nvme_services)
*/
func (a *Client) NvmeServiceCreate(params *NvmeServiceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeServiceCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeServiceCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_service_create",
		Method:             "POST",
		PathPattern:        "/protocols/nvme/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeServiceCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeServiceCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeServiceCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeServiceDelete Deletes an NVMe service. An NVMe service must be disabled before it can be deleted. In addition, all NVMe interfaces, subsystems, and subsystem maps associated with the SVM must first be deleted.

### Related ONTAP commands
* `vserver nvme delete`
### Learn more
* [`DOC /protocols/nvme/services`](#docs-NVMe-protocols_nvme_services)
*/
func (a *Client) NvmeServiceDelete(params *NvmeServiceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeServiceDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeServiceDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_service_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/nvme/services/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeServiceDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeServiceDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeServiceDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NvmeServiceDeleteCollection nvme service delete collection API
*/
func (a *Client) NvmeServiceDeleteCollection(params *NvmeServiceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeServiceDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeServiceDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_service_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/nvme/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeServiceDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeServiceDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeServiceDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeServiceGet Retrieves an NVMe service.

### Related ONTAP commands
* `vserver nvme show`
### Learn more
* [`DOC /protocols/nvme/services`](#docs-NVMe-protocols_nvme_services)
*/
func (a *Client) NvmeServiceGet(params *NvmeServiceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeServiceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeServiceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_service_get",
		Method:             "GET",
		PathPattern:        "/protocols/nvme/services/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeServiceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeServiceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeServiceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeServiceModify Updates an NVMe service.

### Related ONTAP commands
* `vserver nvme modify`
### Learn more
* [`DOC /protocols/nvme/services`](#docs-NVMe-protocols_nvme_services)
*/
func (a *Client) NvmeServiceModify(params *NvmeServiceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeServiceModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeServiceModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_service_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/nvme/services/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeServiceModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeServiceModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeServiceModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NvmeServiceModifyCollection nvme service modify collection API
*/
func (a *Client) NvmeServiceModifyCollection(params *NvmeServiceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeServiceModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeServiceModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_service_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/nvme/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeServiceModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeServiceModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeServiceModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeSubsystemCollectionGet Retrieves NVMe subsystems.

### Related ONTAP commands
* `vserver nvme subsystem host show`
* `vserver nvme subsystem map show`
* `vserver nvme subsystem show`
### Learn more
* [`DOC /protocols/nvme/subsystems`](#docs-NVMe-protocols_nvme_subsystems)
*/
func (a *Client) NvmeSubsystemCollectionGet(params *NvmeSubsystemCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeSubsystemCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_subsystem_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/nvme/subsystems",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeSubsystemCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeSubsystemCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeSubsystemCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeSubsystemControllerCollectionGet Retrieves NVMe subsystem controllers.

### Related ONTAP commands
* `vserver nvme subsystem controller show`
### Learn more
* [`DOC /protocols/nvme/subsystem-controllers`](#docs-NVMe-protocols_nvme_subsystem-controllers)
*/
func (a *Client) NvmeSubsystemControllerCollectionGet(params *NvmeSubsystemControllerCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemControllerCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeSubsystemControllerCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_subsystem_controller_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/nvme/subsystem-controllers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeSubsystemControllerCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeSubsystemControllerCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeSubsystemControllerCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeSubsystemControllerGet Retrieves an NVMe subsystem controller.

### Related ONTAP commands
* `vserver nvme subsystem controller show`
### Learn more
* [`DOC /protocols/nvme/subsystem-controllers`](#docs-NVMe-protocols_nvme_subsystem-controllers)
*/
func (a *Client) NvmeSubsystemControllerGet(params *NvmeSubsystemControllerGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemControllerGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeSubsystemControllerGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_subsystem_controller_get",
		Method:             "GET",
		PathPattern:        "/protocols/nvme/subsystem-controllers/{subsystem.uuid}/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeSubsystemControllerGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeSubsystemControllerGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeSubsystemControllerGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeSubsystemCreate Creates an NVMe subsystem.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the NVMe subsystem.
* `name` - Name for NVMe subsystem. Once created, an NVMe subsystem cannot be renamed.
* `os_type` - Operating system of the NVMe subsystem's hosts.
### Related ONTAP commands
* `vserver nvme subsystem create`
### Learn more
* [`DOC /protocols/nvme/subsystems`](#docs-NVMe-protocols_nvme_subsystems)
*/
func (a *Client) NvmeSubsystemCreate(params *NvmeSubsystemCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeSubsystemCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_subsystem_create",
		Method:             "POST",
		PathPattern:        "/protocols/nvme/subsystems",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeSubsystemCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeSubsystemCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeSubsystemCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeSubsystemDelete Removes an NVMe subsystem.

### Related ONTAP commands
* `vserver nvme subsystem delete`
### Learn more
* [`DOC /protocols/nvme/subsystems`](#docs-NVMe-protocols_nvme_subsystems)
*/
func (a *Client) NvmeSubsystemDelete(params *NvmeSubsystemDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeSubsystemDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_subsystem_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/nvme/subsystems/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeSubsystemDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeSubsystemDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeSubsystemDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NvmeSubsystemDeleteCollection nvme subsystem delete collection API
*/
func (a *Client) NvmeSubsystemDeleteCollection(params *NvmeSubsystemDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeSubsystemDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_subsystem_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/nvme/subsystems",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeSubsystemDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeSubsystemDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeSubsystemDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeSubsystemGet Retrieves an NVMe subsystem.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `subsystem_maps.*`
### Related ONTAP commands
* `vserver nvme subsystem host show`
* `vserver nvme subsystem map show`
* `vserver nvme subsystem show`
### Learn more
* [`DOC /protocols/nvme/subsystems`](#docs-NVMe-protocols_nvme_subsystems)
*/
func (a *Client) NvmeSubsystemGet(params *NvmeSubsystemGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeSubsystemGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_subsystem_get",
		Method:             "GET",
		PathPattern:        "/protocols/nvme/subsystems/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeSubsystemGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeSubsystemGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeSubsystemGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeSubsystemHostCollectionGet Retrieves the NVMe subsystem hosts of an NVMe subsystem.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `subsystem_maps.*`
### Related ONTAP commands
* `vserver nvme subsystem map show`
* `vserver nvme subsystem show`
### Learn more
* [`DOC /protocols/nvme/subsystems`](#docs-NVMe-protocols_nvme_subsystems)
*/
func (a *Client) NvmeSubsystemHostCollectionGet(params *NvmeSubsystemHostCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemHostCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeSubsystemHostCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_subsystem_host_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/nvme/subsystems/{subsystem.uuid}/hosts",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeSubsystemHostCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeSubsystemHostCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeSubsystemHostCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeSubsystemHostCreate Adds NVMe subsystem host(s) to an NVMe subsystem.

### Required properties
* `nqn` or `records.nqn` - NVMe host(s) NQN(s) to add to the NVMe subsystem.
### Related ONTAP commands
* `vserver nvme subsystem host add`
### Learn more
* [`DOC /protocols/nvme/subsystems`](#docs-NVMe-protocols_nvme_subsystems)
*/
func (a *Client) NvmeSubsystemHostCreate(params *NvmeSubsystemHostCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemHostCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeSubsystemHostCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_subsystem_host_create",
		Method:             "POST",
		PathPattern:        "/protocols/nvme/subsystems/{subsystem.uuid}/hosts",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeSubsystemHostCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeSubsystemHostCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeSubsystemHostCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeSubsystemHostDelete Deletes an NVMe subsystem host from an NVMe subsystem.

### Related ONTAP commands
* `vserver nvme subsystem host remove`
### Learn more
* [`DOC /protocols/nvme/subsystems`](#docs-NVMe-protocols_nvme_subsystems)
*/
func (a *Client) NvmeSubsystemHostDelete(params *NvmeSubsystemHostDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemHostDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeSubsystemHostDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_subsystem_host_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/nvme/subsystems/{subsystem.uuid}/hosts/{nqn}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeSubsystemHostDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeSubsystemHostDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeSubsystemHostDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NvmeSubsystemHostDeleteCollection nvme subsystem host delete collection API
*/
func (a *Client) NvmeSubsystemHostDeleteCollection(params *NvmeSubsystemHostDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemHostDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeSubsystemHostDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_subsystem_host_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/nvme/subsystems/{subsystem.uuid}/hosts",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeSubsystemHostDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeSubsystemHostDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeSubsystemHostDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeSubsystemHostGet Retrieves an NVMe subsystem host of an NVMe subsystem.

### Related ONTAP commands
* `vserver nvme subsystem host show`
### Learn more
* [`DOC /protocols/nvme/subsystems`](#docs-NVMe-protocols_nvme_subsystems)
*/
func (a *Client) NvmeSubsystemHostGet(params *NvmeSubsystemHostGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemHostGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeSubsystemHostGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_subsystem_host_get",
		Method:             "GET",
		PathPattern:        "/protocols/nvme/subsystems/{subsystem.uuid}/hosts/{nqn}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeSubsystemHostGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeSubsystemHostGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeSubsystemHostGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeSubsystemHostModify Updates an NVMe subsystem host.

### Related ONTAP commands
* `vserver nvme subsystem host add-proximal-vserver`
* `vserver nvme subsystem host remove-proximal-vserver`
### Learn more
* [`DOC /protocols/nvme/subsystems`](#docs-NVMe-protocols_nvme_subsystems)
*/
func (a *Client) NvmeSubsystemHostModify(params *NvmeSubsystemHostModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemHostModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeSubsystemHostModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_subsystem_host_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/nvme/subsystems/{subsystem.uuid}/hosts/{nqn}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeSubsystemHostModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeSubsystemHostModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeSubsystemHostModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NvmeSubsystemHostModifyCollection nvme subsystem host modify collection API
*/
func (a *Client) NvmeSubsystemHostModifyCollection(params *NvmeSubsystemHostModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemHostModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeSubsystemHostModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_subsystem_host_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/nvme/subsystems/{subsystem.uuid}/hosts",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeSubsystemHostModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeSubsystemHostModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeSubsystemHostModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeSubsystemMapCollectionGet Retrieves NVMe subsystem maps.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `anagrpid`
### Related ONTAP commands
* `vserver nvme subsystem map show`
### Learn more
* [`DOC /protocols/nvme/subsystem-maps`](#docs-NVMe-protocols_nvme_subsystem-maps)
*/
func (a *Client) NvmeSubsystemMapCollectionGet(params *NvmeSubsystemMapCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemMapCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeSubsystemMapCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_subsystem_map_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/nvme/subsystem-maps",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeSubsystemMapCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeSubsystemMapCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeSubsystemMapCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeSubsystemMapCreate Creates an NVMe subsystem map.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the NVMe subsystem map.
* `namespace.uuid` or `namespace.name` - Existing NVMe namespace to map to the specified NVme subsystem.
* `subsystem.uuid` or `subsystem.name` - Existing NVMe subsystem to map to the specified NVMe namespace.
### Related ONTAP commands
* `vserver nvme subsystem map add`
### Learn more
* [`DOC /protocols/nvme/subsystem-maps`](#docs-NVMe-protocols_nvme_subsystem-maps)
*/
func (a *Client) NvmeSubsystemMapCreate(params *NvmeSubsystemMapCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemMapCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeSubsystemMapCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_subsystem_map_create",
		Method:             "POST",
		PathPattern:        "/protocols/nvme/subsystem-maps",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeSubsystemMapCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeSubsystemMapCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeSubsystemMapCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeSubsystemMapDelete Deletes an NVMe subsystem map.

### Related ONTAP commands
* `vserver nvme subsystem map remove`
### Learn more
* [`DOC /protocols/nvme/subsystem-maps`](#docs-NVMe-protocols_nvme_subsystem-maps)
*/
func (a *Client) NvmeSubsystemMapDelete(params *NvmeSubsystemMapDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemMapDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeSubsystemMapDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_subsystem_map_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/nvme/subsystem-maps/{subsystem.uuid}/{namespace.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeSubsystemMapDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeSubsystemMapDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeSubsystemMapDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NvmeSubsystemMapDeleteCollection nvme subsystem map delete collection API
*/
func (a *Client) NvmeSubsystemMapDeleteCollection(params *NvmeSubsystemMapDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemMapDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeSubsystemMapDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_subsystem_map_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/nvme/subsystem-maps",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeSubsystemMapDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeSubsystemMapDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeSubsystemMapDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeSubsystemMapGet Retrieves an NVMe subsystem map.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `anagrpid`
### Related ONTAP commands
* `vserver nvme subsystem map show`
### Learn more
* [`DOC /protocols/nvme/subsystem-maps`](#docs-NVMe-protocols_nvme_subsystem-maps)
*/
func (a *Client) NvmeSubsystemMapGet(params *NvmeSubsystemMapGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemMapGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeSubsystemMapGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_subsystem_map_get",
		Method:             "GET",
		PathPattern:        "/protocols/nvme/subsystem-maps/{subsystem.uuid}/{namespace.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeSubsystemMapGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeSubsystemMapGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeSubsystemMapGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NvmeSubsystemModify Updates an NVMe subsystem.

### Related ONTAP commands
* `vserver nvme subsystem modify`
### Learn more
* [`DOC /protocols/nvme/subsystems`](#docs-NVMe-protocols_nvme_subsystems)
*/
func (a *Client) NvmeSubsystemModify(params *NvmeSubsystemModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeSubsystemModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_subsystem_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/nvme/subsystems/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeSubsystemModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeSubsystemModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeSubsystemModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NvmeSubsystemModifyCollection nvme subsystem modify collection API
*/
func (a *Client) NvmeSubsystemModifyCollection(params *NvmeSubsystemModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NvmeSubsystemModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNvmeSubsystemModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "nvme_subsystem_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/nvme/subsystems",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NvmeSubsystemModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NvmeSubsystemModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NvmeSubsystemModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	PerformanceNamespaceMetricCollectionGet Retrieves historical space and performance metrics for an NVMe namespace.

### Related ONTAP commands
* `statistics namespace show`
*/
func (a *Client) PerformanceNamespaceMetricCollectionGet(params *PerformanceNamespaceMetricCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceNamespaceMetricCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPerformanceNamespaceMetricCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "performance_namespace_metric_collection_get",
		Method:             "GET",
		PathPattern:        "/storage/namespaces/{nvme_namespace.uuid}/metrics",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PerformanceNamespaceMetricCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PerformanceNamespaceMetricCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PerformanceNamespaceMetricCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	PerformanceNamespaceMetricGet Retrieves historical space and performance metrics for an NVMe namespace for a specific time.

### Related ONTAP commands
* `statistics namespace show`
*/
func (a *Client) PerformanceNamespaceMetricGet(params *PerformanceNamespaceMetricGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceNamespaceMetricGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPerformanceNamespaceMetricGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "performance_namespace_metric_get",
		Method:             "GET",
		PathPattern:        "/storage/namespaces/{nvme_namespace.uuid}/metrics/{timestamp}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PerformanceNamespaceMetricGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PerformanceNamespaceMetricGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PerformanceNamespaceMetricGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PerformanceNvmeMetricCollectionGet Retrieves historical performance metrics for the NVMe protocol service of an SVM.
*/
func (a *Client) PerformanceNvmeMetricCollectionGet(params *PerformanceNvmeMetricCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceNvmeMetricCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPerformanceNvmeMetricCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "performance_nvme_metric_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/nvme/services/{svm.uuid}/metrics",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PerformanceNvmeMetricCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PerformanceNvmeMetricCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PerformanceNvmeMetricCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PerformanceNvmeMetricGet Retrieves historical performance metrics for the NVMe protocol service of an SVM for a specific time.
*/
func (a *Client) PerformanceNvmeMetricGet(params *PerformanceNvmeMetricGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceNvmeMetricGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPerformanceNvmeMetricGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "performance_nvme_metric_get",
		Method:             "GET",
		PathPattern:        "/protocols/nvme/services/{svm.uuid}/metrics/{timestamp}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PerformanceNvmeMetricGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PerformanceNvmeMetricGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PerformanceNvmeMetricGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
